<?php
  /**
   **  Email X-Header
   **
   **  By Pontus Ullgren <pontus.ullgren@addin.se>
   **  (c) 2003 (GNU GPL - see ../../COPYING)
   **
   **  This plugin lets site operators add one or more 
   **  X-header fields in all emails sent using their 
   **  installation of SquirrelMail.
   **  
   **  To change the header fields, see below.
   **/


/*******************************************************
 **   Replace the headers below with your own.
 **   All user defined headers should begin with X- to 
 **   be fully RFC 822 compliant.
 **
 **   The example headers add the version of X-Header 
 **   and the logged in users HTTP_USER_AGENT
 *******************************************************/
global $xheader;
$xheader = Array ( "X-XheaderVersion" => "1.1",
	"X-UserAgent"=>$GLOBALS['HTTP_USER_AGENT']);


/*******************************************************
 **   No need to change anything else below this point.
 *******************************************************/
function squirrelmail_plugin_init_xheader()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['compose_send']['xheader']
            = 'xheader_addition';
} // end squirrelmail_plugin_init_xheader()


function xheader_addition(&$argv)
{
  global $xheader;

  // Get the arguments
  $hookName = &$argv[0];
  $message = &$argv[1];

  while(list($key, $value) = each($xheader))
  { 
    $message->rfc822_header->more_headers[$key] = $value;
  }
} // end xheader_addition()

?>
