<?php
  /**
   **  Email X-Header
   **
   **  By Pontus Ullgren <pontus.ullgren@addin.se>
   **  (c) 2001 (GNU GPL - see ../../COPYING)
   **
   **  This plugin lets site operators add one or more 
   **  X-header fields in all emails sent using their 
   **  installation of SquirrelMail.
   **  
   **  To change the header fields, see below.
   **/


/*******************************************************
 **   Replace the headers below with your own.
 **   All user defined headers should begin with X- to 
 **   be fully RFC 822 compliant.
 **
 **   The example headers add the version of X-Header 
 **   and the logged in users HTTP_USER_AGENT
 *******************************************************/

$xheader = Array ( "X-XheaderVersion" => "1.1",
	"X-UserAgent"=>"$GLOBALS[HTTP_USER_AGENT]");


/*******************************************************
 **   No need to change anything else below this point.
 *******************************************************/



global $email_headers;
$email_headers = $xheader;

function squirrelmail_plugin_init_xheader()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['smtp_send']['xheader']
            = 'xheader_addition';
} // end squirrelmail_plugin_init_xheader()


function xheader_addition()
{

    global $email_headers, $more_headers;

    while(list($key, $value) = each($email_headers))
    {
          $more_headers[$key] = $value;
    }
} // end xheader_addition()

?>
