<?php
   /*
    *  Windows Plugin v.1.4
    *  By Shawn South <shawn@ratbert.org>
    *  (c) 2000 (GNU GPL - see ../../COPYING)
    *
    *  This plugin opens a fresh browser window when you click on a message,
    *  allowing you to easily read email with leaving the message list.  
    *  Note that because of the frames-based nature of squirrelmail, this may
    *  result in some minor side-effects (message list without a folder list, 
    *  message list not updating which messages have been read, etc.)  It might 
    *  seem a bit annoying at first, but I've found it grows on you quite 
    *  quickly.
    *  
    *  The ability to compose a message in a new window has been integrated into
    *  the 1.2.5 core and so has been removed from this plugin.  If you are running
    *  1.2.4, download the 1.0 ver for this functionality.  If you are running 
    *  pre-1.2.4, you've got bigger problems than controling when windows open 
    *  (namely security holes that can let a cracker own your box.)  Upgrade to at 
    *  least 1.2.4 (and hey, why not 1.2.5 in that case) immeadiately!
    *
    *  Configuration options to turn this on/off on a per-user basis can be 
    *  found under the 'Display' options page.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  View the ../README.plugins document for information on installing this.  
    *
    */



function windows_read_do ($args) {

      global $data_dir, $username, $mailbox, $msg, 
             $startMsg, $searchString, $javascript_on;
      include_once('../functions/prefs.php');

      if (getPref($data_dir, $username, 'windows_on_read', 0) == 1) {

         $startMsg = $args[0];
         $searchString = $args[1];
         $urlMailbox = urlencode($mailbox);
         $read_new_win_height = getPref($data_dir, $username, 'read_new_win_height', 0);
         $read_new_win_width = getPref($data_dir, $username, 'read_new_win_width', 0);
		 //
		 // This allows us to reuse the same read window
		 //
		 if( getPref( $data_dir, $username, 'reuse_read_window', 0 ) == 1 ) 
		 	$window_name = "Reuseable_Read_Window";
		 else
		 	$window_name = "_blank";

         if ($javascript_on)
            return ' TARGET=' . $window_name . ' onClick="var readwin=window.open(\'read_body.php?mailbox=' . $urlMailbox . '&amp;passed_id=' . $msg['ID'] . '&amp;startMessage=' . $startMsg . $searchString . '\',\'' . $window_name . '\', ' . '\'' . ((isset($read_new_win_width) && $read_new_win_width > 0) ? 'width=' . $read_new_win_width . ', ' : '') . ((isset($read_new_win_height) && $read_new_win_height > 0) ? 'height=' . $read_new_win_height . ', ' : '') . 'scrollbars=yes, resizable=yes\'); return false;" ';
         else
            return ' TARGET="_blank" ';
         //return ' onClick="ref=this.href; ref=\'../plugins/windows/read_body\'+ref.substr(ref.indexOf(\'?\')); window.open(ref); return false" ';
      }

}
//TODO: delete
//read_body.php?mailbox='.$urlMailbox
//                        .  '&amp;passed_id='. $msg["ID"]
//                        .  '&amp;startMessage='.$start_msg.$searchstr


function windows_close_do () {

   echo "<script language='javascript' type='text/javascript'>\n"
      . "<!--\n"
      . "\n"
      . "   if (top == self) this.close();\n"
      . "\n"
      . "//-->\n"
      . "</script>\n";


   //sqgetGlobalVar('reading_in_new_window', $reading_in_new_window);
   //if ($reading_in_new_window)
      //Header('Location: http://www.google.com');

}

function windows_options_do () {

        global $data_dir, $username, $javascript_on;
        include_once('../functions/prefs.php');

        $read_new_win_height = getPref($data_dir, $username, 'read_new_win_height', 0);
        $read_new_win_width = getPref($data_dir, $username, 'read_new_win_width', 0);


?>
	<TR><TD COLSPAN="2">&nbsp;</TD></TR>
	<TR><TD COLSPAN="2" ALIGN=CENTER><B><?php echo _("Windows Preferences") ?></B></TD></TR>
	<TR><TD ALIGN=RIGHT><?php echo _("Open a new window when reading messages:") ?> </TD><TD>
	<INPUT TYPE="RADIO" NAME="windows_on_read_rdo" VALUE="1"
<?php
      if (getPref($data_dir, $username, 'windows_on_read', 0) == 1) {
	   echo 'CHECKED';
	}
        echo '>&nbsp;' . _("Yes") . '&nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="windows_on_read_rdo" VALUE="0"';
	if (getPref($data_dir, $username, 'windows_on_read', 0) == 0)  {
	   echo 'CHECKED';
	}
?>
	>&nbsp;<?php echo _("No") ?>
        </td></tr>
        <tr><td align=right valign=top>


	<TR><TD ALIGN=RIGHT><?php echo _("Reuse message window when reading messages:") ?> </TD><TD>
	<INPUT TYPE="RADIO" NAME="reuse_read_window_rdo" VALUE="1"
<?php
      if (getPref($data_dir, $username, 'reuse_read_window', 0) == 1) {
	   echo 'CHECKED';
	}
        echo '>&nbsp;' . _("Yes") . '&nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="reuse_read_window_rdo" VALUE="0"';
	if (getPref($data_dir, $username, 'reuse_read_window', 0) == 0)  {
	   echo 'CHECKED';
	}
?>
	>&nbsp;<?php echo _("No") ?>
        </td></tr>
        <tr><td align=right valign=top>

<?php
    echo _("Width of message window:<br>(set to zero for default)") . "</td>\n"
       . "<td><input type='text' name='read_new_win_width' size='3' value='"
       . $read_new_win_width;
    if ($javascript_on)
       echo "' onChange='a=this.value; b=\"\"; for (i=0;i<a.length;i++) { if (a.charAt(i)>=\"0\" && a.charAt(i)<=\"9\") b += a.charAt(i); } this.value=b;";
    echo "'> (pixels)\n</td></tr>";
?>
        <tr><td align=right valign=top>
<?php
    echo _("Height of message window:<br>(set to zero for default)") . "</td>\n"
       . "<td><input type='text' name='read_new_win_height' size='3' value='"
       . $read_new_win_height;
    if ($javascript_on)
       echo "' onChange='a=this.value; b=\"\"; for (i=0;i<a.length;i++) { if (a.charAt(i)>=\"0\" && a.charAt(i)<=\"9\") b += a.charAt(i); } this.value=b;";
    echo "'> (pixels)\n</td></tr>";

}

function windows_save_prefs_do () {

	global $username, $data_dir;
        include_once('../functions/prefs.php');

        // get global variable for versions of PHP < 4.1   
        //  
        if ((float)substr(PHP_VERSION,0,3) < 4.1) {    
           global $HTTP_POST_VARS;
           $_POST = $HTTP_POST_VARS;
        }

        setPref($data_dir, $username, 'windows_on_read', $_POST['windows_on_read_rdo']);
        setPref($data_dir, $username, 'reuse_read_window', $_POST['reuse_read_window_rdo']);
        setPref($data_dir, $username, 'read_new_win_width', $_POST['read_new_win_width']);
        setPref($data_dir, $username, 'read_new_win_height', $_POST['read_new_win_height']);

}


?>
