<?php
   /*
    *  Windows Plugin v.1.1
    *  By Shawn South <shawn@ratbert.org>
    *  (c) 2000 (GNU GPL - see ../../COPYING)
    *
    *  This plugin opens a fresh browser window when you click on a message,
    *  allowing you to easily read email with leaving the message list.  
    *  Note that because of the frames-based nature of squirrelmail, this may
    *  result in some minor side-effects (message list without a folder list, 
    *  message list not updating which messages have been read, etc.)  It might 
    *  seem a bit annoying at first, but I've found it grows on you quite 
    *  quickly.
    *  
    *  The ability to compose a message in a new window has been integrated into
    *  the 1.2.5 core and so has been removed from this plugin.  If you are running
    *  1.2.4, download the 1.0 ver for this functionality.  If you are running 
    *  pre-1.2.4, you've got bigger problems than controling when windows open 
    *  (namely security holes that can let a cracker own your box.)  Upgrade to at 
    *  least 1.2.4 (and hey, why not 1.2.5 in that case) immeadiately!
    *
    *  Configuration options to turn this on/off on a per-user basis can be 
    *  found under the 'Display' options page.
    *
    *  If you need help with this, or see improvements that can be made, please
    *  email me directly at the address above.  I definately welcome suggestions
    *  and comments.  This plugin, as is the case with all SquirrelMail plugins,
    *  is not directly supported by the developers.  Please come to me off the
    *  mailing list if you have trouble with it.
    *
    *  View the ../README.plugins document for information on installing this.  
    *
    */



function squirrelmail_plugin_init_windows() {
	global $squirrelmail_plugin_hooks, $username, $data_dir;

	$squirrelmail_plugin_hooks["subject_link"]["windows"] = "windows_read";
	$squirrelmail_plugin_hooks["options_display_inside"]["windows"] = "windows_options";
	$squirrelmail_plugin_hooks["options_display_save"]["windows"] = "windows_save_prefs";
}


function windows_read () {

      global $data_dir, $username;
      include_once('../functions/prefs.php');

      if (getPref($data_dir, $username, 'windows_on_read', 0) == 1) {
        echo ' TARGET="_blank" ';
      }
}


function windows_options () {
	global $username, $data_dir;
        require_once('../functions/prefs.php');

?>
	<TR><TD COLSPAN="2">&nbsp;</TD></TR>
	<TR><TD COLSPAN="2" ALIGN=CENTER><B><?php echo _("Windows Preferences") ?></B></TD></TR>
	<TR><TD ALIGN=RIGHT><?php echo _("Open a new window when reading messages:") ?> </TD><TD>
	<INPUT TYPE="RADIO" NAME="windows_on_read_rdo" VALUE="1"
<?php
      if (getPref($data_dir, $username, 'windows_on_read', 0) == 1) {
	   echo 'CHECKED';
	}
        echo '>&nbsp;' . _("Yes") . '&nbsp;&nbsp;&nbsp;&nbsp;<INPUT TYPE="RADIO" NAME="windows_on_read_rdo" VALUE="0"';
	if (getPref($data_dir, $username, 'windows_on_read', 0) == 0)  {
	   echo 'CHECKED';
	}
?>
	>&nbsp;<?php echo _("No") ?>
	</td></tr>

<?php
}

function windows_save_prefs () {
        include_once('../functions/prefs.php');
	global $username, $data_dir;
        global $_POST;
        $windows_on_read_rdo = $_POST['windows_on_read_rdo'];
        setPref($data_dir, $username, 'windows_on_read', $windows_on_read_rdo);
}




?>
