<?php

/*******************************************************************************

	Author  .......  Daniel B. Hemmerich
	Contact  ......  dan@spot.org
	Home Site  ....  http://www.spot.org/
	Program  ......  SquirrelMail Plugin - Weather
	Version  ......  4.1.0

*******************************************************************************/

/*
 *  Note: the format of the user preference file may seem.. well.. not orderly,
 *  to put it nicely. This is only due to the fact, that we have to remember
 *  that the configuration file may already be from an older version. Users
 *  are not going to want to re-enter information every time the administrator
 *  decides to update this absolutely wonderful plugin!
 */

function load_locations ()
{
	global $data_dir, $username;

	$locations = array ();

	for ($i = 0; $location = getPref ($data_dir, $username, 'weather' . $i); $i++)
	{
		$temp = explode ('\\', $location);
		$locations[$i]['code'] = $temp[0];
		$locations[$i]['place'] = $temp[1];
		$locations[$i]['position'] = $temp[2];
		$locations[$i]['view-temp'] = $temp[3];
		$locations[$i]['view-feels'] = $temp[4];
		$locations[$i]['view-conditions'] = $temp[5];
		$locations[$i]['view-uv'] = $temp[6];
		$locations[$i]['view-wind'] = $temp[7];
		$locations[$i]['view-dew'] = $temp[8];
		$locations[$i]['view-humidity'] = $temp[9];
		$locations[$i]['view-visibility'] = $temp[10];
		$locations[$i]['view-barometer'] = $temp[11];

		$locations[$i]['timestamp'] = $temp[12];
		$locations[$i]['cache-name'] = $temp[13];
		$locations[$i]['cache-temp'] = $temp[14];
		$locations[$i]['cache-feels'] = $temp[15];
		$locations[$i]['cache-conditions'] = $temp[16];
		$locations[$i]['cache-uv'] = $temp[17];
		$locations[$i]['cache-wind'] = $temp[18];
		$locations[$i]['cache-dew'] = $temp[19];
		$locations[$i]['cache-humidity'] = $temp[20];
		$locations[$i]['cache-visibility'] = $temp[21];
		$locations[$i]['cache-barometer'] = $temp[22];
		$locations[$i]['cachetime'] = $temp[23];

		$locations[$i]['viewable'] = $temp[24];
		$locations[$i]['width'] = $temp[25];
		$locations[$i]['margin-right'] = $temp[26];
		$locations[$i]['margin-left'] = $temp[27];
		$locations[$i]['margin-top'] = $temp[28];
		$locations[$i]['margin-bottom'] = $temp[29];
		$locations[$i]['color-background'] = $temp[30];
		$locations[$i]['color-foreground'] = $temp[31];
		$locations[$i]['color-label'] = $temp[32];
		$locations[$i]['color-value'] = $temp[33];

		$locations[$i]['view-place'] = $temp[34];
		$locations[$i]['url'] = $temp[35];
		$locations[$i]['country'] = $temp[36];
	}

	return $locations;
}

function remove_location ($id)
{
	global $data_dir, $username;

	while ($nextLocation = getPref($data_dir, $username, 'weather' . ($id + 1)))
	{
		setPref ($data_dir, $username, 'weather' . $id, $nextLocation);
		$id++;
	}

	removePref ($data_dir, $username, 'weather' . $id);
}

function weather_display ($location, $theid)
{
	global $color, $left_size, $data_dir, $username, $weather_proxy;

	$cache_time = 1800;

	$thetime = time (NULL);
	$cachetime = $location['timestamp'] + $cache_time;

if ($cachetime < $thetime)
	{
		$socketError = 0;
		if ($weather_proxy)
		{
			preg_match ("/^(http:\/\/)?([^\/]+):(\d+)/i", $weather_proxy, $matches);

			$the_server = $matches[2];
			$the_port   = $matches[3];
		}
		else
		{
			$the_server = "www.srh.noaa.gov";
			$the_port = 80;
		}

                $host = "www.srh.noaa.gov";


                if (!empty($location['url'])) {

                    preg_match("/http:\/\/(.*?)\/(.*)/", $location['url'], $matches);
                    $host = $matches[1];
                    $the_server = $host;
		    $request  = "GET /" . $matches[2] . " HTTP/1.0\r\n";
                    // Direct call to their CGI: http://weather.noaa.gov/cgi-bin/call_currwx.pl?cccc=RJTT
                }
                elseif (isset($location['code']))
		    $request  = "GET http://www.srh.noaa.gov/zipcity.php?inputstring=" . $location['code'] . " HTTP/1.0\r\n";
                else
		    $request  = "GET http://www.srh.noaa.gov/zipcity.php?inputstring=" . $location['place'] . " HTTP/1.0\r\n";


		$request .= "Host: $host\r\n";
		$request .= "Accept: */*\r\n";
		$request .= "Connection: close\r\n";
		$request .= "\r\n\r\n";


                // if we have the direct URL, don't need to get redirect info
                //
                if (empty($location['url'])) {

		    $httpsock = @fsockopen ($the_server, 80);

		    if ($httpsock)
		    {

		    	fwrite ($httpsock, $request);
		    	$data = "";

		    	while (!feof($httpsock))
		    	{
			    	$data .= fread ($httpsock, 1024);
		    	}
        		fclose($httpsock);

		    }
		    else
		    {
			$socketError = 1;
		    }
		
		    if (!$socketError)
		    {

		    	$explode = explode('Location: ',$data);
		    	$explode = explode('Via:',$explode[1]);
		    	$data = $explode[0];

		    	$request  = "GET " . $data . " HTTP/1.0\r\n";
		    	$request .= "Host: $host\r\n";
		    	$request .= "Accept: */*\r\n";
		    	$request .= "Connection: close\r\n";
		    	$request .= "\r\n\r\n";

		    }

                }
		
		if (!$socketError && ($httpsock = fsockopen ($the_server, 80))) {

		   fwrite ($httpsock, $request);
		   $data = "";

		   while (!feof($httpsock))
		   {
			$data .= fread ($httpsock, 1024);
		   }
    		   fclose($httpsock);
                }
		else
		{
			$socketError = 1;
		}


                // US locations
                //
                if (!$socketError && empty($location['url'])) {

		    $explode = explode('Last Update on',$data);
		    $explode = explode('<td class="big" width="120" align="center">',$explode[1],2);
		    $explode = explode('<br>',$explode[1],2);
		    $conditions = $explode[0];

		    $explode = explode('<br>',$explode[1],2);
		    $explode = explode('<br>',$explode[1],2);
		    $temperature = $explode[0];

		    $explode = explode('<td align="right">',$explode[1],2);
		    $explode = explode('</td>',$explode[1],2);
		    $humidity = $explode[0];

		    $explode = explode('<td align="right">',$explode[1],2);
		    $explode = explode('</td>',$explode[1],2);
		    $wind = $explode[0];

		    $explode = explode('<td align="right" nowrap>',$explode[1],2);
		    $explode = explode('</td>',$explode[1],2);
		    $barometer = $explode[0];

		    $explode = explode('<td align="right">',$explode[1],2);
		    $explode = explode('</td>',$explode[1],2);
		    $dew = $explode[0];

		    # Check to see if next is visibility or feelslike(Wind Chill).

		    $explode = explode('<td><b>',$explode[1],2);
		    $explode = explode('</b>:</td>',$explode[1],2);
		    $next = $explode[0];

		    # found visibility
		    if( !strcmp( $next, 'Visibility' ) )
		    {
		      $feelslike = 'N/A';

		      $explode = explode('<td align="right">',$explode[1],2);
		      $explode = explode('</td>',$explode[1],2);
		      $visibility = $explode[0];		      

		    }

		    else
		    {
		      $explode = explode('<td align="right">',$explode[1],2);
		      $explode = explode('</td>',$explode[1],2);
		      $feelslike = $explode[0];

		      $explode = explode('<td align="right">',$explode[1],2);
		      $explode = explode('</td>',$explode[1],2);
		      $visibility = $explode[0];

		    }



		    $uv = '';
		    $citytitle = '';
		

                // for international locations
                //
                } elseif (!$socketError) {

                    $explode = explode('Conditions at', $data, 2);
                    $explode = explode('24 Hour Summary', $explode[1], 2);


                    $explode = explode('Wind', $explode[0], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $wind = trim($explode[0]);
                    }
                    else
                    {
                        $wind = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Visibility', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $visibility = trim($explode[0]);
                    }
                    else
                    {
                        $visibility = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Sky conditions', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $conditions = trim($explode[0]);
                    }
                    else
                    {
                        $conditions = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Weather', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $conditions = trim($explode[0]);
                    }
                    else
                    {
                        // don't do this here!  it'll erase what we got above, if anything $conditions = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Temperature', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $temperature = trim($explode[0]);
                    }
                    else
                    {
                        $temperature = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Dew Point', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $dew = trim($explode[0]);
                    }
                    else
                    {
                        $dew = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Relative Humidity', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $humidity = trim($explode[0]);
                    }
                    else
                    {
                        $humidity = '';
                        $explode[1] = $explode[0];
                    }


                    $explode = explode('Pressure', $explode[1], 2);
                    if (!empty($explode[1]))
                    {
                        $explode = explode('<FONT FACE="Arial,Helvetica">', $explode[1], 2);
                        $explode = explode('</FONT>', $explode[1], 2);
                        $barometer = trim($explode[0]);
                    }
                    else
                    {
                        $barometer = '';
                        $explode[1] = $explode[0];
                    }


                    $citytitle = '';
                    $feelslike = '';
                    $uv = '';


                }

		if (!$socketError) {

			setPref ($data_dir, $username, "weather".$theid,
				$location['code']."\\".
				$location['place']."\\".
				$location['position']."\\".
				$location['view-temp']."\\".
				$location['view-feels']."\\".
				$location['view-conditions']."\\".
				$location['view-uv']."\\".
				$location['view-wind']."\\".
				$location['view-dew']."\\".
				$location['view-humidity']."\\".
				$location['view-visibility']."\\".
				$location['view-barometer']."\\".
				$thetime."\\".
				$citytitle."\\".
				$temperature."\\".
				$feelslike."\\".
				$conditions."\\".
				$uv."\\".
				$wind."\\".
				$dew."\\".
				$humidity."\\".
				$visibility."\\".
				$barometer."\\".
				$location['cachetime']."\\".
				$location['viewable']."\\".
				$location['width']."\\".
				$location['margin-right']."\\".
				$location['margin-left']."\\".
				$location['margin-top']."\\".
				$location['margin-bottom']."\\".
				$location['color-background']."\\".
				$location['color-foreground']."\\".
				$location['color-label']."\\".
				$location['color-value']."\\".
				$location['view-place']."\\".
				$location['url']."\\".
				$location['country']);
		}
	}
	else
	{
		$citytitle = $location['cache-name'];
		$conditions = $location['cache-conditions'];
		$temperature = $location['cache-temp'];
		$feelslike = $location['cache-feels'];
		$uv = $location['cache-uv'];
		$wind = $location['cache-wind'];
		$dew = $location['cache-dew'];
		$humidity = $location['cache-humidity'];
		$visibility = $location['cache-visibility'];
		$barometer = $location['cache-barometer'];
	}

	if (!$location['viewable'])
	{
		return;
	}

	if ($location['position'] == "after")
	{
		print "<br>";
	}

	if ($location['width'])
	{
		$tablewidth = $location['width'];
		$tablewidth2 = $tablewidth - 2;
	}
	else
	{
		$tablewidth = $left_size - 12;
		$tablewidth2 = $tablewidth - 2;
	}

	if ($location['margin-right'])
	{
		$table_margin_right = $location['margin-right'];
	}
	else
	{
		$table_margin_right = 4;
	}

	if ($location['margin-left'])
	{
		$table_margin_left = $location['margin-left'];
	}
	else
	{
		$table_margin_left = 4;
	}

	if ($location['margin-top'])
	{
		$table_margin_top = $location['margin-top'];
	}
	else
	{
		$table_margin_top = 4;
	}

	if ($location['margin-bottom'])
	{
		$table_margin_bottom = $location['margin-bottom'];
	}
	else
	{
		$table_margin_bottom = 4;
	}

	if ($location['color-background'])
	{
		$table_color_background = $location['color-background'];
	}
	else
	{
		$table_color_background = $color[9];
	}

	if ($location['color-foreground'])
	{
		$table_color_foreground = $location['color-foreground'];
	}
	else
	{
		$table_color_foreground = $color[3];
	}

	if ($location['color-label'])
	{
		$table_color_label = $location['color-label'];
	}
	else
	{
		$table_color_label = $color[6];
	}

	if ($location['color-value'])
	{
		$table_color_value = $location['color-value'];
	}
	else
	{
		$table_color_value = $color[11];
	}


	print "<table style=\"margin-left: " . $table_margin_left . "px; margin-right: " . $table_margin_right . "px; margin-top: " . $table_margin_top . "px; margin-bottom: " . $table_margin_bottom . "px;\" cellpadding=1 cellspacing=0 border=0 width=" . $tablewidth . " bgcolor=" . $table_color_background . ">";
	print "<tr><td><table cellpadding=1 cellspacing=0 border=0 width=" . $tablewidth2 . " bgcolor=" . $table_color_foreground . ">";

	if ($location['view-place'])
		print "<tr><td align=center><font face=\"helvetica\" style=\"font-size: 8pt;\">" . $location['place'] . "</font></td></tr>";

	if ($location['view-temp'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Temperature") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $temperature . "</font></td></tr>";

	if ($location['view-feels'])
	{
	  # Determine if 'Wind Chill' or 'Heat Index' label should be used
	  # instead of 'Feels Like'; 'Feels Like' is used as a last resort.
 
	  $temp1 = explode( '&deg;', $temperature );
	  $temp2 = explode( '&deg;', $feelslike );

	  if( !strcmp( $feelslike, "N/A" ) )
		  print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Feels Like") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $feelslike . "</font></td></tr>";
	  else if( $temp1[0] < $temp2[0] )
		  print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Heat Index") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $feelslike . "</font></td></tr>";
	  else if( $temp1[0] > $temp2[0] )
		  print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Wind Chill") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $feelslike . "</font></td></tr>";	
	  else
		  print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Feels Like") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $feelslike . "</font></td></tr>";

	}

	if ($location['view-conditions'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Conditions") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $conditions . "</font></td></tr>";

	if ($location['view-uv'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("UV Index") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $uv . "</font></td></tr>";

	if ($location['view-wind'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Wind") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $wind . "</font></td></tr>";

	if ($location['view-dew'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Dew Point") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $dew . "</font></td></tr>";

	if ($location['view-humidity'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Humidity") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $humidity . "</font></td></tr>";

	if ($location['view-visibility'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Visibility") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $visibility . "</font></td></tr>";

	if ($location['view-barometer'])
		print "<tr><td style=\"padding-left: 6px\"><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_label . ">" . _("Barometer") . ": &nbsp; </font><font face=\"helvetica\" style=\"font-size: 8pt;\" color=" . $table_color_value . ">" . $barometer . "</font></td></tr>";

	print '<tr><td style="padding-top: 6px" align=center><a href="';

        if (!empty($location['url'])) 
            echo $location['url'];
        else
            echo 'http://www.srh.noaa.gov/zipcity.php?inputstring=' . $location['code'];

        echo '" target="top"><font face="helvetica" style="font-size: 8pt;" color="' . $table_color_label . '">' . _("Forecast") . '</font></a></td></tr>';
	print "</table></td></tr></table>";

	if ($location['position'] == "before")
	{
		print "<br>";
	}

	return;
}

?>
