<?php

/*******************************************************************************

	Author  .......  Daniel B. Hemmerich
	Contact  ......  dan@spot.org
	Home Site  ....  http://www.spot.org/
	Program  ......  SquirrelMail Plugin - Weather
	Version  ......  4.0.2

*******************************************************************************/

/*
 *  The purpose of this file is for the system administrator (or webmail
 *  administrator) to set limits on the options users can select.
 */


global $weather_proxy, $weather_cache_time_minimum, $weather_location_amount;


/*
 *  Proxy - All users to contact the www.weather.com site via an http proxy.
 *  Both a server and a port must be specified, or the proxy won't work. The
 *  format is either: "http://www.proxy.com:80/" or "www.proxy.com:80". If it
 *  is left blank, then no proxy will be used.
 */

$weather_proxy = "";


/*
 *  Cache Time - Set this for the minimum cache time a user may select. The
 *  weather information is only updated hourly on the weather.com site. There
 *  is no reason to refresh the weather information every time the folder menu
 *  is refreshed if the refresh rate is set low. Some users may not realize
 *  this, and may select to have their weather information cache be very low.
 *  This could definately irritate administrators of heavily used servers.
 *  Recommended value for this it 3600 (3600 secs = 1 hour).
 */

$weather_cache_time_minimum = 3600;


/*
 *  Location Amount - Some users may abuse the purpose of the weather plugin
 *  and add an ungodly amount of locations to monitor. This allows the admin
 *  to limit the amount of locations an individual user may have. There is no
 *  good recommended value, as it depends on the size of the server, as well
 *  as many other factors. I just initially set it to a liberal amount of 10.
 *  Note: this is just the amount of viewable ones. It will not limit the
 *  amount that are permitted to be added.
 */

$weather_location_amount = 10;

?>
