<?php

/*******************************************************************************

    Author ....... Daniel Hemmerich
    Contact ...... dan@spot.org
    Home Site .... http://www.spot.org/
    Program ...... Weather
    Version ...... 1.2.1
    Purpose ...... Grab a weather graphic from www.accuweather, based on the
                   zip code provided by the user, and place it either before
                   or after the folder list on the left (or right).

*******************************************************************************/

function squirrelmail_plugin_init_weather()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks["left_main_before"]["weather"] = "weather_show_before";
    $squirrelmail_plugin_hooks["left_main_after"]["weather"] = "weather_show_after";
    $squirrelmail_plugin_hooks["options_display_inside"]["weather"] = "weather_show_options";
    $squirrelmail_plugin_hooks["options_display_save"]["weather"] = "weather_save_options";
    $squirrelmail_plugin_hooks["loading_prefs"]["weather"] = "weather_load_options";

    return;
}

function weather_show_before()
{
    global $weather_zip_code, $weather_position, $weather_type, $left_size;

    if ($weather_zip_code && ($weather_position == 'above' || $weather_position == ''))
    {
        if ($weather_type == 'large' || ($weather_type == 'auto' && $left_size >= 240))
        {
            print "<a href=\"http://www.accuweather.com/adcbin/curcon_local?nav=home&metric=0&partner=accuweather&zipcode=".$weather_zip_code."\" target=\"new\">";
            print "<center><img src=\"http://www.accuweather.com/wxpost/byzip/".$weather_zip_code."/\" border=\"1\" alt=\"Getting Weather\"></center></a><br><br>";
        }
        elseif ($weather_type == 'small')
        {
            print "<a href=\"http://www.accuweather.com/adcbin/curcon_local?nav=home&metric=0&partner=accuweather&zipcode=".$weather_zip_code."\" target=\"new\">";
            print "<center><img src=\"../plugins/weather/weather.php?zip_code=".$weather_zip_code."&width=140\" border=0 alt=\"Getting Weather\"></center></a><br>";
        }
        elseif ($weather_type == 'auto')
        {
            print "<a href=\"http://www.accuweather.com/adcbin/curcon_local?nav=home&metric=0&partner=accuweather&zipcode=".$weather_zip_code."\" target=\"new\">";
            print "<center><img src=\"../plugins/weather/weather.php?zip_code=".$weather_zip_code."&width=".$left_size."\" border=0 alt=\"Getting Weather\"></center></a><br>";
        }
    }

    return;
}

function weather_show_after()
{
    global $weather_zip_code, $weather_position, $weather_type, $left_size;

    if ($weather_zip_code && $weather_position == 'below')
    {
        if ($weather_type == 'large' || ($weather_type == 'auto' && $left_size >= 240))
        {
            print "<br><br><a href=\"http://www.accuweather.com/adcbin/curcon_local?nav=home&metric=0&partner=accuweather&zipcode=".$weather_zip_code."\" target=\"new\">";
            print "<center><img src=\"http://www.accuweather.com/wxpost/byzip/".$weather_zip_code."/\" border=\"1\" alt=\"Getting Weather\"></center></a><br>";
        }
        elseif ($weather_type == 'small')
        {
            print "<br><br><a href=\"http://www.accuweather.com/adcbin/curcon_local?nav=home&metric=0&partner=accuweather&zipcode=".$weather_zip_code."\" target=\"new\">";
            print "<center><img src=\"../plugins/weather/weather.php?zip_code=".$weather_zip_code."&width=140\" border=0 alt=\"Getting Weather\"></center></a><br>";
        }
        elseif ($weather_type == 'auto')
        {
            print "<a href=\"http://www.accuweather.com/adcbin/curcon_local?nav=home&metric=0&partner=accuweather&zipcode=".$weather_zip_code."\" target=\"new\">";
            print "<center><img src=\"../plugins/weather/weather.php?zip_code=".$weather_zip_code."&width=".$left_size."\" border=0 alt=\"Getting Weather\"></center></a><br>";
        }
    }

    return;
}

function weather_show_options()
{
    global $weather_zip_code, $weather_position, $username, $weather_type;

    print '
        <tr>
            <td align=right>Weather Zip Code:</td>
            <td>
    ';

    print "<input type=\"text\" size=\"5\" name=\"weather_zip_code_in\" value=\"$weather_zip_code\">";

    print '
            </td>
         </tr>
         <tr>
            <td align=right>Weather Position:</td>
            <td>
               <select name="weather_position_in">
    ';

    if ($weather_position == 'above')
        $sel = ' selected';

    print "<option value=above".$sel.">Above folder list\n";

    $sel = '';

    if ($weather_position == 'below' || $weather_position == '')
        $sel = ' selected';

    print "<option value=below".$sel.">Below folder list\n";

    $sel = '';

    print '
               </select>
            </td>
         </tr>
         <tr>
             <td align="right">Size of Weather Image:</td>
             <td>
    ';

    if ($weather_type == 'small' || $weather_type == '')
        $sel = 'checked';

    print "<input type=\"radio\" name=\"weather_type_in\" value=\"small\" ".$sel."> Small &nbsp;&nbsp;";

    $sel = '';

    if ($weather_type == 'large')
        $sel = 'checked';

    print "<input type=\"radio\" name=\"weather_type_in\" value=\"large\" ".$sel."> Large &nbsp;&nbsp;";

    $sel = '';

    if ($weather_type == 'auto')
        $sel = 'checked';

    print "<input type=\"radio\" name=\"weather_type_in\" value=\"auto\" ".$sel."> Automatic (based on folder list width, image may be rough looking)<br>";

    $sel = '';

    print '

</td>
</tr>


    ';

    return;
}

function weather_save_options()
{
    global $data_dir, $username, $weather_zip_code_in, $weather_position_in, $leftsize, $weather_type_in;

    setPref($data_dir, $username, 'weather_zip_code', $weather_zip_code_in);
    setPref($data_dir, $username, 'weather_position', $weather_position_in);
    setPref($data_dir, $username, 'weather_type', $weather_type_in);

    if ($weather_zip_code_in && $leftsize < 240 && $weather_type_in == 'large')
        setPref($data_dir, $username, 'left_size', '240');

    if ($weather_zip_code_in && $leftsize < 140 && $weather_type_in == 'small')
        setPref($data_dir, $username, 'left_size', '140');

    return;
}

function weather_load_options()
{
    global $weather_zip_code, $weather_position, $weather_type, $username, $data_dir;

    $weather_zip_code = getPref($data_dir, $username, 'weather_zip_code');
    $weather_position = getPref($data_dir, $username, 'weather_position');
    $weather_type = getPref($data_dir, $username, 'weather_type');

    return;
}

?>
