<?php

/**
  * SquirrelMail Login Manager Plugin
  * Copyright (C) 2003-2007 Paul Lesneiwski <paul@squirrelmail.org>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/** 
  * Get Per-User, Per-Domain or Per-Service 
  * Level Config Overrides From SQL Database
  *
  * Looks up a user, domain or service level in a SQL database
  * and overrides any settings as found there.
  *
  * @param string $query The query to be run
  * @param string $replacement The value to be inserted into the query
  *                            for lookup (the user name, domain name
  *                            or service level).
  * @param array $args The array of arguments passed to the current hook.
  *
  */
function SQL_settings_lookup($query, $replacement, $args) 
{

   // we assume this function is called from a place 
   // where the config file has already been included...
   //
   global $useSessionBased, $plugins, $squirrelmail_plugin_hooks, $default_org_logo;


   include_once('DB.php');


   $db = vlogin_get_database_connection();

   $query = str_replace('%1', $replacement, $query);


   $settings = $db->getAll($query);


   // check for database errors
   //
   if (DB::isError($settings))
   {
      $msg = $settings->getMessage();
      plain_error_message(sprintf('ERROR IN VLOGIN SQL BACKEND (%s): could not query settings for "%s" - %s', 'SQL_settings_lookup', $replacement, $msg), $color);
      exit;
   }


   if ($useSessionBased)
   {
      global $config_override;
      sqsession_unregister('config_override');
      // If we don't initialize this, it will work
      // together with the multilogin plugin and 
      // any settings already made for the domain
      // $config_override = array();
   }


   $already_enabled = array();


   // override any settings found
   //
   foreach ($settings as $settingPair)
   {

      $setting = $settingPair[0];
      $value = $settingPair[1];


      // put arrays of values back together
      //
      if (strpos($value, ',,') !== FALSE)
      {

         $value_array = explode(',,', $value);

         $value = array();
         foreach ($value_array as $val)
         {
            if (empty($val)) continue;
            if (strpos($val, '=') !== FALSE)
            {
               list($key, $val) = explode('=', $val);
               $value[$key] = $val;
            }
            else  
               $value[] = $val;
         }
         
      }


      // convert strings "true" and "false" to real boolean values
      //
      else if (strtoupper($value) === 'TRUE') $value = TRUE;
      else if (strtoupper($value) === 'FALSE') $value = FALSE;


      if ($useSessionBased)
      {
         // use default org logo if configured and this org_logo non-existent
         //
         if (!empty($default_org_logo) && $setting == 'org_logo' && !file_exists($value))
            $value = $default_org_logo;

         $config_override[$setting] = $value;
      }
      else
      {

         // in order to set the org_title, in the browser
         // title bar, have to do it now (using an eval
         // otherwise things like $_SESSION will never be
         // found when the variable is first defined)
         //
// TODO: what about the embedded PHP setting here???
         if ($setting == 'org_title')
         {
            global $$setting;
            eval('$$setting = ' . $value . ';');
         }


         // use default org logo if configured and this org_logo non-existent
         //
         else if (!empty($default_org_logo) && $setting == 'org_logo' && !file_exists($value))
         {
            global $$setting;
            $$setting = $default_org_logo;
         }


         // enable additional plugins
         //
         else if (stristr($setting, 'enable_plugins'))
         {
            $already_enabled = $value;
            foreach ($value as $pluginName)
            {
               // function is found in Compatibility plugin v2.0.5+
               //
               add_plugin($pluginName, $args);
            }
         }


         // disable plugins
         //
         else if (stristr($setting, 'disable_plugins'))
         {
            // disable ALL plugins?
            //
            if (in_array('*', $value))
            {
               $reenable_vlogin = FALSE;
               $reenable_multilogin = FALSE;
               if (in_array('vlogin', $plugins))
                  $reenable_vlogin = TRUE;
               if (in_array('multilogin', $plugins))
                  $reenable_multilogin = TRUE;

               $plugins = array();
               $squirrelmail_plugin_hooks = array();

               // if we had already enabled some plugins,
               // reenable them again
               //
               foreach ($already_enabled as $pluginName)
                  add_plugin($pluginName, $args, TRUE);

               if ($reenable_multilogin)
                  add_plugin('multilogin', $args, TRUE);
               if ($reenable_vlogin)
                  add_plugin('vlogin', $args, TRUE);
            }

            // no, just disable some plugins...
            //
            else
            {
               foreach ($value as $pluginName)
               {
                  // function is found in Compatibility plugin v2.0.5+
                  //
                  remove_plugin($pluginName);
               }
            }
         }


         // regular config setting...
         //
         else
         {
            global $$setting;
            $$setting = $value;
         }

      }

   }


   if ($useSessionBased)
   {
      
      sqsession_register($config_override, 'config_override');
      
      include_once (SM_PATH . 'plugins/multilogin/functions.php');

      multilogin_sqoverride_config_do($args);

   }

}



