<?php

/**
  * SquirrelMail Virtual Host Login Plugin
  * Copyright (C) 2003-2005 Paul Lesneiwski <paul@openguild.net>
  * This program is licensed under GPL. See COPYING for details
  *
  */


/**
  * Vlogin SQL-based user-to-service level map function
  *
  * @param string $user The username for which to determine
  *                     the servie level
  *
  * @return string The user's service level, or an empty
  *                string if none found.
  *
  */
function vlogin_service_level_map_sql($user)
{

   // we assume this function is called from a place
   // where the config file has already been included...
   //
   global $sqlServiceLevelQuery;


   include_once('DB.php');


   $db = vlogin_get_database_connection();

   $sql = $sqlServiceLevelQuery;
   $sql = str_replace('%1', $user, $sql);


   $service_level = $db->getAll($sql);


   // check for database errors
   //
   if (DB::isError($service_level))
   {
      $msg = $service_level->getMessage();
      plain_error_message('ERROR IN VLOGIN SQL BACKEND (vlogin_service_level_map_sql): could not query service level - ' . $msg, $color);
      exit;
   }

   if (!empty($service_level[0][0]))
      return $service_level[0][0];

   return '';

}



/**
  * Vlogin internal file-based user-to-service level map function
  *
  * @param string $user The username for which to determine
  *                     the servie level
  *
  * @return string The user's service level, or an empty
  *                string if none found.
  *
  */
function vlogin_service_level_map_internal($user)
{

   // we assume this function is called from a place
   // where the config file has already been included...
   //
   global $internalServiceLevelFile;


   // find service level in file
   //
   $service_level = '';
   if ($SERVICELEVELS = @fopen ($internalServiceLevelFile, 'r'))
   {

      while (!feof($SERVICELEVELS))
      {

         $line = fgets($SERVICELEVELS, 4096);
         $line = trim($line);


         // skip blank lines and comment lines
         //
         if (strpos($line, '#') === 0 || strlen($line) < 3)
            continue;


         // parse fields out
         //
         preg_match('/^(\S+)\s+(\S+)/', $line, $matches);


         // stop when we have the right username (case insensitive)
         //
         if (!empty($matches[1]) && strtoupper($user) == strtoupper($matches[1]))
         {
            $service_level = $matches[2];
            break;
         }


         // if wildcard match for user is found,
         // grab service level, but don't stop looking
         // for exact match
         //
         if (!empty($matches[1]) && (strpos($matches[1], '*') !== FALSE
          || strpos($matches[1], '?') !== FALSE))
         {
            if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'),
                        strtoupper($matches[1])) . '$/', strtoupper($user)))
               $service_level = $matches[2];
         }

      }

      fclose($SERVICELEVELS);

   }


   return $service_level;

}



?>
