<?php

// include compatibility plugin
//
if (defined('SM_PATH'))
   include_once(SM_PATH . 'plugins/compatibility/functions.php');
else if (file_exists('../plugins/compatibility/functions.php'))
   include_once('../plugins/compatibility/functions.php');
else if (file_exists('./plugins/compatibility/functions.php'))
   include_once('./plugins/compatibility/functions.php');


function overrideSmConfig() {

  global $data_dir, 
         $org_name, $org_logo, $org_logo_width, $org_logo_height,
         $org_title, $signout_page, $frame_top, $squirrelmail_default_language;

  global $domain, $imapServerAddress, $imapPort, $useSendmail, $smtpServerAddress,
         $smtpPort, $sendmail_path, $use_authenticated_smtp,
         $pop_before_smtp, $imap_server_type, $invert_time, 
         $optional_delimiter;
         
  global $default_folder_prefix, $trash_folder, $sent_folder, $draft_folder,
         $default_move_to_trash, $default_move_to_sent, $default_save_as_draft,
         $show_prefix_option, $list_special_folders_first, $use_special_folder_color,
         $auto_expunge, $default_sub_of_inbox, $show_contain_subfolders_option,
         $default_unseen_notify, $default_unseen_type, $auto_create_special,
         $delete_folder, $noselect_fix_enable, $plugins, $squirrelmail_plugin_hooks;
          
      
  global $notPartOfDomainName, $numberOfDotSections, 
         $putHostNameOnFrontOfUsername, $checkByExcludeList, 
         $at, $dot, $dontUseHostName, $perUserSettingsFile,
         $smHostIsDomainThatUserLoggedInWith, $virtualDomains, 
         $sendmailVirtualUserTable, $virtualDomainDataDir, 
         $allVirtualDomainsAreUnderOneSSLHost, $debug, $removeFromFront, 
         $chopOffDotSectionsFromRight, $chopOffDotSectionsFromLeft,
         $translateHostnameTable, $pathToQmail;
      
  
  // get global variable for versions of PHP < 4.1 
  //
  if (!compatibility_check_php_version(4,1)) {
    global $HTTP_SERVER_VARS, $HTTP_SESSION_VARS, $HTTP_POST_VARS;
    $_SERVER = $HTTP_SERVER_VARS;
    $_SESSION = $HTTP_SESSION_VARS;
    $_POST = $HTTP_POST_VARS;
  }


  // make sure the session has started
  //
  compatibility_sqsession_is_active();


  if (compatibility_check_sm_version(1, 3))
     include_once (SM_PATH . 'plugins/vlogin/config.php');
  else
     include_once ('../plugins/vlogin/config.php');


  // grab hostname into local var
  //
  $hostname = $_SERVER['HTTP_HOST'];


  // for sites where virtual host is pegged on the end of the main
  // site's URL (usually for single-certificate SSL hosting), get 
  // the actual host name out of the PHP_SELF portion of the URL
  //
  if ($allVirtualDomainsAreUnderOneSSLHost) {

     preg_match('/[\/]*(.*?)(\/|$)/', $_SERVER['PHP_SELF'], $matches);
     $hostname = $matches[1];

  }


  // set domain if the $smHostIsDomainThatUserLoggedInWith
  // flag is on...
  //
  if ($smHostIsDomainThatUserLoggedInWith)
     $domain = deconstructDomainName($_SERVER['HTTP_HOST']);
      

  // override data_dir if the $virtualDomainDataDir variable 
  // has been specified
  //
  if (!empty($virtualDomainDataDir)) {
     $data_dir = $virtualDomainDataDir;
     $data_dir = str_replace('###VIRTUAL_DOMAIN###', 
                             deconstructDomainName($_SERVER['HTTP_HOST']), 
                             $data_dir);
  }


  // override the org_logo and other stuff if we find a match
  //
// NOTE: the following line will solve PHP 4.3 problems when using
//       the session_recall patch, however it will also unfortunately
//       mask errors in the config file.  removing this line could
//       possibly help debug non-functional vlogin installations
  if (is_array($virtualDomains))
  foreach (array_keys($virtualDomains) as $virtualDomain) {

    if (stristr($hostname, $virtualDomain)) {


      foreach ($virtualDomains[$virtualDomain] as $setting => $value)
      {

        // enable additional plugins
        //
        if (stristr($setting, 'enable_plugins'))
        {
           foreach ($value as $pluginName)
           {
              $plugins[] = $pluginName;
              use_plugin($pluginName);
           }
           continue;
        }


        // disable plugins
        //
        if (stristr($setting, 'disable_plugins'))
        {
           foreach ($value as $pluginName)
           {
              $pluginKey = array_search($pluginName, $plugins);
              if (!is_null($pluginKey) && $pluginKey !== FALSE)
              {
                 unset($plugins[$pluginKey]);
                 foreach (array_keys($squirrelmail_plugin_hooks) as $hookName)
                 {
                    unset($squirrelmail_plugin_hooks[$hookName][$pluginName]);
                 }
              }
           }
           continue;
        }


        // replace SquirrelMail config values
        //
        $$setting = $value;

      }


      if ($smHostIsDomainThatUserLoggedInWith)
          $domain = deconstructDomainName($_SERVER['HTTP_HOST']);

      
      if (in_array('data_dir', array_keys($virtualDomains[$virtualDomain]))) {
          $data_dir = $virtualDomains[$virtualDomain]['data_dir'];
          $data_dir = str_replace('###VIRTUAL_DOMAIN###',
                                  deconstructDomainName($_SERVER['HTTP_HOST']),
                                  $data_dir);
      }


      // exit this loop
      // 
      break;

    }

  }


  // override settings on a per-user basis
// TODO: not clear if this will work with password_forget and/or login_alias...
  //
  $user = '';
  if (isset($_SESSION['username']))
     $user = $_SESSION['username'];
  elseif (isset($_POST['login_username']))
     $user = $_POST['login_username'];
  perUserOverride($user);



}



// Magic happens below.
function vlogin_domain_do() {


  global $plugins, $login_username, $$login_username, $debug, $data_dir, $foundLoginAlias;
  global $at, $dot, $dontUseHostName, $sendmailVirtualUserTable, $putHostNameOnFrontOfUsername,
         $allVirtualDomainsAreUnderOneSSLHost;


  // get global variable for versions of PHP < 4.1
  //
  if (!compatibility_check_php_version(4,1)) {
    global $HTTP_SERVER_VARS;
    $_SERVER = $HTTP_SERVER_VARS;
  }


  // grab hostname into local var
  //
  $hostname = $_SERVER['HTTP_HOST'];


  // for sites where virtual host is pegged on the end of the main
  // site's URL (usually for single-certificate SSL hosting), get 
  // the actual host name out of the PHP_SELF portion of the URL
  //
  if ($allVirtualDomainsAreUnderOneSSLHost) {

     preg_match('/[\/]*(.*?)(\/|$)/', $_SERVER['PHP_SELF'], $matches);
     $hostname = $matches[1];

  }


  if (compatibility_check_sm_version(1, 3))
     include_once (SM_PATH . 'plugins/vlogin/config.php');
  else
     include_once ('../plugins/vlogin/config.php');



  $user=$login_username;
  
  // if password_forget is loaded, use the obfuscated name
  if (in_array('password_forget',$plugins)) {
    if (!isset($$login_username)) compatibility_sqextractGlobalVar($login_username);
    if ($$login_username != '')
      $user=$$login_username;
  }


  // check for login_alias plugin
  //
  if (in_array('login_alias',$plugins)) {


    // check if login alias was already processed
    if (isset($foundLoginAlias)) {

      //if ($foundLoginAlias) return;

    }
    else {

//TODO!!  check if this works with db prefs!
//also, there might be similar code in the password_forget plugin
      // check for login alias here and return if found
      $filename = $data_dir.'login_alias.pref';
      if (file_exists($filename)) {
        $loginAlias=getPref($data_dir,'login_alias',$user);
        if (!empty($loginAlias)) return;
      }

    }

  }


  // find domain name.  Only truly important bit.

  // check and see if they decided to insert the host anyways
  // or we don't want to use the host name...
  //
  if( !$dontUseHostName && !strstr( $user, $at ) ) { 


    $hostname = deconstructDomainName($hostname);


    // assign realname using parsed hostname
    //
    if ($putHostNameOnFrontOfUsername)
       $realname = $hostname . $at . $user;
    else
       $realname = $user . $at . $hostname;


  } else {
    $realname = $user;
  }

  
  // remap to correct user account when using sendmail virtual logins...
  //
  if (!empty($sendmailVirtualUserTable))
  {
     $realname = getSendmailVirtualUser($realname, $sendmailVirtualUserTable);
  }


  // override settings on a per-user basis
  //
  perUserOverride($realname);


  // if password_forget is loaded, use the obfuscated name
  if (in_array('password_forget',$plugins) && $$login_username != '') $$login_username=$realname;
  else $login_username=$realname;


  // when in debug mode, just dump out final login name and quit
  //
  if ($debug)
  {

     echo '';
     echo '';
     echo '<html><body><hr><br>';
     echo '<h4>Your IMAP login was resolved to:<br><br>';
     echo $realname;
     echo '</h4><br><hr>';
     // was confusing to people using $dontUseHostName 
     // echo '<br>$hostname is ' . $hostname . '<br>';
     echo '<br>PHP_SELF is ' . $_SERVER['PHP_SELF'] . '<br>';
     echo '<br><hr></body></html>';
     exit;

  }

}



function perUserOverride($user) {

  global $data_dir, $squirrelmail_plugin_hooks, 
         $org_name, $org_logo, $org_logo_width, $org_logo_height,
         $org_title, $signout_page, $frame_top, $squirrelmail_default_language;

  global $domain, $imapServerAddress, $imapPort, $useSendmail, $smtpServerAddress,
         $smtpPort, $sendmail_path, $use_authenticated_smtp,
         $pop_before_smtp, $imap_server_type, $invert_time,
         $optional_delimiter;

  global $default_folder_prefix, $trash_folder, $sent_folder, $draft_folder,
         $default_move_to_trash, $default_move_to_sent, $default_save_as_draft,
         $show_prefix_option, $list_special_folders_first, $use_special_folder_color,
         $auto_expunge, $default_sub_of_inbox, $show_contain_subfolders_option,
         $default_unseen_notify, $default_unseen_type, $auto_create_special,
         $delete_folder, $noselect_fix_enable;


  global $numberOfDotSections, $checkByExcludeList, $at, $dot, $dontUseHostName,
         $smHostIsDomainThatUserLoggedInWith, $virtualDomainDataDir, $perUserSettingsFile,
         $removeFromFront, $chopOffDotSectionsFromRight, $chopOffDotSectionsFromLeft,
         $allVirtualDomainsAreUnderOneSSLHost, $sendmailVirtualUserTable;




  // override per-user settings
  //
  if (!empty($perUserSettingsFile) && !empty($user)) {


     // find settings for user
     //
     $userSettings = array();
     if ($USERSETTINGS = @fopen ($perUserSettingsFile, "r"))
     {

        while (!feof($USERSETTINGS))
        {

           $line = fgets($USERSETTINGS, 4096);
           $line = trim($line);


           // skip blank lines and comment lines
           //
           if (strpos($line, '#') === 0 || strlen($line) < 3)
              continue;


           // parse fields out
           //
           if (substr($line, strlen($line) - 1) != ',') $line .= ',';
           preg_match_all('/(.+?),\s*/', $line, $configSettings, PREG_PATTERN_ORDER);


           // stop when we have the right username (case insensitive)
           //
           if (strtoupper($user) == strtoupper($configSettings[1][0]))
           {
              $userSettings = $configSettings[1];
              break;
           }


           // if wildcard match for user is found, 
           // grab settings, but don't stop looking 
           // for exact match
           //
           if (strpos($configSettings[1][0], '*') !== FALSE
            || strpos($configSettings[1][0], '?') !== FALSE)
           {
              if (preg_match('/^' . str_replace(array('?', '*'), array('\w{1}', '.*?'), 
                          strtoupper($configSettings[1][0])) . '$/', strtoupper($user)))
                 $userSettings = $configSettings[1];
           }

        }

        fclose($USERSETTINGS);

     }

     if (sizeof($userSettings) > 0)
     {


        // loop through user's settings 
        //
        foreach ($userSettings as $setting)
        {

           if (!strpos($setting, '='))
              continue;

           $matches = explode('=', $setting);
           $$matches[0] = $matches[1];

        }

     }

  }

}



// Does the actual hostname deconstruction
//
function deconstructDomainName($hostname) {

  global $notPartOfDomainName, $chopOffDotSectionsFromRight, 
         $chopOffDotSectionsFromLeft, $numberOfDotSections, 
         $checkByExcludeList, $at, $dot, $dontUseHostName,
         $removeFromFront, $translateHostnameTable, $pathToQmail;


  if (compatibility_check_sm_version(1, 3))
     include_once (SM_PATH . 'plugins/vlogin/config.php');
  else
     include_once ('../plugins/vlogin/config.php');



  // if enabled, remove "dot sections" until desired size of hostname is reached
  //
  if ($numberOfDotSections > 0) {

     // lop off pieces of hostname until 
     // number of dot sections is same as desired
     //
     while (sizeof(explode('.', $hostname)) > $numberOfDotSections) {

        if ($removeFromFront)
           $hostname = substr($hostname, strpos($hostname, '.') + 1);
        else
           $hostname = substr($hostname, 0, strrpos($hostname, '.'));
        
     }

  }


  // if enabled, remove "dot sections" from the left side...
  //
  for ($i = 0; $i < $chopOffDotSectionsFromLeft; $i++) {

    $hostname = substr($hostname, strpos($hostname, '.') + 1);
     
  }


  // if enabled, remove "dot sections" from the right side...
  //
  for ($i = 0; $i < $chopOffDotSectionsFromRight; $i++) {

    $hostname = substr($hostname, 0, strrpos($hostname, '.'));
     
  }


   // if enabled, extract any of the undesired host name pieces
   //
   if ($checkByExcludeList) {
    
      foreach ($notPartOfDomainName as $dotSection)
      {

         $hostname = preg_replace('/' . $dotSection . '($|\.)/', '', $hostname);

      }

   }


   // if resulting hostname begins or ends with a dot, remove it
   //
   $hostname = preg_replace('/^\./', '', $hostname);
   $hostname = preg_replace('/\.$/', '', $hostname);


  // just in case they need a different '.' seperator
  $hostname = str_replace( ".", $dot, $hostname );


  // if domain name needs to be remapped, do so here
  //
  if (!empty($translateHostnameTable))
     $hostname = translateHostname($hostname, $translateHostnameTable);


  // if qmail/vpopmail domain aliasing is used and we
  // need to translate this domain (if it is an alias),
  // do so here
  //
  if (!empty($pathToQmail))
     $hostname = unaliasQmailDomainAlias($hostname, $pathToQmail);


  return $hostname;

}



// unalias any Qmail/Vpopmail domain aliases
//
function unaliasQmailDomainAlias($host, $pathToQmail)
{
    $tmp = '+'.$host.'-:' ;
    $tlen = strlen($tmp) ;
    $file = fopen($pathToQmail.'/users/assign','r') ;
    while(!feof($file)) {
      $line = fgets($file,256) ;
      if(substr($line,0,$tlen) == $tmp)	{
        $host = substr($line,$tlen) ;
        $tmp = strpos($host,':') ;
        if ($tmp !== FALSE) $host = substr($host,0,$tmp) ;
        break ;
      }
    }
    fclose($file) ;
    return $host;
}



// remap a host name to the one specified in the translate host 
// name table (path given by the $translateHostnameTable)
//
function translateHostname($host, $translateHostnameTable)
{

   if ($HOSTTABLE = @fopen ($translateHostnameTable, 'r'))
   {

      while (!feof($HOSTTABLE))
      {

         $line = fgets($HOSTTABLE, 4096);
         $line = trim($line);


         // skip blank lines and comment lines
         //
         if (strpos($line, '#') === 0 || strlen($line) < 3)
            continue;


         // parse fields out
         //
         preg_match('/^(\S+)\s+(\S+)/', $line, $matches);


         // if host is found, get remapped hostname and return
         //
         if (preg_match('/^' . str_replace(array('?', '*'), 
                                           array('\w{1}', '.*?'),
                                           strtoupper($matches[1])) 
                             . '$/', strtoupper($host)))
         {
            fclose($HOSTTABLE);
            return $matches[2];
         }

      }


      fclose($HOSTTABLE);
      return $host;


   }


   // if we got here and a catchall login is available, use it
   //
   if (!empty($catchallLogin))
   {

      // remove extraneous stuff we don't need off end (begins with plus sign)
      //
      $catchallLogin = preg_replace('/\+%\S+\s*$/', '', $catchallLogin);

      return $catchallLogin;

   }


   // otherwise, unaltered username is returned
   //
   return $user;

}



// remap a user login to the one specified in the sendmail virtual
// user table (path given by the $sendmailVirtualUserTable parameter)
//
function getSendmailVirtualUser($user, $sendmailVirtualUserTable)
{

   global $at;

   $catchallLogin = '';


   if ($VIRTTABLE = @fopen ($sendmailVirtualUserTable, 'r'))
   {

      // be ready to use catchall address - prepare domain name
      //
      $domainName = '';
      if (strpos($user, $at) !== FALSE)
         $domainName = substr($user, strpos($user, $at));


      while (!feof($VIRTTABLE))
      {

         $line = fgets($VIRTTABLE, 4096);
         $line = trim($line);


         // skip blank lines and comment lines
         //
         if (strpos($line, '#') === 0 || strlen($line) < 3)
            continue;


         // parse fields out
         //
         preg_match('/^(\S+)\s+(\S+)/', $line, $matches);


         // grab catchall login
         //
         if ($domainName === $matches[1]) 
            $catchallLogin = $matches[2];


         // if user is found, get remapped login and return
         //
         if ($user === $matches[1]) 
         {
            fclose($VIRTTABLE);
            return $matches[2];
         }

      }


      fclose($VIRTTABLE);


   }


   // if we got here and a catchall login is available, use it
   //
   if (!empty($catchallLogin))
   {

      // remove extraneous stuff we don't need off end (begins with plus sign)
      //
      $catchallLogin = preg_replace('/\+%\S+\s*$/', '', $catchallLogin);

      return $catchallLogin;

   }


   // otherwise, unaltered username is returned
   //
   return $user;

}


?>
