<?php
/*
    Squirrelmail plugin setup file.
    Copyright 2003, 2004 Daniel K. Imori

    This file is part of vkeyboard plugin.

    vkeyboard plugin is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    vkeyboard plugin is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with vkeyboard plugin; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

define('SM_PATH', '../../');

function squirrelmail_plugin_init_vkeyboard()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['login_form']['vkeyboard'] =
    'plugin_vkeyboard_form';
}

function plugin_vkeyboard_form()
{
    include_once(SM_PATH . 'plugins/vkeyboard/config.php');
    include_once(SM_PATH . 'functions/i18n.php');
    $plugin_path = SM_PATH . 'plugins/vkeyboard/';

    global $password_form_name;

    // Gettext functions
    bindtextdomain('vkeyboard', $plugin_path . 'locale');
    textdomain('vkeyboard');

    // Font size
    if($msg_font_size == 'small')
       echo '<p style="text-align: center; font-size: x-small">';
    else
       echo '<p style="text-align: center">';

    // Message?
    if($display_msg == 'yes') {
       echo _("Are you using a public computer?");
       echo '<br>';
       echo _("Enter your password with the ");
    }

    // Button or text?
    if($link_type == 'text') {
       echo '<a href="#" onclick="window.open(\'' . $plugin_path . 'vkeyboard.php' .
            '?passformname=' . $password_form_name . '\', \'\', \'toolbar=no,' .
            'width=450,height=215\')">';
       echo _("virtual keyboard");
       echo '</a>';
    }
    else {
       echo '<input type="button" value="';
       echo _("Keyboard");
       echo '" onclick="window.open(\'vkeyboard.php?passformname=' .
            $password_form_name . '\', \'\', \'toolbar=no,width=450,height=215\')">';
    }

    // Back gettext to Squirrelmail
    bindtextdomain('squirrelmail', SM_PATH . 'locale');
    textdomain('squirrelmail');
}

?>
