<?php
/*  $Id: setup.php,v 0.3 2003/02/24 $
 * 
 *  Copyright (C) 2003 Vi'ktor Bautista i Roca <viktor_at_drac.com>
 *  
 *  Based on Login: Alias plugin 1.3 by David Minor
 *
 *  View the README document for information on installing this. 
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 *  See the complete text at <../../COPYING>
 *  
 */

function squirrelmail_plugin_init_virtusertable() {
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['login_before']['virtusertable'] 
        = 'virtusertable_lookup_alias';
}

/* called in redirect.php */
function virtusertable_lookup_alias() {
 global $login_username;
 global $$login_username;
 global $plugins;
 global $data_dir;
 global $prefs_are_cached;
 global $prefs_cache;
 global $foundLoginAlias;

 $user=$login_username;
 
 // if password_forget is loaded, use the obfuscated name
 if (in_array('password_forget',$plugins)) {
   if (!isset($$login_username)) vut_sqextractGlobalVar($login_username);
   if ($$login_username != '')
  $user=$$login_username;
 }

 $filename = '/etc/mail/virtusertable';

 if (file_exists($filename)) {

  $file = fopen($filename, 'r');
  
  $acaba = 0;
  $realname = "";

  /* Read in the preferences. */
  while ((!feof($file)) && (!$acaba)) 
  {
   $linia = trim(fgets($file, 1024));
   if (preg_match ("/$user\s+(\S+)\s*/i", $linia, $resultat)) 
   {
    $acaba=1;
    $realname = $resultat[1];
   }
  }
  fclose($file);

 }

 $foundLoginAlias = 0;
	
 if (!isset($realname) || $realname=='') return;

 $foundLoginAlias = 1;

 /* if password_forget is loaded, use the obfuscated name */
 if (in_array('password_forget',$plugins) && $$login_username!='') 
  $$login_username=$realname;
 else 
  $login_username=$realname;
}








// returns true if current SquirrelMail version is at mimimum a.b.c
//
function vut_check_SM_version ($a = '0', $b = '0', $c = '0')
{
 global $version;

 list($aa, $bb, $cc) = preg_split('/\./', $version, 3);

 if(!is_numeric($cc))
 list($cc, $info) = explode(' ', $cc, 2);

 return ($aa > $a)
  || (($aa == $a) && ($bb > $b))
  || (($aa == $a) && ($bb == $b) && ($cc >= $c));
}

//
// copied from /src/global.php to accomodate SM versions < 1.2.8...
//

/* returns true if current php version is at mimimum a.b.c */
function vut_check_php_version ($a = '0', $b = '0', $c = '0')
{
 if (vut_check_SM_version(1, 2, 10))
 return check_php_version($a, $b, $c);

 global $SQ_PHP_VERSION;

 if(!isset($SQ_PHP_VERSION))
  $SQ_PHP_VERSION = substr( str_pad( preg_replace('/\D/','', PHP_VERSION), 3, '0'), 0, 3);

 return $SQ_PHP_VERSION >= ($a.$b.$c);
}

/**
 *  Search for the var $name in $_SESSION, $_POST, $_GET
 *  (in that order) and register it as a global var.
 */
function vut_sqextractGlobalVar ($name) 
{
 if (vut_check_SM_version(1, 2, 8))
 {
  sqextractGlobalVar($name);
  return;
 }

 if ( !vut_check_php_version(4,1) )
 {
  global $_SESSION, $_GET, $_POST;
 }

 global  $$name;
 if( isset($_SESSION[$name]) )
 {
  $$name = $_SESSION[$name];
 }
 if( isset($_POST[$name]) )
 {
  $$name = $_POST[$name];
 }
 else if ( isset($_GET[$name]) )
 {
  $$name =  $_GET[$name];
 }
}
?>
