<?php
    function view_as_html_set() {
        global $show_html_default, $view_as_html, $view_unsafe_images;

        if ( (float)substr(PHP_VERSION,0,3) < 4.1 ) {
            global $_GET;
        }
        if(isset($_GET['view_as_html'])) {
            $view_as_html = $_GET['view_as_html'];
        }
        if(isset($_GET['view_unsafe_images'])) {
            $view_unsafe_images = $_GET['view_unsafe_images'];
        }
        /*
         * We only worry if view_unsafe_images is passed from
         * a link.  Other plugins and options should handle it
         * the rest of the time.
         */
        if ($view_unsafe_images) {
            $view_as_html = 1;
        }
        if (isset($view_as_html)) {
            if ($view_as_html == 1) {
                $show_html_default = 1;
            }
            if ($view_as_html == 0) {
                $show_html_default = 0;
            }
        }
    }

    function view_as_html_link() {
        global $show_html_default, $view_as_html, $message,
               $passed_id, $sort, $startMessage,
               $passed_ent_id, $mailbox, $show_more;

        $new_link = "read_body.php?passed_id=$passed_id&amp;mailbox=$mailbox&amp;sort=$sort&amp;startMessage=$startMessage&amp;show_more=$show_more";

        $has_html = 0;
        if ($message->header->type0 == 'multipart' &&
            ($message->header->type1 == 'alternative' ||
             $message->header->type1 == 'mixed' ||
             $message->header->type1 == 'related')) {
            if (findDisplayEntityHTML($message)) {
                $has_html = 1;
            }
        }
        /*
         * Normal single part message so check its type.
         */
        else {
            if ($message->header->type0 == 'text' && $message->header->type1 == 'html') {
                $has_html = 1;
            }
        }
        if ($has_html == 1) {
            include_once('../functions/i18n.php');
            echo '<br>';
            bindtextdomain('view_as_html', '../plugins/view_as_html/locale');
            textdomain('view_as_html');
            if($show_html_default == 1) {
                echo "<a href=\"$new_link&amp;view_as_html=0\">";
                echo _("View as plain text");
                echo "</a>\n";
            }
            else {
                echo "<a href=\"$new_link&amp;view_as_html=1\">";
                echo _("View as HTML");
                echo "</a>\n";
            }
            textdomain('squirrelmail');
        }
    }
?>
