<?php

/**
  * SquirrelMail Verify Reply-To Plugin
  * Copyright (C) 2004-2005 Paul Lesneiwski <pdontthink@angrynerds.com>
  * This program is licensed under GPL. See COPYING for details
  *
  */



/** 
  * Fixes arrays
  *
  * Just removes empty entries and trims all others in an array
  *
  * @param array The array to fix (keys are ignored) (this array
  *              is passed by reference and is changed in place)
  *
  */
function verify_reply_to_do()
{

   $IP_RegExp_Match = '\\[?[0-9]{1,3}(\\.[0-9]{1,3}){3}\\]?';
   $Host_RegExp_Match = '(' . $IP_RegExp_Match .
       '|[0-9a-z]([-.]?[0-9a-z])*\\.[a-z][a-z]+)';
   $Email_RegExp_Match = '[0-9a-z]([-_.+]?[0-9a-z])*(%' . $Host_RegExp_Match .
       ')?@' . $Host_RegExp_Match;


   global $new_reply_to;
   sqgetGlobalVar('new_reply_to', $new_reply_to, SQ_POST);


   if (!empty($new_reply_to) && !preg_match("/$Email_RegExp_Match/", $new_reply_to))
   {

      global $username, $domain, $data_dir, 
             $optmode, $optpage_data, $color;


      $optmode = SMOPT_MODE_DISPLAY;
      $optpage_data['options'][0]['options'][2]->new_value = '';
      $optpage_data['options'][0]['options'][2]->value = '';


/*
global $my_email_address_delimiter;
include_once(SM_PATH . 'plugins/verify_reply_to/config.php');
      $new_reply_to = $username;
      if (strpos($new_reply_to, $my_email_address_delimiter) === FALSE)
         $new_reply_to .= $my_email_address_delimiter . $domain;
*/


      setPref($data_dir, $username, 'reply_to', '');


//      setPref($data_dir, $username, 'reply_to', $new_reply_to);
//      $_POST['new_reply_to'] = $new_reply_to;


      bindtextdomain('verify_reply_to', SM_PATH . 'locale');
      textdomain('verify_reply_to');


//      plain_error_message(sprintf(_("Reply To field must contain a full email address. Reply To has been reset to %s."), '&quot;' . $new_reply_to . '&quot;'), $color);


      plain_error_message(_("Reply To field must contain a full email address. Reply To has been reset."), $color);

      bindtextdomain('squirrelmail', SM_PATH . 'locale');
      textdomain('squirrelmail');

   }

}



?>
