#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! $1; then
 echo "Usage: xdomained.sh domainname.com"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Can't find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi
. $HOME/.vadmin
VDOMAIN=$1

if test ! -d $VADMIN_DIR/$VDOMAIN; then
 echo "Error: Domain $VDOMAIN is not configured with VADMIN"
 exit 1
fi

cd $VADMIN_DIR/cross-admins
while test 1; do
 clear
 echo "Current cross-admins for '$VDOMAIN':"
 echo "--------------------------------------------------"
 for XADMIN in `grep -l $VDOMAIN *`; do echo $XADMIN; done
 echo "--"
 echo -n "Handle/killall/exit: "
 read ACTION
 if test $ACTION; then
  case "$ACTION" in
   exit)
    exit 0
    ;;
   killall)
    echo -n "Remove all cross-admins from this domain? y/[n]: "
    read REPLY
    if test ! $REPLY; then REPLY="n"; fi
    if test $REPLY = "y"; then
     for XADMIN in `grep -l $VDOMAIN *`; do
      grep -v $VDOMAIN "$XADMIN" > .tmp-xadmin
      if test -s .tmp-xadmin; then
       mv .tmp-xadmin "$XADMIN"
      else
       rm .tmp-xadmin "$XADMIN"
      fi
     done
    fi
    ;;
   *)
    XADMIN=$ACTION
    if test -f "$XADMIN"; then
     if egrep "^$VDOMAIN$" "$XADMIN" > /dev/null 2>&1; then
      grep -v $VDOMAIN "$XADMIN" > .tmp-xadmin
      if test -s .tmp-xadmin; then
       mv .tmp-xadmin "$XADMIN"
      else
       rm .tmp-xadmin "$XADMIN"
      fi
     else 
      if egrep "^elvis$" "$XADMIN" > /dev/null 2>&1; then
       echo "$XADMIN is elvis anyway."
       echo -n "[Enter] to continue."
       read REPLY
      else
       echo "$VDOMAIN" >> "$XADMIN"
      fi
     fi
    else
     echo -n "Cross-admin $XADMIN does not exist. Create? [y]/n: "
     read REPLY
     if test ! $REPLY; then REPLY="y"; fi
     if test $REPLY = "y"; then
      echo "$VDOMAIN" > "$XADMIN"
     fi
    fi
    ;;
  esac
 fi
done
