#!/bin/sh 

if test `id -u` != 0 ; then 
 echo "Error: Must be root" 
 exit 1 
fi

clear
cat screens/installer_start.txt
echo -n "Proceed with installation [y]/n: "
read REPLY
if test ! $REPLY; then REPLY="y"; fi
if test $REPLY != "y" ; then exit 1; fi

clear
cat screens/installed_components.txt
echo -n "Did you do everything above? [y]/n: ";
read REPLY
if test ! $REPLY; then REPLY="y"; fi
if test $REPLY != "y" ; then exit 1; fi

clear
cd ..
PLUGIN_DIR=`pwd`
cd scripts
cat screens/plugin_directory.txt | sed "s|%1%|$PLUGIN_DIR|"
echo -n "Plugin directory [$PLUGIN_DIR]: "
read REPLY
if test $REPLY ; then PLUGIN_DIR=$REPLY; fi
if test ! -d $PLUGIN_DIR ; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such directory $PLUGIN_DIR|"
 exit 1
fi

ALAMO=`pwd`
OLDIES="no"
cd $PLUGIN_DIR
cd ../../config
if grep "vchpass" config.php > /dev/null 2>&1; then OLDIES="yes"; fi
if grep "vlogin" config.php > /dev/null 2>&1; then OLDIES="yes"; fi
cd $ALAMO
if test $OLDIES = "yes"; then
 clear
 cat screens/vchpass_vlogin.txt
 exit 1
fi

if test ! -f ../includes/vmail.inc; then
 clear
 cat screens/vmail_inc.txt
 VMAIL_INC="/usr/local/src/vmailmgr-0.96.9"
 while test ! -f "$VMAIL_INC/php/vmail.inc"; do
  echo "Did not find Vmailmgr sources in $VMAIL_INC"
  echo -n "Vmailmgr-0.9x.x directory is here []: "
  read VMAIL_INC
 done
 VMAIL_INC="$VMAIL_INC/php/vmail.inc"
else
 VMAIL_INC="YES"
fi

clear
VADMIN_DIR="/var/vadmin"
cat screens/vadmin_directory.txt | sed "s|%1%|$VADMIN_DIR|"
echo -n "Vadmin storage directory [$VADMIN_DIR]: "
read REPLY
if test $REPLY ; then VADMIN_DIR=$REPLY; fi
if test -d $VADMIN_DIR -a -d $VADMIN_DIR/cross-admins ; then
 clear
 cat screens/old_vadmin_dir.txt | sed "s|%1%|$VADMIN_DIR|"
 echo -n "[Enter] to proceed. "
 read REPLY
fi

clear
HTTPD_CONF="/etc/httpd.conf"
cat screens/which_httpdconf.txt | sed "s|%1%|$HTTPD_CONF|"
echo -n "My httpd.conf is [$HTTPD_CONF]: "
read REPLY
if test $REPLY ; then HTTPD_CONF=$REPLY; fi
if test ! -f $HTTPD_CONF ; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Can't find file $HTTPD_CONF|"
 exit 1
fi

clear
HTTPD_USER=`egrep "^[Uu][Ss][Ee][Rr]" $HTTPD_CONF | sed 's/^[^ ][^ ]* \([^ ][^ ]*\).*/\1/;q'`
HTTPD_GROUP=`egrep "^[Gg][Rr][Oo][Uu][Pp]" $HTTPD_CONF | sed 's/^[^ ][^ ]* \([^ ][^ ]*\).*/\1/;q'`
cat screens/which_apache_proc.txt | sed "s|%1%|$HTTPD_USER|" | sed "s|%2%|$HTTPD_GROUP|"
echo -n "My apache runs as user [$HTTPD_USER]: "
read TMPUSER
echo -n "My apache runs as group [$HTTPD_GROUP]: "
read TMPGROUP
if test $TMPUSER ; then HTTPD_USER=$TMPUSER; fi
if test $TMPGROUP ; then HTTPD_GROUP=$TMPGROUP; fi
if test ! egrep "^$HTTPD_USER:" /etc/passwd > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such user '$HTTPD_USER'|"
 exit 1
fi
if ! egrep "^$HTTPD_GROUP:" /etc/group > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|No such group '$HTTPD_GROUP'|"
 exit 1
fi

if ! egrep "^[Uu][Ss][Ee][Rr] *$HTTPD_USER" $HTTPD_CONF > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Your apache is NOT running as user '$HTTPD_USER'|"
 exit 1
fi

if ! egrep "^[Gg][Rr][Oo][Uu][Pp] *$HTTPD_GROUP" $HTTPD_CONF > /dev/null 2>&1; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Your apache is NOT running as group '$HTTPD_GROUP'|"
 exit 1
fi

clear
cat screens/crypto_line.txt
echo -n "Crypto Line: "
read CRYPTO_HASH_LINE
CRYPTO_HASH_LINE=`echo $CRYPTO_HASH_LINE | sed 's/"//g'` 
if test -z "$CRYPTO_HASH_LINE" ; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|You can't use an empty CRYPTO_HASH_LINE!|"
 exit 1
fi

clear
MCRYPT_ALGO="blowfish"
cat screens/choose_algo.txt | sed "s|%1%|$MCRYPT_ALGO|"
echo -n "Use this algorythm [$MCRYPT_ALGO]: "
read REPLY
if test $REPLY ; then MCRYPT_ALGO=$REPLY; fi

#check to see if they already have an include line
APACHE_INCLUDE="NO"
if ! egrep "^[Ii]nclude *$PLUGIN_DIR/includes/apache.inc" $HTTPD_CONF > /dev/null 2>&1; then
 clear
 APACHE_INCLUDE="YES"
 cat screens/apache_include.txt | sed "s|%1%|$PLUGIN_DIR|"
 if test -f $PLUGIN_DIR/includes/apache.inc; then
  echo "NOTICE: I've found an old apache.inc file. It will be overwritten"
  echo "during this install. If you wish to save that file for any later"
  echo "purposes, you need to do so now."
  echo
  echo
 fi
 echo -n "Add an include line to httpd.conf? [y]/n: "
 read REPLY
 if test ! $REPLY; then REPLY=$APACHE_INCLUDE; fi
 if test $REPLY = "y"; then REPLY="YES"; fi
 if test $REPLY = "yes"; then REPLY="YES"; fi
 if test $REPLY = "Yes"; then REPLY="YES"; fi
 if test $REPLY = "n"; then REPLY="NO"; fi
 if test $REPLY = "no"; then REPLY="NO"; fi
 if test $REPLY = "No"; then REPLY="NO"; fi
 if test $REPLY; then APACHE_INCLUDE=$REPLY; fi
 if test $APACHE_INCLUDE != "YES" -a $APACHE_INCLUDE != "NO"; then
  clear
  cat screens/error_generic.txt | sed "s|%ERROR%|Valid values are YES or NO|"
  exit 1
 fi
fi

clear
VADMIN_CROSS_ADMIN_AUTH_METHOD="USER"
cat screens/auth_method.txt
echo -n "Cross-admins should use this auth method ([USER]/SYSTEM): "
read REPLY
if test $REPLY ; then VADMIN_CROSS_ADMIN_AUTH_METHOD=$REPLY; fi
if test $VADMIN_CROSS_ADMIN_AUTH_METHOD != "USER" -a $VADMIN_CROSS_ADMIN_AUTH_METHOD != "SYSTEM"; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Valid methods are either USER or SYSTEM|"
 exit 1
fi

clear
VADMIN_CROSS_ADMIN_FORCE_HTTPS="NO"
cat screens/force_https.txt
echo -n "Disallow logins if not using HTTPS? y/[n]: "
read REPLY
if test ! $REPLY; then REPLY=$VADMIN_CROSS_ADMIN_FORCE_HTTPS; fi
if test $REPLY = "y"; then REPLY="YES"; fi
if test $REPLY = "yes"; then REPLY="YES"; fi
if test $REPLY = "Yes"; then REPLY="YES"; fi
if test $REPLY = "n"; then REPLY="NO"; fi
if test $REPLY = "no"; then REPLY="NO"; fi
if test $REPLY = "No"; then REPLY="NO"; fi
if test $REPLY; then VADMIN_CROSS_ADMIN_FORCE_HTTPS=$REPLY; fi
if test $VADMIN_CROSS_ADMIN_FORCE_HTTPS != "YES" -a $VADMIN_CROSS_ADMIN_FORCE_HTTPS != "NO"; then
 clear
 cat screens/error_generic.txt | sed "s|%ERROR%|Valid values are YES or NO|"
 exit 1
fi

clear
cat screens/elvis.txt
echo -n "Make this user a superuser: "
read REPLY
if test $REPLY; then VADMIN_ELVIS=$REPLY; fi

clear
VADMIN_MAX_ORG_IMAGE_SIZE_KB=100
cat screens/max_imgsize.txt | sed "s|%1%|$VADMIN_MAX_ORG_IMAGE_SIZE_KB|"
echo -n "Maximum image size in kilobytes should be [$VADMIN_MAX_ORG_IMAGE_SIZE_KB]: "
read REPLY
if test $REPLY; then VADMIN_MAX_ORG_IMAGE_SIZE_KB=$REPLY; fi

# don't give them a choice about delimiters. Nobody really changes
# these.. ;)
VADMIN_DELIMITERS="@:"

clear
cat screens/finalize.txt
echo "PLUGIN_DIR: $PLUGIN_DIR"
echo "VADMIN_DIR: $VADMIN_DIR"
echo "VMAIL_INC: $VMAIL_INC"
echo "HTTPD_CONF: $HTTPD_CONF"
echo "HTTPD_USER: $HTTPD_USER"
echo "HTTPD_GROUP: $HTTPD_GROUP"
echo "CRYPTO_HASH_LINE: $CRYPTO_HASH_LINE"
echo "MCRYPT_ALGO: $MCRYPT_ALGO"
echo "APACHE_INCLUDE: $APACHE_INCLUDE"
echo "VADMIN_CROSS_ADMIN_AUTH_METHOD: $VADMIN_CROSS_ADMIN_AUTH_METHOD"
echo "VADMIN_CROSS_ADMIN_FORCE_HTTPS: $VADMIN_CROSS_ADMIN_FORCE_HTTPS"
echo -n "VADMIN_ELVIS: "
if test $VADMIN_ELVIS; then
 echo $VADMIN_ELVIS; else
 echo "NO"
fi
echo "VADMIN_MAX_ORG_IMAGE_SIZE_KB: $VADMIN_MAX_ORG_IMAGE_SIZE_KB"
# echo "VADMIN_DELIMITERS: $VADMIN_DELIMITERS"
echo 
echo -n "Does this look right? [y]/n: "
read REPLY
if test ! $REPLY; then REPLY="y"; fi
if test $REPLY != "y"; then exit 1; fi

clear
# Rock and roll!
echo "Vadmin v0.9 Installer: Creating files"
echo "--------------------------------------"
echo
if test ! -d $VADMIN_DIR; then
 echo -n "Creating $VADMIN_DIR directory..."
 mkdir $VADMIN_DIR
 chmod 0755 $VADMIN_DIR
 echo "done"
fi
if test ! -d $VADMIN_DIR/cross-admins; then
 echo -n "Creating cross-admins directory..."
 mkdir $VADMIN_DIR/cross-admins
 chmod 0755 $VADMIN_DIR/cross-admins
 echo "done"
fi
if test $VADMIN_ELVIS; then
 echo -n "Adding Elvis..."
 echo "elvis" > "$VADMIN_DIR/cross-admins/$VADMIN_ELVIS"
 echo "done"
fi
if test $VMAIL_INC != "YES"; then
 echo -n "Copying vmail.inc into includes..."
 cp $VMAIL_INC ../includes/
 echo "done"
fi
echo "Saving preferences in $HOME/.vadmin to be later used by"
echo -n "other vadmin scripts..."
# stick some vars into ~/.vadmin so we can read them later
# from other vadmin scripts
echo "#!/bin/sh" > $HOME/.vadmin
echo "# These variables are used by vadmin scripts" >> $HOME/.vadmin
echo "PLUGIN_DIR=$PLUGIN_DIR" >> $HOME/.vadmin
echo "VADMIN_DIR=$VADMIN_DIR" >> $HOME/.vadmin
echo "HTTPD_USER=$HTTPD_USER" >> $HOME/.vadmin
echo "HTTPD_GROUP=$HTTPD_GROUP" >> $HOME/.vadmin
echo "done"
echo -n "Creating an Apache include file..."
cat $PLUGIN_DIR/includes/apache.inc.tmpl | sed "s|%PLUGIN_DIR%|$PLUGIN_DIR|
s|%CRYPTO_HASH_LINE%|$CRYPTO_HASH_LINE|
s|%MCRYPT_ALGO%|$MCRYPT_ALGO|" > $PLUGIN_DIR/includes/apache.inc
echo "done"
echo -n "Setting restrictive permissions on apache.inc..."
chmod 0600 $PLUGIN_DIR/includes/apache.inc
echo "done"
if test $APACHE_INCLUDE = "YES"; then
 echo "Adding include line to $HTTPD_CONF..."
 echo "Include $PLUGIN_DIR/includes/apache.inc" >> $HTTPD_CONF
 echo '...done --> RESTART APACHE SERVER TO TAKE EFFECT<--'
fi
if test -f $PLUGIN_DIR/vadmin_config.php; then
 echo -n "Saving your existing vadmin_config.php in vadmin_config.bak.php..."
 mv $PLUGIN_DIR/vadmin_config.php $PLUGIN_DIR/vadmin_config.bak.php
 echo "done"
fi
echo -n "Generating a vadmin_config.php file..."
cat $PLUGIN_DIR/vadmin_config.php.tmpl | sed "s|%VADMIN_DIR%|$VADMIN_DIR|
s|%VADMIN_CROSS_ADMIN_AUTH_METHOD%|$VADMIN_CROSS_ADMIN_AUTH_METHOD|
s|%VADMIN_CROSS_ADMIN_FORCE_HTTPS%|$VADMIN_CROSS_ADMIN_FORCE_HTTPS|
s|%VADMIN_MAX_ORG_IMAGE_SIZE_KB%|$VADMIN_MAX_ORG_IMAGE_SIZE_KB|
s|%VADMIN_DELIMITERS%|$VADMIN_DELIMITERS|" > $PLUGIN_DIR/vadmin_config.php
echo "done"
echo
echo "All done! Install is complete. Now you will need to add some"
echo "domains using vaddomain.sh script or domain_magic.sh. Good luck!"
echo 
if test $APACHE_INCLUDE = "YES"; then
 echo "-->You will need to run 'apachectl restart' to enable the hash key<--"
 echo
fi
echo "Vadmin v0.9 Installer by Konstantin Riabitsev (c) 2k1."
echo
echo

