<?php
/**
    USERVCHPASSSET MODULE
    ----------------------
    Used by users changing passwords and called after they submit
    a new password. Does some self-explanatory checks, then 
    changes the password and sets a new "key" cookie so users
    don't have to re-login after they have changed the password.
    Mostly adapted from my own vchpass plugin.
    								**/
    
 global $color, $key, $onetimepad, $VADMIN_DOMAIN, $uname;
 $oldpass = $_POST{'oldpass'};
 $newpass = $_POST{'newpass'};
 $reppass = $_POST{'reppass'};
 $PHP_SELF = $_SERVER{'PHP_SELF'};

 $key = $_COOKIE{'key'};
 $onetimepad = $_SESSION{'onetimepad'};
 $clear_key = OneTimePadDecrypt($key, $onetimepad);
 if ($oldpass != $clear_key) vadmin_userError("Incorrect old password");
 if ($newpass != $reppass) vadmin_userError("New password did not match repeat password");
 if ($newpass == $clear_key) vadmin_userError("New password is the same as old one");
 if (ereg("[[:space:]]", $newpass)) vadmin_userError("Sorry, password cannot contain spaces");
 if (strlen($newpass)<6) vadmin_userError("Password must be at least 6 characters long");
 // get secret
 $secret = vadmin_get_domain_passwd($VADMIN_DOMAIN);
 // check if secret is good
 if (vadmin_domain_passwd_isbad($VADMIN_DOMAIN, $secret)){
 	vadmin_systemError("Sorry, but this service is not available at 
	this time. Please try again later, or notify somebody in charge
	that this feature is not working.");
 }
 
 $repl=vchpass($VADMIN_DOMAIN, $secret, $uname, $newpass);
 if ($repl[0]) vadmin_systemError($repl[1]);
 ereg ("(^.*/)[^/]+/[^/]+/[^/]+$", $PHP_SELF, $regs); //get out of plugins dir
 $base_uri = $regs[1];
 setcookie("key", OneTimePadEncrypt($newpass, $onetimepad), 0, $base_uri);
 
 $body="<table border='0' width='50%' align='center'>
 <tr>
  <th bgcolor='$color[9]'>Password changed successfully</th>
 </tr>
 <tr>
  <td align='center'>
   Your password was changed successfully. Next time you log in, please use
   your new password.
  </td>
 </tr>
 <tr>
  <th bgcolor='$color[9]'>&nbsp;</th>
 </tr>
 </table>";

 $title="Password changed";
 vadmin_makePage($title, null, $body);
?>
