<?php
/**
   VADMIN_FUNCTIONS.INC
   --------------
   All Vadmin-wide functions are in this file.
   
**/

function vadmin_putsession($varname, $varvalue){
  // save a session variable
  if (strstr(phpversion(), "4.0")){
    // don't look, I'm hideous!
    global $$varname;
    $$varname = $varvalue;
    session_register($varname);
  } else {
    $_SESSION[$varname] = $varvalue;
  }
}  
   
function vadmin_getsession($varname){
  // retrieve a session variable
  $sessvalue = false;
  if (strstr(phpversion(), "4.0")){
    // argh. This is the hairiest code...
    global $$varname;
    session_register($varname);
    $sessvalue = $$varname;
  } else {
    $sessvalue = $_SESSION[$varname];
  }
  return $sessvalue;
}

function vadmin_load_prefs($domain){
 // Loads domain preferences from the prefs file
 // in domain directory in $VADMIN_DIR. Returns
 // an assoc array.
 global $VADMIN_DIR;
 $filename="$VADMIN_DIR/$domain/prefs";
 $contents= vadmin_get_file($filename);
 if (!$contents) return;
 $c_ary = explode("\n", $contents);
 for ($i=0; $i<sizeof($c_ary); $i++){
  list($pref, $value) = explode(":", $c_ary[$i]);
  $prefs_ary[$pref] = trim($value);
 }
 return $prefs_ary;
}

function vadmin_save_prefs($domain, $prefs_ary){
 // Saves domain preferences into a prefs file
 // in $VADMIN_DIR directory.
 global $VADMIN_DIR;
 while (list($pref, $value)=each($prefs_ary)){
  $c_ary[] = "$pref: $value";
 }
 $contents = join("\n", $c_ary);
 vadmin_put_file("$VADMIN_DIR/$domain/prefs", $contents);
}

function vadmin_trim_array(&$array_member){
 // This function is called from array_walk()
 // Trims every member of array.
 $array_member=trim($array_member);
}

function vadmin_security_breach(){
 // A scarecrow function
 echo "INTRUDER ALERT ON DECK 5. CMDR TUVOK AND SECURITY TEAM REQUESTED!";
 exit;
}

function vadmin_systemError($message){
 // Generic error template. This one is used when an error is
 // due to system problems and not user input.
 $body="<hr><p><strong>SYSTEM ERROR: $message</strong>. We apologize for
 the inconvenience, but your request cannot be completed at this time.
 Please contact your system administrator if the problem persists.</p>
 <hr>";
 vadmin_makePage("SYSTEM ERROR", null, $body);
 exit;
}

function vadmin_userError($message){
 // Generic user error template. This function is used whenever
 // there are errors in user input.
 $body="<p><strong>Error: $message</strong>. Please return to the
 previous page and try to correct your input. If you need assistance
 or believe this is a software error, please contact your system
 administrator.</p>";
 vadmin_makePage("Input Error", null, $body);
 exit;
}

function vadmin_host_walk(){
 // Looks at the domain name and tries to determine
 // which domain directory in $VADMIN_DIR corresponds
 // to this domain name. It will drop domain levels
 // until it either finds a directory or reaches
 // second level.
 global $VADMIN_DIR;
 $HTTP_HOST = $_SERVER{'HTTP_HOST'};
 // Remove a :port if it is there.
 list($HTTP_HOST, $junk) = explode(":", $HTTP_HOST);
 if (file_exists("$VADMIN_DIR/$HTTP_HOST")) return $HTTP_HOST;
 $vhost_file = $HTTP_HOST;
 $dom_ary = explode(".", $HTTP_HOST);
 while (sizeof($dom_ary)>2 && !file_exists("$VADMIN_DIR/$vhost_file")){
  array_shift($dom_ary);
  $vhost_file = join(".", $dom_ary);
 }
 if (file_exists("$VADMIN_DIR/$vhost_file")) return $vhost_file;
 return false;
}

function vadmin_auth(){
 // This function is the authentication core of VADMIN.
 // Read docs/SECURITY for explanation of VADMIN security.
 global $username, $VADMIN_DIR;
 $HTTP_HOST = $_SERVER{'HTTP_HOST'};
 $VADMIN_AUTHCODE=vadmin_getsession("VADMIN_AUTHCODE");
 if (!$username) vadmin_security_breach();
 
 if ($VADMIN_AUTHCODE) return $VADMIN_AUTHCODE;
 $access_host = vadmin_host_walk();
 if (!$access_host){
  vadmin_putsession("VADMIN_AUTHCODE", "NO");
  return "NO";
 }
 
 $admins=file("$VADMIN_DIR/$access_host/admins");
 @array_walk($admins, 'vadmin_trim_array');
 if (in_array($username, $admins)){
  $VADMIN_AUTHCODE="LOGIN"; 
 } else {
  // see if this is a cross-admin
  if (file_exists("$VADMIN_DIR/cross-admins/$username")){
   // see if this is elvis!
   $domain_list = file("$VADMIN_DIR/cross-admins/$username");
   @array_walk($domain_list, 'vadmin_trim_array');
   if ($domain_list[0]=="elvis"){
    $VADMIN_AUTHCODE="ELVIS";
   } else {
    $VADMIN_AUTHCODE="CROSS";
   }
  } else {
   $VADMIN_AUTHCODE="NO";
  }
 }
 vadmin_putsession("VADMIN_AUTHCODE", $VADMIN_AUTHCODE);
 return $VADMIN_AUTHCODE;
}

function vadmin_get_file($filename){
 // Grabs a file and returns all its contents.
 // Pretty generic.
 if (!file_exists($filename)) vadmin_systemError("$filename does not exist");
 $fd=fopen($filename, "r");
 if (!$fd) vadmin_systemError("Could not open $filename for reading.");
 $contents = fread($fd, filesize($filename));
 fclose($fd);
 return $contents;
}

function vadmin_put_file($filename, $contents){
 // writes a file onto the HDD.
 // Pretty generic as well.
 $fd=fopen($filename, "w");
 if (!$fd) vadmin_systemError("Could not open $filename for writing. Check your permissions");
 fwrite($fd, $contents);
 fclose($fd);
}

function vadmin_unlink_file($filename){
 // Doesn't really unlink, since we have to preserve
 // the file "shells" in order to still be able to
 // write to these files later. It just zeroes the
 // contents.
 vadmin_put_file("$filename", "");
}

function vadmin_user_get_unamedomain($unamedomain){
 // Looks at the user's login name, which should be
 // either user@domain.com or user:domain.com, and
 // separates the userid from the domain name, returning
 // them in an array.
 global $VADMIN_DELIMITERS;
 for ($i=0; $i<strlen($VADMIN_DELIMITERS); $i++){
  $separator=substr($VADMIN_DELIMITERS, $i, 1);
  list($uname, $domain) = explode($separator, $unamedomain);
  if ($domain) break;
 }
 if ($domain) $ret_ary=array($uname, $domain);
 else $ret_ary=array("", "");
 return $ret_ary;
}

function vadmin_domain_passwd_isbad($domain, $passwd){
 // Validates the supplied domain/password pair by trying
 // to connect to the daemon and getting a listing for the
 // domain in question. If successful, returns false. If
 // not, returns an error message provided by the daemon
 $reply = vm_daemon_raw(array("listdomain", $domain, $passwd));
 if (is_array($reply)){
  // did not validate;
  return $reply[1];
 } else {
  // validation successful.
  return false;
 }
}

function vadmin_switch_module($newmod){
 // Used to switch from one MOD to another
 // in the middle of a MOD.
 global $MOD, $WORK_DIR;
 $MOD=$newmod;
 include("$WORK_DIR/modules/$MOD.mod");
 exit;
}

function vadmin_get_domain_passwd($domain){
 // returns a stored domain password or false if 
 // it can't find one.
 global $VADMIN_DIR;
 if (!file_exists("$VADMIN_DIR/$domain/passwd")) return false;
 $contents=vadmin_get_file("$VADMIN_DIR/$domain/passwd");
 if (!$contents) return false;
 return vadmin_crypto($contents, "decrypt");
}

function vadmin_put_domain_passwd($domain, $passwd){
 // saves an encrypted domain password onto the disk
 // See docs/CRYPTO, docs/SECURITY, and docs/INSTALL
 // for more info.
 global $VADMIN_DIR;
 vadmin_put_file("$VADMIN_DIR/$domain/passwd", vadmin_crypto($passwd, "encrypt"));
}

function vadmin_makePage($title, $scriptsrc, $body){
 // GUI wrap-around for every generated page.
 // I am soooo lazy! $scriptsrc is not currently
 // used in VADMIN (this is pretty much the same function 
 // as in SquirrelSpell, but I decided to keep it in case
 // I will add this functionality later.
 global $color, $VADMIN_VERSION, $MOD;
 displayPageHeader($color, "None");
 ?>
 &nbsp;<br>
 <?php if($scriptsrc) { ?>
  <script type="text/javascript" src="js/<?php echo $scriptsrc ?>"></script>
 <?php } ?>
 <table width="95%" align="center" border="0" cellpadding="2" cellspacing="0">
  <tr>
   <td bgcolor="<?php echo $color[9] ?>" align="center">
      <strong><?php echo $title ?></strong>
   </td>
  </tr>
  <tr><td><hr></td></tr>
  <tr><td>
   <?php echo $body ?>
  </td></tr>
  <?php if (!strstr($MOD, "log") && 
    !strstr($MOD, "askpass") && $MOD!="mainmenu" && 
    !strstr($MOD, "uservchpass")){
   // Generate a nice return-to-main link.
   ?>
   <tr><td><hr></td></tr>
   <tr><td align="center"><a href="vadmin_main.php">Back to &quot;Main Menu&quot; page</a></td></tr>
  <?php } ?>
  <tr><td><hr></td></tr>
  <tr>
   <td bgcolor="<?php echo $color[9] ?>" align="center">
      Vmailmgr Admin <?php echo $VADMIN_VERSION;
      if (!strstr($MOD, "log") && !strstr($MOD, "uservchpass")){ 
      // give them a logout option, unless it's a login screen or
      // a user module.
      ?> (<strong><a href="vadmin_main.php?MOD=logout">Logout</a></strong>)
      <?php } ?>
   </td>
  </tr>
 </table>
 <?php
}

function vadmin_crypto($input, $mode){
 //
 // This function does the encryption and decryption of sensitive
 // data stored on the HDD. It uses the CRYPTO_HASH_LINE as key.
 // See docs for more info and/or explanation of the security
 // structure of VADMIN.
 //
 $CRYPTO_HASH_LINE = $_SERVER{'CRYPTO_HASH_LINE'};
 $MCRYPT_ALGO = $_SERVER{'MCRYPT_ALGO'};
 if (!$CRYPTO_HASH_LINE || !$MCRYPT_ALGO || !function_exists('mcrypt_generic'))
  vadmin_systemError("Cannot continue. VmailMgr Admin is misconfigured");
 
 $td = mcrypt_module_open($MCRYPT_ALGO, "", MCRYPT_MODE_ECB, "");
 $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
 @mcrypt_generic_init($td, $CRYPTO_HASH_LINE, $iv);
 switch ($mode){
  case "encrypt":
   $crypto = base64_encode(mcrypt_generic($td, $input));
  break;
  case "decrypt":
   $crypto = mdecrypt_generic($td, base64_decode($input));
  break;
 }
 mcrypt_generic_end ($td);
 return $crypto;
}


 /**
    $VADMIN_VERSION
    ----------------
    Moved from vadmin_config.php for easier upgrades.
    VADMIN version. Do not modify. 
    								**/
 $VADMIN_VERSION="v1.0.2";

?>
