<?php
/**
   VADMIN_MAIN.PHP
   --------------------
   Main wrapper for the vadmin interface. This file is accessed
   by admins and takes care of all authorization.
   								**/

$WORK_DIR="vadmin";

// Load some necessary stuff.
chdir("..");
include_once("../src/validate.php");
include_once("../src/load_prefs.php");
include_once("../functions/strings.php");
include_once("../functions/page_header.php");
include_once("$WORK_DIR/vadmin_config.php");
require_once("$WORK_DIR/includes/vmail.inc");
require_once("$WORK_DIR/includes/vadmin_functions.inc");

$AUTHCODE=vadmin_auth();
$MOD = $_GET{'MOD'};
if (!isset($MOD)){
  // try post
  $MOD = $_POST{'MOD'};
}
if (!$AUTHCODE || $AUTHCODE=="NO"){
 // Shouldn't happen. If someone with bad AUTHCODE got here, then
 // they are trying to be baaaad. Kick them.
 vadmin_security_breach();
}

if ($AUTHCODE=="LOGIN" || $AUTHCODE=="CROSS" || $AUTHCODE=="ELVIS"){
 // needs logging in
 // check whether https is enforced.
 if ($VADMIN_CROSS_ADMIN_FORCE_HTTPS=="YES" && ($AUTHCODE=="CROSS" || $AUTHCODE=="ELVIS")){
  if (!$_SERVER{"HTTPS"}) $MOD="loginneedhttps";
 }
 if (!isset($MOD)){
  $MOD="login";
 } else {
  // if anybody with a MOD and a pre-logged AUTHCODE
  // tries to get to a non-login MOD, kick them hard.
  if (!strstr($MOD, "login")) vadmin_security_breach();
 }
} else {
 // they are already logged in.
 // get and decrypt the domain they are authorized to admin
 // during this session.
 // trim() is because for some reason the string terminates
 // with a "null". I almost smashed my laptop before I
 // found this one out. Don't know why it is there --
 // most likely a MCRYPT-related bug...
 $VADMIN_DOMAIN = trim(vadmin_crypto($AUTHCODE, "decrypt"));
 if (!isset($MOD)) $MOD="mainmenu";
}

// see if someone is attempting to be nasty by trying to get out of the
// modules directory, although it probably wouldn't do them any good,
// since every module has to end with .mod. Still, they deserve
// to be warned. ;)
if (strstr($MOD, ".") || strstr($MOD, "/") || strstr($MOD, "%"))
     vadmin_security_breach();	

// load the necessary module.
include_once("$WORK_DIR/modules/$MOD.mod");
?>
