#!/bin/sh

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Can't find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi
. $HOME/.vadmin

while test 1; do
 clear
 echo "Current Cross-Admins"
 echo "----------------------"
 ls $VADMIN_DIR/cross-admins
 echo "-- "
 echo -n "Handle/killall/exit: "
 read ACTION
 if test ! $ACTION; then exit 0; fi
 case "$ACTION" in
  exit)
   exit 0
   ;;
  killall)
   echo -n "This will delete ALL cross-admins! Proceed? y/[n]: "
   read REPLY
   if test ! $REPLY; then REPLY="n"; fi
   if test $REPLY = "y"; then
    rm -f $VADMIN_DIR/cross-admins/*
   fi
   ;;
  *)
   XADMIN=$ACTION
   if test ! -f $VADMIN_DIR/cross-admins/$XADMIN; then
    echo -n "Cross-admin $XADMIN doesn't exist. Create? [y]/n: "
    read REPLY
    if test ! $REPLY; then REPLY="y"; fi
    if test $REPLY = "y"; then
     touch $VADMIN_DIR/cross-admins/$XADMIN
    fi
   fi
   if test -f $VADMIN_DIR/cross-admins/$XADMIN; then
    while test 1; do
     clear
     echo "Editing $XADMIN:"
     echo "--------------------------------------------"
     cat $VADMIN_DIR/cross-admins/$XADMIN
     echo "--"
     echo -n "Domainname/elvis/delete/done/exit: "
     read BOOGER
     if test $BOOGER; then
      case "$BOOGER" in
       done)
        break
	;;
       exit)
        exit 0
        ;;
       delete)
        echo -n "Delete $XADMIN? y/[n]: "
        read REPLY
        if test ! $REPLY; then REPLY="n"; fi
        if test $REPLY = "y"; then
         rm -f $VADMIN_DIR/cross-admins/$XADMIN
         echo "$XADMIN deleted."
         break
        fi
        ;;
       elvis)
        echo "elvis" > $VADMIN_DIR/cross-admins/$XADMIN
        ;;
       *)
        VDOMAIN=$BOOGER
        if egrep "^$VDOMAIN$" $VADMIN_DIR/cross-admins/$XADMIN > /dev/null 2>&1; then
         grep -v $VDOMAIN $VADMIN_DIR/cross-admins/$XADMIN > .xadmin-tmp
         mv .xadmin-tmp $VADMIN_DIR/cross-admins/$XADMIN
        else
         if test ! -d $VADMIN_DIR/$VDOMAIN; then
          echo "No such domain $VDOMAIN"
          echo -n "[Enter] to continue"
          read REPLY
         else
          if egrep "^elvis$" $VADMIN_DIR/cross-admins/$XADMIN > /dev/null 2>&1; then
           rm $VADMIN_DIR/cross-admins/$XADMIN
          fi
          echo $VDOMAIN >> $VADMIN_DIR/cross-admins/$XADMIN
         fi
        fi
        ;;
      esac
     fi
    done
   fi
 esac
done
