#!/bin/sh

BE_VERBOSE="NO"

if test `id -u` != 0; then 
 echo "Error: Must be root!"
 exit 1
fi

if test ! $1; then
 echo "Usage: vaddomain.sh domainname.com"
 exit 1
fi

if test ! -f $HOME/.vadmin; then
 echo "Can't find $HOME/.vadmin. Run installer.sh or mkdot-vadmin.sh"
 exit 1
fi
. $HOME/.vadmin

VDOMAIN=$1

if test -d $VADMIN_DIR/$VDOMAIN; then
 echo "$VDOMAIN is already set up."
 exit 1
fi

echo "Adding $VDOMAIN..."
mkdir $VADMIN_DIR/$VDOMAIN
echo -n " creating passwd file..."
touch $VADMIN_DIR/$VDOMAIN/passwd
echo "done"
echo -n " creating prefs file..."
touch $VADMIN_DIR/$VDOMAIN/prefs
echo "done"
echo -n " creating pic file..."
touch $VADMIN_DIR/$VDOMAIN/pic
echo "done"
echo -n " setting permissions..."
chown $HTTPD_USER:$HTTPD_GROUP $VADMIN_DIR/$VDOMAIN/*
echo "done"
echo -n " creating admins file..."
touch $VADMIN_DIR/$VDOMAIN/admins
echo "done"
echo "... all done. Domain '$VDOMAIN' created."

if test ! $SCRIPTS_DIR; then
 SCRIPTS_DIR="$PLUGIN_DIR/scripts"
 while test ! -f "$SCRIPTS_DIR/admined.sh"; do
  SCRIPTS_DIR="/root/vadmin-scripts"
  echo "You have moved Vadmin scripts out of the PLUGIN_DIR. Where are they?"
  echo -n "[$SCRIPTS_DIR]: "
  read SCRIPTS_DIR
  if test ! $SCRIPTS_DIR; then SCRIPTS_DIR="/root/vadmin-scripts"; fi
 done
 echo "SCRIPTS_DIR=$SCRIPTS_DIR" >> $HOME/.vadmin
else
 if test ! -f "$SCRIPTS_DIR/admined.sh"; then
  while test ! -f "$SCRIPTS_DIR/admined.sh"; do
   echo "Your SCRIPTS_DIR is set in ~/.vadmin, but it's invalid. Where is it now?"
   echo -n "[$SCRIPTS_DIR]: "
   read SCRIPTS_DIR
   if test ! $SCRIPTS_DIR; then SCRIPTS_DIR="/root/vadmin-scripts"; fi
  done
  grep -v "SCRIPTS_DIR" $HOME/.vadmin > $HOME/.vadmin.tmp
  mv $HOME/.vadmin.tmp $HOME/.vadmin
  echo "SCRIPTS_DIR=$SCRIPTS_DIR" >> $HOME/.vadmin
 fi
fi

   
if test $BE_VERBOSE = "YES"; then
 echo
 cat $SCRIPTS_DIR/screens/lowly_admins.txt
fi
echo
echo -n "Would you like to add lowly admins to this domain? [y]/n: "
read REPLY
if test ! $REPLY; then REPLY="y"; fi
if test $REPLY = "y"; then
 $SCRIPTS_DIR/admined.sh $VDOMAIN
fi
if test $BE_VERBOSE = "YES"; then
 echo
 cat $SCRIPTS_DIR/screens/cross_admins.txt
 echo
fi
echo -n "Would you like to set cross-admins for this domain? [y]/n: "
read REPLY
if test ! $REPLY; then REPLY="y"; fi
if test $REPLY = "y"; then
 $SCRIPTS_DIR/xdomained.sh $VDOMAIN
fi
