<?php
/**
 * accounts.mod
 * ------------
 * This file takes care of user accounts and aliases.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: accounts.mod,v 1.54 2009/09/05 02:45:10 pdontthink Exp $
 * 
 * @author Konstantin Riabitsev ($Author: pdontthink $)
 * @version $Date: 2009/09/05 02:45:10 $
 */

$max_length_of_display_field_contents_change_confirmation = 200;


/**
 * This is the only function not in the common include file. It generates
 * a nice output so I don't have to do it over and over again. It only
 * takes one param, but modifies several global values. 
 *
 * @param $command  the name of parameter that was modified.
 * @param $userid   the user whose attributes are being changed
 *                  (OPTIONAL; default not specified)
 * @param $value    the value of the new attribute (even if it was invalid/failed)
 *                  (OPTIONAL; default not specified)
 * @param $desig    the current logged in user's authentication level
 *                  (OPTIONAL; default not specified - unprivileged)
 *
 * @return         void.
 */
function vadmin_report_progress($command, $userid='', $value='', $desig=FALSE){
    $me = 'vadmin_report_progress';
    /**
     * Dirty little bastard, that's what I am. :(
     */
    global $change_count, $body, $errormsg, $successmsg, $color, $skip_pwd, $skip_mailfwd;
    
    /** 
     * Make pretty alternating rows.
     */
    if ($change_count/2 != intval($change_count/2)){
        $body .= '<tr bgcolor="' . $color[0] . '">';
    } else{
        $body .= '<tr>';
    }
    $body .= '<th>' . $command . ':</th><td>';
    spew("$me: reporting progress of '$command'");
    if ($errormsg){
        spew("$me: reporting an error: $errormsg");
        $body .= '<strong>' . _("Error:") . '</strong> ' . $errormsg;


        // add override password button if allowed
        //
        $overrides_ok = explode(',', vadmin_getvar('CONFIG', 'password.override'));
        @array_walk($overrides_ok, 'vadmin_trim_array');
        if ($skip_pwd && in_array(strtolower($desig), $overrides_ok)) {
//FIXME: use $LVL?  $MOD? but these are global, and I really don't want to use globals, so hard-coded for now
            $action = vadmin_mkform_action('admin', 'accounts', 'chattrs_force_pwd');
            $body .= ' <form method="post" action="' . $action . '" style="display:inline; margin:0"><input type="hidden" name="userid" value="' . $userid . '" /><input type="hidden" name="vpassword" value="' . $value . '" /><input type="submit" value="' . _("Override") . '"/></form>';
            $skip_pwd = FALSE;
        }


        // add override forwards button if allowed
        //
        $overrides_ok = explode(',', vadmin_getvar('CONFIG', 'forwarding.override'));
        @array_walk($overrides_ok, 'vadmin_trim_array');
        if ($skip_mailfwd && in_array(strtolower($desig), $overrides_ok)) {
//FIXME: use $LVL?  $MOD? but these are global, and I really don't want to use globals, so hard-coded for now
            $action = vadmin_mkform_action('admin', 'accounts', 'chattrs_force_mailfwd');
            $body .= ' <form method="post" action="' . $action . '" style="display:inline; margin:0"><input type="hidden" name="userid" value="' . $userid . '" /><input type="hidden" name="valiases" value="' . $value . '" /><input type="submit" value="' . _("Override") . '"/></form>';
            $skip_mailfwd = FALSE;
        }


        $body .= ''
            . '</td></tr>';
    } else {
        spew("$me: reporting a success: $successmsg");
        $body .= '<strong>' . _("Success:") . '</strong> '
            . $successmsg . '</td></tr>';
    }
    $change_count++;
    $errormsg = '';
    $successmsg = '';
}

$ACT = vadmin_getvar('VADMIN', 'ACT');
$LVL = vadmin_getvar('VADMIN', 'LVL');
$MOD = 'accounts';
$me = "$MOD.mod/$ACT";
spew("$me: taking over");

$domain   = vadmin_getvar('VADMIN',  'VADMIN_DOMAIN');
$crypto   = vadmin_getvar('SESSION', 'VADMIN_SECRET');
$secret   = vadmin_crypto($crypto, 'decrypt');
$color    = vadmin_getvar('SQMAIL', 'color');
$username = vadmin_getvar('SQMAIL', 'username');
$desig    = vadmin_get_user_designation($domain, $username);

global $javascript_on;

$catchall_alias = vadmin_getvar('BACKEND', 'catchall_alias');

// getuser action needs to be changed to listall
// when username contains a wildcard
//
$search_user = '';
if ($ACT == 'getuser')
{
   $userid = vadmin_getvar('GET', 'userid');
   if (!$userid){
       $userid = vadmin_getvar('POST', 'userid');
   }
   if (strpos($userid, '*') !== FALSE)
   {
      $search_user = $userid;
      $ACT = 'listall';
   }
}

// when we have a listall action generated by the
// delete button on that page, change the action
// to the multiple deletion confirmation (or if only
// one user was selected, go to the single user 
// delete page)
//
$multiple_del_come_single_userid = '';
if ($ACT == 'listall')
{
   $delbutton = vadmin_getvar('POST', 'delbutton');
   $delusers = vadmin_getvar('POST', 'delusers');
   if (!empty($delbutton) && !empty($delusers))
      if (sizeof($delusers) < 2) {
          $ACT = 'deluser';
          $multiple_del_come_single_userid = array_shift(array_keys($delusers));
      } else
          $ACT = 'delmultipleusersconfirm';
}

switch ($ACT){
    /***************************** listall *****************************/
 case 'listall':
 case 'inactivelookup':
 case 'activelookup':
     $trackusage = vadmin_get_pref($domain, 'track_usage');
     $pagination = vadmin_getvar('BACKEND', 'pagination');
     $sortCol = vadmin_getvar('GET', 'sortCol');
     $meth = vadmin_getvar('GET', 'meth');
     if (empty($search_user)) 
         $search_user = urldecode(vadmin_getvar('POST', 'search_user'));
     if (empty($search_user)) 
         $search_user = urldecode(vadmin_getvar('GET', 'search_user'));
     if ($meth == 'GET') {
         $limit = vadmin_getvar('GET', 'limit');
         if (!$limit) $limit = $pagination;
         $pageNumber = vadmin_getvar('GET', 'page');
     } else {
         $limit = vadmin_getvar('POST', 'limit');
         if (!$limit) $limit = $pagination;
         $pageNumber = vadmin_getvar('POST', 'page');
     }

     spew("$me: Calling listdomain");

     if ($ACT == 'inactivelookup') {
         // send pagination info even if not available; should not cause notices
         $userbunch = listdomain($domain, $secret, $limit, $pageNumber, $sortCol, $search_user, -1);
     } else if ($ACT == 'activelookup') {
         // send pagination info even if not available; should not cause notices
         $userbunch = listdomain($domain, $secret, $limit, $pageNumber, $sortCol, $search_user, 1);
     } else {
         // send pagination info even if not available; should not cause notices
         $userbunch = listdomain($domain, $secret, $limit, $pageNumber, $sortCol, $search_user);
     }

     if ($limit) {
         spew("$me: Total users on this page for this domain: " . sizeof($userbunch));
     } else {
         spew("$me: Total users in this domain: " . sizeof($userbunch));
     }

     // what fields are to be displayed on this screen?
     //
     $displayablefields = vadmin_get_displayable_fields('user_list', 'username');

     $numbercols = sizeof($displayablefields);

     // figure out pagination
     //
     global $LISTDOMAIN_TOTAL_USERS, $LISTDOMAIN_FIRST_USER_PER_PAGE;
     $paginationLink = vadmin_mkform_action($LVL, $MOD, $ACT)
                     . '&search_user=' . urlencode($search_user);
     $sortLink = $paginationLink;
     if ($pagination && $LISTDOMAIN_TOTAL_USERS) {
         if (!$pageNumber) $pageNumber = 1;
         $sortLink .= '&page=' . $pageNumber . '&limit=' . $limit . '&meth=GET';
         if (!empty($sortCol)) $paginationLink .= '&sortCol=' . $sortCol;
         $totalPages = ceil($LISTDOMAIN_TOTAL_USERS / $limit);
         if ($totalPages > 1) {
             $paginator = '<tr bgcolor="' . $color[9] . '">'
                 . '<td colspan="' . $numbercols . '">' 
                 . '<input type="hidden" name="limit" value="'
                 . $limit . '">'
                 . '<table width="100%" cellspacing="0" cellpadding="0" border="0">'
                 . '<tr><td align="left">'
                 . _("Total:") . ' ' . $LISTDOMAIN_TOTAL_USERS 
                 . '</td><td align="right"><select name="page">';
             for ($i = 1; $i <= $totalPages; $i++)
                 $paginator .= '<option value="' . $i 
                            . ($i == $pageNumber ? '" SELECTED>' : '">') 
                            . $i 
                            . (!empty($LISTDOMAIN_FIRST_USER_PER_PAGE)
                               && is_array($LISTDOMAIN_FIRST_USER_PER_PAGE)
                            ? ' - ' . $LISTDOMAIN_FIRST_USER_PER_PAGE[$i - 1] : '')
                            . '</option>';
             $paginator .= '</select> <input type="submit" value="'
                        . _("Go") . '" /></td></tr></table></td></tr>';
         } else 
             $paginator = '<tr bgcolor="' . $color[9] . '"><td colspan="' 
                 . $numbercols . '">' . _("Total:") . ' ' 
                 . $LISTDOMAIN_TOTAL_USERS . '</td></tr>';
     } else {
         $paginator = '';
     }

     $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');
     if ($support_aliases == 'yes')
        $username_title = _("Username/Alias");
     else
        $username_title = _("Username");

     $body = ''
         . '<form style="display:inline; margin:0" method="POST" action="' . $paginationLink
         . '"><table border="0" align="center" width="95%">'
         . $paginator
         . ' <tr bgcolor="' . $color[9] . '">'
         . (in_array('delete_checkbox', $displayablefields) ? '  <th>' 
         . ($javascript_on ? '<a href="#" onclick="for (i = 0; i < document.forms.length; i++) { for (j = 0; j < document.forms[i].elements.length; j++) { if (document.forms[i].elements[j].type == \'checkbox\') document.forms[i].elements[j].checked = !document.forms[i].elements[j].checked; } }">' : '')
         . _("Del") 
         . ($javascript_on ? '</a>' : '')
         . '</th>' : '')
         . (in_array('username', $displayablefields) ? '  <th><a href="' . $sortLink . '">' . $username_title . '</a></th>' : '')
         . (in_array('info', $displayablefields) ? '  <th>' . _("Personal Info") . '</th>' : '')
         . ($trackusage != FALSE && in_array('webmail_stats', $displayablefields) ? '  <th><a href="' . $sortLink . '&sortCol=login">' . _("Last Login") . '</a></th>' : '')
         . (in_array('mailbox', $displayablefields) ? '  <th>' . _("Mailbox") . '</th>' : '')
         . (in_array('forwards', $displayablefields) ? '  <th>' . _("Forwards") . '</th>' : '')
         . ' </tr>';
     spew("$me: Checking if this is a CROSS or ELVIS to show admin info");
     $never_show_admins = vadmin_getvar('CONFIG', 'permissions.never_show_admins');
     $show_admin = false;
     if ($never_show_admins == "no" && ($desig == 'CROSS' || $desig == 'ELVIS')){
         $show_admin = true;
         $lowly_ary = vadmin_get_lowly_array($domain);
     }

     $flip = true;
     foreach ($userbunch as $userarray){

         $userid = $userarray[0];
         if ($userid == $catchall_alias){
             if (vadmin_IMAP_usernames_have_domain($domain))
             {
//FIXME: why using @ instead of $delim???
//FIXME: should we use $catchall_alias instead of *?  does * work for all backends?
                $userid = '*@' . $domain;
                $usertitle = $userid;
             }
             else
             {
//FIXME: should we use $catchall_alias instead of *?  does * work for all backends?
                $userid = '*';
//FIXME: why using @ instead of $delim???
                $usertitle = "*@$domain";
             }
             spew("$me: catchall ('$catchall_alias') account found. Changed to '$userid'");
         } else {
//FIXME: shouldn't we be using $delim instead of @??
             $usertitle = "$userid@$domain";
         }
         $userStatus = vadmin_get_user_designation($domain, "$usertitle");
         $can_edit = vadmin_get_edit_perms($domain, $username, $desig,
                                           $usertitle);

         // get user webmail stats
         //
         if ($trackusage != FALSE && $can_edit && !is_alias($userarray)) {
             if (isset($userarray[13]['LAST_LOGIN']))
                 $stats = $userarray[13];
             else
                 $stats = vadmin_get_user_webmail_stats($userarray[0], $domain);
             $last_login = $stats['LAST_LOGIN'];
             $last_login_short = $stats['LAST_LOGIN_SHORT'];
             $total_logins = $stats['TOTAL_LOGINS'];
             $never_logged_in = $stats['NEVER_LOGGED_IN'];
             if ($never_logged_in) {
//                 $bg_row_never_logged_in = $color[12];
                 $bg_row_never_logged_in = $color[3];
                 $last_login_short .= '<small> (<a href="'
                                   . vadmin_mkform_action($LVL, $MOD, 'deluser')
                                   . '&userid=' . $userid 
                                   . '&camefrom=' . $ACT 
                                   . '">' . _("del") . '</a>)</small>';
             }
             else
                 $bg_row_never_logged_in = '';
         } else {
             $last_login = '';
             $last_login_short = '';
             $total_logins = '';
             $never_logged_in = '';
             $bg_row_never_logged_in = '';
         }

         if ($flip = !$flip){
             $body .= '<tr bgcolor="' 
               . ($bg_row_never_logged_in ? $bg_row_never_logged_in : $color[0]) .'">';
         } else {
             $body .= '<tr' 
               . ($bg_row_never_logged_in ? ' bgcolor="' . $bg_row_never_logged_in 
               . '"' : '') . '>';
         }

         $link = vadmin_mkform_action($LVL, $MOD, 'getuser');
         if ($show_admin == true){
             //if (in_array($usertitle, $lowly_ary)){
             if ($userStatus == 'LOWLY'){
                 $userid = sprintf(_("%s (admin)"), $userid);
                 spew("$me: $userid is a lowly admin");
             }
         }
         if (in_array('delete_checkbox', $displayablefields)){

             // second test below excludes catchall aliases where 
             // the catchall is a blank value because there is no
             // way to tell it apart from the username "0", and
             // it generally causes problems
             //
             if ($can_edit == true && $userarray[0] !== ''){
                 $body .= '<td><input type="checkbox" name="delusers[' . $userarray[0] . ']" value="1" /></td>';
             } else {
                 $body .= '<td></td>';
             }
         }
         if (in_array('username', $displayablefields)){
             if ($can_edit == true){
                 $body .= ''
                     . '<td>'
                     . ' <a href="' . $link . '&amp;userid=' . $userarray[0] 
                     . '&camefrommod=' . $MOD . '&camefromact=' . $ACT
                     . '">';
                 if ($show_admin) {
                     if ($userStatus == 'ELVIS' && $desig == 'ELVIS')
                        $body .= '<strong>^';
                     else if ($userStatus == 'CROSS')
                        $body .= '<strong>*';
                     else if ($userStatus == 'LOWLY')
                     //else if (in_array($usertitle, $lowly_ary))
                        $body .= '<strong>';
                 }
                 $body .= $userid;
                 if ($show_admin) {
                     if ($userStatus == 'ELVIS' || $userStatus == 'CROSS' 
                      || $userStatus == 'LOWLY')
                        $body .= '</strong>';
                 }
                 $body .= '</a>'
                     . '</td>';
             } else {
                 $body .= '<td>' . $userid . '</td>';
             }
         }

         $body .= ''
             . (in_array('info', $displayablefields) ? '<td>' 
             . (!is_alias($userarray) ? $userarray[4] : '') 
             . '&nbsp;</td>' : '')
             . ($trackusage != FALSE && in_array('webmail_stats', $displayablefields) ? '<td><small>' 
             . $last_login_short
             . '&nbsp;</small></td>' : '')
             . (in_array('mailbox', $displayablefields) ? '<td>' 
             . (!is_alias($userarray) ? $userarray[2] : '') . '&nbsp;</td>' : '');

         if (in_array('forwards', $displayablefields)){
             $body .= '<td>';
             if (sizeof($userarray[3])){
                 $body .= htmlspecialchars(join(', ', $userarray[3]));
             } else {
                 $body .= '&nbsp;';
             }
             $body .= '</td>';
         }
         $body .= '</tr>';
     }
     $body .= ''
         . ' <tr bgcolor="' . $color[9] . '">'
         . '  <th align="left"><input type="submit" name="delbutton" value="' . _("Del") . '"></th>'
         . '  <th colspan="' . ($numbercols - 1) . '">';

     // show previous/next links at bottom if pagination is in use
     //
     if ($pagination && $LISTDOMAIN_TOTAL_USERS) {
         global $color;
         if ($pageNumber > 1) {
             $body .= '<a href="' . $paginationLink . '&page=1&limit=' . $limit . '&meth=GET">' . _("<< First") . '</a>'
                   . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                   . '<a href="' . $paginationLink . '&page=' . ($pageNumber - 1) . '&limit=' . $limit . '&meth=GET">' . _("< Previous") . '</a>';
         } else {
             $body .= '<span style="color : ' . $color[0] . ';">' . _("<< First")
                   . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                   . _("< Previous") . '</span>';
         }
         $body .= '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
         if ($pageNumber < $totalPages) {
             $body .= '<a href="' . $paginationLink . '&page=' . ($pageNumber + 1) . '&limit=' . $limit . '&meth=GET">' . _("Next >") . '</a>'
                   . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                   . '<a href="' . $paginationLink . '&page=' . $totalPages . '&limit=' . $limit . '&meth=GET">' . _("Last >>") . '</a>';
         } else {
             $body .= '<span style="color : ' . $color[0] . ';">' . _("Next >")
                   . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                   . _("Last >>") . '</span>';
         }
     } else {
         $body .= _("End of listing");
     }

     $body .= ''
         . '  </th>'
         . ' </tr></table></form>'
         . '<table align="center" width="95%" cellpadding="0" cellspacing="0" border="0"><tr><td style="white-space: nowrap;">'
         . ($show_admin ? '<small>'
         . ' * cross-admin<br />'
         . ($desig == 'ELVIS' ? ' ^ superuser<br />' : '')
         . ' </small>' : '')
         . '</td><td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td><td>'
         . ($ACT == 'activelookup' || $ACT == 'inactivelookup' 
         ? _("Please note that active status is only based on webmail usage and does not account for usage of any other email clients.")
         : '')
         . '</td></tr></table>';
     if ($ACT == 'inactivelookup') {
         $title = sprintf(_("Inactive user listing for %s"), $domain);
         $previous_link = '<tr><td align="center"><a href="'
                        . vadmin_mkform_action($LVL, 'email', 'acctlist')
                        . '">&lt; ' . _("Previous") . '</a></td></tr>';
     } else if ($ACT == 'activelookup') {
         $title = sprintf(_("Active user listing for %s"), $domain);
         $previous_link = '<tr><td align="center"><a href="'
                        . vadmin_mkform_action($LVL, 'email', 'acctlist')
                        . '">&lt; ' . _("Previous") . '</a></td></tr>';
     } else if (empty($search_user)) {
         $title = sprintf(_("User listing for %s"), $domain);
         $previous_link = '<tr><td align="center"><a href="'
                        . vadmin_mkform_action($LVL, 'email', 'acctlist')
                        . '">&lt; ' . _("Previous") . '</a></td></tr>';
     } else {
         $title = sprintf(_("User listing for %s matching \"%s\""), $domain, $search_user);
         $previous_link = '<tr><td align="center"><a href="'
                        . vadmin_mkform_action($LVL, 'email', 'userlookup')
                        . '">&lt; ' . _("Previous") . '</a></td></tr>';
     }
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

    /***************************** quicklistall *****************************/
 case 'quicklistall':

     $numberOfCols = vadmin_getvar('CONFIG', 'username.quicklist_columns');

     $vadmin_backend = vadmin_getvar('CONFIG', 'backend.type');

     if (!function_exists('getQuickAccountList')) {
         $userbunch = listdomain($domain, $secret);
         $userList = array();
         foreach ($userbunch as $user)
             $userList[] = $user[0];
     } else {
         $userList = getQuickAccountList($domain, $secret, '');
     }
     $title = sprintf(_("Quick user listing for %s"), $domain);
     $previous_link = '<tr><td align="center"><a href="'
                    . vadmin_mkform_action($LVL, 'email', 'acctlist')
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';


     // split results into number of columns
     //
     $totalUsers = sizeof($userList);
     $colSize = ceil($totalUsers / $numberOfCols);
     $cols = array();
     for ($i = 0; $i < $numberOfCols; $i++) {
         $cols[$i] = array_splice($userList, 0, $colSize);
     }


     // now spit out whatever we found
     //
     $body = ''
         . '<table border="0" align="center" width="95%">'
         . ' <tr bgcolor="' . $color[9] . '">'
         . '<th colspan="' . $numberOfCols . '">' . _("Total:") . $totalUsers . '</th>'
         . ' </tr>';


     $getuserLink = vadmin_mkform_action($LVL, 'accounts', 'getuser');
     $flip = TRUE;
     for ($i = 0; $i < $colSize; $i++){
         if ($flip = !$flip){
             $body .= '<tr bgcolor="' . $color[0] .'">';
         } else {
             $body .= '<tr>';
         }

         for ($j = 0; $j < $numberOfCols; $j++) {
             if (isset($cols[$j][$i])) {
                 $userid = $cols[$j][$i];
                 if ($userid == $catchall_alias) {
                     if (vadmin_IMAP_usernames_have_domain($domain))
                     {
//FIXME: why using @ instead of $delim???
//FIXME: should we use $catchall_alias instead of *?  does * work for all backends?
                        $userid = '*@' . $domain;
                        $usertitle = $userid;
                     }
                     else
                     {
//FIXME: should we use $catchall_alias instead of *?  does * work for all backends?
                        $userid = '*';
//FIXME: why using @ instead of $delim???
                        $usertitle = "*@$domain";
                     }
                     spew("$me: catchall ('$catchall_alias') account found. Changed to '$userid'");
                 } else {
//FIXME: shouldn't we be using $delim instead of @??
                     $usertitle = "$userid@$domain";
                 }
                 $body .= '<td>'
                       . '<a href="' . $getuserLink
                       . '&userid=' . $cols[$j][$i] . '">' . $userid  . '</a>'
                       . '&nbsp;&nbsp;&nbsp;</td>';
             } else {
                 $body .= '<td>'
                       . '&nbsp;&nbsp;&nbsp;</td>';
             }
         }

         $body .= ''
             . ' </tr>';
     }

     $body .= ''
         . '</table>';

     vadmin_make_page($title, null, $body, true, true, $previous_link);

     break;

     /******************************** getuser ***************************/
 case 'getuser':

     $camefrommod = vadmin_getvar('POST', 'camefrommod');
     if (empty($camefrommod)) $camefrommod = vadmin_getvar('GET', 'camefrommod');
     if (empty($camefrommod)) $camefrommod = 'email';
     $camefromact = vadmin_getvar('POST', 'camefromact');
     if (empty($camefromact)) $camefromact = vadmin_getvar('GET', 'camefromact');
     if (empty($camefromact)) $camefromact = 'acctlist';

     $trackusage = vadmin_get_pref($domain, 'track_usage');

     /**
      * See if this user really exists
      */
     spew("$me: checking if such user exists");
     $userid = vadmin_getvar('GET', 'userid');
     if (!$userid){
         $userid = vadmin_getvar('POST', 'userid');
     }

     // force username to lowercase if SM is set as such
// FIXME: do we want to do this globally at the top of the file or anything?  or do we NOT want to do this at all?
     //
     global $force_username_lowercase;
     if ($force_username_lowercase)
        $userid = strtolower($userid);

//FIXME: shouldn't we be using $delim instead of @??
     $usertitle = "$userid@$domain";
     $command = array('lookup', $domain, $userid, $secret);
     $tmp = vm_daemon_raw($command);
     if ($tmp[0]){
         spew("$me: no such user or alias '$userid'");
         $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');
         if ($support_aliases == 'yes')
             $msg = sprintf(_("No such user or alias exists: %s"), $userid);
         else
             $msg = sprintf(_("No such user exists: %s"), $userid);
         vadmin_user_error($msg);
     }
   
     /**
      * Make sure they can edit this user.
      */
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }

     /**
      * Call lookup(), a function provided by vmail.inc.
      */
     spew("$me: fetching the user data");
     $user_ary = listdomain_parse_userdata($tmp[1], $userid);

     /**
      * Since it doesn't return the password, change the "Set" into
      * "encrypted" to make it more obvious to the end-user.
      */
     if ($user_ary[1] != 'Set'){
         spew("$me: password is not set for this user");
         $setpass = "-"; 
     } else {
         spew("$me: changing password to 'encrypted' for clarity");
         $setpass = _("encrypted");
     }
   
     /**
      * Process and organize the rest of the data.
      */
     $mailbox = $user_ary[2];
     spew("$me: mailbox is '$mailbox'");
     
     if (is_array($user_ary[3])){
         $aliases = join(', ', $user_ary[3]);
     } else {
         $aliases = '';
     }
     spew("$me: aliases is '$aliases'");
   
     $personal_info = $user_ary[4];
     spew("$me: personal_info is '$personal_info'");
   
     $addon_custom_textareas = array();
     $hard_quota = $user_ary[5];
     $soft_quota = $user_ary[6];
     $size_limit = $user_ary[7];
     if ($hard_quota != '-'){
         $hard_quota = intval($hard_quota/1024/1024);
     }
     if ($soft_quota != '-'){
         $soft_quota = intval($soft_quota/1024/1024);
     }
     if ($size_limit != '-'){
         $size_limit = intval($size_limit/1024/1024);
     }
     spew("$me: hard_quota is '$hard_quota'");
     spew("$me: soft_quota is '$soft_quota'");
     spew("$me: size_limit is '$size_limit'");
   
     $count_limit = $user_ary[8];
     $creation_time = $user_ary[9];
     spew("$me: count_limit is '$count_limit'");
     spew("$me: creation_time is '$creation_time'");
     if (empty($creation_time) || $creation_time == '===N/A===') {
        $creation_time = '(date unknown)';
     } else {
         if (!is_numeric($creation_time))
            $creation_time = strtotime($creation_time);
         $creation_time = date("M-d-Y", $creation_time);
     }
     spew("$me: formatted creation_time is '$creation_time'");
   
     $expiry_time = $user_ary[10];
     if ($expiry_time != '-'){
         /**
          * Convert into days from seconds.
          */
         $expiry_time = intval($expiry_time/86400);
     }
     spew("$me: expiry_time is '$expiry_time'");
     
     if ($userid == $catchall_alias){
         $usertitle = _("a 'catchall' account");
     } else {
         $usertitle = sprintf('%s@%s', $userid, $VADMIN_DOMAIN);
     }
     spew("$me: usertitle is '$usertitle'");
     $title = sprintf(_("Listing for <em>%s</em>, created on <em>%s</em>"),
                      $usertitle, $creation_time);
   
     // what fields are to be displayed on this screen?
     //
     $displayablefields = vadmin_get_displayable_fields('user_details', 'info');

     $action = vadmin_mkform_action($LVL, $MOD, 'chattrs');

         $body = '<form name="userinfoform" method="post" action="' . $action . '">'
         . ' <input type="hidden" name="userid" value="' . $userid . '">'
         . '  <table border="0" width="80%" align="center">';

     // display non-alias fields
     //
     if (!is_alias($user_ary))
     {
        $attributes = array();

        $body .=  '   <tr>'
         . '    <th bgcolor="' . $color[9] . '" colspan="2">'
         .       _("Change user attributes")
         . '    </th>'
         . '   </tr>';

        if (in_array('info', $displayablefields))
           $attributes[] = '<td>' . _("Personal Info") 
                         . ' (<a href="#personalinfo">?</a>): '
                         . ' <input name="personal_info" value="' . $personal_info . '" />'
                         . '</td>';

        if (in_array('hardquota', $displayablefields))
           $attributes[] = '<td>' . _("Hard Quota") 
                         . ' (<a href="#hardquota">?</a>): '
                         . ' <input name="hard_quota" size="10" value="'
                         . $hard_quota . '" /> ' . _("MiB")
                         . '</td>';



        // need to put the following hook calls inside an eval() 
        // because even just the syntax of the 1.4.x hook call
        // evokes a PHP error in 1.5.x, even though it's not 
        // actually called
        //
        if (check_sm_version(1, 5, 2))
        {
           $temp = array(&$userid, &$domain, &$secret, &$desig);
           eval('$hook_results = concat_hook_function(\'vadmin_after_user_details_mailbox\', $temp);');
        }
        else
           eval('$hook_results = concat_hook_function(\'vadmin_after_user_details_mailbox\', array($userid, $domain, $secret, $desig));');

        if (in_array('mailbox', $displayablefields))
           $attributes[] = '<td>' . _("Mailbox") 
                         . ' (<a href="#mailbox">?</a>): '
                         . ' <input name="vmailbox" value="' . $mailbox . '" />'
                         . $hook_results
                         . '</td>';

        if (in_array('softquota', $displayablefields))
           $attributes[] = '<td>' . _("Soft Quota") 
                         . ' (<a href="#softquota">?</a>): '
                         . ' <input name="soft_quota" size="10" value="' 
                         . $soft_quota . '" /> ' . _("MiB")
                         . '</td>';

        if (in_array('password', $displayablefields))
           $attributes[] = '<td>' . _("Set Password") 
                         . ' (<a href="#password">?</a>): '
                         . ' <input size="10" name="vpassword" value="' . $setpass . '" '
                         . ' onfocus="if (this.value==\'' . _("encrypted") . '\') '
                         . ' this.value=\'\';" /> ' 
                         // for better readability, removed i, l, 1, o, O, 0
                         // also use oldschool indexOf() instead of regex to keep requirements down
                         . ($javascript_on ? '<a href="#" onclick="digits=\'23456789\'; posschars=\'abcdefghjkmnpqrstuvwxyz23456789\'; pwd=\'\'; pwdlen=8; directinsert=true; for (i=0;i<pwdlen;i++) pwd+=posschars.charAt(Math.floor(Math.random()*posschars.length)); if (pwd.indexOf(\'0\') == -1 && pwd.indexOf(\'1\') == -1 && pwd.indexOf(\'2\') == -1 && pwd.indexOf(\'3\') == -1 && pwd.indexOf(\'4\') == -1 && pwd.indexOf(\'5\') == -1 && pwd.indexOf(\'6\') == -1 && pwd.indexOf(\'7\') == -1 && pwd.indexOf(\'8\') == -1 && pwd.indexOf(\'9\') == -1) pwd = digits.charAt(Math.floor(Math.random()*digits.length)) + pwd.substring(1); if (directinsert) { document.userinfoform.vpassword.value=pwd; } else { newwin=window.open(\'\', \'random_pwd_win\', \'width=150, height=100\'); newwin.document.open(); newwin.document.write(\'<html><head><title>Random Password</title></head><body><strong>\'+pwd+\'</strong></body></html>\'); newwin.document.close(); } return false;"><small>' . _("Random") . '</small></a>' : '')
                         . '</td>';

        if (in_array('sizelimit', $displayablefields))
           $attributes[] = '<td>' . _("Size Limit") 
                         . ' (<a href="#sizelimit">?</a>): '
                         . ' <input name="size_limit" size="10" value="' 
                         . $size_limit . '" /> ' . _("MiB")
                         . '</td>';

        if (in_array('expiry', $displayablefields))
           $attributes[] = '<td>' . _("Expiry Time") 
                         . ' (<a href="#expiry">?</a>): '
                         . ' <input name="expiry_time" size="10" value="' 
                         . $expiry_time . '" /> ' . _("days")
                         . '</td>';

        if (in_array('countlimit', $displayablefields))
           $attributes[] = '<td>' . _("Count Limit") 
                         . ' (<a href="#countlimit">?</a>): '
                         . ' <input name="count_limit" size="10" value="' 
                         . $count_limit . '" /> ' . _("msgs")
                         . '</td>';


        // prepare to iterate through any custom fields
        //
        $custom_fields = vadmin_getvar('BACKEND', 'custom_user_account_fields');
        if ($custom_fields) 
           $custom_fields = explode(',', $custom_fields);
        else
           $custom_fields = array();
        @array_walk($custom_fields, 'vadmin_trim_array');
        $i = 13;
        foreach ($custom_fields as $field) {

            $field_name = str_replace(' ', '_', $field);
            $field_type = vadmin_getvar('BACKEND', $field_name . '_type');
            $field_suffix = vadmin_getvar('BACKEND', $field_name . '_suffix');
            $i++;
            if (in_array($field, $displayablefields)) {
                if ($field_type == 'largetext')
                    $addon_custom_textareas[] = array('title'  => _($field),
                                                      'name'   => $field_name,
                                                      'suffix' => _($field_suffix),
                                                      'value'  => $user_ary[$i]);
                else if ($field_type == 'boolean')
                    $attributes[] = '<td>' . _($field) 
                    . ' (<a href="#' . $field_name . '">?</a>): '
                    . ' <input type="radio" name="' 
                    . $field_name . '" id="' . $field_name . '_yes" value="1"' 
                    . ($user_ary[$i] ? ' checked' : '') . ' /><label for="' 
                    . $field_name . '_yes"> ' . _("Yes") . '</label>'
                    . ' <input type="radio" name="'
                    . $field_name . '" id="' . $field_name . '_no" value="0"'
                    . ($user_ary[$i] ? '' : ' checked') . ' /><label for="' 
                    . $field_name . '_no"> ' . _("No") . '</label>'
                    . (!empty($field_suffix) ? ' ' . _($field_suffix) : '')
                    . '</td>';
                else if ($field_type == 'checkbox')
                    $attributes[] = '<td><label for="' . $field_name . '_checkbox">' 
                    . _($field) . '</label> (<a href="#' . $field_name 
                    . '">?</a>):  <input type="checkbox" name="' 
                    . $field_name . '" id="' . $field_name . '_checkbox" value="1"' 
                    . ($user_ary[$i] ? ' checked' : '') . ' />'
                    . (!empty($field_suffix) 
                    ? ' ' . _($field_suffix) : '')
/* don't put label around this in case the suffix has some tags in it or whatever
                    ? ' <label for="' . $field_name . '_checkbox">' 
                    . _($field_suffix) . '</label>' : '')
*/
                    . '</td>';
                else
                    $attributes[] = '<td>' . _($field) 
                    . ' (<a href="#' . $field_name . '">?</a>): '
                    . ' <input type="text" name="' 
                    . $field_name . '" size="10" value="' . $user_ary[$i] . '" />'
                    . (!empty($field_suffix) ? ' ' . _($field_suffix) : '')
                    . '</td>';
            }

        }


        $i = 0;
        foreach ($attributes as $attribute)
        {
           if ($i % 2 == 0) $body .= '<tr>';
           $body .= $attribute;
           if ($i++ % 2 != 0) $body .= '</tr>';
        }
        if ($i % 2 != 0) $body .= '<td>&nbsp;</td></tr>';


     spew("$me: checking if we should display admin information");
     if ($desig == 'CROSS' || $desig == 'ELVIS'){
         $udesig = vadmin_get_user_designation($domain, $usertitle);
         $ison = '';
         if ($udesig == 'LOWLY'){
             $ison = ' checked="yes"';
         }
         if ($udesig == 'ELVIS' && $desig == 'ELVIS'){
             $body .= ''
                 . '<tr>'
                 . ' <td colspan="2" align="center"><i>'
                 . _("User has superuser access to this domain")
                 . '</i></td>'
                 . '</tr>';
         }
         else if ($udesig == 'CROSS'){
             $body .= ''
                 . '<tr>'
                 . ' <td colspan="2" align="center"><i>'
                 . _("User has cross-administrative access to this domain")
                 . '</i></td>'
                 . '</tr>';
         }
         else {
             $body .= ''
                 . '<tr>'
                 . ' <td colspan="2" align="center">'
                 . '  <input type="hidden" name="adminChkVisible" value="1" />' 
                 . '<input type="checkbox" name="admin" id="adminID" value="1"' 
                 .     $ison . ' /><label for="adminID">' 
                 . _("Can administer this domain")
                 . '</label> </td>'
                 . '</tr>';
         }
     }
     } else { // end display non-alias fields

/* This is the same as the forwards below...
         if (function_exists('get_real_account_for_alias')) {
             $actual_account = get_real_account_for_alias($domain, $user_ary[0], $secret);
         } else {
             $actual_account = '';
         }
         if ($actual_account[0]){
             spew("$me: no alias info found '$userid'");
             $body .= '<tr><td align="middle">Aliased to: <i>(NOT FOUND)</i><br /><br /></td></tr>';
         } else {
             $body .= '<tr><td align="middle">Aliased to: <i>'
                   . implode(', ', $actual_account[1])
                   . '</i><br /><br /></td></tr>';
         }
*/

     } // end display alias fields


     // add custom fields that are textareas
     //
     foreach ($addon_custom_textareas as $custom_text_area)
         $body .= ''
             . '<tr>'
             . ' <th colspan="2" bgcolor="' . $color[9] . '">'
             .     $custom_text_area['title'] . ' (<a href="#' . $custom_text_area['name'] . '">?</a>): '
             . (!empty($custom_text_area['suffix']) ? '   ' . $custom_text_area['suffix'] : '')
             . ' </th>'
             . '</tr>'
             . '<tr>'
             . ' <td colspan="2" align="center">'
             . '  <textarea name="' . $custom_text_area['name'] . '" cols="60" rows="2">' . $custom_text_area['value'] 
             .    '</textarea><br /><br />'
             . ' </td>'
             . '</tr>';


     $body .= ''
         . (in_array('forwards', $displayablefields) ? '<tr>'
         . ' <th colspan="2" bgcolor="' . $color[9] . '">'
         .     _("Forwards") . ' (<a href="#forwards">?</a>): '
         . '   /' . _("separate by commas") . '/'
         . ' </th>'
         . '</tr>'
         . '<tr>'
         . ' <td colspan="2" align="center">'
         . '  <textarea name="valiases" cols="60" rows="2">' . $aliases 
         .    '</textarea>'
         . ' </td>'
         . '</tr>' : '')
         . '<tr>'
         . ' <th bgcolor="' . $color[9] . '" colspan="2">'
         . '  <input type="submit" value="' . _("Make these changes") 
         .     '&gt;&gt;" />'
         . ' </th>'
         . '</tr>'
         . '</table></form>';

     // generate and display webmail stats
     //
     if ($trackusage != FALSE && in_array('webmail_stats', $displayablefields)
      && !is_alias($user_ary)) {
         if (isset($user_ary[13]['LAST_LOGIN']))
             $stats = $user_ary[13];
         else
             $stats = vadmin_get_user_webmail_stats($userid, $domain);
         $last_login = $stats['LAST_LOGIN'];
         $last_login_short = $stats['LAST_LOGIN_SHORT'];
         $total_logins = $stats['TOTAL_LOGINS'];

         $body .= ''
             . '<hr />'
             . ' <table border="0" width="80%" align="center">'
             . '  <tr>'
             . '   <th colspan="2" bgcolor="' . $color[9] . '"> '
             . _("Webmail Statistics")
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '   <td>'
             .       _("Last logged in on") . ': ' . $last_login
             . '   </td>'
             . '   <td>'
             .       _("Total logins") . ': ' . $total_logins
             . '   </td>'
             . '  </tr>'
             . '  <tr>'
             . '   <td colspan="2">' . _("These statistics are only for webmail usage and do not account for usage of other email clients.") . '</td>'
             . '  </tr>'
             . '  <tr>'
             . '   <th colspan="2" bgcolor="' . $color[9] . '">&nbsp;</th>'
             . '  </tr>'
             . ' </table><br />';
     }


     // need to put the following hook calls inside an eval() 
     // because even just the syntax of the 1.4.x hook call
     // evokes a PHP error in 1.5.x, even though it's not 
     // actually called
     //
     if (check_sm_version(1, 5, 2))
     {
        $temp = array(&$userid, &$domain, &$secret, &$desig);
        eval('$body .= concat_hook_function(\'vadmin_user_details_extra_section\', $temp);');
     }
     else
        eval('$body .= concat_hook_function(\'vadmin_user_details_extra_section\', array($userid, $domain, $secret, $desig));');


     // show user prefs for real accounts
     //
     if (in_array('prefs', $displayablefields) 
      && !is_alias($user_ary)) {

         global $force_username_lowercase;
         $user_datadir = vadmin_get_per_domain_sm_setting('data_dir', $domain);
         if ($force_username_lowercase)
            $the_user = strtolower($user_ary[0]);
         else
            $the_user = $user_ary[0];
         if (vadmin_IMAP_usernames_have_domain($domain)) {
             $delim = vadmin_getvar('BACKEND', 'delimiters');
             $delim = substr($delim, 0, 1);
             $the_user .= $delim . $domain;
         }

         // figure out where prefs are stored
         //
         // need to put the following hook calls inside an eval() 
         // because even just the syntax of the 1.4.x hook call
         // evokes a PHP error in 1.5.x, even though it's not 
         // actually called
         //
         global $prefs_dsn;
         if (check_sm_version(1, 5, 2))
         {
            global $null;
            eval('$prefs_backend = do_hook(\'prefs_backend\', $null);');
         }
         else
            eval('$prefs_backend = do_hook_function(\'prefs_backend\');');
         if (!isset($prefs_backend) || empty($prefs_backend) 
          || !file_exists(SM_PATH . $prefs_backend)) {
             if (isset($prefs_dsn) && !empty($prefs_dsn))
                 $prefs_backend = 'DB';
             else
                 $prefs_backend = 'FILE';
         }

         // show prefs file location only for file-based prefs
         //
         $prefs_file_exists = FALSE;
         if ($prefs_backend == 'FILE') {

    //FIXME:
    // -- there used to be a bug here when usernames have caps 
    //    in them, they would get hashed to different path; but 
    //    if usernames are forced to lowercase, we need to hash 
    //    with the all lowercase version thereof (um, I think... 
    //    really, all I've done is seen that I am getting the 
    //    wrong pref files for users with caps -- needs more 
    //    research, should be easy to fix when I have the time to 
    //    look at it)  UPDATE: now that I have looked at it, I
    //    cannot reproduce the problem.  Either it is gone or 
    //    I need help reproducing it again
             $prefs_file_path = $user_datadir;
             while (strrpos($prefs_file_path, '/')  == strlen($prefs_file_path) - 1)
                 $prefs_file_path = substr($prefs_file_path, 0, -1);

             global $dir_hash_level;
             if ($dir_hash_level > 0) {
                 $hashdirs = computeHashDirs($the_user);
                 for ($h = 0; $h < $dir_hash_level; ++$h)
                     $prefs_file_path .= '/' . $hashdirs[$h];
             }

             $prefs_file_path .= '/' . $the_user . '.pref';
             if (file_exists($prefs_file_path)) {
                 $prefs_file_exists = TRUE;
//FIXME: do we throw an error in this condition (think not), but if not, what exactly should we do...?
             } else if (0) { // umm, not sure exactly what to do if not found, it's not an error because the user simply may not have logged in yet
                 spew("$me: no prefs file found - new user?");
                 $msg = _("No prefs file found; user may never have logged in before");
                 vadmin_user_error($msg);
             }

         }

         $prefs_view_link = vadmin_mkform_action($LVL, $MOD, 'editprefssubmit')
                          . '&userid=' . $userid;

         $body .= ''
             . '<hr />'
             . ' <table border="0" width="80%" align="center">'
             . '  <tr>'
             . '   <th colspan="1" bgcolor="' . $color[9] . '"> '
             . _("User Webmail Preferences")
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '   <td>';

         if ($prefs_backend == 'DB')
             $body .= _("Preferences: stored in database");
         else if ($prefs_backend == 'FILE') {
             if ($prefs_file_exists)
                 $body .= sprintf(_("Preferences file: %s"), $prefs_file_path);
             else
                 $body .= _("Preferences: "); // put "file not found" on this line??
         } else
             $body .= _("Preferences: "); // put "stored in other backend" on this line?? can we get more specific info from the prefs_backend hook?

         $body .= ''
             . ($javascript_on
             ? ' &nbsp;<small>(<a href="" onclick="newwin=window.open(\'' . $prefs_view_link . '\', \'prefs_contents\', \'scrollbars=yes, resizable=yes, width=600, height=400\'); return false;">' . _("View") . '</a>)</small>'
// the following conditional is borked; works, but doesn't make a lot of sense... but we don't care that much to fix it
             : ($prefs_backend == 'FILE' && !$prefs_file_exists ? ' &nbsp;<small>(' . _("does not exist") . ')</small>' : ''))
             . '   </td>'
             . '  </tr>'
             . '  <tr>'
             . '   <th colspan="1" bgcolor="' . $color[9] . '">&nbsp;</th>'
             . '  </tr>'
             . ' </table><br />';

/* ------------- The code below was used to read user prefs into a variable,
                 then some javascript-enabled code was written to the HTML
                 page with a link, that, when clicked, popped up a window
                 and wrote the HTML contents of that window with the contents
                 of the prefs variable.  That means that, unless this "getuser"
                 page is refreshed, the prefs link will pop up and show the
                 user prefs in a static manner, even if they've changed... so
                 we are not using this any more (also, we want to avoid as
                 much javascript as possible), however, this worked very well,
                 so it is being left for educational purposes.
                 Also note that this code is only for file-based prefs, but
                 the other places in this file that deal with user prefs display
                 and editing have been upgraded to allow using other prefs
                 backends....
             global $dir_hash_level;
             $user_datadir = vadmin_get_per_domain_sm_setting('data_dir', $domain);
    
             $prefs_file_path = $user_datadir;
             while (strrpos($prefs_file_path, '/')  == strlen($prefs_file_path) - 1)
                 $prefs_file_path = substr($prefs_file_path, 0, -1);
    
             global $force_username_lowercase;
             if ($force_username_lowercase)
                $the_user = strtolower($user_ary[0]);
             else
                $the_user = $user_ary[0];
             if (vadmin_IMAP_usernames_have_domain($domain)) {
                 $delim = vadmin_getvar('BACKEND', 'delimiters');
                 $delim = substr($delim, 0, 1);
                 $the_user .= $delim . $domain;
             }
    
             if ($dir_hash_level > 0) {
                 $hashdirs = computeHashDirs($the_user);
                 for ($h = 0; $h < $dir_hash_level; ++$h) 
                     $prefs_file_path .= '/' . $hashdirs[$h];
             }
    
             $prefs_file_path .= '/' . $the_user . '.pref';
             $prefs_file_exists = FALSE;
             if (file_exists($prefs_file_path))
             {
    ///             $hashed_file = getHashedFile($the_user, $user_datadir, $the_user . '.pref');
                 $prefs_file_exists = TRUE;
                 $prefs = file($prefs_file_path);
                 @array_walk($prefs, 'vadmin_trim_array');
                 $prefs = implode('<br />', $prefs);
                 // htmlspecialchars is too much... just these:
                 $prefs = str_replace(array('\'', '"', '&'), array('\\\'', '&quot;', '&amp;'), $prefs);
             }
    
             $prefs_edit_link = vadmin_mkform_action($LVL, $MOD, 'editprefs')
                              . '&userid=' . $userid;

             $body .= ''
                 . '<hr />'
                 . ' <table border="0" width="80%" align="center">'
                 . '  <tr>'
                 . '   <th colspan="1" bgcolor="' . $color[9] . '"> '
                 . _("User Webmail Preferences")
                 . '   </th>'
                 . '  </tr>'
                 . '  <tr>'
                 . '   <td>'
                 .       _("Preferences file:") . ' ' . $prefs_file_path
                 . ($prefs_file_exists && $javascript_on
                 ?       ' &nbsp;<small>(<a href="" onclick="newwin=window.open(\'\', \'prefs_contents\', \'scrollbars=yes, resizable=yes, width=600, height=400\'); newwin.document.open(); newwin.document.write(\'<html><head><title>' . sprintf(_("Preferences: %s"), $the_user) . '</title></head><body><strong>' . sprintf(_("Preferences: %s"), $the_user) . '</strong>' . (!empty($prefs_edit_link) ? '&nbsp;&nbsp;<small>(<a href=\\\'' . $prefs_edit_link . '\\\'>' . _("Edit") . '</a>)</small>' : '') . '<hr />' . $prefs . (!empty($prefs_edit_link) ? '<hr /><a href=\\\'' . $prefs_edit_link . '\\\'>' . _("Edit") . '</a>' : '') . '</body></html>\'); newwin.document.close(); return false;">' . _("View") . '</a>)</small>'
    //FIXME:
    // -- there used to be a bug here when usernames have caps 
    //    in them, they would get hashed to different path; but 
    //    if usernames are forced to lowercase, we need to hash 
    //    with the all lowercase version thereof (um, I think... 
    //    really, all I've done is seen that I am getting the 
    //    wrong pref files for users with caps -- needs more 
    //    research, should be easy to fix when I have the time to 
    //    look at it)  UPDATE: now that I have looked at it, I
    //    cannot reproduce the problem.  Either it is gone or 
    //    I need help reproducing it again
                 :       ($javascript_on ? ' &nbsp;<small>(' . _("does not exist") . ')</small>' : ''))
                 . '   </td>'
                 . '  </tr>'
                 . '  <tr>'
                 . '   <th colspan="1" bgcolor="' . $color[9] . '">&nbsp;</th>'
                 . '  </tr>'
                 . ' </table><br />';
------------- */

     }

     if ((vadmin_IMAP_usernames_have_domain($domain) && $username != $usertitle)
          || (!vadmin_IMAP_usernames_have_domain($domain) && $username != $userid)) {
         spew("$me: creating a 'delte this user' button");
         $action = vadmin_mkform_action($LVL, $MOD, 'deluser');
         $body .= ''
             . '<hr />'
             . '<form style="display:inline; margin:0" method="post" action="' . $action . '">'
             . ' <input type="hidden" name="userid" value="' . $userid . '" />'
             . ' <input type="hidden" name="camefrom" value="' . $ACT . '" />'
             . ' <table border="0" width="80%" align="center">'
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '"> ' 
             . (!is_alias($user_ary) ? _("Delete this account") 
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '   <td align="center">'
             . '    <p style="width: 90%; text-align: left">'
             .       _("Click here if you wish to delete this account. This will also delete any and all user files associated with it -- mailbox files, webmail preferences, etc.")
             . '    </p>'
             . '   </td>'
             . '  </tr>'
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <input type="submit" value="' . _("Delete this account") 
             : _("Delete this alias") 
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '   <td align="center">'
             . '    <p style="width: 90%; text-align: left">'
             .       _("Click here if you wish to delete this alias. This will not delete any user files associated with whatever real account it is associated with, it will only remove the alias.")
             . '    </p>'
             . '   </td>'
             . '  </tr>'
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <input type="submit" value="' . _("Delete this alias"))
             .       ' &gt;&gt;" /> '
             . '   </th>'
             . '  </tr>'
             . ' </table>'
             . '</form><br />';
     }
     /**
      * Provide some documentation, explaining which field does what.
      * So much pain. For translators, too.
      */
     spew("$me: writing a cheat-sheet");
     $body .= ''
         . '<hr />'
         . '<table border="0" width="80%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">' 
         .     _("Description of fields")
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td>';
     // display non-alias fields
     if (!is_alias($user_ary))
     {

     $body .= ''
         . (in_array('info', $displayablefields) 
         ? '   <p><strong><a name="personalinfo">' . _("Personal Info") . '.'
         . '    </a></strong> '
         .      _("This is where you put full name of this user or some other information to help you better identify your users and aliases.") . '</p>'
         : '')
         . (in_array('mailbox', $displayablefields) 
         ? '   <p><strong><a name="mailbox">' . _("Mailbox") . '.</a></strong>'
         .       _("This is a Maildir-format style mailbox. If you wish to change this user to an alias without a mailbox, then you will need to leave this setting blank. Please don't change setting unless you know what you are doing, as this can prevent users from accessing their mailboxes.") . '</p>'
         : '')
         . (in_array('password', $displayablefields) 
         ? '   <p><strong><a name="password">' . _("Set Password") . '.'
         . '    </a></strong> '
         .      _("Since users' passwords are encrypted, it is impossible to see what it is in this listing. Leave it saying 'encrypted' or blank to keep the old value, or type in a new value to change this user's mailbox access password.") . '<br />'
         . _("A '-' means that password for this user is not set.") . '</p>'
         : '')
         . (in_array('expiry', $displayablefields) 
         ? '   <p><strong><a name="expiry">' . _("Expiry Time") . '.'
         . '    </a></strong> '
         .      _("If you want to limit the availability of this mailbox by some amount of time, put in the number of days this box should be active.") . '<br />'
         .      _("A '-' means there is no time limit on this box.") . '</p>'
         : '')
         . (in_array('hardquota', $displayablefields) 
         ? '   <p><strong><a name="hardquota">' . _("Hard Quota") . '.'
         . '    </a></strong> '
         .       _("The absolute limit of how many mebibytes this user may have in his or her mailbox. If this limit is ever reached, the system will not accept any more messages for this user.") . '<br />'
         .       _("A '-' means unlimited storage space.") . '</p>'
         : '')
         . (in_array('softquota', $displayablefields) 
         ? '   <p><strong><a name="softquota">' . _("Soft Quota") . '.'
         . '    </a></strong> '
         .      _("This sets the size of user's mailbox in mebibytes. If this level is reached, the user is notified that his or her mailbox is at its limits and should be cleaned. The system will still accept messages until Hard Quota limit is reached. Soft Quota should be less than Hard Quota.") . '<br />'
         .      _("A '-' means no limits are set on this user's mailbox.")
         . '   </p>'
         : '')
         . (in_array('sizelimit', $displayablefields) 
         ? '   <p><strong><a name="sizelimit">' . _("Size Limit") . '.'
         . '    </a></strong> '
         .      _("This limits the maximum size of any one message that this user is trying to receive in mebibytes. If a message arrives which is larger than the limit specified here, then it will be discarded.") . '<br />'
         .      _("A '-' means no limits on message sizes.") . '</p>'
         : '')
         . (in_array('countlimit', $displayablefields) 
         ? '   <p><strong><a name="countlimit">' . _("Count Limit") . '.'
         . '    </a></strong> '
         .      _("This limits how many messages a user can have in his or her mailbox. If more messages accumulate than the amount allows, any incoming messages will be discarded until the user cleans the mailbox.") . '<br />'
         .      _("A '-' means no limits.") . '</p>'
         : '');


         // iterate through custom fields
         //
         foreach ($custom_fields as $field) {
             $field_name = str_replace(' ', '_', $field);
             $custom_field_desc = vadmin_getvar('BACKEND', $field_name);
             if (in_array($field, $displayablefields))
                 $body .= '<p><strong><a name="' . $field_name
                        . '">' . _($field) . '.</a></strong> '
                        . _($custom_field_desc) . '<br /></p>';
         }

     } // end display alias fields

     $body .= ''
         . (in_array('forwards', $displayablefields) 
         ? '   <p><strong><a name="forwards">' . _("Forwards") . '.'
         . '    </a></strong> '
         .      _("This specifies the forwarding addresses for this user or alias. You may put in as  many as you want, separating them by commas (comma-space is OK). Leave blank if you don't want to forward any copies, although for aliases, this should not be left blank.") . '</p>'
         : '')
         . '  </td>'
         . ' </tr>'
         . '</table>';
     $previous_link = '<tr><td align="center"><a href="'
                    . vadmin_mkform_action($LVL, $camefrommod, $camefromact)
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';

     // we specifically remove SM's onload focus function, if the password is 
     // the first element on the page, in which case the SM auto-focus will 
     // trigger its own focus handler prematurely
     //
     $blockOnLoad = (!in_array('info', $displayablefields) 
                  && !in_array('hardquota', $displayablefields)
                  && !in_array('mailbox', $displayablefields)
                  && !in_array('softquota', $displayablefields)
                  && in_array('password', $displayablefields));

     vadmin_make_page($title, null, $body, true, true, $previous_link, $blockOnLoad);
     break;

     /***************************** editprefs ***************************/
 case 'editprefs':
     // NOTE that this action is designed to be performed in a popup window

     /**
      * See if this user really exists
      */
     spew("$me: checking if such user exists");
     $userid = vadmin_getvar('GET', 'userid');
     if (!$userid){
         $userid = vadmin_getvar('POST', 'userid');
     }

     // force username to lowercase if SM is set as such
// FIXME: do we want to do this globally at the top of the file or anything?  or do we NOT want to do this at all?
     //
     global $force_username_lowercase;
     if ($force_username_lowercase)
        $userid = strtolower($userid);

//FIXME: shouldn't we be using $delim instead of @??
     $usertitle = "$userid@$domain";
     $command = array('lookup', $domain, $userid, $secret);
     $tmp = vm_daemon_raw($command);
     if ($tmp[0]){
         spew("$me: no such user '$userid'");
         $msg = sprintf(_("No such user exists: %s"), $userid);
         vadmin_user_error($msg);
     }

     /**
      * Make sure they can edit this user.
      */
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"),
                          $userid);
         vadmin_user_error($msg);
     }

     /**
      * Call lookup(), a function provided by vmail.inc.
      */
     spew("$me: fetching the user data");
     $user_ary = listdomain_parse_userdata($tmp[1], $userid);


     $displayablefields = vadmin_get_displayable_fields('user_details', 'info');
     if ($userid == $catchall_alias){
         $usertitle = _("a 'catchall' account");
     } else {
         $usertitle = sprintf('%s@%s', $userid, $VADMIN_DOMAIN);
     }
     spew("$me: usertitle is '$usertitle'");
     $title = sprintf(_("Edit Preferences for %s"), $usertitle);
     $body = '';


     // show user prefs for real accounts
     //
     if (in_array('prefs', $displayablefields)
      && !is_alias($user_ary)) {

         global $force_username_lowercase;
         $user_datadir = vadmin_get_per_domain_sm_setting('data_dir', $domain);
         if ($force_username_lowercase)
            $the_user = strtolower($user_ary[0]);
         else
            $the_user = $user_ary[0];
         if (vadmin_IMAP_usernames_have_domain($domain)) {
             $delim = vadmin_getvar('BACKEND', 'delimiters');
             $delim = substr($delim, 0, 1);
             $the_user .= $delim . $domain;
         }

         $prefs = vadmin_get_all_user_prefs($user_datadir, $the_user);

         // squish down prefs into string format
         //
         $display_prefs = '';
         foreach ($prefs as $key => $val) 
             $display_prefs .= trim($key) . '=' . trim($val) . "\n";

         // build body
         //
         $action = vadmin_mkform_action($LVL, $MOD, 'editprefssubmit')
                 . '&userid=' . $userid;
         $body .= '<strong>'
             . sprintf(_("Edit Preferences for %s"), $usertitle)
             . '</strong><hr />'
             . '<form style="display:inline; margin:0" method="post" action="' . $action . '">'
           ///  . '<input type="submit" value="' . _("Submit") . '" /><br />'
             . '<textarea rows="15" cols="60" name="newprefs">'
             . $display_prefs . '</textarea>'
             . '<br /><input type="submit" value="' . _("Submit") . '" />'
             . '</form>';

     } else {
         spew("$me: prefs not available or this is an alias (which can not have prefs)");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), $userid);
         vadmin_user_error($msg);
     }


     // This is ripped and shortened from displayHtmlHeader() in 
     // SM STABLE's functions/page_header.php as of January 2008
     // We don't use stylesheets because STABLE and DEVEL streams
     // have very different ways of handling them; for now, all
     // we want is a simple text area and submit button anyway.
     //
     global $squirrelmail_language;

     echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'
        . "\n\n<html"
        . (!empty($squirrelmail_language) ? ' lang="' . $squirrelmail_language . '"' : '')
        . ">\n<head>\n"
        . "<meta name=\"robots\" content=\"noindex,nofollow\" />\n";

     if ($squirrelmail_language == 'ja_JP') {
         // Why is it added here? Header ('Content-Type:..) is used in i18n.php
         echo "<!-- \xfd\xfe -->\n";
         echo '<meta http-equiv="Content-type" content="text/html; charset=euc-jp">' . "\n";
     }

     echo "\n<title>$title</title>\n";

     /* work around IE6's scrollbar bug */
     echo <<<ECHO
<!--[if IE 6]>
<style type="text/css">
/* avoid stupid IE6 bug with frames and scrollbars */
body {
     width: expression(document.documentElement.clientWidth - 30);
}
</style>
<![endif]-->

ECHO;

     echo "\n</head>\n\n<body>\n" . $body;

     break;

     /***************************** editprefssubmit ***************************/
 case 'editprefssubmit':
     // NOTE that this action is designed to be performed in a popup window
     // NOTE also that, despite the poor name of this action, it can (and is)
     //      also used for simply viewing prefs without submitting them for change

     /**
      * See if this user really exists
      */
     spew("$me: checking if such user exists");
     $userid = vadmin_getvar('GET', 'userid');
     if (!$userid){
         $userid = vadmin_getvar('POST', 'userid');
     }

     // force username to lowercase if SM is set as such
// FIXME: do we want to do this globally at the top of the file or anything?  or do we NOT want to do this at all?
     //
     global $force_username_lowercase;
     if ($force_username_lowercase)
        $userid = strtolower($userid);

//FIXME: shouldn't we be using $delim instead of @??
     $usertitle = "$userid@$domain";
     $command = array('lookup', $domain, $userid, $secret);
     $tmp = vm_daemon_raw($command);
     if ($tmp[0]){
         spew("$me: no such user '$userid'");
         $msg = sprintf(_("No such user exists: %s"), $userid);
         vadmin_user_error($msg);
     }

     /**
      * Make sure they can edit this user.
      */
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"),
                          $userid);
         vadmin_user_error($msg);
     }

     /**
      * Call lookup(), a function provided by vmail.inc.
      */
     spew("$me: fetching the user data");
     $user_ary = listdomain_parse_userdata($tmp[1], $userid);


     $displayablefields = vadmin_get_displayable_fields('user_details', 'info');
     if ($userid == $catchall_alias){
         $usertitle = _("a 'catchall' account");
     } else {
         $usertitle = sprintf('%s@%s', $userid, $VADMIN_DOMAIN);
     }
     spew("$me: usertitle is '$usertitle'");
     $title = sprintf(_("Preferences: %s"), $usertitle);
     $body = '';


     // show user prefs for real accounts
     //
     if (in_array('prefs', $displayablefields)
      && !is_alias($user_ary)) {

         global $force_username_lowercase;
         $user_datadir = vadmin_get_per_domain_sm_setting('data_dir', $domain);
         if ($force_username_lowercase)
            $the_user = strtolower($user_ary[0]);
         else
            $the_user = $user_ary[0];
         if (vadmin_IMAP_usernames_have_domain($domain)) {
             $delim = vadmin_getvar('BACKEND', 'delimiters');
             $delim = substr($delim, 0, 1);
             $the_user .= $delim . $domain;
         }

         $msg = '';

         // update prefs if they were submitted
         //
         if (sqGetGlobalVar('newprefs', $newprefs, SQ_POST)) {

             // normalize newlines, then break up into an array
             // of key/value pairs of prefs
             //
             $newprefs = explode("\n", str_replace(array("\r\n", "\r"), "\n", $newprefs));
             $new_preferences = array();
             foreach ($newprefs as $keyval) {
                 $keyval = trim($keyval);
                 if (empty($keyval) || strpos($keyval, '=') === FALSE) continue;
                 list($key, $val) = explode('=', $keyval, 2);
                 if (!empty($key))
                     $new_preferences[$key] = $val;
             }

             // save the new prefs
             //
             $result = vadmin_put_all_user_prefs($user_datadir, $the_user, $new_preferences);

             if ($result === FALSE) {
                 spew("$me: prefs could not be saved - check web server logs");
                 $msg = _("Sorry, user preferences could not be saved");
                 vadmin_user_error($msg);
                 exit;  // not strictly necessary; the above should already exit
             }

             $msg = _("PREFERENCES SAVED");
         }

         $prefs = vadmin_get_all_user_prefs($user_datadir, $the_user);

         // squish down prefs into string format and sanitize
         //
         $display_prefs = '';
         foreach ($prefs as $key => $val)
             $display_prefs .= trim($key) . '=' . trim($val) . "\n";
         // htmlspecialchars is too much... just these:
         $display_prefs = str_replace(array('\'', '"', '&'), array('\\\'', '&quot;', '&amp;'), $display_prefs);

         // build body
         //
         $prefs_edit_link = vadmin_mkform_action($LVL, $MOD, 'editprefs')
                              . '&userid=' . $userid;
         $body .= '<strong>'
             . sprintf(_("Preferences: %s"), $usertitle)
             . '</strong>'
             . (!empty($prefs_edit_link) 
             ? '&nbsp;&nbsp;<small>(<a href="' . $prefs_edit_link 
             . '">' . _("Edit") . '</a>)</small>' : '') 
             . (!empty($msg)
             ? '<br /><strong>' . $msg . '</strong>' : '')
             . '<hr />' . nl2br($display_prefs)
             . (!empty($prefs_edit_link) 
             ? '<hr /><a href="' . $prefs_edit_link 
             . '">' . _("Edit") . '</a>' : '');

     } else {
         spew("$me: prefs not available or this is an alias (which can not have prefs)");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), $userid);
         vadmin_user_error($msg);
     }


     // This is ripped and shortened from displayHtmlHeader() in
     // SM STABLE's functions/page_header.php as of January 2008
     // We don't use stylesheets because STABLE and DEVEL streams
     // have very different ways of handling them; for now, all
     // we want is a simple text area and submit button anyway.
     //
     global $squirrelmail_language;

     echo '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">'
        . "\n\n<html"
        . (!empty($squirrelmail_language) ? ' lang="' . $squirrelmail_language . '"' : '')
        . ">\n<head>\n"
        . "<meta name=\"robots\" content=\"noindex,nofollow\" />\n";

     if ($squirrelmail_language == 'ja_JP') {
         // Why is it added here? Header ('Content-Type:..) is used in i18n.php
         echo "<!-- \xfd\xfe -->\n";
         echo '<meta http-equiv="Content-type" content="text/html; charset=euc-jp">' . "\n";
     }

     echo "\n<title>$title</title>\n";

     /* work around IE6's scrollbar bug */
     echo <<<ECHO
<!--[if IE 6]>
<style type="text/css">
/* avoid stupid IE6 bug with frames and scrollbars */
body {
     width: expression(document.documentElement.clientWidth - 30);
}
</style>
<![endif]-->

ECHO;

     echo "\n</head>\n\n<body>\n" . $body;

     break;

     /***************************** chattrs ***************************/
 case 'chattrs':
 case 'chattrs_force_pwd':
 case 'chattrs_force_mailfwd':

     /**
      * Get values passed via the form, POST.
      */
     spew("$me: getting the values passed via POST");
     $userid        = vadmin_getvar('POST', 'userid');
//FIXME: shouldn't we be using $delim instead of @??
     $usertitle  = "$userid@$domain";
     if ($userid == $catchall_alias){
         $usertitle = _("'catchall'");
     }
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }

     $skip_pwd = FALSE;
     $skip_mailfwd = FALSE;

     $zeroIsUnlimited = vadmin_getvar('CONFIG', 'backend.zero_is_unlimited');
     $zeroIsUnlimited = explode(',', $zeroIsUnlimited);
     @array_walk($zeroIsUnlimited, 'vadmin_trim_array');

     // need to limit changes also according to displayable
     // fields on previous screen
     //
     $displayablefields = vadmin_get_displayable_fields('user_details', 'info');

     /**
      * lookup() is a function from vmail.inc by vmailmgr.
      */
     spew("$me: looking up current user settings");
     $user_ary = lookup($domain, $userid, $secret);

     /**
      * Generate table header.
      */
     $body = ''
         . '<table border="0" width="80%" align="center">'
         . ' <tr bgcolor="' . $color[9] . '">'
         . '  <th>' . _("Command") . '</th>'
         . '  <th>' . _("Execution result") . '</th>'
         . ' </tr>';

     /**
      * This var tracks how many changes were done to the
      * user settings.
      */
     $change_count = 0;

     /**
      * Set administrator privs, but only if this is CROSS or ELVIS
      */
 if ((sqGetGlobalVar('admin', $admin, SQ_POST) 
  || sqGetGlobalVar('adminChkVisible', $adminChkVisible, SQ_POST))
  && ($desig == 'CROSS' || $desig == 'ELVIS')){
         $achange = false;
         $removedAdmin = false;
         $handle = $userid;
//FIXME: why using @ instead of $delim???
         if (vadmin_IMAP_usernames_have_domain($domain)) $handle .= "@$domain";
         spew("$me: check if $userid is currently a lowly admin");
         $lowly_ary = vadmin_get_lowly_array($domain);
         if (in_array($handle, $lowly_ary)){
             spew("$me: Yes, this is currently an admin");
             if (empty($admin) && !empty($adminChkVisible)){
                 spew("$me: Removing admin privs from $handle");
                 $new_ary = array();
                 foreach ($lowly_ary as $eadmin){
                     if ($handle != $eadmin){
                         spew("$me: keeping $eadmin");
                         array_push($new_ary, $eadmin);
                     }
                 }
                 $lowly_ary = $new_ary;
                 $achange = true;
                 $removedAdmin = true;
             }
         } else {
             spew("$me: No, this is currently not an admin");
             if (isset($admin) && $admin == '1'){
                 spew("$me: granting $userid lowly admin privs");
                 array_push($lowly_ary, $handle);
                 $achange = true;
             }
         }
         if ($achange == true){
             vadmin_put_lowly_array($domain, $lowly_ary);
             if ($removedAdmin)
                 $successmsg = _("Removed administrator privileges");
             else
                 $successmsg = _("Marked as administrator");
             vadmin_report_progress(_("Setting administrator privileges"));
         }
     }

     /**
      * Analyze the password. If it's "encrypted" or empty, then no
      * change is requested. If the new value is "-", then they have
      * requested to remove the password. 
      */
 if (sqGetGlobalVar('vpassword', $vpassword, SQ_POST) 
  && in_array('password', $displayablefields)) {
     spew("$me: analyzing password request if any");
     if ($user_ary[1] != "Set"){
         $user_ary[1] = "-";
     }
     if ($vpassword != _("encrypted") && $vpassword != ""){
         if ($vpassword != $user_ary[1]){
             /**
              * New password provided. 
              */
             spew("$me: so, they want to change the password");
             if ($vpassword == "-"){
                 /**
                  * They want to remove the password.
                  * Somehow, this feature is not in the current vmail.inc
                  * Disabling (only for vmailmgr) until it appears, since 
                  * it IS in the console scripts.
                  *
                  * $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'PASS', '');
                  * do_hook('vadmin_change_account_before', $temp);
                  * $repl=vchattr($VADMIN_DOMAIN, $secret, $userid, 'PASS', '');
                  * if ($repl[0]) $errormsg = $repl[1];
                  */
                 $vadmin_backend = vadmin_getvar('CONFIG', 'backend.type');
                 if ($vadmin_backend == 'vmailmgr')
                 {
                     spew("$me: Bzzt! Can't make a passwordless account atm.");
                     $errormsg = _("This is currently not working due to a bug in include files provided by vmailmgr.");
                 }
                 else
                 {
                     /**
                      * Call the vchpass function, provided by vmail.inc.
                      * Note that the backend will take care of changing the
                      * "-" to a blank/passwordless value.
                      */
                     spew("$me: calling vadmin_change_account_before hook");
                     $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'PASS', $vpassword);
                     do_hook('vadmin_change_account_before', $temp);
                     spew("$me: calling vchpass");
                     $repl = vchpass($VADMIN_DOMAIN, $secret, $userid, 
                                     $vpassword);
                     if ($repl[0]){
                         spew("$me: error reported: " . $repl[1]);
                         $errormsg = $repl[1];
                     } else {

                         spew("$me: password changed successfully");
                         $successmsg = _("The password has been changed.");

                         // write new cookies for the password if the
                         // current logged-in admin changed their own
                         // password
                         //
                         if ((vadmin_IMAP_usernames_have_domain($domain) 
                           && $username == $usertitle) 
                          || (!vadmin_IMAP_usernames_have_domain($domain) 
                           && $username == $userid)) {
                             $onetimepad = OneTimePadCreate(strlen($vpassword));
                             sqsession_register($onetimepad, 'onetimepad');
                             $key = OneTimePadEncrypt($vpassword, $onetimepad);
                             //setcookie('key', $key, 0, sqm_baseuri());
                             //sqsetcookie('key', $key, 0, sqm_baseuri());
                             vadmin_setcookie('key', $key, 0, sqm_baseuri());
                         }

                     }
                 }
             } else {
                 /**
                  * Set a new password.
                  * Do some simple checks.
                  */

                 // verify password integrity
                 // (use administrative override (allow
                 // insecure passwords) if elvis told us to)
                 //
                 $valid_pwd = vadmin_validate_password($vpassword, $domain, $userid, ($ACT == 'chattrs_force_pwd' && $desig == 'ELVIS' ? TRUE : FALSE));
                 if ($valid_pwd[0]) {
                     $errormsg = $valid_pwd[1];
                     $skip_pwd = TRUE;
                 }

// old code...
//                 if (!preg_match("/[\w_]/si", $vpassword)){
//                     spew("$me: bad chars in the password?");
//                     $errormsg = _("Invalid characters in password. Passwords can only contain latin characters, numbers, and underscores.");
//                 } else {
                 if (!$skip_pwd){
                     /**
                      * Call the vchpass function, provided by vmail.inc.
                      */
                     spew("$me: calling vadmin_change_account_before hook");
                     $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'PASS', $vpassword);
                     do_hook('vadmin_change_account_before', $temp);
                     spew("$me: calling vchpass");
                     $repl = vchpass($VADMIN_DOMAIN, $secret, $userid, 
                                     $vpassword);
                     if ($repl[0]){
                         spew("$me: error reported: " . $repl[1]);
                         $errormsg = $repl[1];
                     } else {

                         spew("$me: password changed successfully");
                         $successmsg = _("The password has been changed.");

                         // write new cookies for the password if the
                         // current logged-in admin changed their own
                         // password
                         //
                         if ((vadmin_IMAP_usernames_have_domain($domain) 
                           && $username == $usertitle) 
                          || (!vadmin_IMAP_usernames_have_domain($domain) 
                           && $username == $userid)) {
                             $onetimepad = OneTimePadCreate(strlen($vpassword));
                             sqsession_register($onetimepad, 'onetimepad');
                             $key = OneTimePadEncrypt($vpassword, $onetimepad);
                             //setcookie('key', $key, 0, sqm_baseuri());
                             //sqsetcookie('key', $key, 0, sqm_baseuri());
                             vadmin_setcookie('key', $key, 0, sqm_baseuri());
                         }

                     }
                 }
             }
             vadmin_report_progress(_("Changing Password"), $userid, $vpassword, $desig);
         }
     }
 }

     /**
      * See if changes to the mailbox are requested.
      */
 if (sqGetGlobalVar('vmailbox', $vmailbox, SQ_POST)
  && in_array('mailbox', $displayablefields)) {
     spew("$me: analyzing mailbox change requests if any");
     if ($vmailbox != $user_ary[2] && $user_ary[2] != '===N/A==='){
         spew("$me: Check against the limits");
         $proceed = true;
         if ($user_ary[2] == ''){
             $mailbox_limit = vadmin_smart_limit($domain, $desig, 'mailboxes');
             if ($mailbox_limit != false){
                 $mboxes = vadmin_get_user_number($domain);
                 if ($mboxes >= $mailbox_limit){
                     spew("$me: cute, but I've thought of this. :)");
                     $errormsg = 'Mailbox limit reached. Ignored.';
                     $proceed = false;
                 }
             }
         }
         if ($proceed == true){
             /**
              * Change the destination of the mailbox. Call the
              * vchattr() function provided by vmail.inc.
              */
             spew("$me: calling vadmin_change_account_before hook");
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'DEST', $mailbox);
             do_hook('vadmin_change_account_before', $temp);
             spew("$me: calling vchattr");
             $repl = vchattr($domain, $secret, $userid, "DEST", $vmailbox);
             if ($repl[0]){
                 spew("$me: error returned: " . $repl[1]);
                 $errormsg = $repl[1];
             } else {
                 $successmsg = sprintf(_("Changed to '%s'"), $vmailbox);
             }
         }
         vadmin_report_progress(_("Changing Mailbox"));
     }
 }
     
     /**
      * Prepare the aliases by collapsing them into a string. This allows us
      * to comare the new values with the old ones.
      */
 if (sqGetGlobalVar('valiases', $valiases, SQ_POST)
  && in_array('forwards', $displayablefields)) {
     spew("$me: analyzing aliases");
     if (is_array($user_ary[3])){
         $aliases = implode(', ', $user_ary[3]);
     } else { 
         $aliases = "";
     }

     // rid ourselves of newlines in user input, they
     // only cause trouble
     //
     $valiases = str_replace(array("\r\n", "\r", "\n"), ',', $valiases);

     spew("$me: (forwards) aliases is: $aliases");
     spew("$me: (forwards) valiases is: $valiases");
     
     if ($valiases != $aliases){
         /**
          * Change forwards to a new value.
          */
         if (strlen($valiases)){
             $fwds = explode(',', $valiases);
             /**
              * Trim the values to avoid issues with spaces,
              * also remove empty entries
              */
             $forwards = array();
             $forward_errors = array(); 
             foreach ($fwds as $addr) {
                 $addr = trim($addr);
                 if (!empty($addr)) {
                     $result = validate_restricted_user_mail_forwarding($addr, $domain, $userid, ($ACT == 'chattrs_force_mailfwd' && $desig == 'ELVIS' ? TRUE : FALSE));
                     if (!$result[0])
                        $forwards[] = $addr;
                     else {
                        $forward_errors[] = $result[1];
                        break;
                     }
                 }
             }
         } else {
             $forwards = array();
         }

         // if there were errors, report
         //
         if (!empty($forward_errors)) {
             $errormsg = implode(' -- ', $forward_errors);
             spew("$me: forward address error: " . $errormsg);
             $msg = sprintf(_("Error: %s"), $errormsg);
             $skip_mailfwd = TRUE;

         } else {

             spew("$me: total size of forwads is: " . sizeof($forwards));

             /**
              * Call the vchforward function provided by vmail.inc.
              */
             spew("$me: calling vchforward");
             $repl = vchforward($VADMIN_DOMAIN, $secret, $userid, $forwards);
             if ($repl[0]){
                 spew("$me: error returned: " . $repl[1]);
                 $errormsg = $repl[1]; 
             } else {
                 $successmsg = sprintf(_("Updated to '%s'"), $valiases);
             }
         }
         vadmin_report_progress(_("Changing Forwards"), $userid, $valiases, $desig);
     }
 }
     
     /**
      * Analyze if changes requested to the personal info.
      */
 if (sqGetGlobalVar('personal_info', $personal_info, SQ_POST)
  && in_array('info', $displayablefields)) {
     spew("$me: analyzing changes to personal info if any");
     if ($personal_info != $user_ary[4] && $user_ary[4] != '===N/A==='){
         /**
          * Call vchattr(), a vmail.inc function.
          */
         spew("$me: calling vadmin_change_account_before hook");
         $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'PERSONAL', $personal_info);
         do_hook('vadmin_change_account_before', $temp);
         spew("$me: calling vchattr");
         $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'PERSONAL',
                         $personal_info);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1]; 
         } else{
             $successmsg = sprintf(_("Updated to '%s'"), $personal_info);
         }
         vadmin_report_progress(_("Changing Personal Info"));
     }
 }
     
     /**
      * Analyze Hard Quota changes.
      * If the setting was changed to "", they want to remove the setting,
      * so change it to "-".
      */
 if (sqGetGlobalVar('hard_quota', $hard_quota, SQ_POST)
  && in_array('hardquota', $displayablefields)) {
     spew("$me: analyzing hard quota change requests if any");
     if (!strlen($hard_quota) 
      || ($hard_quota == 0 && in_array('hardquota', $zeroIsUnlimited))){
         $hard_quota = "-";
     }
     if ($hard_quota*1024*1024 != $user_ary[5]){
         $limit = vadmin_smart_limit($domain, $desig, 'hardquota');
         if ($hard_quota == "-"){
             if ($limit != false){
                 $errormsg = _("Unlimited quotas not permitted");
             } else {
                 /**
                  * Change hard quota to unlimited.
                  */
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'HARDQUOTA', '-');
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: changing hard_quota to unlimited via vchattr");
                 $repl = vchattr($domain, $secret, $userid, 'HARDQUOTA', '-');
                 if (!$repl[0]){
                     $successmsg=_("Changed to unlimited.");
                 }
             }
         } else {
             if ($limit && $limit < $hard_quota){
                 $errormsg = sprintf(_("Quota above the limit of %d MiB"),
                                     $limit);
             } else {
                 /**
                  * Call the vchattr() function provided by vmail.inc and
                  * change the quota setting.
                  */
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'HARDQUOTA', $hard_quota*1024*1024);
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: setting to " . $hard_quota*1024*1024);
                 $repl = vchattr($domain, $secret, $userid, 'HARDQUOTA',
                                 $hard_quota*1024*1024);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %d MiB."), 
                                           $hard_quota);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Hard Quota"));
     }
 }
     
     /**
      * Analyze Soft Quota changes requested. If the new value is "",
      * then set it to "-" for consistency with the values returned by
      * vmail.inc.
      */
 if (sqGetGlobalVar('soft_quota', $soft_quota, SQ_POST)
  && in_array('softquota', $displayablefields)) {
     spew("$me: analyzing request for soft_quota change if any");
     if (!strlen($soft_quota)
      || ($soft_quota == 0 && in_array('softquota', $zeroIsUnlimited))){
         $soft_quota = "-";
     }
     if ($soft_quota*1024*1024 != $user_ary[6]){

         // apply the hard quota limit to the soft quota 
         // simply to prevent confusion
         //
         $limit = vadmin_smart_limit($domain, $desig, 'hardquota');

         if ($soft_quota == "-"){
             /**
              * Change to unlimited.
              * For soft quota, don't need to check limit, as not
              * to have a soft quota is OK, no matter what
              */
             spew("$me: calling vadmin_change_account_before hook");
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'SOFTQUOTA', '-');
             do_hook('vadmin_change_account_before', $temp);
             spew("$me: changing soft_quota to unlimited. Calling vchattr");
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'SOFTQUOTA', '-');
             if (!$repl[0]){
                 $successmsg=_("Changed to unlimited.");
             }
         } else {
             if ($limit && $limit < $soft_quota){
                 $errormsg = sprintf(_("Quota above the limit of %d MiB"),
                                     $limit);
             } else {
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'SOFTQUOTA', $soft_quota*1024*1024);
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: changing soft_quota to: " . $soft_quota*1024*1024);
                 $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'SOFTQUOTA', 
                                 $soft_quota*1024*1024);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %d MiB."), 
                                           $soft_quota);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Soft Quota"));
     }
 }
     
     /**
      * Analyze MessageSize Limit requests. If the value is "", change
      * it to "-".
      */
 if (sqGetGlobalVar('size_limit', $size_limit, SQ_POST)
  && in_array('sizelimit', $displayablefields)) {
     spew("$me: analyzing message size limit requests if any");
     if (!strlen($size_limit)
      || ($size_limit == 0 && in_array('sizelimit', $zeroIsUnlimited))){
         $size_limit = "-";
     }
     if ($size_limit*1024*1024 != $user_ary[7]){
         $limit = vadmin_smart_limit($domain, $desig, 'size');
         if ($size_limit == "-"){
             if ($limit != false){
                 $errormsg = _("Unlimited message size not permitted");
             } else {
                 /**
                  * Change to unlimited.
                  */
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGSIZE', '-');
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: changing size_limit to unlimited via vchattr");
                 $repl = vchattr($domain, $secret, $userid, 'MSGSIZE', '-');
                 if (!$repl[0]){
                     $successmsg = _("Changed to unlimited.");
                 }
             }
         } else {
             if ($limit && $limit < $size_limit){
                 $errormsg = sprintf(_("Size above the limit of %d MiB"), 
                                     $limit);
             } else {
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGSIZE', $size_limit*1024*1024);
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: changing size_limit to: " . $size_limit*1024*1024);
                 $repl = vchattr($domain, $secret, $userid, 'MSGSIZE',
                                 $size_limit*1024*1024);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %d MiB."), 
                                           $size_limit);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Size Limit"));
     }
 }
     
     /**
      * Analyze Message Count Limit requests. Change from "" to "-" if needed.
      */
 if (sqGetGlobalVar('count_limit', $count_limit, SQ_POST)
  && in_array('countlimit', $displayablefields)) {
     spew("$me: analyzing message count change requests if any");
     if (!strlen($count_limit)
      || ($count_limit == 0 && in_array('countlimit', $zeroIsUnlimited))){
         $count_limit = "-";
     }
     if ($count_limit != $user_ary[8]){
         $limit = vadmin_smart_limit($domain, $desig, 'count');
         if ($count_limit == "-"){
             if ($limit != false){
                 $errormsg = _("Unlimited message count not permitted");
             } else {
                 /**
                  * change to unlimited
                  */
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGCOUNT', '-');
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: changing count_limit to unlimited");
                 $repl = vchattr($domain, $secret, $userid, 'MSGCOUNT', '-');
                 if (!$repl[0]){
                     $successmsg = _("Changed to unlimited.");
                 }
             }
         } else {
             if ($limit && $limit < $count_limit){
                 $errormsg = sprintf(_("Message count above permitted %d"), 
                                     $limit);
             } else {
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGCOUNT', $count_limit);
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: changing count_limit to $count_limit");
                 $repl = vchattr($domain, $secret, $userid, 'MSGCOUNT',
                                 $count_limit);
                 if (!$repl[0]){
                     $successmsg = sprintf(_("Changed to %s messages."), 
                                           $count_limit);
                 }
             }
         }
         if (isset($repl) && $repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Count Limit"));
     }
 }
     
     /**
      * Analyze the changes to the time of acct expiration. Change
      * from "" to "-" if unlimited is requested.
      */
 if (sqGetGlobalVar('expiry_time', $expiry_time, SQ_POST)
  && in_array('expiry', $displayablefields)) {
     spew("$me: analyzing expiry time change requests if any");
     if (!strlen($expiry_time)){
         $expiry_time = "-";
     }
     if ($expiry_time != $user_ary[10]){
         if ($expiry_time == "-"){
             /**
              * change to unlimited
              */
             spew("$me: calling vadmin_change_account_before hook");
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'EXPIRY', '-');
             do_hook('vadmin_change_account_before', $temp);
             spew("$me: changing expiry_time to unlimited");
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'EXPIRY', '-');
             if (!$repl[0]){
                 $successmsg = _("Changed to unlimited.");
             }
         } else {
             $expiry_time_sec = $expiry_time * 86400;
             spew("$me: calling vadmin_change_account_before hook");
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'EXPIRY', $expiry_time_sec);
             do_hook('vadmin_change_account_before', $temp);
             spew("$me: changing expiry_time to $expiry_time_sec");
             $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 'EXPIRY',
                             $expiry_time_sec);
             if (!$repl[0]){
                 $successmsg=sprintf(_("Changed to %s days."), $expiry_time);
             }
         }
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             $errormsg = $repl[1];
         }
         vadmin_report_progress(_("Changing Expiry Time"));
     }
 }
     
     /**
      * Analyze the changes to all custom fields.
      */
     $custom_fields = vadmin_getvar('BACKEND', 'custom_user_account_fields');
     if ($custom_fields) 
        $custom_fields = explode(',', $custom_fields);
     else
        $custom_fields = array();
     @array_walk($custom_fields, 'vadmin_trim_array');
     $i = 13;
     foreach ($custom_fields as $field) {

         $field_name = str_replace(' ', '_', $field);
         $field_type = vadmin_getvar('BACKEND', $field_name . '_type');
         $new_value = 0;
         $i++;

         // note we have to allow for the fact that unchecked checkboxes 
         // won't appear to be passed here, but at the same time, make
         // sure we were not being called by the "chattrs_force_pwd" or
         // "chattrs_force_mailfwd" actions where the checkbox probably
         // ISN'T in the form whether or not it's enabled
         //
         if ((sqGetGlobalVar($field_name, $new_value, SQ_POST)
          || ($ACT == 'chattrs' && $field_type == 'checkbox'))
          && in_array($field, $displayablefields)) {
             spew("$me: analyzing $field change requests if any");
             $old_value = $user_ary[$i];

             if ($field_type == 'int' && preg_match('/[^1234567890]/', $new_value)) {
                 $errormsg = _("Only integer values allowed");
                 vadmin_report_progress(sprintf(_("Changing %s"), $field));
                 $old_value = '===N/A===';  // just to trick the if() below
             }
             if (($field_type == 'boolean' || $field_type == 'checkbox') 
              && $new_value != 1 && $new_value != 0) {
                 $errormsg = _("Only yes/no values allowed");
                 vadmin_report_progress(sprintf(_("Changing %s"), $field));
                 $old_value = '===N/A===';  // just to trick the if() below
             }

             if ($new_value != $old_value && $old_value != '===N/A===') {
                 /**
                  * Call vchattr(), a vmail.inc function.
                  */
                 spew("$me: calling vadmin_change_account_before hook");
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, $field_name, $new_value);
                 do_hook('vadmin_change_account_before', $temp);
                 spew("$me: calling vchattr");
                 $repl = vchattr($VADMIN_DOMAIN, $secret, $userid, 
                                 $field_name,
                                 $new_value);
                 if ($repl[0]){
                     spew("$me: error returned: " . $repl[1]);
                     $errormsg = $repl[1]; 
                 } else{
                     if ($field_type == 'boolean' && $new_value == 1)
                         $successmsg = _("Updated to Yes");
                     else if ($field_type == 'boolean' && $new_value == 0)
                         $successmsg = _("Updated to No");
                     else if ($field_type == 'checkbox' && $new_value == 1)
                         $successmsg = _("Updated to On");
                     else if ($field_type == 'checkbox' && $new_value == 0)
                         $successmsg = _("Updated to Off");
                     else if ($field_type == 'largetext' && strlen($new_value) > $max_length_of_display_field_contents_change_confirmation)
                         $successmsg = sprintf(_("Updated to '%s...'"), substr($new_value, 0, $max_length_of_display_field_contents_change_confirmation));
                     else
                         $successmsg = sprintf(_("Updated to '%s'"), $new_value);
                 }

                 vadmin_report_progress(sprintf(_("Changing %s"), $field));
             }

         }

     }

     /**
      * See if any changes were made.
      */
     if ($change_count){
         $body .= '<tr bgcolor="' . $color[9] . '"><th colspan="2">'
             . _("Execution completed") . '</th></tr>';
     } else {
         $body .= '<tr><td colspan="2" align="center">'
             . _("No changes requested") . '</td></tr>';
     }
     
     $body .= '</table>'
           . '<center><a href="'
           . vadmin_mkform_action($LVL, $MOD, 'getuser') 
           . '&amp;userid=' . urlencode($user_ary[0])
           . '">&lt; ' . _("Back to Account Details") . '</a>'
           . '<br /><a href="'
           . vadmin_mkform_action($LVL, 'email', 'acctlist')
           . '">&lt; ' . _("Back to Accounts Management") . '</a>'
           . '</center>';
     $title = sprintf(_("Changing attributes for <em>%s</em>"), $usertitle);
     
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** newuser **************************/
 case 'newuser':
     $action = vadmin_mkform_action($LVL, $MOD, 'createuser');

     // below, we'll not show forwards input field if the current user
     // cannot also see them on the user details screen
     //
     $displayablefields = vadmin_get_displayable_fields('user_details', '');

     $body = ''
         . '<form method="post" name="createuserform" action="' . $action . '">'
         . ' <input type="hidden" name="type" value="user" />'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Username:") . '</th>'
         . '   <td><input name="userid" /></td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Password:") . '</th>'
         . '   <td><input name="vpassword" /> '
         // for better readability, removed i, l, 1, o, O, 0
         // also use oldschool indexOf() instead of regex to keep requirements down
         . ($javascript_on ? '<a href="#" onclick="digits=\'23456789\'; posschars=\'abcdefghjkmnpqrstuvwxyz23456789\'; pwd=\'\'; pwdlen=8; directinsert=true; for (i=0;i<pwdlen;i++) pwd+=posschars.charAt(Math.floor(Math.random()*posschars.length)); if (pwd.indexOf(\'0\') == -1 && pwd.indexOf(\'1\') == -1 && pwd.indexOf(\'2\') == -1 && pwd.indexOf(\'3\') == -1 && pwd.indexOf(\'4\') == -1 && pwd.indexOf(\'5\') == -1 && pwd.indexOf(\'6\') == -1 && pwd.indexOf(\'7\') == -1 && pwd.indexOf(\'8\') == -1 && pwd.indexOf(\'9\') == -1) pwd = digits.charAt(Math.floor(Math.random()*digits.length)) + pwd.substring(1); if (directinsert) { document.createuserform.vpassword.value=pwd; } else { newwin=window.open(\'\', \'random_pwd_win\', \'width=150, height=100\'); newwin.document.open(); newwin.document.write(\'<html><head><title>Random Password</title></head><body><strong>\'+pwd+\'</strong></body></html>\'); newwin.document.close(); } return false;"><small>' . _("Random") . '</small></a>' : '')
         . '   </td>'
         . '  </tr>'
         . ' </table>'
         . ' <table border="0" align="center">'
         . (!in_array('forwards', $displayablefields) 
         ? ''
         : '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("[Optional] Also forward to (separate by commas):")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="forwards" cols="60" rows="2"></textarea>'
         . '   </td>'
         . '  </tr>'
         );

     // allow insecure passwords for elvis only
     //
     if ($desig == 'ELVIS')
         $body .= ''
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <table width="100%"><tr><td align="left">'
             . '     <input type="submit" value="' . _("Create new user")
             .        ' &gt;&gt;" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
             . '    </td><td align="right">'
             . '     <input type="submit" name="allowinsecurepasswords" value="' . _("Create new user - Allow Insecure Password")
             .        ' &gt;&gt;" />'
             . '    </td></tr></table>'
             . '   </th>'
             . '  </tr>';

     else
         $body .= ''
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <input type="submit" value="' . _("Create new user") 
             .       ' &gt;&gt;" />'
             . '   </th>'
             . '  </tr>';

     $body .= ''
         . ' </table>'
         . '</form>';
     $title = _("Creating New User");

     $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');
     if ($support_aliases == 'yes')
        $previous_uri = vadmin_mkform_action($LVL, 'email', 'addnew');
     else
        $previous_uri = vadmin_mkform_action($LVL, 'email', 'main');

     $previous_link = '<tr><td align="center"><a href="' . $previous_uri
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /****************************** multiplenewusers **************************/
 case 'multiplenewusers':
     $action = vadmin_mkform_action($LVL, $MOD, 'createmultipleusersconfirm');

     $body = ''
         . '<form method="post" name="createuserform" action="' . $action . '" enctype="multipart/form-data">'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Use File:") . '</th>'
         . '   <td><input type="file" name="userfile" size="35" /></td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("User/Password separator:") . '</th>'
         . '   <td><input name="userpassdelimiter" value="," size="1" maxlength="1" /> '
         . '   </td>'
         . '  </tr>'
         . ' </table>'
         . ' <table border="0" align="center" width="40%">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("Use cut-n-paste:")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="userlist" cols="60" rows="15"></textarea>'
         . '   </td>'
         . '  </tr>';

     // allow insecure passwords for elvis only
     //
     if ($desig == 'ELVIS')
         $body .= ''
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <table width="100%"><tr><td align="left">'
             . '     <input type="submit" value="' . _("Confirm")
             .        ' &gt;&gt;" />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
             . '    </td><td align="right">'
             . '     <input type="submit" name="allowinsecurepasswords" value="' . _("Confirm - Allow Insecure Passwords")
             .        ' &gt;&gt;" />'
             . '    </td></tr></table>'
             . '   </th>'
             . '  </tr>';

     else
         $body .= ''
             . '  <tr>'
             . '   <th bgcolor="' . $color[9] . '">'
             . '    <input type="submit" value="' . _("Confirm")
             .       ' &gt;&gt;" />'
             . '   </th>'
             . '  </tr>';

     $body .= ''
         . '  <tr>'
         . '  <td>'
         . _("Specify a file containing one user per line or paste in a user list here.  If passwords are included, specify the character that separates them from each username.  If passwords are not given, they will be automatically generated.")
         . '  </td>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Creating Multiple Users");

     $previous_uri = vadmin_mkform_action($LVL, 'email', 'addnew');
     $previous_link = '<tr><td align="center"><a href="' . $previous_uri
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /****************************** newalias **************************/
 case 'newalias':
     $action = vadmin_mkform_action($LVL, $MOD, 'createuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="type" value="alias" />'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Username:") . '</th>'
         . '   <td><input name="userid" /></td>'
         . '  </tr>'
         . ' </table>'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("Forward to (separate by commas):")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="forwards" cols="60" rows="2"></textarea>'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="' . _("Create new alias") 
         .       ' &gt;&gt;" />'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Creating New Alias");
     $previous_link = '<tr><td align="center"><a href="'
                    . vadmin_mkform_action($LVL, 'email', 'addnew')
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /****************************** newcatchall **************************/
 case 'newcatchall':
     $action = vadmin_mkform_action($LVL, $MOD, 'createuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="type" value="alias" />'
         . ' <input type="hidden" name="userid" value="' . $catchall_alias . '" />'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("Forward to (separate by commas):")
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <textarea name="forwards" cols="60" rows="2"></textarea>'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="'
         .       _("Create new 'catchall' default forward") . ' &gt;&gt;" />'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Creating New 'catchall' Account");
     $previous_link = '<tr><td align="center"><a href="'
                    . vadmin_mkform_action($LVL, 'email', 'addnew')
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /****************************** createmultipleusersconfirm **************************/
 case 'createmultipleusersconfirm':
     $action = vadmin_mkform_action($LVL, $MOD, 'createmultipleusers');

     // get user list from a file?
     //
     if (!is_uploaded_file($_FILES['userfile']['tmp_name'])
      || !($user_list = file($_FILES['userfile']['tmp_name']))) 


     // get user list from cut-n-paste
     //
     {
         $user_list = explode("\n", vadmin_getvar('POST', 'userlist'));
     }


     $allow_insecure_passwords = vadmin_getvar('POST', 'allowinsecurepasswords');


     // now process user list one user per line
     //
     $failed_user_list = array();
     $users_to_be_added = array();

     $mailbox_limit = vadmin_smart_limit($domain, $desig, 'mailboxes');
     if ($mailbox_limit != FALSE)
         $account_count = vadmin_get_user_number($domain);
     else
         $account_count = FALSE;
     $username_chars = vadmin_getvar('CONFIG', 'username.valid_characters');
     $min_username_len = vadmin_getvar('CONFIG', 'username.minimum_length');
     $max_username_len = vadmin_getvar('CONFIG', 'username.maximum_length');

     $show_min_username_footnote = FALSE;
     $show_max_username_footnote = FALSE;
     $show_min_password_footnote = FALSE;
     $show_max_password_footnote = FALSE;
     $show_username_chars_footnote = FALSE;
     $show_password_chars_footnote = FALSE;
     $show_password_override_footnote = FALSE;

     $user_pwd_delim = vadmin_getvar('POST', 'userpassdelimiter');
     // "0" (zero) could be deceptive here, but who'd use that as a delim??...
     if (!empty($user_pwd_delim)) $user_pwd_delim = $user_pwd_delim{0};
     else $user_pwd_delim = '';

     foreach ($user_list as $user) {

         // sanitize!
         //
         $user = htmlspecialchars($user);


         // determine if we need to generate a password for this user
         //
         $pwd = FALSE;
         if (empty($user_pwd_delim) 
          || strpos($user, $user_pwd_delim) === FALSE) {
             $uname = $user;
             $pwd = vadmin_generate_random_password();
         } else {
             @list($uname, $pwd) = explode($user_pwd_delim, $user, 2);

             // NOTE: we could skip the next three lines and thusly 
             //       require that if there is a password delimiter 
             //       there must be a password given....  if no 
             //       password, then this is an erroneous entry....
             //       but for now, we'll try to be extra helpful - 
             //       hopefully not too presumptuous
             $pwd = trim($pwd);
             if (empty($pwd))
                 $pwd = vadmin_generate_random_password();
         }

         $uname = trim($uname);
         $pwd = trim($pwd);
         if ($uname === '') continue;
         $uname_len = strlen($uname);


         // verify password integrity
         // (use administrative override (allow
         // insecure passwords) if elvis told us to)
         //
         $password_result = vadmin_validate_password($pwd, $domain, $uname, (!empty($allow_insecure_passwords) && $desig == 'ELVIS' ? TRUE : FALSE));


         // get user (below we need to make sure it doesn't already exist)
         //
         $command = array('lookup', $domain, $uname, $secret);
         $tmp = vm_daemon_raw($command);


         // add to error list if mailbox limit is exceeded
         //
         if ($account_count !== FALSE && (++$account_count > $mailbox_limit))
            $failed_user_list[$uname] = _("Account limit has been reached");


         // add to error list if username has illegal characters
         //
         else if (!empty($username_chars) 
               && !vadmin_verify_character_input($uname, $username_chars)) {
            $failed_user_list[$uname] = _("User name contains illegal characters");
            $show_username_chars_footnote = TRUE;
         }


         // add to error list if username length is illegal
         //
         else if ($min_username_len > 0 && $max_username_len > 0 
          && ($uname_len < $min_username_len || $uname_len > $max_username_len)) {
            $failed_user_list[$uname] = _("User name is too long or too short");
            $show_min_username_footnote = TRUE;
            $show_max_username_footnote = TRUE;
         }


         // add to error list if no password found for this user
//TODO: should we allow elvis to override this condition too???  if we do, first check if empty $pwd is handled downstream OK when actually setting the user account up (NOTE that the above pwd setup actions may mean that this condition is never met anyway!(??))
         //
         else if (empty($pwd))
            $failed_user_list[$uname] = _("No password found");


         // add to error list if password was bad
         //
         else if ($password_result[0]) {
            $password_error_message = $password_result[1];

            // we want to shorten error messages...
            //
            if ($password_result[0] == 1) {
               $password_error_message = _("Password contains illegal characters");
               $show_password_chars_footnote = TRUE;
            }
            else if ($password_result[0] == 3) {
               $password_error_message = _("Password is too long or too short");
               $show_min_password_footnote = TRUE;
               $show_max_password_footnote = TRUE;
            }

            $failed_user_list[$uname] = $password_error_message;
            if (empty($allow_insecure_passwords) && $desig == 'ELVIS' ? TRUE : FALSE)
               $show_password_override_footnote = TRUE;
         }


         // check for duplicated users
         //
         else if (!empty($users_to_be_added[$uname]))
            $failed_user_list[$uname] = _("Listed more than once (only the first one will be added)");


         // make sure user does not exist
         //
         else if (!$tmp[0]) {
            $failed_user_list[$uname] = _("User already exists");
         }


         // user can be added
         //
         else 
            $users_to_be_added[$uname] = $pwd;

     }


     // now place valid users into session so we don't have to rePOST them
     //
     vadmin_putvar('SESSION', 'VADMIN_MULTIPLE_USERADD', $users_to_be_added);


     // create columns of users for display
     //
     $number_user_columns = vadmin_getvar('CONFIG', 'username.multiple_add_user_columns');
     $user_columns = array();
     $column_size = ceil(sizeof($users_to_be_added) / $number_user_columns);
     $i = 0;
     $j = 0;
     foreach ($users_to_be_added as $uname => $pwd) {
         if ($i == $column_size) {
             $j++;
             $i = 0;
         }
         $user_columns[$j][$i]['username'] = $uname;
         $user_columns[$j][$i]['password'] = $pwd;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_user_columns = sizeof($user_columns);


     // create columns of failed users for display
     //
     $number_failed_columns = vadmin_getvar('CONFIG', 'username.multiple_add_error_columns');
     $failed_columns = array();
     $failed_column_size = ceil(sizeof($failed_user_list) / $number_failed_columns);
     $i = 0;
     $j = 0;
     foreach ($failed_user_list as $uname => $err) {
         if ($i == $failed_column_size) {
             $j++;
             $i = 0;
         }
         $failed_columns[$j][$i]['username'] = $uname;
         $failed_columns[$j][$i]['reason'] = $err;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_failed_columns = sizeof($failed_columns);


     $body = ''
         . '<form method="post" name="createuserform" action="' . $action . '">';


     // give list of failed users
     //
     if (!empty($failed_user_list)) {

         $body .= ''
             . ' <table border="0" align="center">'
             . '  <tr>'
             . '   <th colspan="' . (($number_failed_columns * 3) - 1)
             . '" bgcolor="' . $color[9] . '">'
             .      _("Users that will NOT be added:")
             . '   </th>'
             . '  </tr>'
             . '  <tr>';


         // print correct number of column headers
         //
         $first = TRUE;
         for ($i = 0; $i < $number_failed_columns; $i++) {
             if ($first)
                 $first = FALSE;
             else
                 $body .= ''
                     . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';

             $body .= ''
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Username")
                 . '   </th>'
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Reason")
                 . '   </th>';
         }


         $body .= '  </tr>';


         // print actual columns of data
         //
         $flip = true;
         for ($i = 0; $i < $failed_column_size; $i++) {
             $body .= ''
                 . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';

             $first = TRUE;
             for ($j = 0; $j < $number_failed_columns; $j++) {
                 if ($first)
                     $first = FALSE;
                 else
                     $body .= '   <td></td>';

                 $body .= ''
                     . (!empty($failed_columns[$j][$i])
                     ? '   <td align="center">' . $failed_columns[$j][$i]['username'] . '</td>'
                     . '   <td align="center">' . $failed_columns[$j][$i]['reason'] . '</td>'
                     : '<td></td><td></td>'
                     );
             }

             $body .= '  </tr>';
         }


         $body .= ' </table><br /><br />';
     }


     // if needed, display text indicating no users were found to add
     //
     if (empty($users_to_be_added))
         $body .= ''
             . '<table border="0" align="center" width="40%">'
             . '<tr><td>' 
             . _("No users were found to add; please go back and correct your input")
             . '</td></tr>'
             . ' </table>'
             . '</form>';


     // main display of users that will be added
     //
     else {
         $body .= ''
             . ' <table border="0" align="center" width="40%">'
             . '  <tr>'
             . '   <th colspan="' . (($number_user_columns * 3) - 1) 
             . '" bgcolor="' . $color[9] . '">'
             .      _("Users to be added:")
             . '   </th>'
             . '  </tr>'
             . '  <tr>';


         // print correct number of column headers
         //
         $first = TRUE;
         for ($i = 0; $i < $number_user_columns; $i++) {
             if ($first)
                 $first = FALSE;
             else
                 $body .= ''
                     . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';

             $body .= ''
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Username")
                 . '   </th>'
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Password")
                 . '   </th>';
         }


         $body .= '  </tr>';


         // print actual columns of data
         //
         $flip = true;
         for ($i = 0; $i < $column_size; $i++) {
             $body .= ''
                 . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';

             $first = TRUE;
             for ($j = 0; $j < $number_user_columns; $j++) {
                 if ($first)
                     $first = FALSE;
                 else
                     $body .= '   <td></td>';

                 $body .= ''
                     . (!empty($user_columns[$j][$i])
                     ? '   <td align="center">' . $user_columns[$j][$i]['username'] . '</td>'
                     . '   <td align="center">' . $user_columns[$j][$i]['password'] . '</td>'
                     : '<td></td><td></td>'
                     );
             }

             $body .= '  </tr>';
         }


         $footnotes = '';
         if ($show_min_username_footnote && $show_max_username_footnote) {
             $footnotes .= ' ' . sprintf(_("User names must be at least %d and at most %d characters long."), $min_username_len, $max_username_len);
         }
         if ($show_min_password_footnote && $show_max_password_footnote) {
             $min_pwd_len = vadmin_getvar('CONFIG', 'password.minimum_length');
             $max_pwd_len = vadmin_getvar('CONFIG', 'password.maximum_length');
             $footnotes .= ' ' . sprintf(_("Passwords must be at least %d and at most %d characters long."), $min_pwd_len, $max_pwd_len);
         }
         if ($show_username_chars_footnote) {
             $footnotes .= ' ' . sprintf(_("User names may only contain the following characters: %s"), $username_chars);
         }
         if ($show_password_chars_footnote) {
             $pwd_chars = vadmin_getvar('CONFIG', 'password.valid_characters');
             $footnotes .= ' ' . sprintf(_("Passwords may only contain the following characters: %s"), $pwd_chars);
         }
         if ($show_password_override_footnote) {
             $footnotes .= ' ' . _("As a superuser, you may go back to the previous screen and choose to submit user data while ignoring most password integrity limits");
         }


         $body .= ''
             . '  <tr>'
             . '   <th colspan="' . (($number_user_columns * 3) - 1) 
             . '" bgcolor="' . $color[9] . '">'
             . '    <input type="submit" value="' . _("Create new users") . ' &gt;&gt;" />'
             . (!empty($allow_insecure_passwords) && $desig == 'ELVIS'
             ? '    <input type="hidden" name="allowinsecurepasswords" value="1" />' : '')
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '  <td colspan="' . (($number_user_columns * 3) - 1) . '">'
             . $footnotes
             . '  </td>'
             . '  </tr>'
             . ' </table>'
             . '</form>';

     }


     $title = _("Confirm Creating Multiple Users");

     $previous_uri = vadmin_mkform_action($LVL, $MOD, 'multiplenewusers');
     $previous_link = '<tr><td align="center"><a href="' . $previous_uri
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /***************************** createuser *************************/
 case 'createuser':

     /**
      * Get form values.
      */
     $type      = vadmin_getvar('POST', 'type');
     $userid    = vadmin_getvar('POST', 'userid');
     $vpassword = vadmin_getvar('POST', 'vpassword');
     $forwards  = vadmin_getvar('POST', 'forwards');
     $allow_insecure_passwords = vadmin_getvar('POST', 'allowinsecurepasswords');

     // rid ourselves of newlines in user input, they
     // only cause trouble
     //
     $forwards = str_replace(array("\r\n", "\r", "\n"), '', $forwards);

     /**
      * Collapse forwards into array and trim so we don't have issues with
      * spaces.
      */
     if (strlen($forwards)){
         $forwards = explode(',', $forwards);
         @array_walk($forwards, 'vadmin_trim_array');
     } else {
         $forwards = array();
     }
     spew("$me: total number of forwards is: " . sizeof($forwards));

     $success_button = _("ERROR!");
     $success_text = _("ERROR!");
     $success_title = _("ERROR!");
     $usertitle = "$userid@$VADMIN_DOMAIN";
     if ($userid == $catchall_alias){
         $usertitle = _("'catchall'");
     }

     if ($type == 'user'){

         // verify username name characters
         //
         $username_chars = vadmin_getvar('CONFIG', 'username.valid_characters');
         if (!empty($username_chars)
          && !vadmin_verify_character_input($userid, $username_chars)) {
             spew("$me: username contains illegal characters");
             vadmin_user_error(sprintf(_("User name may only contain these characters: %s."), $username_chars));
         }

         // verify username name length
         //
         $minlen = vadmin_getvar('CONFIG', 'username.minimum_length');
         $maxlen = vadmin_getvar('CONFIG', 'username.maximum_length');
         $len = strlen($userid);
         if ($minlen > 0 && $maxlen > 0 && ($len < $minlen || $len > $maxlen)) {
             spew("$me: username is not an allowable length");
             vadmin_user_error(sprintf(_("User name must be between %d and %d characters in length."), $minlen, $maxlen));
         }

         // verify password integrity
         // (use administrative override (allow
         // insecure passwords) if elvis told us to)
         //
         $valid_pwd = vadmin_validate_password($vpassword, $VADMIN_DOMAIN, $userid, (!empty($allow_insecure_passwords) && $desig == 'ELVIS' ? TRUE : FALSE));
         if ($valid_pwd[0]) {
             spew("$me: insecure password: " . $valid_pwd[1]);
             vadmin_user_error($valid_pwd[1] . (empty($allow_insecure_passwords) && $desig == 'ELVIS' ? _(" (You may go back to the previous screen and choose to submit user data while ignoring most password integrity limits)") : ''));
         }


         /**
          * Call a vadduser() function by vmail.inc.
          */
         spew("$me: calling vadmin_create_account_before hook");
         $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, $vpassword, $forwards);
         do_hook('vadmin_create_account_before', $temp);
         spew("$me: calling vadduser()");
         $repl = vadduser($domain, $secret, $userid, $vpassword, $forwards);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             vadmin_user_error($repl[1]);
         }
         spew("$me: taking care of domain limits.");
         // there is no reason why users should have unlimited quota
         // just because their account was created by an ELVIS...
         // likewise for CROSS...
         //$hardquota = vadmin_smart_limit($domain, $desig, 'hardquota');
         //$size = vadmin_smart_limit($domain, $desig, 'size');
         //$count = vadmin_smart_limit($domain, $desig, 'count');
         $temp_desig = $desig;
         if ($desig == 'ELVIS') $temp_desig = 'CROSS';
         elseif ($desig == 'CROSS') $temp_desig = 'LOWLY';
         $hardquota = vadmin_smart_limit($domain, $temp_desig, 'hardquota');
         $softquota = vadmin_smart_limit($domain, $temp_desig, 'softquota');
         $size = vadmin_smart_limit($domain, $temp_desig, 'size');
         $count = vadmin_smart_limit($domain, $temp_desig, 'count');
         if ($softquota != false){
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'SOFTQUOTA', $softquota*1024*1024);
             do_hook('vadmin_change_account_before', $temp);
             vchattr($domain, $secret, $userid, 'SOFTQUOTA',
                     $softquota*1024*1024);
         }
         if ($hardquota != false){
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'HARDQUOTA', $hardquota*1024*1024);
             do_hook('vadmin_change_account_before', $temp);
             vchattr($domain, $secret, $userid, 'HARDQUOTA',
                     $hardquota*1024*1024);
         }
         if ($size != false){
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGSIZE', $size*1024*1024);
             do_hook('vadmin_change_account_before', $temp);
             vchattr($domain, $secret, $userid, 'MSGSIZE', $size*1024*1024);
         }
         if ($count != false){
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGCOUNT', $count);
             do_hook('vadmin_change_account_before', $temp);
             vchattr($domain, $secret, $userid, 'MSGCOUNT', $count);
         }
         $success_button = _("Customize this account");
         $success_title = sprintf(_("Account %s created"), $usertitle);
         $success_text = sprintf(_("User <strong>%s</strong> has been successfully created and is ready to be used. If you would like to adjust settings for this newly created account, then please click the button below."), $usertitle);

     } elseif ($type == 'alias'){

         if ($userid != $catchall_alias){

             // verify alias name characters
             //
             $username_chars = vadmin_getvar('CONFIG', 'username.valid_characters');
             if (!empty($username_chars) 
              && !vadmin_verify_character_input($userid, $username_chars)) {
                 spew("$me: alias contains illegal characters");
                 vadmin_user_error(sprintf(_("Alias name may only contain these characters: %s."), $username_chars));
             }

             // verify alias name length
             //
             $minlen = vadmin_getvar('CONFIG', 'username.minimum_length');
             $maxlen = vadmin_getvar('CONFIG', 'username.maximum_length');
             $len = strlen($userid);
             if ($minlen > 0 && $maxlen > 0 && ($len < $minlen || $len > $maxlen)) {
                 spew("$me: alias is not an allowable length");
                 vadmin_user_error(sprintf(_("Alias name must be between %d and %d characters in length."), $minlen, $maxlen));
             }

         }

         /**
          * Call a vaddalias() function by vmail.inc.
          */
         spew("$me: calling vaddalias()");
         $repl = vaddalias($VADMIN_DOMAIN, $secret, $userid, "", $forwards);
         if ($repl[0]){
             spew("$me: error returned: " . $repl[1]);
             vadmin_user_error($repl[1]);
         }
         $success_button = _("Customize this alias");
         $success_title = sprintf(_("Alias %s created"), $usertitle);
         $success_text = sprintf(_("Alias <strong>%s</strong> has been successfully created and is ready to be used. If you would like to adjust settings for this newly created alias, then please click the button below."), $usertitle);
     }
     $action = vadmin_mkform_action($LVL, $MOD, 'getuser');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="userid" value="' . $userid . '" />'
         . ' <table border="0" width="60%" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      $success_title
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td>'
         .      $success_text
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         . '    <input type="submit" value="' . $success_button
         .       ' &gt;&gt;" />'
         . '   </th>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("User created");

     $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');
     if ($support_aliases == 'yes')
        $previous_uri = vadmin_mkform_action($LVL, 'email', 'addnew');
     else
        $previous_uri = vadmin_mkform_action($LVL, 'email', 'main');

     $previous_link = '<tr><td align="center"><a href="'
                    . $previous_uri
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /***************************** createmultipleusers *************************/
 case 'createmultipleusers':

     $user_list = vadmin_getvar('SESSION', 'VADMIN_MULTIPLE_USERADD');
     vadmin_putvar('SESSION', 'VADMIN_MULTIPLE_USERADD', '');
     if (!is_array($user_list))
         vadmin_system_error(_("User list was corrupted"));

     $ok_users = array();
     $bad_users = array();
     $username_chars = vadmin_getvar('CONFIG', 'username.valid_characters');
     $minuserlen = vadmin_getvar('CONFIG', 'username.minimum_length');
     $maxuserlen = vadmin_getvar('CONFIG', 'username.maximum_length');
     $mailbox_limit = vadmin_smart_limit($domain, $desig, 'mailboxes');
     if ($mailbox_limit != FALSE)
         $account_count = vadmin_get_user_number($domain);
     else
         $account_count = FALSE;

     $allow_insecure_passwords = vadmin_getvar('POST', 'allowinsecurepasswords');

     $show_min_username_footnote = FALSE;
     $show_max_username_footnote = FALSE;
     $show_min_password_footnote = FALSE;
     $show_max_password_footnote = FALSE;
     $show_username_chars_footnote = FALSE;
     $show_password_chars_footnote = FALSE;
     $show_password_override_footnote = FALSE;

     // loop through all users, check if they can be added
     // and then add each one
     //
     foreach ($user_list as $userid => $vpassword) {

         $useridlen = strlen($userid);

         // verify password integrity
         // (use administrative override (allow
         // insecure passwords) if elvis told us to)
         //
         $password_result = vadmin_validate_password($vpassword, $domain, $userid, (!empty($allow_insecure_passwords) && $desig == 'ELVIS' ? TRUE : FALSE));

         // get user (below we need to make sure it doesn't already exist)
         //
         $command = array('lookup', $domain, $userid, $secret);
         $tmp = vm_daemon_raw($command);

         // verify that account limit has not been exceeded
         //
         if ($account_count !== FALSE && (++$account_count > $mailbox_limit)) {
             spew("$me: account limit has been reached");
             $bad_users[$userid] = _("Account limit has been reached");
         }

         // verify username name characters
         //
         else if (!empty($username_chars)
          && !vadmin_verify_character_input($userid, $username_chars)) {
             spew("$me: username contains illegal characters");
             $bad_users[$userid] = _("User name contains illegal characters");
             $show_username_chars_footnote = TRUE;
         }

         // verify username name length
         //
         else if ($minuserlen > 0 && $maxuserlen > 0 
          && ($useridlen < $minuserlen || $useridlen > $maxuserlen)) {
             spew("$me: username is not an allowable length");
             $bad_users[$userid] = _("User name is too long or too short");
             $show_min_username_footnote = TRUE;
             $show_max_username_footnote = TRUE;
         }

         // add to error list if password was bad
         //
         else if ($password_result[0]) {
            $password_error_message = $password_result[1];

            // we want to shorten error messages...
            //
            if ($password_result[0] == 1) {
               $password_error_message = _("Password contains illegal characters");
               $show_password_chars_footnote = TRUE;
            }
            else if ($password_result[0] == 3) {
               $password_error_message = _("Password is too long or too short");
               $show_min_password_footnote = TRUE;
               $show_max_password_footnote = TRUE;
            }

            $bad_users[$userid] = $password_error_message;
            spew("$me: " . $password_error_message);
            if (empty($allow_insecure_passwords) && $desig == 'ELVIS' ? TRUE : FALSE)
               $show_password_override_footnote = TRUE;
         }

         // check for duplicated users
         //
         else if (!empty($ok_users[$userid]))
             $bad_users[$userid] = _("Listed more than once (only the first one will be added)");

         // make sure user does not exist
         //
         else if (!$tmp[0]) {
            $bad_users[$userid] = _("User already exists");
         }


         // user can be added
         //
         else {

             /**
              * Call a vadduser() function by vmail.inc.
              */
             spew("$me: calling vadmin_create_account_before hook");
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, $vpassword, array());
             do_hook('vadmin_create_account_before', $temp);
             spew("$me: calling vadduser()");
             $repl = vadduser($domain, $secret, $userid, $vpassword, array());
             if ($repl[0]){
                 spew("$me: error returned: " . $repl[1]);
                 $bad_users[$userid] = $repl[1];
                 continue;
             }
             spew("$me: taking care of domain limits.");
             // there is no reason why users should have unlimited quota
             // just because their account was created by an ELVIS...
             // likewise for CROSS...
             //$hardquota = vadmin_smart_limit($domain, $desig, 'hardquota');
             //$size = vadmin_smart_limit($domain, $desig, 'size');
             //$count = vadmin_smart_limit($domain, $desig, 'count');
             $temp_desig = $desig;
             if ($desig == 'ELVIS') $temp_desig = 'CROSS';
             elseif ($desig == 'CROSS') $temp_desig = 'LOWLY';
             $hardquota = vadmin_smart_limit($domain, $temp_desig, 'hardquota');
             $softquota = vadmin_smart_limit($domain, $temp_desig, 'softquota');
             $size = vadmin_smart_limit($domain, $temp_desig, 'size');
             $count = vadmin_smart_limit($domain, $temp_desig, 'count');
             if ($softquota != false){
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'SOFTQUOTA', $softquota*1024*1024);
                 do_hook('vadmin_change_account_before', $temp);
                 vchattr($domain, $secret, $userid, 'SOFTQUOTA',
                         $softquota*1024*1024);
             }
             if ($hardquota != false){
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'HARDQUOTA', $hardquota*1024*1024);
                 do_hook('vadmin_change_account_before', $temp);
                 vchattr($domain, $secret, $userid, 'HARDQUOTA',
                         $hardquota*1024*1024);
             }
             if ($size != false){
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGSIZE', $size*1024*1024);
                 do_hook('vadmin_change_account_before', $temp);
                 vchattr($domain, $secret, $userid, 'MSGSIZE', $size*1024*1024);
             }
             if ($count != false){
                 $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain, 'MSGCOUNT', $count);
                 do_hook('vadmin_change_account_before', $temp);
                 vchattr($domain, $secret, $userid, 'MSGCOUNT', $count);
             }
             $ok_users[$userid] = $vpassword;

         }

     } // end foreach user in user list 

     // create columns of users for display
     //
     $number_user_columns = vadmin_getvar('CONFIG', 'username.multiple_add_user_columns');
     $user_columns = array();
     $column_size = ceil(sizeof($ok_users) / $number_user_columns);
     $i = 0;
     $j = 0;
     foreach ($ok_users as $uname => $pwd) {
         if ($i == $column_size) {
             $j++;
             $i = 0;
         }
         $user_columns[$j][$i]['username'] = $uname;
         $user_columns[$j][$i]['password'] = $pwd;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_user_columns = sizeof($user_columns);


     // create columns of failed users for display
     //
     $number_failed_columns = vadmin_getvar('CONFIG', 'username.multiple_add_error_columns');
     $failed_columns = array();
     $failed_column_size = ceil(sizeof($bad_users) / $number_failed_columns);
     $i = 0;
     $j = 0;
     foreach ($bad_users as $uname => $err) {
         if ($i == $failed_column_size) {
             $j++;
             $i = 0;
         }
         $failed_columns[$j][$i]['username'] = $uname;
         $failed_columns[$j][$i]['reason'] = $err;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_failed_columns = sizeof($failed_columns);


     $body = '';


     // give list of failed users
     //
     if (!empty($bad_users)) {

         $body .= ''
             . ' <table border="0" align="center">'
             . '  <tr>'
             . '   <th colspan="' . (($number_failed_columns * 3) - 1)
             . '" bgcolor="' . $color[9] . '">'
             .      _("Users that have NOT been added:")
             . '   </th>'
             . '  </tr>'
             . '  <tr>';


         // print correct number of column headers
         //
         $first = TRUE;
         for ($i = 0; $i < $number_failed_columns; $i++) {
             if ($first)
                 $first = FALSE;
             else
                 $body .= ''
                     . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';

             $body .= ''
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Username")
                 . '   </th>'
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Reason")
                 . '   </th>';
         }


         $body .= ''
             . '  </tr>';


         // print actual columns of data
         //
         $flip = true;
         for ($i = 0; $i < $failed_column_size; $i++) {
             $body .= ''
                 . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';

             $first = TRUE;
             for ($j = 0; $j < $number_failed_columns; $j++) {
                 if ($first)
                     $first = FALSE;
                 else
                     $body .= '   <td></td>';

                 $body .= ''
                     . (!empty($failed_columns[$j][$i])
                     ? '   <td align="center">' . $failed_columns[$j][$i]['username'] . '</td>'
                     . '   <td align="center">' . $failed_columns[$j][$i]['reason'] . '</td>'
                     : '<td></td><td></td>'
                     );
             }

             $body .= '  </tr>';
         }


         $body .= ''
             . ' </table><br /><br />';
     }


     // if needed, display text indicating no users were found to add
     //
     if (empty($ok_users))
         $body .= ''
             . '<table border="0" align="center" width="40%">'
             . '<tr><td>' 
             . _("No users were found to add; please go back and correct your input")
             . '</td></tr>'
             . ' </table>'
             . '</form>';


     // main display of users that were added
     //
     else {
         $body .= ''
             . ' <table border="0" align="center" width="40%">'
             . '  <tr>'
             . '   <th colspan="' . (($number_user_columns * 3) - 1) 
             . '" bgcolor="' . $color[9] . '">'
             .      _("Users that have been added:")
             . '   </th>'
             . '  </tr>'
             . '  <tr>';


         // print correct number of column headers
         //
         $first = TRUE;
         for ($i = 0; $i < $number_user_columns; $i++) {
             if ($first)
                 $first = FALSE;
             else
                 $body .= ''
                     . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';

             $body .= ''
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Username")
                 . '   </th>'
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Password")
                 . '   </th>';
         }


         $body .= ''
             . '  </tr>';


         // print actual columns of data
         //
         $flip = true;
         for ($i = 0; $i < $column_size; $i++) {
             $body .= ''
                 . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';

             $first = TRUE;
             for ($j = 0; $j < $number_user_columns; $j++) {
                 if ($first)
                     $first = FALSE;
                 else
                     $body .= '   <td></td>';

                 $body .= ''
                     . (!empty($user_columns[$j][$i])
                     ? '   <td align="center">' . $user_columns[$j][$i]['username'] . '</td>'
                     . '   <td align="center">' . $user_columns[$j][$i]['password'] . '</td>'
                     : '<td></td><td></td>'
                     );
             }

             $body .= '  </tr>';
         }


         $footnotes = '';
         if ($show_min_username_footnote && $show_max_username_footnote) {
             $footnotes .= ' ' . sprintf(_("User names must be at least %d and at most %d characters long."), $minuserlen, $maxuserlen);
         }
         if ($show_min_password_footnote && $show_max_password_footnote) {
             $minpwdlen = vadmin_getvar('CONFIG', 'password.minimum_length');
             $maxpwdlen = vadmin_getvar('CONFIG', 'password.maximum_length');
             $footnotes .= ' ' . sprintf(_("Passwords must be at least %d and at most %d characters long."), $minpwdlen, $maxpwdlen);
         }
         if ($show_username_chars_footnote) {
             $footnotes .= ' ' . sprintf(_("User names may only contain the following characters: %s"), $username_chars);
         }
         if ($show_password_chars_footnote) {
             $password_chars = vadmin_getvar('CONFIG', 'password.valid_characters');
             $footnotes .= ' ' . sprintf(_("Passwords may only contain the following characters: %s"), $password_chars);
         }
         if ($show_password_override_footnote) {
             $footnotes .= ' ' . _("As a superuser, you may go back to the previous screen and choose to submit user data while ignoring most password integrity limits");
         }


         if (empty($footnotes)) $footnotes = '&nbsp;';
         $body .= ''
             . '  <tr>'
             . '   <th colspan="' . (($number_user_columns * 3) - 1) 
             . '" bgcolor="' . $color[9] . '">'
             . '&nbsp;'
             . '   </th>'
             . '  </tr>'
             . '  <tr>'
             . '  <td colspan="' . (($number_user_columns * 3) - 1) . '">'
             . $footnotes
             . '  </td>'
             . '  </tr>'
             . ' </table>';

     }


     $title = _("Created Multiple Users");

     $previous_uri = vadmin_mkform_action($LVL, $MOD, 'multiplenewusers');
     $previous_link = '<tr><td align="center"><a href="' . $previous_uri
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /****************************** deluser **************************/
 case 'deluser':
     $camefrom = vadmin_getvar('POST', 'camefrom');
     if (empty($camefrom)) $camefrom = vadmin_getvar('GET', 'camefrom');
     $userid = vadmin_getvar('POST', 'userid');
     if (empty($userid)) $userid = vadmin_getvar('GET', 'userid');

     if (!empty($multiple_del_come_single_userid)) {
         $userid = $multiple_del_come_single_userid;
         $camefrom = 'listall';
     }

     $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');

     if (empty($userid) && !empty($catchall_alias))  // allow delete of empty catchalls too(!)
         vadmin_system_error(_("No user specified."));
//FIXME: shouldn't we be using $delim instead of @??
     $usertitle = "$userid@$domain";
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }
     if ((vadmin_IMAP_usernames_have_domain($domain) && $username == $usertitle) 
          || (!vadmin_IMAP_usernames_have_domain($domain) && $username == $userid)) {
         spew("$me: oi-oi-oi, they can't delete the account they are logged in with.");
         $msg = _("You can't delete your own account"); 
         vadmin_user_error($msg);
     }
     spew("$me: making sure they know what they are doing");
     if ($userid == $catchall_alias){
         $usertitle = _("'catchall'");
     }

     $action_cancel = vadmin_mkform_action($LVL, $MOD, $camefrom);
     $action_ok = vadmin_mkform_action($LVL, $MOD, 'deluser_yes');

     $body = ''
         . '<table border="0" width="80%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '" colspan="2">'
         .     _("Confirm action")
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td align="center" colspan="2">'
         . '   <p style="width: 90%; text-align: left">'
         . ($support_aliases == 'yes'
         ?      sprintf(_("<strong>WARNING:</strong> You are about to delete user or alias <strong>%s</strong>. If it's a real user, this will delete his/her mailbox including all stored messages, and clear any webmail preferences this user has. Proceed?"), $usertitle)
         :      sprintf(_("<strong>WARNING:</strong> You are about to delete user <strong>%s</strong>. This will delete his/her mailbox including all stored messages, and clear any webmail preferences this user has. Proceed?"), $usertitle)
         )
         . '   </p>'
         . '  </td>'
         . ' </tr>'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">'
         . '   <form method="post" action="' . $action_cancel . '">'
         . '    <input type="hidden" name="userid" value="' . $userid . '" />'
         . '    <input type="submit" value="&lt;&lt; '._("No, cancel").'" />'
         . '   </form>'
         . '  </th>'
         . '  <th bgcolor="' . $color[9] . '">'
         . '   <form method="post" action="' . $action_ok . '">'
         . '    <input type="hidden" name="userid" value="' . $userid . '" />'
         . '    <input type="submit" value="'._("Yes, delete").' &gt;&gt;" />'
         . '   </form>'
         . '  </th>'
         . ' </tr>'
         . '</table>'
         . '<center><a href="'
         . vadmin_mkform_action($LVL, $MOD, $camefrom) 
         . '&amp;userid=' . urlencode($userid)
         . '">&lt; ' . _("Previous") 
         . '</a></center>';
     $title = sprintf(_("About to delete account %s"), $usertitle);
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** delmultipleusersconfirm **************************/
 case 'delmultipleusersconfirm':

     // already checked this above (very top of file), but just 
     // for the heck of it...
     if (empty($delusers))
         vadmin_system_error(_("No user specified."));


     $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');


     // make sure all users are deletable
     //
     $ok_users = array();
     $bad_users = array();
     foreach ($delusers as $userid => $ignore) {

         // make sure dummy value $ignore is set to 1 (per checkbox value)
         //
         if ($ignore !== '1')
             continue;

         // skip empty entries unless it's actually the catchall
         //
         if (empty($userid) && !empty($catchall_alias))
             continue;

         // get user (below we need to make sure it actually exists)
         //
         $command = array('lookup', $domain, $userid, $secret);
         $tmp = vm_daemon_raw($command);

         if ($userid == $catchall_alias)
             $display_userid = $catchall_alias;
         else
             $display_userid = $userid;

         // make sure we have edit permissions against this account
         //
//FIXME: shouldn't we be using $delim instead of @??
         $usertitle = "$userid@$domain";
         if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)) {
             spew("$me: ai-ai-ai, they can't edit this user.");
             $bad_users[$display_userid] = _("You don't have permission to edit this user");
         } 

         // can't delete onesself
         //
         else if ((vadmin_IMAP_usernames_have_domain($domain) && $username == $usertitle) 
          || (!vadmin_IMAP_usernames_have_domain($domain) && $username == $userid)) {
             $bad_users[$display_userid] = _("You can't delete your own account");
         }

         // make sure user exists
         //
         else if ($tmp[0]) {
             spew("$me: no such user or alias '$userid'");
             if ($support_aliases == 'yes')
                 $bad_users[$display_userid] = _("No such user or alias exists");
             else
                 $bad_users[$display_userid] = _("No such user exists");
         }

         // user is delete-able
         //
         else {
             $ok_users[$userid] = $display_userid;
         }

     }


     // now place valid users into session so we don't have to rePOST them
     //
     vadmin_putvar('SESSION', 'VADMIN_MULTIPLE_USERDEL', $ok_users);


     // create columns of failed users for display
     //
     $number_failed_columns = vadmin_getvar('CONFIG', 'username.multiple_delete_error_columns');
     $failed_columns = array();
     $failed_column_size = ceil(sizeof($bad_users) / $number_failed_columns);
     $i = 0;
     $j = 0;
     foreach ($bad_users as $userid => $err) {
         if ($i == $failed_column_size) {
             $j++;
             $i = 0;
         }
         $failed_columns[$j][$i]['username'] = $userid;
         $failed_columns[$j][$i]['reason'] = $err;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_failed_columns = sizeof($failed_columns);


     // create columns of users for display
     //
     $number_user_columns = vadmin_getvar('CONFIG', 'username.multiple_delete_user_columns');
     $user_columns = array();
     $column_size = ceil(sizeof($ok_users) / $number_user_columns);
     $i = 0;
     $j = 0;
     foreach ($ok_users as $userid => $display_userid) {
         if ($i == $column_size) {
             $j++;
             $i = 0;
         }
         $user_columns[$j][$i] = $display_userid;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_user_columns = sizeof($user_columns);


     $body = '';


     // give list of failed users
     //
     if (!empty($bad_users)) {

         $body .= ''
             . ' <table border="0" align="center">'
             . '  <tr>'
             . '   <th colspan="' . (($number_failed_columns * 3) - 1)
             . '" bgcolor="' . $color[9] . '">'
             .      _("Accounts that will NOT be deleted:")
             . '   </th>'
             . '  </tr>'
             . '  <tr>';


         // print correct number of column headers
         //
         $first = TRUE;
         for ($i = 0; $i < $number_failed_columns; $i++) {
             if ($first)
                 $first = FALSE;
             else
                 $body .= ''
                     . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';

             $body .= ''
                 . '   <th bgcolor="' . $color[9] . '">'
                 . ($support_aliases == 'yes'
                 ?      _("Username/Alias")
                 :      _("Username")
                 )
                 . '   </th>'
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Reason")
                 . '   </th>';
         }


         $body .= ''
             . '  </tr>';


         // print actual columns of data
         //
         $flip = true;
         for ($i = 0; $i < $failed_column_size; $i++) {
             $body .= ''
                 . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';

             $first = TRUE;
             for ($j = 0; $j < $number_failed_columns; $j++) {
                 if ($first)
                     $first = FALSE;
                 else
                     $body .= '   <td></td>';

                 $body .= ''
                     . (!empty($failed_columns[$j][$i])
                     ? '   <td align="center">' . $failed_columns[$j][$i]['username'] . '</td>'
                     . '   <td align="center">' . $failed_columns[$j][$i]['reason'] . '</td>'
                     : '<td></td><td></td>'
                     );
             }

             $body .= '  </tr>';
         }


         $body .= ''
             . ' </table><br /><br />';
     }


     // if needed, display text indicating no users were found to delete
     //
     if (empty($ok_users))
         $body .= ''
             . '<table border="0" align="center" width="40%">'
             . '<tr><td>' 
             . _("No users were found to delete; please go back and correct your input")
             . '</td></tr>'
             . ' </table>';


     // main display of users that will be deleted
     //
     else {

        $body .= ''
            . ' <table border="0" align="center" width="40%">'
            . '  <tr>'
            . '   <th colspan="' . (($number_user_columns * 2) - 1)
            . '" bgcolor="' . $color[9] . '">'
            .      _("Accounts to be deleted:")
            . '   </th>'
            . '  </tr>'
            . '  <tr>';


        // print correct number of column headers
        //
        $first = TRUE;
        for ($i = 0; $i < $number_user_columns; $i++) {
            if ($first)
                $first = FALSE;
            else
                $body .= ''
                    . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';
   
            $body .= ''
                . '   <th bgcolor="' . $color[9] . '">'
                . ($support_aliases == 'yes'
                ?      _("Username/Alias")
                :      _("Username")
                )
                . '   </th>';
        }


        $body .= ''
            . '  </tr>';


        // print actual columns of data
        //
        $flip = true;
        for ($i = 0; $i < $column_size; $i++) {
            $body .= ''
                . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';
   
            $first = TRUE;
            for ($j = 0; $j < $number_user_columns; $j++) {
                if ($first)
                    $first = FALSE;
                else
                    $body .= '   <td></td>';
   
                $body .= ''
                    . (!empty($user_columns[$j][$i])
                    ? '   <td align="center">' . $user_columns[$j][$i] . '</td>'
                    : '<td></td><td></td>'
                    );
            }

            $body .= '  </tr>';
        }


        $action_ok = vadmin_mkform_action($LVL, $MOD, 'delmultipleusers');
//TODO -- can we add page info or search info to this previous link if needed?
        $action_cancel = vadmin_mkform_action($LVL, $MOD, 'listall');
        $body .= ''
            . ' </table><br /><br />'
            . '<table border="0" align="center" width="40%">'
            . '  <tr>'
            . '   <th colspan="2" bgcolor="' . $color[9] . '">'
            . '&nbsp;   </th>'
            . '  </tr>'
            . '  <tr>'
            . '  <td colspan="2">'
            . ($support_aliases == 'yes'
            ? _("<strong>WARNING:</strong> You are about to delete multiple users or aliases. If any are real users, their mailboxes will be deleted, including all stored messages, and any webmail preferences they have.")
            : _("<strong>WARNING:</strong> You are about to delete multiple users. Their mailboxes will be deleted, including all stored messages, and any webmail preferences they have.")
            )
            . '  </td>'
            . '  </tr>'
            . ' <tr>'
            . '  <th bgcolor="' . $color[9] . '">'
            . '   <form method="post" action="' . $action_cancel . '">'
            . '    <input type="hidden" name="userid" value="' . $userid . '" />'
            . '    <input type="submit" value="&lt;&lt; '._("No, cancel").'" />'
            . '   </form>'
            . '  </th>'
            . '  <th bgcolor="' . $color[9] . '">'
            . '   <form method="post" action="' . $action_ok . '">'
            . '    <input type="hidden" name="userid" value="' . $userid . '" />'
            . '    <input type="submit" value="'._("Yes, delete").' &gt;&gt;" />'
            . '   </form>'
            . '  </th>'
            . ' </tr>'
            . ' </table>';

     }

     $body .= ''
         . '<center><a href="'
//TODO -- can we add page info or search info to this previous link if needed?
         . vadmin_mkform_action($LVL, $MOD, 'listall') 
         . '&amp;userid=' . urlencode($userid)
         . '">&lt; ' . _("Previous") 
         . '</a></center>';

     $title = _("Confirm Deleting Multiple Accounts");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /*************************** deluser_yes *************************/
 case 'deluser_yes':
     $datadir = vadmin_get_per_domain_sm_setting('data_dir', $domain);
     $userid = vadmin_getvar('POST', 'userid');
// FIXME: shouldn't we be using $delim instead of @??
     $usertitle = "$userid@$domain";
     if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)){
         spew("$me: ai-ai-ai, they can't edit this user.");
         $msg = sprintf(_("You don't have permissions to edit user '%s'"), 
                          $userid);
         vadmin_user_error($msg);
     }
     if ((vadmin_IMAP_usernames_have_domain($domain) && $username == $usertitle)
          || (!vadmin_IMAP_usernames_have_domain($domain) && $username == $userid)) {
         spew("$me: oi-oi-oi, they can't delete the account they are logged in with.");
         $msg = _("You can't delete your own account"); 
         vadmin_user_error($msg);
     }
     spew("$me: Deleting $userid fo sho.");

     spew("$me: Removing all admin privileges for $usertitle.");
     delete_user_from_all_admin($usertitle);

     /**
      * Call vdeluser() provided by vmail.inc.
      */
     spew("$me: calling vadmin_delete_account_before hook");
     $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain);
     do_hook('vadmin_delete_account_before', $temp);
     spew("$me: calling vdeluser");
     $repl = vdeluser($VADMIN_DOMAIN, $secret, $userid);
     if ($repl[0]){
         spew("$me: error returned: " . $repl[1]);
         vadmin_system_error($repl[1]);
     }

     /**
      * Remove user preferences.
      */
     $fileary = array();
     if (vadmin_IMAP_usernames_have_domain($domain)) 
        $the_user = $usertitle;
     else    
        $the_user = $userid;
     global $force_username_lowercase;
     if ($force_username_lowercase)
        $the_user = strtolower($the_user);
     $prefsfile = getHashedFile($the_user, $datadir, "$the_user.pref");
     if (file_exists($prefsfile)){
         $hash_dir = dirname($prefsfile);
         if ($dh = opendir($hash_dir)){
             while (false !== ($ufile = readdir($dh))) {
                 if (strpos($ufile, $the_user . '.') === 0){
                     spew("$me: found '$ufile'. Attempting to delete.");
                     if (unlink("$hash_dir/$ufile")){
                         spew("$me: deleted '$hash_dir/$ufile'");
                         array_push($fileary, $ufile);
                     } else {
                         spew("$me: deletion of '$hash_dir/$ufile' failed");
                     }
                 }
             }
         }
     }
     if (file_exists($datadir . "$the_user.pref")){
         spew("$me: found '$the_user.pref'. Attempting to delete.");
         if (unlink("$datadir/$the_user.pref")){
             spew("$me: deleted '$datadir/$the_user.pref'");
             array_push($fileary, $the_user.pref);
         } else {
             spew("$me: deletion of '$datadir/$the_user.pref' failed");
         }
     }

     if ($userid == $catchall_alias){
         $usertitle = _("'catchall'");
     }

     $body = ''
         . '<table border="0" width="60%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">'
         .     sprintf(_("Account %s deleted"), $usertitle)
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td align="center">'
         .     sprintf(_("Account <strong>%s</strong> deleted successfully."), $the_user);

     $extra_delete_files_dirs = vadmin_get_displayable_fields('extra_delete_files_dirs', '');
     $files = '';
     foreach ($extra_delete_files_dirs as $filename)
        if (!empty($filename))
           $files .= str_replace('$1', $the_user, $filename) . '<br />';
     if (!empty($files)) {
         $body .= ''
             . '<p>'
             . _("The following files and/or directories have been deleted:")
             . '<br />' . $files . '</p>';
     }

     if (sizeof($fileary)){
         $files = join($fileary, '<br />');
         $body .= ''
             . '<p>'
             . _("The following preference files have also been deleted:") 
             . '<br />' . $files . '</p>';
     }
     $body .= ''
         . '  </td>'
         . ' </tr>'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">&nbsp;</th>'
         . ' </tr>'
         . '</table>';
     $title = _("Deletion Results");
     $previous_link = '<tr><td align="center"><a href="'
                    . vadmin_mkform_action($LVL, 'email', 'acctlist')
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

     /***************************** delmultipleusers *************************/
 case 'delmultipleusers':
     $datadir = vadmin_get_per_domain_sm_setting('data_dir', $domain);
     $delusers = vadmin_getvar('SESSION', 'VADMIN_MULTIPLE_USERDEL');
     vadmin_putvar('SESSION', 'VADMIN_MULTIPLE_USERDEL', '');
     if (!is_array($delusers))
         vadmin_system_error(_("User list was corrupted"));

     $support_aliases = vadmin_getvar('CONFIG', 'backend.support_aliases');


     // make sure all users are deletable
     //
     $ok_users = array();
     $bad_users = array();
     foreach ($delusers as $userid => $display_userid) {

         // skip empty entries unless it's actually the catchall
         //
         if (empty($userid) && !empty($catchall_alias))
             continue;

         // get user (below we need to make sure it actually exists)
         //
         $command = array('lookup', $domain, $userid, $secret);
         $tmp = vm_daemon_raw($command);

         // make sure we have edit permissions against this account
         //
//FIXME: shouldn't we be using $delim instead of @??
         $usertitle = "$userid@$domain";
         if (!vadmin_get_edit_perms($domain, $username, $desig, $usertitle)) {
             spew("$me: ai-ai-ai, they can't edit this user.");
             $bad_users[$display_userid] = _("You don't have permission to edit this user");
         } 

         // can't delete onesself
         //
         else if ((vadmin_IMAP_usernames_have_domain($domain) && $username == $usertitle) 
          || (!vadmin_IMAP_usernames_have_domain($domain) && $username == $userid)) {
             $bad_users[$display_userid] = _("You can't delete your own account");
         }

         // make sure user exists
         //
         else if ($tmp[0]) {
             spew("$me: no such user or alias '$userid'");
             if ($support_aliases == 'yes')
                 $bad_users[$display_userid] = _("No such user or alias exists");
             else
                 $bad_users[$display_userid] = _("No such user exists");
         }

         // user is delete-able
         //
         else {
             spew("$me: Deleting $userid fo sho.");

             spew("$me: Removing all admin privileges for $usertitle.");
             delete_user_from_all_admin($usertitle);

             /**
              * Call vdeluser() provided by vmail.inc.
              */
             spew("$me: calling vadmin_delete_account_before hook");
             $temp = array($VADMIN_DOMAIN, $secret, $desig, $userid, $domain);
             do_hook('vadmin_delete_account_before', $temp);
             spew("$me: calling vdeluser");
             $repl = vdeluser($VADMIN_DOMAIN, $secret, $userid);
             if ($repl[0]){
                 spew("$me: error returned: " . $repl[1]);
                 $bad_users[$display_userid] = $repl[1];
                 continue;
             }

             /**
              * Remove user preferences.
              */
             $fileary = array();
// FIXME: shouldn't we be using $delim instead of @??
             $usertitle = "$userid@$domain";
             if (vadmin_IMAP_usernames_have_domain($domain))
                $the_user = $usertitle;
             else
                $the_user = $userid;
             global $force_username_lowercase;
             if ($force_username_lowercase)
                $the_user = strtolower($the_user);
             $prefsfile = getHashedFile($the_user, $datadir, "$the_user.pref");
             if (file_exists($prefsfile)){
                 $hash_dir = dirname($prefsfile);
                 if ($dh = opendir($hash_dir)){
                     while (false !== ($ufile = readdir($dh))) {
                         if (strpos($ufile, $the_user . '.') === 0){ 
                             spew("$me: found '$ufile'. Attempting to delete.");
                             if (unlink("$hash_dir/$ufile")){
                                 spew("$me: deleted '$hash_dir/$ufile'");
                                 array_push($fileary, $ufile);
                             } else {
                                 spew("$me: deletion of '$hash_dir/$ufile' failed");
                             }   
                         }   
                     }   
                 }   
             }   
             if (file_exists($datadir . "$the_user.pref")){
                 spew("$me: found '$the_user.pref'. Attempting to delete.");
                 if (unlink("$datadir/$the_user.pref")){
                     spew("$me: deleted '$datadir/$the_user.pref'");
                     array_push($fileary, $the_user.pref);
                 } else {
                     spew("$me: deletion of '$datadir/$the_user.pref' failed");
                 }
             }

             // currently not doing anything here with $fileary for each 
             // deleted user, but we could I suppose...

             $ok_users[$userid] = $display_userid;

         }

     }


     // create columns of failed users for display
     //
     $number_failed_columns = vadmin_getvar('CONFIG', 'username.multiple_delete_error_columns');
     $failed_columns = array();
     $failed_column_size = ceil(sizeof($bad_users) / $number_failed_columns);
     $i = 0;
     $j = 0;
     foreach ($bad_users as $userid => $err) {
         if ($i == $failed_column_size) {
             $j++;
             $i = 0;
         }
         $failed_columns[$j][$i]['username'] = $userid;
         $failed_columns[$j][$i]['reason'] = $err;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_failed_columns = sizeof($failed_columns);


     // create columns of users for display
     //
     $number_user_columns = vadmin_getvar('CONFIG', 'username.multiple_delete_user_columns');
     $user_columns = array();
     $column_size = ceil(sizeof($ok_users) / $number_user_columns);
     $i = 0;
     $j = 0;
     foreach ($ok_users as $userid => $display_userid) {
         if ($i == $column_size) {
             $j++;
             $i = 0;
         }
         $user_columns[$j][$i] = $display_userid;
         $i++;
     }
     // if fewer users than configured number of columns...
     $number_user_columns = sizeof($user_columns);


     $body = '';


     // give list of failed users
     //
     if (!empty($bad_users)) {

         $body .= ''
             . ' <table border="0" align="center">'
             . '  <tr>'
             . '   <th colspan="' . (($number_failed_columns * 3) - 1)
             . '" bgcolor="' . $color[9] . '">'
             .      _("Accounts that have NOT been deleted:")
             . '   </th>'
             . '  </tr>'
             . '  <tr>';


         // print correct number of column headers
         //
         $first = TRUE;
         for ($i = 0; $i < $number_failed_columns; $i++) {
             if ($first)
                 $first = FALSE;
             else
                 $body .= ''
                     . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';

             $body .= ''
                 . '   <th bgcolor="' . $color[9] . '">'
                 . ($support_aliases == 'yes'
                 ?      _("Username/Alias")
                 :      _("Username")
                 )
                 . '   </th>'
                 . '   <th bgcolor="' . $color[9] . '">'
                 .      _("Reason")
                 . '   </th>';
         }


         $body .= ''
             . '  </tr>';


         // print actual columns of data
         //
         $flip = true;
         for ($i = 0; $i < $failed_column_size; $i++) {
             $body .= ''
                 . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';

             $first = TRUE;
             for ($j = 0; $j < $number_failed_columns; $j++) {
                 if ($first)
                     $first = FALSE;
                 else
                     $body .= '   <td></td>';

                 $body .= ''
                     . (!empty($failed_columns[$j][$i])
                     ? '   <td align="center">' . $failed_columns[$j][$i]['username'] . '</td>'
                     . '   <td align="center">' . $failed_columns[$j][$i]['reason'] . '</td>'
                     : '<td></td><td></td>'
                     );
             }

             $body .= '  </tr>';
         }


         $body .= ''
             . ' </table><br /><br />';
     }


     // if needed, display text indicating no users were found to delete
     //
     if (empty($ok_users))
         $body .= ''
             . '<table border="0" align="center" width="40%">'
             . '<tr><td>' 
             . _("No users were found to delete; please go back and correct your input")
             . '</td></tr>'
             . ' </table>';


     // main display of users that will be deleted
     //
     else {

        $body .= ''
            . ' <table border="0" align="center" width="40%">'
            . '  <tr>'
            . '   <th colspan="' . (($number_user_columns * 2) - 1)
            . '" bgcolor="' . $color[9] . '">'
            .      _("Accounts that have been deleted:")
            . '   </th>'
            . '  </tr>'
            . '  <tr>';


        // print correct number of column headers
        //
        $first = TRUE;
        for ($i = 0; $i < $number_user_columns; $i++) {
            if ($first)
                $first = FALSE;
            else
                $body .= ''
                    . '   <th bgcolor="' . $color[9] . '">&nbsp;&nbsp;&nbsp;&nbsp;</th>';
   
            $body .= ''
                . '   <th bgcolor="' . $color[9] . '">'
                . ($support_aliases == 'yes'
                ?      _("Username/Alias")
                :      _("Username")
                )
                . '   </th>';
        }


        $body .= ''
            . '  </tr>';


        // print actual columns of data
        //
        $flip = true;
        for ($i = 0; $i < $column_size; $i++) {
            $body .= ''
                . '  <tr' . ($flip = !$flip ? ' bgcolor="' . $color[0] . '"' : '') . '>';
   
            $first = TRUE;
            for ($j = 0; $j < $number_user_columns; $j++) {
                if ($first)
                    $first = FALSE;
                else
                    $body .= '   <td></td>';
   
                $body .= ''
                    . (!empty($user_columns[$j][$i])
                    ? '   <td align="center">' . $user_columns[$j][$i] . '</td>'
                    : '<td></td><td></td>'
                    );
            }

            $body .= '  </tr>';
        }

        $footnotes = '&nbsp;';
        $body .= ''
            . '  <tr>'
            . '   <th colspan="' . (($number_user_columns * 2) - 1) 
            . '" bgcolor="' . $color[9] . '">'
            . '&nbsp;'
            . '   </th>'
            . '  </tr>'
            . '  <tr>'
            . '  <td colspan="' . (($number_user_columns * 2) - 1) . '">'
            . $footnotes
            . '  </td>'
            . '  </tr>'
            . ' </table>';

     }

     $title = _("Deletion Results");
     $previous_link = '<tr><td align="center"><a href="'
                    . vadmin_mkform_action($LVL, 'email', 'acctlist')
                    . '">&lt; ' . _("Previous") . '</a></td></tr>';
     vadmin_make_page($title, null, $body, true, true, $previous_link);
     break;

   /******************************* default ***************************/
 default:
     vadmin_system_error(
         sprintf(_("Invalid request, handler for '%s' does not exist"), $ACT));
     break;
}

echo '</body></html>';

/**
 * For emacs weenies among us:
 * Local variables:
 * mode: php
 * End:
 */
