<?php
/**
 * domprefs.mod
 * ------------
 * This module allows setting domain preferences, such as login pictures, and
 * user permissions (autoresponder, password change, etc).
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: domprefs.mod,v 1.7 2003/06/16 04:20:28 graf25 Exp $
 * 
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/06/16 04:20:28 $
 */

$ACT = vadmin_getvar('VADMIN', 'ACT');
$LVL = vadmin_getvar('VADMIN', 'LVL');
$MOD = 'domprefs';
$me = "$MOD.mod/$ACT";
spew("$me: taking over");

$domain = vadmin_getvar('VADMIN',  'VADMIN_DOMAIN');
$color = vadmin_getvar('SQMAIL', 'color');
$username = vadmin_getvar('SQMAIL', 'username');
$desig = vadmin_get_user_designation($domain, $username);
$sizelimit = vadmin_smart_limit($domain, $desig, 'imgsize');
if ($sizelimit != false){
    $sizelimit = $sizelimit*1024;
} else {
    /**
     * Make it something silly
     */
    $sizelimit = 1000000000;
}
$good_types = array('image/gif', 'image/jpeg', 'image/png');


switch ($ACT){
    /****************************** title *****************************/
 case 'title':
     $title = vadmin_get_pref($domain, 'title');
     $action = vadmin_mkform_action($LVL, $MOD, 'settitle');
     $body = ''
         . '<form method="post" enctype="multipart/form-data" '
         . ' action="' . $action . '">'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <td align="center">';
     spew("$me: figure out if they have an image");
     $contents = vadmin_get_pic($domain);
     if ($contents == false){
         spew("$me: No uploaded image. Use the standard one.");
         $body .= ''
             . '<p><img src="../../images/sm_logo.png" border="1" '
             . ' alt="' . _("The default squirrelmail image") . '" /></p>';
     } else {
         spew("$me: Show custom image and a 'delete' option");
         $body .= ''
             . '<p><img src="vadmin_fetch_pic.php?DOM=' . $domain . '"'
             . ' border="1"'
             . ' alt="' . _("Your custom login image") . '" /><br />'
             . ' <input type="checkbox" name="rmcustom" value="1" />'
             .   _("Restore the default login image") . '</p>';
     }
     $body .= ''
         . '    <p>'
         . '     <input type="hidden" name="MAX_FILE_SIZE" '
         . '      value="' . $sizelimit . '" />'
         .       _("Upload custom image") . ': '
         . '     <input type="file" name="titleimage" />'
         . '    </p>'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <td align="center">'
         . '    <strong>' . _("Title") . ':</strong>'
         . '    <input name="title" size="40" value="' . $title . '" />'
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <td bgcolor="' . $color[9] . '" align="center">'
         . '    <input type="submit" '
         . '      value="' . _("Make these changes") . '&gt;&gt;" />'
         . '   </td>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Customize the login page look");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** settitle ***************************/
 case 'settitle':
     $title = vadmin_getvar('POST', 'title');
     $rmcustom = vadmin_getvar('POST', 'rmcustom');
     if (isset($rmcustom) && $rmcustom == '1'){
         vadmin_del_pic($domain);
     } else {
         $titleimage = vadmin_getvar('FILES', 'titleimage');
         if (isset($titleimage) && $titleimage{'error'} == 0){
             $type = strtolower($titleimage{'type'});
             if (!in_array($type, $good_types)){
                 $msg = _("Only GIF, PNG, and JPEG type images are permitted");
                 vadmin_user_error($msg);
             }
             $size = $titleimage{'size'};
             if ($size > $sizelimit){
                 $msg = sprintf(_("The image is over the limit of %d Kb"),
                                $sizelimit/1024);
                 vadmin_user_error($msg);
             }
             spew("$me: image passes. Load and store.");
             $imgfile = $titleimage{'tmp_name'};
             $fp = fopen($imgfile, 'r');
             $contents = fread($fp, filesize($imgfile));
             fclose($fp);
             unlink($imgfile);
             vadmin_put_pref($domain, 'mimetype', $type);
             vadmin_put_pic($domain, $contents);
         }
     }
     vadmin_put_pref($domain, 'title', $title);
     $body = ''
         . '<table border="0" width="60%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">'
         .     _("Login page preferences saved")
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td align="center">'
         . '   <img border="1" src="vadmin_fetch_pic.php?DOM=' . $domain . '"'
         . '    alt="' . _("Login page image") . '" />'
         . '  </td>'
         . ' </tr>'
         . ' <tr>'
         . '  <td align="center">'
         . '   <strong>' . _("Title") . ':</strong> ' . $title
         . '  </td>'
         . ' </tr>'
         . ' <tr>'
         . '  <td bgcolor="' . $color[9] . '">&nbsp;</td>'
         . ' </tr>'
         . '</table>';
     $title = _("Login page preferences");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /******************************** perms **************************/
 case 'perms':
     if (!vadmin_domain_passwd_issaved($domain)){
         spew("$me: this operation requires a stored password. Redirect.");
         vadmin_redirect($LVL, $MOD, 'needdompass', null);
     }
     $passchange = vadmin_get_pref($domain, 'password_change');
     if ($passchange != false){
         $passon = ' checked="yes"';
     } else {
         $passon = '';
     }
     $autores = vadmin_get_pref($domain, 'autoresponder');
     if ($autores != false){
         $autoreson = ' checked="yes"';
     } else {
         $autoreson = '';
     }
     $action = vadmin_mkform_action($LVL, $MOD, 'setperms');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <table border="0" align="center" width="50%">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("You may set the following permissions") . ':'
         . '   </th>'
         . '  </tr>'
         . '  <tr>'
         . '   <td>'
         . '    <input type="checkbox" name="passchange" value="1"'
         .       $passon . ' /> ' . _("Users may change their passwords")
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <td>'
         . '    <input type="checkbox" name="autores" value="1"'
         .       $autoreson . ' /> ' . _("Users may use autoresponder")
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <td bgcolor="' . $color[9] . '" align="center">'
         . '    <input type="submit"'
         . '     value="' . _("Set these permissions") . ' &gt;&gt;" />'
         . '   </td>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = sprintf(_("Set user permissions for %s"), $domain);
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** setperms *************************/
 case 'setperms':
     $passchange = vadmin_getvar('POST', 'passchange');
     $autores = vadmin_getvar('POST', 'autores');
     if (isset($passchange) && $passchange == '1'){
         $passchange = 1;
     } else {
         $passchange = false;
     }
     if (isset($autores) && $autores == '1'){
         $autores = 1;
     } else {
         $autores = false;
     }
     $body = ''
         . '<table border="0" align="center" width="50%">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">' . _("Action taken") . '</th>'
         . '  <th bgcolor="' . $color[9] . '">' . _("Result") . '</th>'
         . ' </tr>';

     if ($passchange != vadmin_get_pref($domain, 'password_change')){
         spew("$me: changing the preference for password change");
         vadmin_put_pref($domain, 'password_change', $passchange);
         if ($passchange){
             $result = _("Enabled");
         } else {
             $result = _("Disabled");
         }
     } else {
         $result = _("No change");
     }
     $body .= ''
         . '<tr>'
         . ' <td>' . _("Changing password change settings") . ':</td>'
         . ' <td>' . $result . '</td>'
         . '</tr>';
       
     if ($autores != vadmin_get_pref($domain, 'autoresponder')){
         spew("$me: changing the preference for autoresponder");
         vadmin_put_pref($domain, 'autoresponder', $autores);
         if ($autores){
             $result = _("Enabled");
         } else {
             $result = _("Disabled");
         }
     } else {
         $result = _("No change");
     }
     $body .= ''
         . '<tr>'
         . ' <td>' . _("Changing autoresponder settings") . ':</td>'
         . ' <td>' . $result . '</td>'
         . '</tr>';
     
     $body .= ''
         . '<tr>'
         . ' <td colspan="2" bgcolor="' . $color[9] . '">&nbsp;</td>'
         . '</tr>'
         . '</table>';
     $title = sprintf(_("Setting user preferences for %s"), $domain);
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** needdompass ************************/
 case 'needdompass':
     $action = vadmin_mkform_action($LVL, $MOD, 'setdompass');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <table border="0" align="center" width="60%">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">'
         .      _("This option requires domain password")
         . '   </th>'
         . '  <tr>'
         . '   <td>'
         .      _("To let users change passwords and set autoresponders, there will need to be a copy of the system password saved on the disk.")
         . '   </td>'
         . '  </tr>'
         . '  <tr>'
         . '   <td bgcolor="' . $color[9] . '" align="center">'
         . '    <input type="submit" '
         . '     value="' . _("Save domain password") . ' &gt;&gt;" />'
         . '   </td>'
         . '  </tr>'
         . ' </table>'
         . '</form>';
     $title = _("Domain password required");
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** setdompass ***********************/
 case 'setdompass':
     $crypto = vadmin_getvar('SESSION', 'VADMIN_SECRET');
     $secret   = vadmin_crypto($crypto, 'decrypt');
     vadmin_put_domain_passwd($domain, $secret);
     vadmin_redirect($LVL, $MOD, 'perms', null);
     break;

   /******************************* default ***************************/
 default:
     vadmin_system_error(
         sprintf(_("Invalid request, handler for '%s' does not exist"), $ACT));
     break;
}

/**
 * For emacs weenies among us:
 * Local variables:
 * mode: php
 * End:
 */
?>
