<?php
/**
 * setup.php
 * ---------
 * This is a standard SquirrelMail-1.2 API for plugins.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 * 
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/07/08 02:25:24 $
 *
 * $Id: setup.php,v 1.23 2003/07/08 02:25:24 graf25 Exp $
 */

function vadmin_prep(){
    require_once(SM_PATH . 'plugins/vadmin/config_parser.php');
    /**
     * Parse the main config file. Note, that if it's in a relative 
     * location, the path must be given as seen from the "plugins" dir.
     */
    $config_file = SM_PATH . 'plugins/vadmin/conf/vadmin.conf';
    $vadmin_config = vadmin_parse_config($config_file);
    $GLOBALS{'VADMIN_CONFIG'} = $vadmin_config;
    /**
     * Load main functions.
     */
    $include_dir = $vadmin_config{'paths'}{'includes'};
    require_once($include_dir . '/vadmin_functions.inc');
    /**
     * See what setting is storage.type set to and load the needed
     * file. This is the only place where error checking is implemented
     * since many different storage types are possible.
     */
    $storage_type = vadmin_getvar('CONFIG', 'storage.type');
    $storage_functions_file = sprintf('%s/%s_functions.inc', 
                                      $include_dir, $storage_type); 
    if (file_exists($storage_functions_file) 
        && is_readable($storage_functions_file)){
        require_once($storage_functions_file);
    } else {
        /**
         * Don't fail. Just return.
         */
        return;
    }
}

/**
 * Main intialization function. SquirrelMail calls it whenever
 * the plugin is initialized. Plugin hooks are defined within so
 * SM knows which place to put which function on.
 *
 * @return void
 */
function squirrelmail_plugin_init_vadmin(){
    global $squirrelmail_plugin_hooks;
    $squirrelmail_plugin_hooks["login_cookie"]["vadmin"] = "vadmin_reroute";
    $squirrelmail_plugin_hooks["login_top"]["vadmin"] = "vadmin_login_prefs";
    $squirrelmail_plugin_hooks["webmail_top"]["vadmin"] = "vadmin_setcookie";
    $squirrelmail_plugin_hooks["optpage_register_block"]["vadmin"] =
        "vadmin_useropts";
    $squirrelmail_plugin_hooks["left_main_after"]["vadmin"] = 
        "vadmin_autores_notify";
}

/**
 * This function hooks to the options page for the end-users and 
 * allows them to change their passwords.
 *
 * @return void
 */
function vadmin_useropts(){
    vadmin_prep();
    global $use_gettext;
    $domain = vadmin_getdomain();
    if ($domain){
        /**
         * Upgrade check. Will return if not useful
         */
        vadmin_upgrade_v1($domain);
        $locale_dir  = vadmin_getvar('CONFIG', 'paths.locale');
        if ($use_gettext == true){
            bindtextdomain('vadmin', $locale_dir);
            textdomain('vadmin');
        }
        global $optpage_blocks;
        $AUTHCODE = vadmin_auth();
        if ($AUTHCODE != 'NONER'){
            $optpage_blocks[] = 
                array(
                    'name' => _("Administrator Interface"),
                    'url'  => "../plugins/vadmin/vadmin_main.php?LVL=admin",
                    'desc' => _("Access the administrator interface to set up and configure users, mailboxes, and other domain settings."),
                    'js'   => false);
        }
        /**
         * The following two are only useful in certain cases.
         */
        $username = vadmin_getvar('SQMAIL', 'username');
        list($uname, $udomain) = vadmin_get_user_unamedomain($username);
        if (vadmin_domain_passwd_issaved($domain) && $domain == $udomain){
            $passchange = vadmin_get_pref($domain, 'password_change');
            $autores = vadmin_get_pref($domain, 'autoresponder');
            if ($passchange != false){
                $optpage_blocks[] = 
                    array(
                          'name' => _("Change Password"),
                          'url'  => "../plugins/vadmin/vadmin_main.php?LVL=user&amp;MOD=vchpass&amp;ACT=main",
                          'desc' => _("You may change the password that you use to log in and check your e-mail."),
                          'js'   => false);
            }
            if ($autores != false){
                $optpage_blocks[] = 
                    array(
                          'name' => _("Configure autoresponder"),
                          'url'  => "../plugins/vadmin/vadmin_main.php?LVL=user&amp;MOD=autores&amp;ACT=main",
                          'desc' => _("You may set up an automatic responder, for example to notify your correspondents that you are on vacation."),
                          'js'   => false);
            }
        }

        /**
         * Rebind back to squirrelmail
         */
        if ($use_gettext == true){
            bindtextdomain('squirrelmail', SM_PATH . 'locale/');
            textdomain('squirrelmail');
        }
    }
}

function vadmin_autores_notify(){
    vadmin_prep();
    /**
     * Load vmail.inc.
     */
    $vmail_inc = vadmin_getvar('CONFIG', 'paths.vmail');
    require_once($vmail_inc);
    global $use_gettext;
    $domain = vadmin_getdomain();
    if (!$domain){
        return;
    }
    vadmin_upgrade_v1($domain);
    if (vadmin_get_pref($domain, 'autoresponder') == false){
        return;
    }
    $username = vadmin_getvar('SQMAIL', 'username');
    list($uname, $udomain) = vadmin_get_user_unamedomain($username);

    if ($domain && $udomain == $domain){
        $secret = vadmin_get_domain_passwd($domain);
        list($code, $stat) = vautoresponsestatus($domain, $secret, $uname);
        if ($stat == 'enabled'){
            $locale_dir  = vadmin_getvar('CONFIG', 'paths.locale');
            if ($use_gettext == true){
                bindtextdomain('vadmin', $locale_dir);
                textdomain('vadmin');
            }
            echo '<br /><small><center>(<a '
                . ' href="../plugins/vadmin/vadmin_main.php?LVL=user&amp;'
                . 'MOD=autores&amp;ACT=main" target="right">' 
                . _("autoresponder&nbsp;on") . '</a>)</center></small>';
            if ($use_gettext == true){
                bindtextdomain('squirrelmail', SM_PATH . 'locale/');
                textdomain('squirrelmail');
            }
        }
    }
}

/**
 * This function sets the front page preferences per-domain. It will
 * check if the virtual domain has custom name and picture and will
 * substitute the default ones with them.
 *
 * @return void
 */
function vadmin_login_prefs(){
    vadmin_prep();
    $domain = vadmin_getvar('VADMIN', 'vadmin_user_domain');
    if (!isset($domain) || !$domain){
        $domain = vadmin_getvar('COOKIE', 'vadmin_user_domain');
    }
    if (!isset($domain) || !$domain){
        $domain = vadmin_gethost();
    }
    if (isset($domain) && $domain){
        vadmin_upgrade_v1($domain);
        global $org_name, $org_logo, $org_logo_width, $org_logo_height;
        $contents = vadmin_get_pic($domain);
        $title = vadmin_get_pref($domain, 'title');
        if ($title != false){
            $org_name = $title;
        }
        if ($contents != false){
            $org_logo_width = $org_logo_height = 0;
            $org_logo = '../plugins/vadmin/vadmin_fetch_pic.php?DOM=' 
                . urlencode($domain);
        }
    }
}

function vadmin_reroute(){
    vadmin_prep();
    /**
     * Check if we need to redirect
     */
    $rhost = vadmin_getvar('CONFIG', 'redirect.host');
    $rpath = vadmin_getvar('CONFIG', 'redirect.path');
    if (!isset($rhost) || ! $rhost){
        return;
    }
    $HTTP_HOST = vadmin_getvar('SERVER', 'HTTP_HOST');
    $HTTP_HOST = preg_replace('/:.*/s', '', $HTTP_HOST);
    $need_https = vadmin_getvar('CONFIG', 'redirect.https');
    $HTTPS = vadmin_getvar('SERVER', 'HTTPS');
    if ($HTTP_HOST == $rhost && 
        ($need_https == 'yes' && (isset($HTTPS) && $HTTPS))){
        /**
         * We are here!
         * Set the cookie if we have a ?domain
         */
        $domain = vadmin_getvar('GET', 'domain');
        if (isset($domain) && $domain){
            setcookie('vadmin_user_domain', $domain, time()+31536000, 
                      $rpath, $HTTP_HOST);
            /**
             * And stick into VADMIN, so it's immediately accessible.
             */
            vadmin_putvar('VADMIN', 'vadmin_user_domain', $domain);
        }
        return;
    }
    /**
     * Figure out domain
     */
    $domain = vadmin_gethost();
    if (!$domain){
        /**
         * Oh well.
         */
        return;
    }
    /**
     * Redirect.
     */
    $proto = 'http';
    if ($need_https == 'yes'){
        $proto = 'https';
    }
    $loc = sprintf('%s://%s%s%s?domain=%s', $proto, $rhost, $rpath, 
                   'src/login.php', urlencode($domain));
    header('Location: ' . $loc);
    exit;
}

function vadmin_setcookie(){
    vadmin_prep();
    $username = vadmin_getvar('SQMAIL', 'username');
    $path = vadmin_getvar('SQMAIL', 'base_uri');
    list($uname, $domain) = vadmin_get_user_unamedomain($username);
    if (isset($domain) && $domain){
        setcookie('vadmin_user_domain', $domain, time()+31536000, $path);
    }
}

?>
