<?php
/**
 * templates.mod
 * -------------
 * This module lets you define templates for new domains.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: templates.mod,v 1.2 2003/06/18 16:38:58 graf25 Exp $
 * 
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/06/18 16:38:58 $
 */

function vadmin_zval($val){
    if ($val == false){
        $val = '-';
    } elseif ($val == '-'){
        $val = false;
    }
    return $val;
}

$ACT = vadmin_getvar('VADMIN', 'ACT');
$LVL = vadmin_getvar('VADMIN', 'LVL');
$MOD = 'templates';
$me = "$MOD.mod/$ACT";
spew("$me: taking over");

$domain = vadmin_getvar('VADMIN',  'VADMIN_DOMAIN');
$color = vadmin_getvar('SQMAIL', 'color');
$username = vadmin_getvar('SQMAIL', 'username');
$designation = vadmin_get_user_designation($domain, $username);
if ($designation != 'ELVIS'){
    spew("$me: only elvis can be here");
    vadmin_security_breach();
}

switch ($ACT){
    /******************************* main *****************************/
 case 'main':
     $tmplname = vadmin_get_storparams();
     if (!isset($tmplname) || !$tmplname){
         $tmplname = '';
         $smalltitle = _("Domain Creation Templates");
     } else {
         $smalltitle = sprintf(_("Template '%s' processed"), $tmplname);
     }
     $body = ''
         . '<table border="0" width="50%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">' . $smalltitle . '</th>'
         . ' </tr>';
     $names = vadmin_get_template_list();
     $action = vadmin_mkform_action($LVL, $MOD, 'edit');
     if (count($names)){
         $body .= ''
             . '<tr><td align="center">'
             . '<form method="post" action="' . $action . '">'
             . '<select name="tmplname">';
         foreach ($names as $name){
             if ($name == $tmplname){
                 $body .= '<option selected="yes">';
             } else {
                 $body .= '<option>';
             }
             $body .= $name . '</option>';
         }
         $body .= ''
             . '</select>&nbsp;'
             . '<input type="submit" value="  ' . _("Edit") . '  " />'
             . '</form>'
             . '</td></tr>';
     } else {
         $body .= ''
             . '<tr><td><p>'
             . _("No domain templates are currently defined. Please click the button below to create one")
             .'</p></td></tr>';
     }
     $body .= ''
         . '<tr><th bgcolor="' . $color[9] . '">'
         . '<form method="post" action="' . $action . '">'
         . ' <input type="hidden" name="addnew" value="1" />'
         . ' <input type="submit" value="' . _("Create a New Template") .'"/>'
         . '</form>'
         . '</th></tr>'
         . '</table>';
     $title = _("Domain creation templates");
     vadmin_make_page($title, null, $body, true, true);
     break;


     /***************************** edit ******************************/
 case 'edit':
     $addnew = vadmin_getvar('POST', 'addnew');
     if (!isset($addnew) || $addnew != '1'){
         $tmplname = vadmin_getvar('POST', 'tmplname');
         $oldtmplname = $tmplname;
         $contents = vadmin_get_template($tmplname);
         $title = sprintf(_("Editing template '%s'"), $tmplname);
     } else {
         $oldtmplname = '__new__';
         $tmplname = '';
         $contents = array('mailboxes' => false, 'hardquota' => false, 
                           'size' => false, 'count' => false, 'imgsize' => 100,
                           'password_change' => 1, 'autoresponder' => 0);
         $title = _("Creating a new domain template");
     }
     $action = vadmin_mkform_action($LVL, $MOD, 'add');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . '<input type="hidden" name="oldtmplname" value="' 
         .    $oldtmplname . '" />'
         . '<table border="0" width="60%" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '" colspan="2">'
         .     _("Set template parameters")
         . '  </th>'
         . ' </tr>'
         . ' <tr>'
         . '  <td>' . _("Template name") . '</td>'
         . '  <td><input size="15" name="tmplname" value="'
         .       $tmplname . '" /></td>'
         . ' <tr>'
         . '  <td>' . _("Maximum allowed mailboxes") . '</td>'
         . '  <td><input size="5" name="mailboxes" value="' 
         .       vadmin_zval($contents['mailboxes']) .'"/></td>'
         . ' </tr><tr>'
         . '  <td>' . _("Maximum allowed hard quota per user (Mb)") . '</td>'
         . '  <td><input size="5" name="hardquota" value="' 
         .       vadmin_zval($contents['hardquota']) . '" /></td>'
         . ' </tr><tr>'
         . '  <td>' . _("Maximum allowed message size per user (Mb)") . '</td>'
         . '  <td><input size="5" name="size" value="' 
         .       vadmin_zval($contents['size']) . '" /></td>'
         . ' </tr><tr>'
         . '  <td>' . _("Maximum message count per user") . '</td>'
         . '  <td><input size="5" name="count" value="' 
         .       vadmin_zval($contents['count']) . '" /></td>'
         . ' </tr><tr>'
         . '  <td>' . _("Maximum front page image size (Kb)") . '</td>'
         . '  <td><input size="5" name="imgsize" value="' 
         .       vadmin_zval($contents['imgsize']) . '" /></td>'
         . ' </tr><tr>'
         . '  <td>' . _("Allow changing passwords by users") . '</td>'
         . '  <td><input type="checkbox" name="password_change"'
         . '       value="1"';
     if ($contents['password_change'] == 1){
         $body .= ' checked="yes"';
     }
     $body .= ''
         . '       /></td>'
         . ' </tr><tr>'
         . '  <td>' . _("Let users use the autoresponder (requires qmail-autoresponder)") . '</td>'
         . '  <td><input type="checkbox" name="autoresponder" value="1"';
     if ($contents['autoresponder'] == 1){
         $body .= ' checked="yes"';
     }
     $body .= ''
         . '       /></td>'
         . ' </tr><tr>'
         . '  <th colspan="2" bgcolor="' . $color[9] . '">'
         . '   <input type="submit" value="' . _("Save template")
         .      ' &gt;&gt;" />'
         . '  </th></form>';
     if ($oldtmplname != '__new__'){
         $action = vadmin_mkform_action($LVL, $MOD, 'delete');
         $body .= ''
             . ' </tr><form method="post" action="' . $action . '">'
             . ' <input type="hidden" name="tmplname" value="'.$tmplname.'" />'
             . ' <tr>'
             . '  <th colspan="2" bgcolor="' . $color[9] . '">'
             . '   <input type="submit" value="' . _("Delete template") . '"/>'
             . '  </th>';
     }
     $body .= ''
         . ' </tr><tr>'
         . '  <td colspan="2">'
         . '   <p>'
         . _("Domain templates let you specify a set of default parameters that can be applied to the domains you enable. These parameters include limits, restrictions, and some preferences as well")
         . '   </p>'
         . '  </td>'
         . ' </tr>'
         . '</table></form>';
     vadmin_make_page($title, null, $body, true, true);
     break;

     /****************************** add *****************************/
 case 'add':
     $tmplname = vadmin_getvar('POST', 'tmplname');
     if (!isset($tmplname) || $tmplname == ''){
         $msg = _("Please provide a template name");
         vadmin_user_error($msg);
     }
     $oldtmplname = vadmin_getvar('POST', 'oldtmplname');
     $mailboxes = vadmin_getvar('POST', 'mailboxes');
     $hardquota = vadmin_getvar('POST', 'hardquota');
     $size = vadmin_getvar('POST', 'size');
     $count = vadmin_getvar('POST', 'count');
     $imgsize = vadmin_getvar('POST', 'imgsize');
     $password_change = vadmin_getvar('POST', 'password_change');
     if (!isset($password_change) || $password_change != '1'){
         $password_change = 0;
     } else {
         $password_change = 1;
     }
     $autoresponder = vadmin_getvar('POST', 'autoresponder');
     if (!isset($autoresponder) || $autoresponder != '1'){
         $autoresponder = 0;
     } else {
         $autoresponder = 1;
     }

     $contents = array(
                       'mailboxes' => vadmin_zval($mailboxes),
                       'hardquota' => vadmin_zval($hardquota),
                       'size' => vadmin_zval($size),
                       'count' => vadmin_zval($count),
                       'imgsize' => vadmin_zval($imgsize),
                       'password_change' => $password_change,
                       'autoresponder' => $autoresponder);
     if ($oldtmplname != '__new__' && $oldtmplname != $tmplname){
         spew("$me: deleting old template '$tmplname'");
         vadmin_delete_template($oldtmplname);
     }
     vadmin_put_template($tmplname, $contents);
     /**
      * I'm lazy. Just redirect them back to main
      */
     vadmin_redirect($LVL, $MOD, 'main', $tmplname);
     break;
     
     /***************************** delete *****************************/
 case 'delete':
     $tmplname = vadmin_getvar('POST', 'tmplname');
     vadmin_delete_template($tmplname);
     spew("$me: deleted template '$tmplname'");
     vadmin_redirect($LVL, $MOD, 'main', $tmplname);
     break;

   /******************************* default ***************************/
 default:
     vadmin_system_error(
         sprintf(_("Invalid request, handler for '%s' does not exist"), $ACT));
     break;
}

/**
 * For emacs weenies among us:
 * Local variables:
 * mode: php
 * End:
 */
?>
