<?php
/**
 * limits.mod
 * ----------
 * This module operates the limits set per domain.
 *
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: limits.mod,v 1.6 2003/06/16 04:18:24 graf25 Exp $
 * 
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/06/16 04:18:24 $
 */

function vadmin_zval($val){
    if ($val == false){
        $val = '-';
    } elseif ($val == '-'){
        $val = false;
    }
    return $val;
}

$ACT = vadmin_getvar('VADMIN', 'ACT');
$LVL = vadmin_getvar('VADMIN', 'LVL');
$MOD = 'limits';
$me = "$MOD.mod/$ACT";
spew("$me: taking over");

$domain = vadmin_getvar('VADMIN',  'VADMIN_DOMAIN');
$color = vadmin_getvar('SQMAIL', 'color');
$username = vadmin_getvar('SQMAIL', 'username');
$designation = vadmin_get_user_designation($domain, $username);
if ($designation == 'ELVIS'){
    $level = 'CROSS';
} else {
    $level = 'LOWLY';
}

$fields = array(
    'mailboxes' => _("Maximum number of mailboxes"),
    'hardquota' => _("Maximum user hard quota limit (Mb)"),
    'size'      => _("Maximum user message size limit (Mb)"),
    'count'     => _("Maximum user message count limit"),
    'imgsize'   => _("Maxium login page image size (Kb)")
    );


switch ($ACT){
    /******************************* main *****************************/
 case 'main':
     $action = vadmin_mkform_action($LVL, $MOD, 'setlimits');
     $body = ''
         . '<form method="post" action="' . $action . '">'
         . ' <table border="0" align="center">'
         . '  <tr>'
         . '   <th bgcolor="' . $color[9] . '">' 
         .      _("Field Description") 
         . '   </th>'
         . '   <th bgcolor="' . $color[9] . '">' . _("Current value") . '</th>'
         . '  </tr>';
     foreach ($fields as $field=>$descr){
         $val = vadmin_zval(vadmin_smart_limit($domain, $level, $field));
         $body .= ''
             . '<tr>'
             . ' <td align="right">' . $descr . ':</th>'
             . ' <td>'
             . '  <input name="' . $field . '" size="5" value="' . $val .'" />'
             . ' </td>'
             . '</tr>';
     }
     $body .= ''
         . '<tr>'
         . ' <th colspan="2" bgcolor="' . $color[9] . '">'
         . '  <input type="submit" value="' 
         .     _("Set these limits") . ' &gt;&gt;" />'
         . ' </th>'
         . '</tr></table></form>';
     $title = sprintf(_("Set domain limits for %s"), $domain);
     vadmin_make_page($title, null, $body, true, true);
     break;

     /***************************** setlimits ****************************/
 case 'setlimits':
     $body = ''
         . '<table border="0" align="center">'
         . ' <tr>'
         . '  <th bgcolor="' . $color[9] . '">' 
         .     _("Field Description") 
         . '  </th>'
         . '  <th bgcolor="' . $color[9] . '">' . _("Result") . '</th>'
         . ' </tr>';
     foreach ($fields as $field=>$descr){
         $val = vadmin_zval(trim(vadmin_getvar('POST', $field)));
         $result = '';
         if (strval(intval($val)) != $val){
             spew("$me: $val is not an int. Ignoring.");
             $result = sprintf(_("%s is not an integer. Ignored", $val));
         } else {
             spew("$me: new setting for '$field': $val");
             if ($val != false && $level == 'LOWLY'){
                 spew("$me: This is a CROSS. Checking against master.");
                 $master = vadmin_get_limit($domain, 'CROSS', $field);
                 if ($val > $master){
                     spew("$me: Tried to override the limit from above.");
                     $result = sprintf(_("%d is over the master limit of %d. Maximum setting of %d used"), $val, $master, $master);
                     $val = $master;
                 }
             }
             $oldval = vadmin_get_limit($domain, $level, $field);
             if ($val != $oldval){
                 vadmin_put_limit($domain, $level, $field, $val);
                 if ($result == ''){
                     if ($val == false){
                         $result = _("OK, set to unlimited");
                     } else {
                         $result = sprintf(_("OK, set to %d"), $val);
                     }
                 }
             } else {
                 if ($result == ''){
                     $result = _("No change");
                 }
             }
         }
         $body .= ''
             . '<tr>'
             . ' <td>' . $descr . ':</th>'
             . ' <td>' . $result . '</td>'
             . '</tr>';
     }
     $body .= ''
         . '<tr>'
         . ' <th colspan="2" bgcolor="' . $color[9] . '">&nbsp;</th>'
         . '</tr></table>';
     $title = sprintf(_("Recording domain limits for %s"), $domain);
     vadmin_make_page($title, null, $body, true, true);
     break;
     
   /******************************* default ***************************/
 default:
     vadmin_system_error(
         sprintf(_("Invalid request, handler for '%s' does not exist"), $ACT));
     break;
}

/**
 * For emacs weenies among us:
 * Local variables:
 * mode: php
 * End:
 */
?>
