<?php
/**
 * vadmin_functions.inc
 * ---------------------
 * All Vadmin-wide functions are in this file.
 * 
 * Licensed under GNU GPL v2. Please see COPYING for full terms.
 *
 * $Id: vadmin_functions.inc,v 1.54 2003/07/09 22:05:37 graf25 Exp $
 *
 * @author Konstantin Riabitsev ($Author: graf25 $)
 * @version $Date: 2003/07/09 22:05:37 $
 * 
 */

/**
 * This is a debugging function.
 *
 * @param  $message  The message to put into the debug log.
 * @return           void
 */
function spew($message){
    static $debug_level, $debug_file;
    if (!isset($debug_level)){
        $debug_level = vadmin_getvar('CONFIG', 'debug.level');
        $debug_file  = vadmin_getvar('CONFIG', 'debug.output');
        $username    = vadmin_getvar('SQMAIL', 'username');
        $debug_file .= '.' . $username;
    }
    if ($debug_level > 0){
        $nowdate = date('H:i:s');
        error_log("$nowdate> $message\n", 3, $debug_file);
    }
}

/**
 * This function retrieves various php-provided variables in a sane
 * and safe way, offering a path of migration from php 4.0.x to 4.1 and
 * beyond, as well as allowing us to work with register_globals=off.
 *
 * @param  $vartype  The type of the variable to retireve.
 * @param  $varname  The name of the variable to retrieve.
 * @return           The value of the variable.
 */
function vadmin_getvar($vartype, $varname){
    $varvalue = false;
    switch ($vartype){
    case 'SERVER':
        if (isset($_SERVER{$varname})){
            $varvalue = $_SERVER{$varname};
        }
        break;
    case 'COOKIE':
        if (isset($_COOKIE{$varname})){
            $varvalue = $_COOKIE{$varname};
            $varvalue = htmlspecialchars($varvalue);
        }
        break;
    case 'ENV':
        if (isset($_ENV{$varname})){
            $varvalue = $_ENV{$varname};
        }
        break;
    case 'POST':
        if (isset($_POST{$varname})){
            $varvalue = $_POST{$varname};
            $varvalue = htmlspecialchars($varvalue);
        }
        break;
    case 'GET':
        if (isset($_GET{$varname})){
            $varvalue = $_GET{$varname};
            $varvalue = htmlspecialchars($varvalue);
        }
        break;
    case 'FILES':
        if (isset($_FILES{$varname})){
            $varvalue = $_FILES{$varname};
        }
        break;
    case 'SESSION':
        if (isset($_SESSION{'VADMIN_SESSION_VARS'}) 
            && isset($_SERVER{'HTTP_HOST'})){
            $VADMIN_SESSION_VARS = $_SESSION{'VADMIN_SESSION_VARS'};
            $domain = $_SERVER{'HTTP_HOST'};
            if (isset($VADMIN_SESSION_VARS{$domain}{$varname})){
                $varvalue = $VADMIN_SESSION_VARS{$domain}{$varname};
            }
        }
        break;
    case 'SQMAIL':
        if (isset($GLOBALS{$varname})){
            $varvalue = $GLOBALS{$varname};
        }
        break;
    case 'CONFIG':
        list($parent, $child) = explode(".", $varname);
        if (isset($child)){
            if (isset($GLOBALS{'VADMIN_CONFIG'}{$parent}{$child})){
                $varvalue = $GLOBALS{'VADMIN_CONFIG'}{$parent}{$child};
            }
        } else {
            if (isset($GLOBALS{'VADMIN_CONFIG'}{$parent})){
                $varvalue = $GLOBALS{'VADMIN_CONFIG'}{$parent};
            }
        }
        break;
    case 'VADMIN':
        if (isset($GLOBALS{'VADMIN_VARS'}{$varname})){
            $varvalue = $GLOBALS{'VADMIN_VARS'}{$varname};
        }
        break;
    }
    return $varvalue;
}

/**
 * This function sets certain variables that should be handled safely.
 *
 * @param  $vartype  The type of the variable to set.
 * @param  $varname  The name of the variable.
 * @param  $varvalue The value of the variable.
 * @return           void
 */
function vadmin_putvar($vartype, $varname, $varvalue){
    $me = 'vadmin_putvar';
    spew("$me: Received putvar request of type '$vartype'");
    spew("$me: varname: '$varname', varvalue: '$varvalue'");
    switch($vartype){
    case 'SESSION':
        $domain = $_SERVER{'HTTP_HOST'};
        if (isset($_SESSION{'VADMIN_SESSION_VARS'})){
            $VADMIN_SESSION_VARS = $_SESSION{'VADMIN_SESSION_VARS'};
        }
        $VADMIN_SESSION_VARS{$domain}{$varname} = $varvalue;
        $_SESSION{'VADMIN_SESSION_VARS'} = $VADMIN_SESSION_VARS;
        break;
    case 'SQMAIL':
        $GLOBALS{$varname} = $varvalue;
        break;
    case 'VADMIN':
        $GLOBALS{'VADMIN_VARS'}{$varname} = $varvalue;
        break;
    }
}

/**
 * This utility function notifies the user that they have attempted
 * an action that was deemed as violating security by the system.
 * It used to carry an "INTRUDER ALERT ON DECK 5", but I changed it
 * to be more non-geek friendly. ;)
 * 
 * @return Never returns.
 */
function vadmin_security_breach(){
    $me = 'vadmin_security_breach';
    spew("$me: I was invoked!");
    echo _("You have attempted an action that was flagged by the system as violating the security measures in place. Your access has been denied. If you believe it was an error on our part, please try your action again, or e-mail your system administrator.");
    exit;
}

/**
 * This function displays an error message if the error was due to 
 * system malfunction and not user input.
 *
 * @param $message A text message to display to the user.
 * @return         Never returns.
 */
function vadmin_system_error($message){
    $me = 'vadmin_system_error';
    spew("$me: Invoked with message '$message'");
    spew("$me: checking if we're in vadmin_main");
    $SCRIPT_NAME = vadmin_getvar('SERVER', 'SCRIPT_NAME');
    if (!strstr($SCRIPT_NAME, 'vadmin')){
        spew("$me: no, just printing the error message and exiting.");
        echo sprintf(_("VADMIN SYSTEM ERROR: %s"), $message);
        return;
    }
    $warning = sprintf(_("<strong>SYSTEM ERROR: %s</strong>. We apologize for the inconvenience, but your request cannot be completed at this time. Please contact your system administrator if the problem persists."), $message);
    $body = sprintf('<hr/><p>%s</p><hr/>', $warning);
    vadmin_make_page(_("SYSTEM ERROR"), null, $body, false, false);
    exit;
}

/**
 * This function displays an error message if the error was due to the
 * user input.
 *
 * @param $message A text message to display to the user.
 * @return         Never returns.
 */
function vadmin_user_error($message){
    $me = 'vadmin_user_error';
    spew("$me: Invoked with message '$message'");
    spew("$me: checking if we're in vadmin_main");
    $SCRIPT_NAME = vadmin_getvar('SERVER', 'SCRIPT_NAME');
    if (!strstr($SCRIPT_NAME, 'vadmin')){
        spew("$me: no, just printing the error message and exiting.");
        echo sprintf(_("VADMIN SYSTEM ERROR: %s"), $message);
        return;
    }
    $warning = sprintf(_("<strong>Error: %s</strong>. Please return to the previous page and try to correct your input. If you need assistance or believe this is a software error, please contact your system administrator."), $message);
    $body = sprintf('<p>%s</p>', $warning);
    vadmin_make_page(_("Input Error"), null, $body, false, false);
    exit;
}

/**
 * This function is the authentication core of vadmin. Read the
 * docs/SECURITY for the in-depth explanation on how the security
 * is handled in vadmin.
 *
 * @return $VADMIN_AUTHCODE, which is a string with the 
 *         authentication information.
 */
function vadmin_auth(){
    $me = 'vadmin_auth';
    $username = vadmin_getvar('SQMAIL',  'username');
    $authcode = vadmin_getvar('SESSION', 'VADMIN_AUTHCODE');
    $domain   = vadmin_getdomain();
    
    /**
     * If VADMIN_AUTHCODE is set, then they have already authenticated.
     */
    if ($authcode != false){
        spew("$me: AUTHCODE is already in session with '$authcode'");
        return ($authcode);
    }
    if ($domain == false){
        spew("$me: doesn't look like this domain is configured with vadmin");
        spew("$me: setting AUTHCODE to 'NONER' and returning");
        vadmin_putvar('SESSION', 'VADMIN_AUTHCODE', 'NONER');
        return 'NONER';
    }
    $authcode = vadmin_get_user_designation($domain, $username);
    vadmin_putvar('SESSION', 'VADMIN_AUTHCODE', $authcode);
    return $authcode;
}

/**
 * Looks at the user's login name, which should be either user@domain.com
 * or user:domain.com, and separates the userid from the domain name,
 * returning them in an array.
 *
 * @param $unamedomain A string in the format username{sep}domainname
 * @return             an array with the username and the domainname, 
 *                     or array with two empty fields if unsuccessful.
 */
function vadmin_get_user_unamedomain($unamedomain){
    $me = 'vadmin_get_user_unamedomain';
    spew("$me: analyzing '$unamedomain'");
    $delimiters = vadmin_getvar('CONFIG', 'vmailmgr.delimiters');
    for($ct = 0; $ct < strlen($delimiters); $ct++){
        $separator = substr($delimiters, $ct, 1);
        list($uname, $domain) = explode($separator, $unamedomain);
        if (isset($domain) && strlen($domain)){
            spew("$me: domain '$domain' found with separator '$separator'");
            break;
        }
    }
    if (isset($domain) && strlen($domain)){
        spew("$me: username: $uname, domain: $domain");
        $ret_ary = array(strtolower($uname), strtolower($domain));
    } else {
        spew("$me: Couldn't grok what the hell '$unamedomain' is!");
        $ret_ary = array("", "");
    }
    return $ret_ary;
}

/**
 * Tries to validate the supplied domain/password pair by
 * connecting to the vmailmgr daemon and getting a
 * listing for the domain in question.
 *
 * @param $domain vadmin domain.
 * @param $passwd the password for this domain.
 * @return        true if successful, or false if not.
 */
function vadmin_domain_passwd_validate($domain, $passwd){
    $me = 'vadmin_domain_passwd_validate';
    spew("$me: Trying to validate password for domain '$domain'");
    $reply = vm_daemon_raw(array('listdomain', $domain, $passwd));
    if (is_array($reply)){
        /** 
         * did not validate. Return the error message.
         */
        spew("$me: password did not validate!");
        spew("$me: Error: " . $reply[1]);
        return false;
    } else {
        /**
         * validation successful. Return false.
         */
        spew("$me: password validated successfully");
        return true;
    }
}

/**
 * This is a GUI wrap-around for every generated page, since I'm too
 * lazy to write one for each generated page, nor should I. ;)
 * $scriptsrc is not currently used in vadmin, but I preserved it
 * from SquirrelSpell in case I will add this functionality later.
 *
 * @param $title         the title of the page.
 * @param $scriptsrc     the name of a javascript file to load before loading
 *                       the page itself.
 * @param $body          the contents of the page.
 * @param $returntomain  show "return to main menu" link? true/false
 * @param $logoutlink    show logout link? true/false
 * @return               void.
 */
function vadmin_make_page($title, $scriptsrc, $body, $returntomain, 
                          $logoutlink){
    global $VADMIN_VERSION;
    $me = 'vadmin_make_page';
    spew("$me: building a page '$title'");
    $color    = vadmin_getvar('SQMAIL', 'color');
    $PHP_SELF = vadmin_getvar('SERVER', 'PHP_SELF');
    $LVL      = vadmin_getvar('GET', 'LVL');
    /**
     * Call squirrelmail's "displayPageHeader" function"
     */
    displayPageHeader($color, "None");
    if(isset($scriptsrc) && $scriptsrc){
        $scriptsrc = sprintf('<script type="text/javascript" src="js/%s"></script>', $scriptsrc);
    } else {
        $scriptsrc = '';
    }
    spew("$me: scriptsrc=$scriptsrc");
    /**
     * This checks whether we should include a "return to main menu"
     * link at the bottom for convenience.
     */
    if ($returntomain == true){
        spew("$me: Providing a 'return to main' link");
        $link = vadmin_mkform_action('admin', 'menu', 'main');
        $str = ''
            . ' <tr>'
            . '  <td align="center">'
            . '   <a href="%s">&lt;&lt; %s</a>'
            . '  </td>'
            . '</tr>';
        $returntomain = sprintf($str, $link, 
                                _("Back to &quot;Main Menu&quot;"));
    } else {
        $returntomain = '';
    }
    spew("$me: returntomain=$returntomain");
    /** 
     * Provide them with a logout link if requested.
     */
    if ($logoutlink == true){ 
        spew("$me: Providing a 'logout' link");
        $link = vadmin_mkform_action('admin', 'logout', 'main');
        $str = '(<strong><a href="%s">%s</a></strong>)';
        $logoutlink = sprintf($str, $link, _("Logout"));
    } else {
        $logoutlink = '';
    }

    $versionline = sprintf(_("Vadmin Plugin version %s"), $VADMIN_VERSION);
    $str = '&nbsp;<br/>'
        . '%s'
        . '<table width="95%%" align="center" border="0" cellpadding="2" '
        . 'cellspacing="0">'
        . ' <tr>'
        . '  <td bgcolor="%s" align="center">'
        . '   <strong>%s</strong>'
        . '  </td>'
        . ' </tr>'
        . ' <tr><td><hr/></td></tr>'
        . ' <tr>'
        . '  <td>'
        . '   %s'
        . '  </td>'
        . ' </tr>'
        . ' %s'
        . ' <tr><td><hr/></td></tr>'
        . ' <tr>'
        . '  <td bgcolor="%s" align="center">'
        . '    %s %s'
        . '  </td>'
        . ' </tr>'
        . '</table>';
    print sprintf($str, $scriptsrc, $color[9], $title, $body, 
                  $returntomain, $color[9], $versionline, $logoutlink);
}

/**
 * This function stolen nearly verbatim from hastymail. 
 * http://hastymail.sf.net/
 */
function vadmin_rc4_crypt($input, $key) {
    $me = 'vadmin_rc4_crypt';
    spew("$me: encrypting using the builtin rc4");
    $k_tmp = preg_split('//', $key, -1, PREG_SPLIT_NO_EMPTY);
    foreach($k_tmp as $char) {
        $k[] = ord($char);
    }
    unset($k_tmp); 
    $message = preg_split('//', $input, -1, PREG_SPLIT_NO_EMPTY);
    $rep = count($k);
    for ($n=0;$n<$rep;$n++) {
        $s[] = $n;
    }
    $i = 0;
    $f = 0;
    for ($i = 0;$i<$rep;$i++) {
        $f = (($f + $s[$i] + $k[$i]) % $rep);
        $tmp = $s[$i];
        $s[$i] = $s[$f];
        $s[$f] = $tmp;
    }
    $i = 0;
    $f = 0;
    foreach($message as $letter) {
        $i = (($i + 1) % $rep);
        $f = (($f + $s[$i]) % $rep);
        $tmp = $s[$i];
        $s[$i] = $s[$f];
        $s[$f] = $tmp;
        $t = $s[$i] + $s[$f];
        $done = ($t^(ord($letter)));
        $i++;
        $f++;
        $enc_array[] = chr($done);
    }
    $coded = implode('', $enc_array);
    return $coded;
}


/**
 * This function does the encryption and decryption of sensitive
 * data stored on the HDD. It uses the CRYPTO_HASH_LINE as key.
 * See docs for more info and/or explanation of the security
 * structure of VADMIN.
 *
 * @param $input the contents to encrypt/decrypt.
 * @param $mode  a string that can be either "decrypt" or "encrypt"
 *               depending on which action needs to be performed.
 * @return       the results of encryption/decryption.
 */
function vadmin_crypto($input, $mode){
    $me = 'vadmin_crypto';
    $CRYPTO_HASH_LINE   = vadmin_getvar('SERVER', 'CRYPTO_HASH_LINE');
    $MCRYPT_ALGO        = vadmin_getvar('SERVER', 'MCRYPT_ALGO');
    /**
     * See if we have everything needed for
     * encryption/decryption. This includes checking for the
     * encryption functions, the algorithm, and the hash line.
     */
    if (!$CRYPTO_HASH_LINE || !$MCRYPT_ALGO){
        $message = '';
        if (!$CRYPTO_HASH_LINE){
            $message .= _("Could not find CRYPTO_HASH_LINE! ");
        }
        if (!$MCRYPT_ALGO){
            $message .= _("Could not find MCRYPT_ALGO! ");
        }
        spew("$me: Can't use crypt functions for the following reasons:");
        spew("$me: $message");
        vadmin_system_error(sprintf(_("Vamin is misconfigured: %s"),$message));
    }
    $key = $CRYPTO_HASH_LINE;
    if ($MCRYPT_ALGO == 'rc4_builtin'){
        spew("$me: using builtin rc4 encryption/decryption");
        spew("$me: thank you jason. :)");
        switch($mode){
        case 'encrypt':
            $endresult = base64_encode(vadmin_rc4_crypt($input, $key));
            spew("$me: encrypted successfully");
            break;
        case 'decrypt':
            $endresult = vadmin_rc4_crypt(base64_decode($input), $key);
            spew("$me: decrypted successfully");
            break;
        }
    } else {
        if (!function_exists('mcrypt_generic')){
            $message = _("An algorithm other than 'rc4_builtin' specified, but mcrypt support not found.");
            spew("$me: MCRYPT_ALGO is: $MCRYPT_ALGO");
            spew("$me: mcrypt functions are not found!");
            vadmin_system_error(sprintf(_("Vadmin is misconfigured: %s"), 
                                        $message));
        }
        $td = mcrypt_module_open($MCRYPT_ALGO, '', MCRYPT_MODE_ECB, '');
        $iv = mcrypt_create_iv(mcrypt_enc_get_iv_size ($td), MCRYPT_RAND);
        @mcrypt_generic_init($td, $key, $iv);
        switch ($mode){
        case 'encrypt':
            $endresult = base64_encode(mcrypt_generic($td, $input));
            spew("$me: encrypted successfully");
            break;
        case 'decrypt':
            $endresult = mdecrypt_generic($td, base64_decode($input));
            /**
             * There will be trailing nul's on the end. Remove
             * these. They suck.
             */
            $endresult = rtrim($endresult);
            spew("$me: decrypted successfully");
            break;
        }
        mcrypt_generic_deinit($td);
    }
    return $endresult;
}

function vadmin_mkform_action($tolvl, $tomod, $toact){
    $me = 'vadmin_mkform_action';
    spew("$me: LVL='$tolvl', MOD='$tomod', ACT='$toact'");
    $PHP_SELF = vadmin_getvar('SERVER', 'PHP_SELF');
    $action = sprintf('%s?LVL=%s&amp;MOD=%s&amp;ACT=%s',
                      $PHP_SELF, $tolvl, $tomod, $toact);
    spew("$me: $action");
    return $action;
}

function vadmin_redirect($lvl, $mod, $act, $stor_params){
    $me = 'vadmin_redirect';
    spew("$me: storing the params in session");
    vadmin_putvar('SESSION', 'VADMIN_REDIRECT_STOR', $stor_params);
    spew("$me: redirecting to LVL: $lvl, MOD: $mod, ACT: $act");
    $self = vadmin_getvar('SERVER', 'PHP_SELF');
    $loc = sprintf('%s?LVL=%s&MOD=%s&ACT=%s', $self, $lvl, $mod, $act);
    header(sprintf('Location: %s', $loc));
    spew("$me: Exiting, done processing.");
    exit;
}

function vadmin_get_storparams(){
    $me = 'vadmin_get_storparams';
    spew("$me: grabbing the storred redirect params from the session");
    $stor_params = vadmin_getvar('SESSION', 'VADMIN_REDIRECT_STOR');
    vadmin_putvar('SESSION', 'VADMIN_REDIRECT_STOR', '');
    return $stor_params;
}

function vadmin_getdomain(){
    $me = 'vadmin_getdomain';
    $username = vadmin_getvar('SQMAIL', 'username');
    if (!isset($username) || !$username){
        spew("$me: no username, returning false");
        return false;
    }
    list($uname, $domain) = vadmin_get_user_unamedomain($username);
    spew("$me: returning $domain");
    return $domain;
}

function vadmin_gethost(){
    $me = 'vadmin_gethostdomain';
    $HTTP_HOST = vadmin_getvar('SERVER', 'HTTP_HOST');
    $domain = preg_replace('/:.*/s', '', $HTTP_HOST);
    spew("$me: preliminary domain is '$domain'");
    if (vadmin_domain_exists($domain)){
        spew("$me: found it on the first try");
    } else {
        spew("$me: dropping levels until found or second level reached");
        $dom_ary = explode('.', $domain);
        do {
            array_shift($dom_ary);
            $domain = join('.', $dom_ary);
            spew("$me: trying '$domain'");
        } while (sizeof($dom_ary) > 2 && !vadmin_domain_exists($domain));
        if (!vadmin_domain_exists($domain)){
            spew("$me: domain not configured, it seems!");
            $domain = false;
        } else {
            spew("$me: domain found as '$domain'");
        }
    }
    return $domain;
}

function vadmin_list_virtual_domains(){
    $me = 'vadmin_list_virtual_domains';
    $control = vadmin_getvar('CONFIG', 'paths.qmailcontrol');
    $vfile = "$control/virtualdomains";
    spew("$me: Looking at $vfile now");
    if (!file_exists($vfile) || !is_readable($vfile)){
        spew("$me: Could not find $vfile!");
        $error = sprintf(_("Could not find virtual domains file %s!"), $vfile);
        vadmin_system_error($error);
    }
    $fd = fopen($vfile, 'r');
    $contents = fread($fd, filesize($vfile));
    $contents = rtrim($contents);
    if (strlen($contents) > 0){
        spew("$me: got $vfile, size is " . strlen($contents));
        $domuary = explode("\n", $contents);
        $domary = array();
        foreach ($domuary as $domu){
            $domain = preg_replace('/:.*/s', '', $domu);
            spew("$me: found $domain");
            array_push($domary, $domain);
        }
        return $domary;
    } else {
        spew("$me: Uhm... No domains seem to be defined.");
        $error = sprintf(_("No virtual domains defined in %s!"), $vfile);
        vadmin_system_error($error);
    }
}

function vadmin_smart_limit($domain, $level, $def){
    $me = 'vadmin_smart_limit';
    spew("$me: fetching smart limit '$def' for level '$level'");
    $limit = vadmin_get_limit($domain, $level, $def);
    if ($limit == false && $level == 'LOWLY'){
        spew("$me: limit not set for LOWLY, checking CROSS");
        $limit = vadmin_get_limit($domain, 'CROSS', $def);
    }
    spew("$me: smart limit set to '$limit'");
    return $limit;
}

function vadmin_get_user_number($domain){
    $me = 'vadmin_get_user_number';
    spew("$me: getting the number of real users in domain '$domain'");
    $crypto   = vadmin_getvar('SESSION', 'VADMIN_SECRET');
    $secret   = vadmin_crypto($crypto, 'decrypt');
    $userbunch = listdomain($domain, $secret);
    $mboxes = 0;
    foreach ($userbunch as $userary){
        if ($userary[2] != ''){
            $mboxes++;
        }
    }
    spew("$me: total number of real users is: $mboxes");
    return $mboxes;
}

function vadmin_trim_array(&$member){
    $member = trim($member);
}

/**
 * This identifies the version of Vadmin.
 */
global $VADMIN_VERSION;
$VADMIN_VERSION = "1.9.2 (2.0 beta)";

?>
