<?php

/**
  * SquirrelMail Vacation Local Plugin
  * Copyright (c) 2004-2005 Jonathan Bayer <jbayer@spamcop.net>,
  *                         Paul Lesneiwski <pdontthink@angrynerds.com>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage Vacation Local 
  *
  */



define('SM_PATH', '../../');



if (file_exists(SM_PATH . 'include/validate.php'))
   include_once(SM_PATH . 'include/validate.php');
else
   include_once(SM_PATH . 'src/validate.php');



include_once(SM_PATH . 'plugins/vacation_local/config.php');



global $vacation_delete, $vacation_file, $sq_vacation_file, 
       $sq_forward_addresses_file, $vacation_prefs_file,
       $sq_vacation_subject_file, $maintain_dot_forward_file,
       $username, $vacation_path, $data_dir, $domain,
       $forward_file, $color;



$do_autoreply = 0;
$vacation_subject = '';
$vacation_message = '';
$do_forward = 0;
$no_local_delivery = 0;
$forward_addresses = '';



// get vacation prefs
//
// usually contains these values:
//
//    do_autoreply
//    do_forward
//    no_local_delivery
//
//
if (do_action('list', $vacation_prefs_file)) 
{

   $vac_prefs = download_data($vacation_prefs_file);

   $vac_prefs = explode("\n", $vac_prefs);

   foreach ($vac_prefs as $a_pref) 
   {
      if (!empty($a_pref) && strpos($a_pref, '#') !== 0) 
      {
         list($pref_name, $pref_value) = explode('=', $a_pref, 2);
         $$pref_name = $pref_value;
      }
   }

}



// get vacation text and forwarding addresses
//
if (do_action('list', $sq_vacation_subject_file))
   $vacation_subject = download_data($sq_vacation_subject_file);
if (do_action('list', $sq_vacation_file))
   $vacation_message = download_data($sq_vacation_file);
if (do_action('list', $sq_forward_addresses_file))
   $forward_addresses = download_data($sq_forward_addresses_file);



// if user has changed settings, override all values
//
sqgetGlobalVar('vac_action', $vac_action, SQ_FORM);
if ($vac_action == 'CHANGE_VACATION_SETTINGS')
{

   // checkboxes aren't included when not checked
   //
   if (!sqgetGlobalVar('do_autoreply', $do_autoreply, SQ_FORM))
      $do_autoreply = 0;
   if (!sqgetGlobalVar('do_forward', $do_forward, SQ_FORM))
      $do_forward = 0;
   if (!sqgetGlobalVar('no_local_delivery', $no_local_delivery, SQ_FORM))
      $no_local_delivery = 0;


   sqgetGlobalVar('vacation_subject', $vacation_subject, SQ_FORM);
   sqgetGlobalVar('vacation_message', $vacation_message, SQ_FORM);


   // now upload them
   //
   upload_data($vacation_subject, $sq_vacation_subject_file);
   upload_data($vacation_message, $sq_vacation_file);
   $vac_pref_array = array('do_autoreply' => $do_autoreply, 
                           'do_forward' => $do_forward,
                           'no_local_delivery' => $no_local_delivery);
   $vac_prefs = "# DO NOT EDIT THIS FILE BY HAND\n";
   $vac_prefs .= implode_with_keys("\n", $vac_pref_array);
   upload_data($vac_prefs, $vacation_prefs_file);


   // sanitize forwarding addresses
   //
   sqgetGlobalVar('forward_addresses', $temp_forward_addresses, SQ_FORM);
   if (preg_match("/[^a-zA-Z0-9_+.@\r\n-]/", $temp_forward_addresses))
      plain_error_message(_("Bad characters in list of forwarding address."), $color);

   else
   {
      $forward_addresses = $temp_forward_addresses;
      upload_data($forward_addresses, $sq_forward_addresses_file);
   }

}



// allow vacation executable to handle aliases; all
// aliases have to be defined in SM prefs already
//
$email = $username . '@' . $domain;
$alias_list = '';
$ident = getPref($data_dir, $username, 'identities');
if (!$ident) $ident = 1;
for ($i = 0; $i < $ident; $i++) 
{

   if ($i == 0) 
      $prefs_email = getPref($data_dir, $username, 'email_address');
   else 
      $prefs_email = getPref($data_dir, $username, 'email_address' . $i);

   if (!empty($prefs_email))
      $email = $prefs_email;

   preg_match('/(^[-_.[:alnum:]]+)/', $prefs_email, $alias);
   if (isset($alias[1]) && $alias[1] != $username)
      $alias_list .= '-a ' . $alias[1] . ' ';

}
 


// get user's real name for use in the reply header
//
$full_name = getPref($data_dir, $username, 'full_name');



// build the auto-reply message file
//
$vacation_header = 'From: ';

if (isset($full_name) && !empty($full_name))
   $vacation_header .= $full_name . ' <' . $email . ">\n";
else
   $vacation_header .= $email ."\n";

$vacation_header .= 'Subject: ' . $vacation_subject . "\n\n";



// upload message 
//
upload_data($vacation_header . $vacation_message . "\n", $vacation_file);



// build the .forward file
//
if ($maintain_dot_forward_file)
{

   $forward_file_contents = '';


   // other addresses
   //
   if ($do_forward && !empty($forward_addresses))
      $forward_file_contents .= $forward_addresses . "\n";


   // pipe to vacation executable
   //
   if ($do_autoreply)
      $forward_file_contents .= '"|' . $vacation_path . ' '
                             . $alias_list . $username . "\"\n";


   // if we have no other .forward contents to here,
   // we don't need a .forward file... delete it
   //
   if (empty($forward_file_contents))
      do_action('delete', $vacation_delete . ',' . $forward_file);


   // otherwise finsih off the .forward file and upload it
   //
   else 
   {

      // local delivery (skip if user turned if off, but don't
      // skip if user did not give any forwarding addresses)
      //
      if (!$no_local_delivery || empty($forward_addresses))
         $forward_file_contents .= '\\\\' . $username . "\n";


      // upload
      //
      upload_data($forward_file_contents, $forward_file);

   }

}



// when not maintaining the .forward file, need to wipe out the vacation
// message file when user clears out the message and subject text
//
else if (empty($vacation_message) && empty($vacation_subject))
{
   do_action('delete', $vacation_delete . ',' . $vacation_file);
}



// -----------------------------------------------------------------------
//                              INTERFACE
// -----------------------------------------------------------------------



displayPageHeader($color, 'None');



bindtextdomain ('vacation_local', SM_PATH . 'locale');
textdomain ('vacation_local');



echo '<br />'."\n"
   . '<table width="95%" align="center" border="0" cellpadding="2" cellspacing="0">'
   . '<tr><td bgcolor="' . $color[0] . '">'."\n"
   . '<center><b>' . _("Options") . ' - ' . _("Change Vacation Message") 
   . '</b></center></td></tr></table>'."\n"
   . '<center><table width="95%" border="0" cellpadding="2" cellspacing="0"><tr><td>'."\n";



if ($vac_action == 'CHANGE_VACATION_SETTINGS')
{
   echo '<font color="' . $color[2] . '"><strong><center>' . _("Settings Saved") 
      . '</center></strong></font>';
}


echo '<br /><p><form method="post" action="vac_init.php">'."\n"
   . "\n".'<input type="checkbox" value="1" id="do_autoreply_id" name="do_autoreply"' . ($do_autoreply ? ' checked="checked"' : '') . ' />'
   . "\n".'<label for="do_autoreply_id">' . _("Send auto-reply to sender?") . '</label><br /><br />'
   . _("Vacation subject:")
   . '<br />'."\n".'<input type="text" size="40" name="vacation_subject" value="' . $vacation_subject . '" />'
   . '<br /><br />'."\n" . _("Vacation message:") 
   . '<br /><textarea name="vacation_message" rows="8" cols="50">'
   . $vacation_message . '</textarea><br /><br />';



if ($maintain_dot_forward_file)
{
   echo "\n".'<input type="checkbox" value="1" id="do_forward" name="do_forward"' . ($do_forward ? ' checked="checked"' : '') . ' />'
      . "\n".'<label for="do_forward">' . _("Forward incoming messages to addresses listed below?") . '</label><br /><br />'
      . "\n".'<input type="checkbox" value="1" id="no_local_delivery" name="no_local_delivery"' . ($no_local_delivery ? ' checked="checked"' : '') . ' />'
      . "\n".'<label for="no_local_delivery">' . _("No local delivery; forward and/or auto-reply only.") . '</label><br /><br />'
      . _("Forwarding email addresses (one address per line)")
      . '<br /><textarea name="forward_addresses" rows="8" cols="50">'
      . $forward_addresses . '</textarea><br /><br />';
}



echo '<input type="hidden" name="vac_action" value="CHANGE_VACATION_SETTINGS">'."\n"
   . '<input type="submit" value="' . _("Submit") . '">'."\n"
   . '</form></p>';



echo '</td></tr></table></center>'."\n";



bindtextdomain ('squirrelmail', SM_PATH . 'locale');
textdomain ('squirrelmail');



// -----------------------------------------------------------------------
//                              FUNCTIONS
// -----------------------------------------------------------------------



/**
  * Do Action
  *
  * Serves as a proxy between PHP code and the binary 
  * that can access the local file system.
  *
  * Can connect to server by either FTP or SUID script.
  *
  * @param string $action This should be one of four values
  *                       that indicate what action is to be
  *                       taken: 
  *                         'list'   determines if a file exists
  *                         'put'    uploads the given file 
  *                         'get'    downloads the given file
  *                         'delete' removes the indicated file
  * @param string $remoteFile The name of the file to be manipulated
  *                           on the local file system.
  * @param string $localFile The name of the file to be uploaded or
  *                          downloaded (basically, this is usually
  *                          just a temporary file).
  *
  * @return boolean FALSE if the action failed, TRUE otherwise
  *
  */
function do_action($action, $remoteFile, $localFile='') 
{

   global $color, $username, $key, $onetimepad, $ftp_server, $ldap_attribute,
          $mail_vacation_binary, $vac_debug, $vacation_backend,
          $ftp_passive, $ldap_lookup_ftp_server, $ldap_base, $ldap_server;


   $vacation_backend = strtolower($vacation_backend);


   // decrypt password
   //
   sqgetGlobalVar('key', $key, SQ_COOKIE);
   sqgetGlobalVar('onetimepad', $onetimepad, SQ_SESSION);
   $password = OneTimePadDecrypt($key, $onetimepad); 


   // look up ftp server in LDAP if necessary
   //
   if ($ldap_lookup_ftp_server)
   {

      // try to get ftp server name from user's session if possible
      //
      sqgetGlobalVar('vac_ftp_server', $vac_ftp_server, SQ_SESSION);


      // do the LDAP lookup
      //
      if (empty($vac_ftp_server))
      {

         $LDAP = ldap_connect($ldap_server);
         if ($LDAP) 
         {

            $r = ldap_bind($LDAP);    // this is an "anonymous" bind, ty


            if ($r)
            {
               $sr = ldap_search($LDAP, $ldap_base, "uid=$username");
               // Maybe check for search error... 
            }
            else
            {
               plain_error_message(_("Error: Could not bind to LDAP server."), $color);
               return FALSE;
            }


            $entry = ldap_first_entry($LDAP, $sr);
            $values = ldap_get_values($LDAP, $entry, $ldap_attribute);
            $vac_ftp_server = $values[0];


            // check for null return from ldap
            //
            if (!isset($vac_ftp_server)) 
            {
               plain_error_message(sprintf(_("Error: Could not find FTP server for %s in LDAP server."), $username), $color);
               ldap_close($LDAP);
               return FALSE;
            }
            else 
               sqsession_register($vac_ftp_server, 'vac_ftp_server');


            ldap_close($LDAP);

         } 
         else 
         {
            plain_error_message(_("Error: Could not connect to LDAP server."), $color);
            return FALSE;
         }

      }

      $ftp_server = $vac_ftp_server;

   }


   $server = 'localhost';

   $result = FALSE;

   if ($vac_debug)
   {
      echo "ACTION: $action === REMOTE: $remoteFile === LOCAL: $localFile === USER: $username === PASSWORD: $password<br />";
   }

   if ($vacation_backend == 'ftp')
   {
      if (!($FTP = ftp_connect($ftp_server)))
      {
         plain_error_message(_("Error: Unable to connect to FTP server. Please try again later."), $color);
         return FALSE;
      }
      if (!($FTPConn = ftp_login($FTP, $username, $password)))
      {
         plain_error_message(_("Error: Unable to log in to FTP server. Please contact your system administrator."), $color);
         ftp_quit($FTP);
         return FALSE;
      }
      if ($ftp_passive && !ftp_pasv($FTP, TRUE))
      {
         plain_error_message(_("Error: Unable to switch to passive FTP mode. Please contact your system administrator."), $color);
         ftp_quit($FTP);
         return FALSE;
      }

      // TODO: this flushes browser output too, and might create problems...?
      flush();

   }

   switch ($action) 
   {

      // check whether file exists
      //
      case 'list': 

         if ($vacation_backend == 'ftp')
         {
            $ftpList = ftp_size($FTP, $remoteFile);

            if ($ftpList > 0) 
               $result = TRUE;
            else 
               $result = FALSE;
         }
         else // suid
         {
	    $list = exec($mail_vacation_binary . ' ' . $server . ' ' . $username 
                  . ' ' . $password . ' list ' . $remoteFile . ' ???', $output, $retval);
 
            if ($list == $remoteFile) 
               $result = TRUE;
            else
               $result = FALSE;
         }

         break;



      // upload $remoteFile to $localFile
      //
      case 'put': 

         if ($vacation_backend == 'ftp')
         {
            if (ftp_put($FTP, $remoteFile, $localFile, FTP_ASCII))
               $result = TRUE;
            else 
            {
               plain_error_message(_("Error: Unable to upload file. Please contact your system administrator."), $color);
               $result = FALSE;
            }
         }
         else // suid
         {
            $put = exec($mail_vacation_binary . ' ' . $server . ' ' . $username 
                 . ' ' . $password . ' put ' . $localFile . ' ' . $remoteFile, $output, $retval);

            if ($put != '')
               $result = TRUE;
            else
            {
               plain_error_message(_("An error occurred uploading the file:") . ' ' . $output[0], $color);
               $result = FALSE;
            }
         }

         break;



      // download $remoteFile to $localFile
      // 
      case 'get': 

         if ($vacation_backend == 'ftp')
         {
            if (ftp_get($FTP, $localFile, $remoteFile, FTP_ASCII))
               $result = TRUE;
            else 
            {
               plain_error_message(_("Error: unable to download file. Please contact your system administrator."), $color);
               $result = FALSE;
            }
         }
         else // suid
         {
            $get = exec($mail_vacation_binary . ' ' . $server . ' ' . $username 
                 . ' ' . $password . ' get ' . $remoteFile . ' ' . $localFile, $output, $retval);

            if ($get != '' && strpos($get, 'Usage') !== 0) 
               $result = TRUE;
            else
            {
               plain_error_message(_("An error occurred downloading the file:") . ' ' . $output[0], $color);
               $result = FALSE;
            }
         }

         break;



      // delete files listed in $remoteFile if they exist
      //
      case 'delete': 

         $remoteFiles = explode(',', $remoteFile);
         $result = TRUE;
         foreach ($remoteFiles as $file)
         {

            if ($vacation_backend == 'ftp')
            {
               $ftpList = ftp_size($FTP, $file);
               if ($ftpList > 0 && !ftp_delete($FTP, $file))
               {
                  plain_error_message(_("Error: unable to delete file. Please contact your system administrator."), $color);
                  $result = FALSE;
               }
            }
            else // suid
            {
               $list = exec($mail_vacation_binary . ' ' . $server . ' ' . $username
                     . ' ' . $password . ' list ' . $file . ' ???', $output, $retval);

               if ($list == $file) 
               {
                  $del = exec($mail_vacation_binary . ' ' . $server . ' '
                       . $username . ' ' . $password . ' delete ' . $file . ' ???', $output, $retval);

                  if (!$del) 
                  {
                     plain_error_message(_("An error occurred deleting the file:") . ' ' . $output[0], $color);
                     $result = FALSE;
                  }

               }

            }

         }

         break;



      // unknown action
      //
      default:

         echo _("Unknown action:") . " $action<br />\n";
         $result = FALSE;

   }

   if ($vacation_backend == 'ftp') ftp_quit($FTP);

   return $result;

}



/**
  * Download Data
  *
  * Download remote file and return its contents.
  *
  * @param string $remoteFile The path and name of the 
  *                           file to be retrieved.
  *
  * @return string The contents of the desired file are returned
  *
  */
function download_data($remoteFile) 
{

   global $attachment_dir, $username, $color;

   $tempFile = $attachment_dir . '/' . $username . '.mailcfg.tmp';
   
   $result = '';
   
   $get = do_action('get', $remoteFile, $tempFile);
   
   if ($get) 
   {
      if (($FILE = fopen($tempFile, 'r')) === FALSE)
      {
         plain_error_message(_("An error occurred attempting to read temp file; check permissions on attachments directory."), $color);
         @fclose($FILE);
         @unlink($tempFile);  
         return '';
      }

      while (!feof($FILE)) 
         $result .= fread($FILE, 1024);

      fclose($FILE);
      unlink($tempFile);
   }
   
   return $result;

}



/**
  * Upload Data
  *
  * Upload string to a remote file.
  *
  * @param string $data The actual data to be uploaded
  *                     to the indicated file.
  * @param string $remoteFile The path and name of the 
  *                           file to be uploaded.
  *
  * @return boolean FALSE if the upload failed, TRUE otherwise
  *
  */
function upload_data($data, $remoteFile) 
{

   global $attachment_dir, $username, $color;
   
   $tempFile = $attachment_dir . '/' . $username . '.mailcfg.tmp';
   
   if (($FILE = fopen($tempFile, 'w')) === FALSE)
   {
      plain_error_message(_("An error occurred attempting to create temp file; check permissions on attachments directory."), $color);
      @fclose($FILE);
      @unlink($tempFile);  
      return FALSE;
   }

   fwrite($FILE, stripslashes($data));
   fclose($FILE);
  
   $put = do_action('put', $remoteFile, $tempFile);

   // delete localFile
   //
   unlink($tempFile);  
   
   return $put;

}



/**
  * Convenience function for storing user prefs in file
  *
  * @param string $glue Delimiter that will separate key/value pairs 
  *                     (keys and values are always separated from
  *                     each other by an equal sign)
  * @param string $array The associative array to disassemble
  *
  * @return string The flattened array, ready for storage in a file
  *
  */
function implode_with_keys($glue, $array) 
{

   $output = array();

   foreach ($array as $key => $value)
      $output[] = $key . '=' . $value;

   return implode($glue, $output);

}



?> 
