<?php

/**
 * vacation.php
 *
 * Copyright (c) 1999-2002 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  Vacation plugin. 
 *
 * $Id: vacation.php,v 1.6 2003/02/23 23:43:28 dminor Exp $
 */
define('SM_PATH','../../');

function implode_with_keys($glue, $array) {
       $output = array();
       foreach( $array as $key => $item )
               $output[] = $key . "=" . $item;

       return implode($glue, $output);
}

require_once(SM_PATH."plugins/vacation/config.php");

// check for existence of prefs file
if (do_ftp("list", $sq_vacation_pref)) {
  // gets preferences from prefs file
  $ftpflist = download_data($sq_vacation_pref);
  
  $vac_prefs = preg_split("/\n/", $ftpflist, -1, PREG_SPLIT_NO_EMPTY);
  
  while ($a_pref = each($vac_prefs)) {
    if (!preg_match("/^#/", $a_pref)) {
      list($pref_name,$pref_value) = preg_split("/[\s=]+/", $a_pref[value]);
      $$pref_name = $pref_value;
    }
  }
}
else { // checks for vacation set in previous version of plugin and defines current state 
  if (do_ftp("list", $sq_vacation_file)) {
    $vacation = TRUE;
    $vacation_fwd = download_data($sq_vacation_fwd_file);
    if ($vacation_fwd != "") {
      $vacation_fwd_yes = TRUE;
    } else {
      $vacation_fwd_yes = FALSE;
    }
  } else {
    $vacation = FALSE;
  }
}

// if auto-reply not checked, check for existence of other associated files that still can be displayed
if (!$vacation) {
  $sq_vacation_file_exists = do_ftp("list", $sq_vacation_file) ? TRUE : FALSE;
  $sq_vacation_subj_file_exists = do_ftp("list", $sq_vacation_subj_file) ? TRUE : FALSE;
  $sq_vacation_fwd_file_exists = do_ftp("list", $sq_vacation_fwd_file) ? TRUE : FALSE;
}


// build the vacation command
// list any forwards
if ($_POST["vacation_fwd"] && $_POST["vacation_fwd_yes"]){ 
  $forward_data = $_POST["vacation_fwd"] . "\n";
} elseif ($vacation_fwd_yes){
  $vacation_fwd = download_data($sq_vacation_fwd_file);
  $forward_data = $vacation_fwd . "\n";
} 
// local delivery if desired
if (!($_POST["vacation_no_local"] || $vacation_no_local) && 
  (($_POST["button"] == $change_vacation && $_POST["vacation"]) || 
  (($_POST["button"] != $change_vacation) && $vacation))) {
  $forward_data .= "\\\\".$username.", ";
}
// 
if (($_POST["button"] == $change_vacation && $_POST["vacation"]) || 
  (($_POST["button"] != $change_vacation) && $vacation)) {
  $forward_data .= "\"\|" . $vacation_prog_path . " ";
}

// If email address is different from username, add alias to vacation command
$ident = getPref($data_dir, $username, 'identities');
if (!$ident) {
  $ident = 1;
}
for ($i=0; $i<$ident; $i++) {
  if ($i == 0) {
    $email = getPref($data_dir, $username, 'email_address');
  } else {
    $email = getPref($data_dir, $username, 'email_address'.$i);
  }
  preg_match('/(^[-_.[:alnum:]]+)/',$email, $alias);
  if ($alias[1] && $alias[1] != $username && ($_POST["vacation"] || $vacation)) {
    $alias_list .= "-a ".$alias[1]." ";
  }
}
if  (($_POST["button"] == $change_vacation && $_POST["vacation"]) || 
  (($_POST["button"] != $change_vacation) && $vacation)) {
  $forward_data .= $alias_list . $username."\"\n";
}

// Get users realname to use on reply header
$full_name = getPref($data_dir, $username, 'full_name');

// Vacation Header
$vacation_header = "From: ";
if ($full_name && $full_name != "") {
  $vacation_header .= $full_name . " <" . $email . ">\n";
} else {
  $vacation_header .= $email ."\n";
}
$vacation_header .= "Subject: " . $_POST["vacation_subj"] . "\n\n";

// if not sending vacation message and not forwarding, delete .forward file, et al.
if (do_ftp("list",$forward_file)) {
  if (!$_POST["vacation"] && !$_POST["vacation_fwd_yes"] && $_POST["button"] == $change_vacation) {
    do_ftp("delete", $vacation_delete);
  }
}

if ($_POST["button"] == $change_vacation) {
  upload_data($_POST["vacation_fwd"], $sq_vacation_fwd_file);
  if ($_POST["vacation"] || $_POST["vacation_fwd_yes"]) {
    upload_data($forward_data, $forward_file); // change forward file
  }
  upload_data($_POST["vacation_data"], $sq_vacation_file); // text only format
  upload_data($vacation_header . $_POST["vacation_data"] . "\n", $vacation_file);  // change vacation message
  upload_data($_POST["vacation_subj"], $sq_vacation_subj_file); // upload subject file
  $vac_pref_array = array('vacation' => $_POST["vacation"], 'vacation_fwd_yes' => $_POST["vacation_fwd_yes"]);
  $vac_prefs = "# DO NOT EDIT THIS FILE BY HAND\n";
  $vac_prefs .= implode_with_keys("\n",$vac_pref_array);
  upload_data($vac_prefs, $sq_vacation_pref); // upload status file
  $vacation = $_POST["vacation"];
  $vacation_fwd_yes = $_POST["vacation_fwd_yes"];
  $vacation_no_local = $_POST["vacation_no_local"];
}

echo "<table width=\"95%\" cellpadding=\"1\" cellspacing=\"1\" border=\"0\" align=\"center\">\n";
echo "<tr>\n";
echo "<td>\n";

if (!$vacation){
  echo "<p>" . $vac_no_message . "</p>\n";
} else {
  echo "<p>" . $vac_yes_message . "</p>\n";
}
if ($sq_vacation_file_exists || $vacation) {
$vacation_data = download_data($sq_vacation_file);
}
if ($sq_vacation_subj_file_exists || $vacation) {
$vacation_subj = download_data($sq_vacation_subj_file);
}
if ($sq_vacation_fwd_file_exists || $vacation) {
$vacation_fwd = download_data($sq_vacation_fwd_file);
}

if ($vacation) {
  $vac_checked = " checked";
}

echo "<input type=\"checkbox\" name=\"vacation\" value=\"true\"" . $vac_checked . ">&nbsp;&nbsp;<strong>" . $vac_enable . "</strong><br><br>\n";
echo "\n<strong>" . _("Vacation Subject") . "</strong><br>";
echo "<input type=\"text\" name=\"vacation_subj\" size=\"40\" value=\"" . $vacation_subj . "\"><br><br>\n";
echo "<strong>" . _("Vacation Message") . "</strong><br>\n";
echo "\n<textarea name=\"vacation_data\" rows=\"8\" cols=\"70\" wrap=\"virtual\">" . $vacation_data. "</textarea><br><br>\n";

if ($vacation_fwd_yes){
  $fwd_checked = " checked";
  echo "<p>" . $fwd_yes_message . "</p>\n";
} else {
  echo "<p>" . $fwd_no_message . "</p>\n";
}

if ($vacation_no_local) {
  $local_checked = " checked";
}

echo "<input type=\"checkbox\" name=\"vacation_fwd_yes\" value=\"true\"" . $fwd_checked . ">&nbsp;&nbsp;<strong>" . $vac_fwd_enable . "</strong><br>\n";
echo "<input type=\"checkbox\" name=\"vacation_no_local\" value=\"true\"" . $local_checked . ">&nbsp;&nbsp;<strong>" .  $vac_local_enable . "</strong><br>\n";

if ($vacation_fwd_yes){
  echo "<i>" .  $fwd_yes_inst . "\"" . $change_vacation . "\"</i><br>\n";
}

echo "<br><strong>" . _("Forwarding E-Mail Addresses (One Address Per Line)") . "</strong><br>\n";

echo "\n<textarea name=\"vacation_fwd\" rows=\"8\" cols=\"70\" wrap=\"physical\">" . $vacation_fwd. "</textarea><br><br>\n";

echo "<input type=submit name=\"button\" value=\"" . $change_vacation . "\">\n";

echo "</td>\n";
echo "</tr>\n";
echo "</table>\n";

?>
