<?php

/**
 * vac_init.php
 *
 * Copyright (c) 1999-2002 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 *  Vacation plugin. 
 *
 * $Id: vac_init.php,v 1.6 2003/02/23 23:43:28 dminor Exp $
 */

chdir("..");
require_once("../src/validate.php");
require_once("../functions/page_header.php");
require_once("../functions/imap.php");
include_once("../src/load_prefs.php");
require_once("../functions/auth.php");

include_once("../plugins/vacation/config.php");

//function sqStripSlashes($string) {
//  if (get_magic_quotes_gpc()) {
//    $string = stripslashes($string);
//  }
//  return $string;
//}

displayPageHeader($color, "None");

echo "<br>\n";
echo "<table width=\"95%\" align=\"center\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">";
echo "<tr><td bgcolor=\"$color[0]\">\n";
echo "<center><b>" . _("Options") . " - " . $vac_header_line . "</b></center></td></tr></table>\n";
echo "<form method=\"post\" action=\"vac_init.php\">\n";

if ($edit_vacation) {
  include_once("../plugins/vacation/vacation.php");
} else {
  echo $vac_no_edit;
}

echo "</form>\n";

// do_ftp
// perform various ftp actions

function do_ftp($action, $remotefile, $localfile="") {

  global $username, $key, $onetimepad, $ftp_server;
  $password = OneTimePadDecrypt($key, $onetimepad); // decrypt password
    
  $result = FALSE;
    
  $fs = ftp_connect($ftp_server);
  if (!$fs){
    echo _("Could not connect to FTP server.") . "<br>\n";
  }
  $ftpconn = ftp_login($fs, $username, $password);
  if (!$ftpconn){
    echo _("Failed to login to FTP server.") . "<br>\n";
  }
  if ($use_passive) {
    if (!ftp_pasv($fs, TRUE)) {
      echo _("Unable to switch to passive FTP mode.") . "<br>\n";
    }
  }
  flush();
  
  switch ($action){
    case "list": // check whether file exists
      $ftpflist = ftp_size($fs, $remotefile);
      if ($ftpflist > 0) {
        $result = TRUE;
      } else {
        $result=FALSE;
      }

    break;

    case "put": // upload $remotefile to $localfile
       
      if (ftp_put($fs, $remotefile, $localfile, FTP_ASCII)){
        $result = TRUE;
      } else {
        echo _("An error occured uploading the file...");
        $result = FALSE;
      }
    
    break;
        
    case "get": // download $remotefile to $localfile
    
      if (ftp_get($fs, $localfile, $remotefile, FTP_ASCII)){
        $result = TRUE;
      } else {
        echo _("An error occured downloading the file.");
        $result = FALSE;
      }
      
    break;
        
    case "delete": //delete files listed in $remotefile if they exist
    
      $remotefiles = explode(",",$remotefile);
      $result = TRUE;
      for ($i=0; $i<count($remotefiles); $i++){
        $ftpflist = ftp_size($fs, $remotefiles[$i]); // Check file exists
        if ($ftpflist > 0) {
          $ftpfdel = ftp_delete($fs, $remotefiles[$i]);
          if (!$ftpfdel){
            echo _("An error occured deleting the file...");
            $result = FALSE;
          }
        }
      }
    
    break;
     
    default:
    
      echo sprintf( _("Unknown action %s in do_ftp."), $action) . "<br>\n";
      $result = FALSE;
    
  }
    
  $ftpquit = ftp_quit($fs); //close active connection
  return $result;
}

// download_data
// download remote file and return its contents

function download_data($remotefile) {
  global $attachment_dir, $username;

  $tempfile = $attachment_dir . "/" . $username . ".mailcfg.tmp";

  $result = "";

  $ftp_get = do_ftp("get", $remotefile, $tempfile);

  if ($ftp_get){
    $tempfilehandle=fopen($tempfile, "r");
    while (!feof($tempfilehandle)){
      $result .= fgets($tempfilehandle, 80);
    }
    fclose($tempfilehandle);
    unlink($tempfile);
  }

  return $result;
}

// download_data
// save string into a file and upload it

function upload_data($string, $remotefile) {
  global $attachment_dir, $username;

  $tempfile = $attachment_dir . "/" . $username . ".mailcfg.tmp";

  $tempfilehandle=fopen($tempfile, "w");
  fwrite($tempfilehandle, stripslashes($string));
  fclose($tempfilehandle);

  $ftp_put = do_ftp("put", $remotefile, $tempfile);
  unlink($tempfile);  // delete localfile

  return $ftp_put;
}

?> 
