<?php
/*
 Copyright  2001 Jrme Tournier. Proprit intellectuelle de IDEALX
 S.A.S. Peut tre librement modifi et redistribu aux termes de la
 General Public License version 2.

 Author: jerome.tournier@IDEALX.com
 Version: $Id: options.php,v 1.3 2002/02/10 01:34:57 jtournier Exp $
*/

define("SM_PATH", "../../");

require_once (SM_PATH . "include/validate.php");
require_once (SM_PATH . "include/load_prefs.php");
displayPageHeader($color, "None");
if (!isset($config_php))
	require_once (SM_PATH . "config/config.php");
if (!isset($strings_php))
	require_once (SM_PATH . "functions/strings.php");
if (!isset($page_header))
	require_once (SM_PATH . "functions/page_header.php");
if (!isset($imap_php))
	require_once (SM_PATH . "functions/imap.php");
/** COOKIE VARS */
sqgetGlobalVar('key',       $key,           SQ_COOKIE);

/** SESSION VARS */
sqgetGlobalVar('username',  $username,      SQ_SESSION);
sqgetGlobalVar('onetimepad',$onetimepad,    SQ_SESSION);

require_once (SM_PATH . "plugins/vacation/config.php");

/* for internalization */
include_once(SM_PATH . "functions/i18n.php");
bindtextdomain('vacation', SM_PATH . 'plugins/vacation/locale');
textdomain('vacation');
?>

<br>
<table width="95%" align="center" cellpadding="2" cellspacing="2" border="0">
<tr><td bgcolor="<?php echo $color[0] ?>">
<center><b><?echo _("Vacation message")?></b></center>
</td></tr></table><?php


echo "<table width=\"75%\" align=\"center\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\"><tr><td bgcolor=\"$color[3]\">\n<center><b>\n";
//echo _("Here you can set an auto-reply message to your mail. This option is most commonly used to notify the sender about your absence. For this, you have to check the \"Auto-reply active\" box and enter a message you wish to send to your contact. To deactivate this option, just uncheck the \"Auto-reply active\" box (you can leave the message, it will be saved for the next time).");
echo _("Here you can set an auto-reply message to your mail.");
echo "</b></center>\n</td></tr></table><p/>";

function getSubject(&$vacationMessage) {
	$fp = tmpfile();
	fwrite($fp, $vacationMessage);
	rewind($fp);
	$subject = trim(fgets($fp, 255));
	if (substr($subject, 0, 3) == "%%%" && substr($subject, -3) == "%%%") {
		$subject = substr($subject, 3);
		$subject = substr($subject, 0, strlen($subject) - 3);
		$vacationMessage = "";
		while ($tmp = fgets($fp, 255))
			$vacationMessage .= $tmp;
		fclose($fp);
		return $subject;
	}
	else {
		fclose($fp);
		return null;
	}
}

# connecting to the LDAP server
$ds = ldap_connect($ldap_server);
ldap_set_option($ds, LDAP_OPT_PROTOCOL_VERSION, $ldap_protocol);
if ($ds) {
	$r = ldap_bind($ds,$ldap_login,$ldap_password);
	$sr = ldap_search($ds,$cn,$ldap_query_filter);
	$info = ldap_get_entries($ds, $sr);
	#$num=$info["count"];
	#echo "There's $num message available";
	#for ($i=0; $i<$info["count"]; $i++) {
	#	$vacation=$info[$i]["mailreplytext"][0];
	#	$state=$info[$i]["deliverymode"][0];
	#}
	# We are using the first mailreplytext
	#$vacation=$info[0]["mailreplytext"][0];
	$vacation = $info[0][strtolower($ldap_replymessage_field)][0];
	if ($base64encode_message)
		$vacation = base64_decode($vacation);
	$vacation = utf8_decode($vacation);
	$subject = getSubject($vacation);
	$state = $info[0][strtolower($ldap_replyflag_field)][0];
	# Choosing the delivery mode
	# "reply" to set an auto-reply message to incoming email
	# "normal" for normal use :)
	echo "<table><tr><td>"._("Auto-reply active:")." </td><td><form action=\"update.php\" method=\"post\">";
	echo "<input type=\"checkbox\" name=\"state\"".($state == $ldap_replyflag_reply ? " checked" : "")."></td>\n";
	# get the message in case of reply mode
	if ($use_subject_field)
		echo "<tr><td>"._("Subject:")." </td><td><input type=\"text\" name=\"subject\" value=\"".htmlentities($subject)."\"/></td></tr>";
	echo "<tr><td>"._("Message:")." </td><td><textarea rows=\"8\" cols=\"50\" name=\"message\">".htmlentities($vacation)."</textarea></td></tr>";
	echo "<tr><td><input type=\"submit\" value=\""._("Apply")."\"></form></td><td></td>";
	echo "</tr></table>";


	# disconnected from the LDAP server
	ldap_close($ds);

} else {
	echo "<h4>"._("Unable to connect LDAP-server.")."</h4>";
}
bindtextdomain('squirrelmail', SM_PATH . 'locale');
textdomain('squirrelmail');
?>
