<?php
/* user_special_mailboxes -- Version 0.1
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 */

/* Path for SquirrelMail required files. */
define('SM_PATH', '../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'include/load_prefs.php');

/* get globals we may need */
sqgetGlobalVar('key', $key, SQ_COOKIE);
sqgetGlobalVar('username', $username, SQ_SESSION);
sqgetGlobalVar('data_dir', $data_dir, SQ_SESSION);
sqgetGlobalVar('user_special_mailboxes', $user_special_mailboxes, SQ_POST);
/* end of get globals */

if (isset($user_special_mailboxes) && isset($user_special_mailboxes[0]) && $user_special_mailboxes[0] != '') {
/*
 *  Set the preferences for the passed mailboxes
 */
  for ($boxnum = 0; $boxnum < count($user_special_mailboxes); $boxnum++) {
    setPref($data_dir, $username, 'user_special_mailboxes' . $boxnum, $user_special_mailboxes[$boxnum]);
  }
} else {
/*
 * Set boxnum to zero so all prefs will be removed below.
 */
  $boxnum = 0;
}

/*
 * Remove any extra prefs after 'boxnum'
 */

while (getPref($data_dir, $username, 'user_special_mailboxes' . $boxnum)) {
  removePref($data_dir, $username, 'user_special_mailboxes' . $boxnum++);
}

/*
 * We're done - redirect back to folders page.
 */

$location = get_location();
header ("Location: $location/../../src/folders.php?user_special_mailboxes_success=done");

?>
