<?php
/* user_special_mailboxes -- Version 0.1
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 */

function squirrelmail_plugin_init_user_special_mailboxes() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['special_mailbox']['user_special_mailboxes'] =
    'user_special_mailboxes_check';
  $squirrelmail_plugin_hooks['folders_bottom']['user_special_mailboxes'] =
    'user_special_mailboxes_select';
}

/*
 * We have the ability to disable this because when the options are being built
 * we don't want to show the default special stuff, and we also want to show the list
 * in 'standard' order, which is done by setting disable_check to 1 while we make the
 * options.
 */

$disable_user_special_mailboxes_check = 0;
function user_special_mailboxes_check($box) {
  global $disable_user_special_mailboxes_check;
  if ($disable_user_special_mailboxes_check) return 0;
  return check_user_special($box);
}

function check_user_special($box) {
  global $data_dir, $username;

  $boxnum = 0;
  while ($mailbox = getPref($data_dir, $username, 'user_special_mailboxes' . $boxnum++)) {
    if ($mailbox == $box) return 1;
  }
  return 0;
}

function user_special_mailboxes_select() {
/*
 * Log into server if not already done.
 */

  global $imapConnection, $username, $key, $imapServerAddress, $imapPort;
  if (!isset($imapConnection)) {
    $imapConnection = sqimap_login($username, $key, $imapServerAddress,
                                   $imapPort, 0);
  }

/*
 * Show the folder options
 */

  global $color;

/*
 * Hopefully folders.php will be updated so we can remove this later.
 * until then, we have to display our own message.
 */

  sqgetGlobalVar('user_special_mailboxes_success', $success, SQ_GET);
  if (isset($success) && $success) {
    echo html_tag( 'table',
                html_tag( 'tr',
                     html_tag( 'td', '<b>Special Folders Successfully Stored!</b><br>'.
                               '<a href="../src/left_main.php" target=left>' .
                               _("refresh folder list") . '</a>', 
                               'center' )
                ) ,
            'center', '', 'width="100%" cellpadding="4" cellspacing="0" border="0"' );
  }

/*
 * Here's the table, etc. holding all our options.
 */

  echo "\n<br>";
  echo html_tag( 'table', '', 'center', '', 'width="70%" cellpadding="4" cellspacing="0" border="0"' ) .
       html_tag( 'tr',
           html_tag( 'td', '<b>' . _("Additional Special Folders") . '</b>', 'center', $color[9] )
                ) .
       html_tag( 'tr' ) .
       html_tag( 'td', '', 'center', $color[0] );

/*
 * Disable our special checks for this part.
 */

  global $disable_user_special_mailboxes_check;
  $disable_user_special_mailboxes_check = 1;

  $boxes = sqimap_mailbox_list($imapConnection);
  echo '<form name=usm method="POST" action="' . SM_PATH . "plugins/user_special_mailboxes/set_mailboxes.php". '">' . "\n";
  echo '<select multiple size="8" name="user_special_mailboxes[]">' . "\n";
  for ($boxnum = 0; $boxnum < count($boxes); $boxnum++) {
    if (isSpecialMailbox($boxes[$boxnum]['unformatted'])) continue;
    echo '<option value="' . $boxes[$boxnum]['unformatted'] . '"' .
         (check_user_special($boxes[$boxnum]['unformatted']) ? ' selected' : '') .
         '>' .
         $boxes[$boxnum]['unformatted-disp'] . "</option>\n";
  }
  echo "</select>\n";
  echo html_tag ( 'tr' ) . html_tag ( 'td', '', 'center', $color[0] );
  echo "<input type=SUBMIT VALUE=\"".  _("Set Special") . "\">\n";
  echo "</form>\n";

  echo html_tag( 'tr',
           html_tag( 'td', '&nbsp;', 'left', $color[4] )
               ) ."\n";
}

?>
