<?php

/**
  * SquirrelMail User Information Plugin
  * Copyright (c) 2008-2009 Paul Lesniewski <paul@squirrelmail.org>
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage user_info
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_user_info()
{

   global $squirrelmail_plugin_hooks;


   // this hook gets run very early in all page requests
   //
   $squirrelmail_plugin_hooks['prefs_backend']['user_info']
      = 'user_info_setup';


   // configuration check
   //
   $squirrelmail_plugin_hooks['configtest']['user_info']
      = 'user_info_check_configuration';

}



/**
  * Returns info about this plugin
  *
  */
function user_info_info()
{

   return array(
                 'english_name' => 'User Information',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'summary' => 'Provides data about the current user for use by other plugins.',
                 'details' => 'This plugin provides an extensible set of data about the current user such as IP address, browser type and version, possibly their country, etc., mainly for use by other plugins.',
                 'requires_source_patch' => 0,
                 'required_plugins' => array(),
               );

}



/**
  * Returns version info about this plugin
  *
  */
function user_info_version()
{
   $info = user_info_info();
   return $info['version'];
}



/**
  * Validate that this plugin is configured correctly
  *
  * @return boolean Whether or not there was a
  *                 configuration error for this plugin.
  *
  */
function user_info_check_configuration()
{
   include_once(SM_PATH . 'plugins/user_info/functions.php');
   return user_info_check_configuration_do();
}



/**
  * Gather user data
  *
  */
function user_info_setup()
{
   include_once(SM_PATH . 'plugins/user_info/functions.php');
   get_user_info(FALSE);
}



