<?php

/**
 * unsafe_image_rules -- Version 0.7
 * this page written by Marc Powell <marc@xodus.com>
 *
 * Copyright (c) 2004 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This page adds the address to the rules list.
   
/* Path for SquirrelMail required files. */
define('SM_PATH','../../');

/* SquirrelMail required files. */
require_once(SM_PATH . 'include/validate.php');
require_once(SM_PATH . 'functions/i18n.php');
require_once(SM_PATH . 'include/load_prefs.php');
   
displayPageHeader($color, 'None');

/*
 * Get globals
*/

$username = $_SESSION['username'];


/* input data */
sqgetGlobalVar('address', $address, SQ_FORM);
sqgetGlobalVar('mailbox', $mailbox, SQ_FORM);
sqgetGlobalVar('passed_id',     $passed_id,     SQ_FORM);
sqgetGlobalVar('passed_ent_id', $passed_ent_id, SQ_FORM);
sqgetGlobalVar('startMessage',  $startMessage,  SQ_FORM);
sqgetGlobalVar('sort',          $sort,          SQ_FORM);
sqgetGlobalVar('how',          $how,          SQ_FORM);

$unsafe_image_rules_add_email = getPref($data_dir, $username, 'unsafe_image_rules_add_email');
$unsafe_image_rules_add_domain = getPref($data_dir, $username, 'unsafe_image_rules_add_domain');
$unsafe_image_rules_add_ask = getPref($data_dir, $username, 'unsafe_image_rules_add_ask');
$where = "From,";

if (isset($address)) {
    if ($how == 'regexp') $where = "R" . $where;
    echo '<br><table width=95% align=center border=0 cellpadding=2 cellspacing=0>'.
          "<tr><td bgcolor=\"$color[0]\">".
          '<center><b>' . _("Unsafe Image Rules") . ' - ' . _("Safe Sender") . '</b></center>'.
          '</td></tr></table>';

    if (isset($unsafe_image_rules_add_ask) && $unsafe_image_rules_add_ask) {
    	if (!(isset($_POST['user_submit']))) {
        echo '<br><center>' .
          _("Use the form below to modify the address that will be added to the Unsafe Image Rules."). '<br>'. 
          '<form method=post action="add.php">'.
          '<input type=hidden name=mailbox value="' . $mailbox . '">'.
          '<input type=hidden name=passed_id value="' . $passed_id . '">'.
          '<input type=hidden name=passed_ent_id value="' . $passed_ent_id . '">'.
          '<input type=hidden name=startmessage value="' . $startmessage . '">'.
          '<input type=hidden name=sort value="' . $sort . '">'.
           _("From") . '&nbsp;';

/* Some duplicated code here from options.php. bleh */
       echo '<select name=how>';

       echo "<option value=\"contains\" $sel>" . _("Contains") . '</option>';
       echo "<option value=\"regexp\" $sel>" . _("Reg.Exp.") . '</option>';
       echo "</select>&nbsp;" .
            '<input type=text size=32 name=address value="';
       echo htmlentities($address);
       echo '">&nbsp;&nbsp;<input type=submit name="user_submit" value="' .
       _("Save") . '">';
       exit;
        }	
    }

    if (isset($unsafe_image_rules_add_domain) && $unsafe_image_rules_add_domain) {
        $email_address_array = explode("@", trim($address));
        $ii = count($email_address_array)-1;
        $address = $email_address_array[$ii];
    }

    $unsafe_image_rules_list = load_unsafe_image_rules();

    $theid = count($unsafe_image_rules_list);

    setPref($data_dir, $username, "unsafe_image_rules" . $theid, $where . $address);

    $urlMailbox = urlencode($mailbox);
    $location .= "/src/right_main.php?mailbox=$urlMailbox" .
             "&startMessage=$startMessage" .
             "&passed_id=$passed_id";
    if(isset($passed_ent_id)) {
        $location .= '&passed_ent_id=' . $passed_ent_id;
    }
    if(isset($sort)) {
        $location .= '&sort=' . $sort;
    }
    echo '<META HTTP-EQUIV=Refresh CONTENT="5; URL=' . $location . '">';

    echo '<center><br>';
    echo _("The following address has been successfully added to the Unsafe Images Rules: ");
    echo '<strong>' . $address . '</strong><br>';
    echo _("Sending you back to the message list in 5 seconds.");
    echo '<br>';
    echo _("If you are not automatically redirected, please click ");
    echo '<a href = "' . $location . '">HERE</A>.</center><br>';
} else {

    echo '<META HTTP-EQUIV=Refresh CONTENT="5; URL=' . $location . '">';

    echo '<center><br>';
    echo _("I didn't seem to get a valid email address to add. This shouldn't happen!");
    echo _("Sending you back to the message list in 5 seconds.");
    echo '<br>';
    echo _("If you are not automatically redirected, please click ");
    echo '<a href = "' . $location . '">HERE</A>.</center><br>';
} 
?>
</body>
</html>
