<?php
/* unsafe_image_rules -- Version 0.1
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 *
 * This page handles options for the plugin.
 * Shamless snatch of code from filters page - thanks guys ;-)
 */

  chdir ('..');
  require_once('../src/validate.php');
  require_once('../functions/page_header.php');
  require_once('../src/load_prefs.php');

  displayPageHeader($color, 'None');

  if (isset($unsafe_image_rules_submit)) {
     if (!isset($theid)) $theid = 0;
     $what = ereg_replace(",", " ", $what);
     $what = str_replace("\\\\", "\\", $what);
     $what = str_replace("\\\"", "\"", $what);
     $what = str_replace("\"", "&quot;", $what);

     setPref($data_dir, $username, "unsafe_image_rules".$theid, $where.",".$what);
     $filters[$theid]["where"] = $where;
     $filters[$theid]["what"] = $what;
  } elseif (isset($action) && $action == 'delete') {
     remove_trusted($theid);
  } elseif (isset($user_submit)) {
      setPref($data_dir, $username, 'unsafe_image_rules_all',
              isset($uir_all) ? "1" : "0");
      setPref($data_dir, $username, 'unsafe_image_rules_trusted',
              isset($uir_trusted) ? "1" : "0");
      echo "<br><center><b>"._("Saved Trusted Options")."</b></center>\n";
  }

  $unsafe_image_rules_list = load_unsafe_image_rules();
  $unsafe_image_rules_all = getPref($data_dir, $username, 'unsafe_image_rules_all');
  $unsafe_image_rules_trusted = getPref($data_dir, $username, 'unsafe_image_rules_trusted');

  echo '<br>' .
       '<table width=95% align=center border=0 cellpadding=2 cellspacing=0>'.
       "<tr><td bgcolor=\"$color[0]\">".
       '<center><b>' . _("Options") . ' -  ' . _("Unsafe Image Rules") . '</b></center>'.
       '</td></tr></table>'.

       '<br><form method=post action="options.php">'.
       '<center>'.
       '<table width=80% cellpadding=2 cellspacing=0 border=0>';

/*
 * Trust all images option.
 */

  echo '<tr><th align=right nowrap>' . _("Trust all sources:") . '</th>'.
       '<td><input type=checkbox name="uir_all"';
  if (isset($unsafe_image_rules_all) && $unsafe_image_rules_all) {
      echo ' CHECKED';
  }
  echo "></td><td><small>If checked unsafe images are always seen. This is not recommended by" .
       " the Squirrelmail Development Team.<BR>" . 
       "If this option is checked, the state of 'Trust defined sources' is irrelevant." .
        "</small></td><tr>" .
        "</tr>\n";

/*
 * Trust only some option.
 */

  echo '<tr><th align=right nowrap>' . _("Trust defined sources:") . '</th>'.
       '<td><input type=checkbox name="uir_trusted"';         
  if (isset($unsafe_image_rules_trusted) && $unsafe_image_rules_trusted) {
      echo ' CHECKED';
  }
  echo "></td><td><small>If checked unsafe images are shown for the sources shown below." .
       "</small></td></tr>\n";

/*
 * Submit for top changes.
 */

  echo '<tr><td colspan=3 align=center><input type=submit name="user_submit" value="' .
       _("Save") . '"></td></tr>'.
       '</table>'.
       '</center>'.
       '</form>';

/*
 * New, done, then list existing ones.
 */

  echo '<center>[<a href="options.php?action=add">' . _("Add New Rule") .
       '</a>] - [<a href="../../src/options.php">' . _("Done") . '</a>]</center><br>';

  if (isset($action) && ($action == 'add' || $action == 'edit')) {
    if ( !isset($theid) ) {
         $theid = count($unsafe_image_rules_list);
    }
    echo '<form action="options.php" method=post>'.
         '<table width=95%><tr><td align=center>' .
         _("Trust source if ") .
         '<select name=where>';

    $where_set = isset($unsafe_image_rules_list[$theid]['where']);

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'From')?'selected':'');
    echo "<option value=\"From\" $sel>" . _ ("From") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'To')?'selected':'');
    echo "<option value=\"To\" $sel>" . _ ("To") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'Cc')?'selected':'');
    echo "<option value=\"Cc\" $sel>" . _ ("Cc") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'To or Cc')?'selected':'');
    echo "<option value=\"To or Cc\" $sel>" . _ ("To or Cc") . '</option>';

    $sel = (($where_set && $unsafe_image_rules_list[$theid]['where'] == 'Subject')?'selected':'');
    echo "<option value=\"Subject\" $sel>" . _ ("Subject") . '</option>';

    echo '</select>' .
         _(" matches regexp: ") .
         '<input type=text size=32 name=what value="';
    if (isset($unsafe_image_rules_list[$theid]['what'])) {
      echo $unsafe_image_rules_list[$theid]["what"];
    }
    echo '"></td></tr><tr><td align=center>'.
         '<input type=submit name=unsafe_image_rules_submit value=' . _("Submit") . '>'.
         "<input type=hidden name=theid value=$theid>".
         '</td></tr></table>' .
         '</form>' .
         '</center>';
    }

    echo '<table border=0 cellpadding=3 cellspacing=0 align=center>';

    for ($lp = 0; $lp < count($unsafe_image_rules_list); $lp++) {
      $clr = (($lp % 2)?$color[0]:$color[9]);
      echo "<tr bgcolor=\"$clr\"><td><small>".
           "[<a href=\"options.php?theid=$lp&action=edit\">" . _("Edit") . '</a>]'.
            '</small></td><td><small>'.
            "[<a href=\"options.php?theid=$lp&action=delete\">" . _("Delete") . '</a>]' .
            "</small></td><td>-</td><td>";
      printf( _("If <b>%s</b> matches <b>%s</b></b>"), _($unsafe_image_rules_list[$lp]['where']),
                                                         $unsafe_image_rules_list[$lp]['what']);
      echo '</td></tr>';

  }
  echo '</table>';

function remove_trusted($id)
{
  global $data_dir, $username;

  while ($trusted = getPref($data_dir, $username, 'unsafe_image_rules' . ($id + 1))) {
    setPref($data_dir, $username, 'unsafe_image_rules' . $id, $trusted);
    $id++;
  }

  removePref($data_dir, $username, 'unsafe_image_rules' . $id);
}

?>
