<?php
/* unsafe_image_rules -- Version 0.1
 * By Robin Rainton <robin@rainton.com>
 * http://rainton.com/fun/freeware
 *
 * Always show unsafe images in HTML mail. Saves the user
 * having to always click that pesky link at the bottom of the
 * message each time.
 */

function squirrelmail_plugin_init_unsafe_image_rules() {
  global $squirrelmail_plugin_hooks;
  $squirrelmail_plugin_hooks['read_body_header']['unsafe_image_rules'] =
    'unsafe_image_rules_main';
  $squirrelmail_plugin_hooks['optpage_register_block']['unsafe_image_rules'] =
    'unsafe_image_rules_optpage_register_block';

}

function unsafe_image_rules_main()
{
  global $view_unsafe_images, $data_dir, $username, $message;

/*
 * Handle the case where we always show unsafe images
 */

  $unsafe_image_rules_all = getPref($data_dir, $username, 'unsafe_image_rules_all');
  if (isset($unsafe_image_rules_all) && $unsafe_image_rules_all == 1)
  {
    $view_unsafe_images = TRUE;
    return;
  }

/*
 * OK - see if we've configured system to always show
 * unsafe for this message.
 */

  $unsafe_image_rules_trusted = getPref($data_dir, $username,
                                        'unsafe_image_rules_trusted');
  if (isset($unsafe_image_rules_trusted) &&
      $unsafe_image_rules_trusted &&
      is_in_unsafe_image_rules_list($message)) $view_unsafe_images = TRUE;
}

/*
 * Figure out if the message we're looking matches any details in our list.
 */

function is_in_unsafe_image_rules_list($message)
{
  $trusted = load_unsafe_image_rules();

/*
 * Loop through options seeing if this messages details match one.
 */

  for ($lp = 0; $lp < count($trusted); $lp++) {
    if ($trusted[$lp]['where'] == "To or Cc") {
      if (unsafe_image_rules_match($message, "To", $trusted[$lp]['what'])) return TRUE;
      if (unsafe_image_rules_match($message, "Cc", $trusted[$lp]['what'])) return TRUE;
    } else {
      if (unsafe_image_rules_match($message, $trusted[$lp]['where'], $trusted[$lp]['what'])) return TRUE;
    }
  }
  return FALSE;
}

function unsafe_image_rules_match($message, $where, $what)
{
  switch ($where) {
/*
 * To and Cc fields are arrays, so we have to join then all together
 */
    case "To" : $search = join(",", $message->header->to); break;
    case "Cc" : $search = join(",", $message->header->cc); break;
/*
 * From and Subject are standard text fields
 */
    case "From" : $search = $message->header->from; break;
    case "Subject" : $search = $message->header->subject; break;
/*
 * If we don't recognise the $where then how can it match?
 */
    default: return FALSE;
  }

  return preg_match("/$what/", $search);
}

/*
 * Register our options section.
 */

function unsafe_image_rules_optpage_register_block() {
  global $optpage_blocks;

  $optpage_blocks[] = array(
      'name' => _("Unsafe Image Rules"),
      'url'  => '../plugins/unsafe_image_rules/options.php',
      'desc' => _("Set up rules about how unsafe images in HTML messages are handled."),
      'js'   => false
  );
}

/*
 * Function to load trusted message details
 */

function load_unsafe_image_rules()
{
  global $data_dir, $username;

  $out = array();
  for ($lp=0; $opt = getPref($data_dir, $username, 'unsafe_image_rules' . $lp); $lp++) {
      $ary = explode(',', $opt);
      $out[$lp]['where'] = $ary[0];
      $out[$lp]['what'] = $ary[1];
  }
  return $out;
}

?>
