<?php

/******************************************************************************/
include_once ('twc_support.php');

/* SM Version Checking */

global $debug, $weather_debug_dir;

if (isset ($debug) && $debug===TRUE)
{
    $fp = fopen($weather_debug_dir ."twc_weather-debug.log", "w");
    fwrite ($fp, "SM Version: " . twc_weather_check_SM_version (1,3,2) . "\n\n");
    fclose($fp);
}

if (twc_weather_check_SM_version (1, 3, 2))
{       
	if(!defined('SM_PATH'))
	{
		define('SM_PATH','../../');
	}
        include_once (SM_PATH . 'plugins/twc_weather/weather.php');

        if (file_exists (SM_PATH . 'plugins/twc_weather/config.php'))
                include_once (SM_PATH . 'plugins/twc_weather/config.php');
        else
		include_once (SM_PATH . 'plugins/twc_weather/config.php.sample');
}
else
{
        include_once ('weather.php');

	if (file_exists ('config.php'))
                include_once ('config.php');
        else
		include_once ('config.php.sample');
}

function twc_weather_version()
{
	return ('1.3p2 RC1');
}

function squirrelmail_plugin_init_twc_weather()
{
	global $squirrelmail_plugin_hooks;
	
	include_once(SM_PATH . 'functions/i18n.php');
	bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
	textdomain('twc_weather');

	$squirrelmail_plugin_hooks['left_main_before']['twc_weather'] = 
		'twc_weather_show_before';
	$squirrelmail_plugin_hooks['left_main_after']['twc_weather'] = 
		'twc_weather_show_after';
	$squirrelmail_plugin_hooks['optpage_register_block']['twc_weather'] = 
		'twc_weather_optpage_register_block';

	bindtextdomain('squirrelmail', SM_PATH . 'locale');
	textdomain('squirrelmail');

	return;
}

function twc_weather_show_before ()
{
	include_once(SM_PATH . 'functions/i18n.php');
	bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
	textdomain('twc_weather');

	$locations = load_locations ();
	for ($i = 0; $i < count ($locations); $i++)
	{
		if ($locations[$i]['position'] == "before")
		{
			weather_display ($locations[$i], $i);
		}
	}
	bindtextdomain('squirrelmail', SM_PATH . 'locale');
	textdomain('squirrelmail');

	return;
}


function twc_weather_show_after ()
{
	include_once(SM_PATH . 'functions/i18n.php');
	bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
	textdomain('twc_weather');
	
	$locations = load_locations ();
	for ($i = 0; $i < count ($locations); $i++)
	{
		if ($locations[$i]['position'] == "after")
		{
			weather_display ($locations[$i], $i);
		}
	}
	
	bindtextdomain('squirrelmail', SM_PATH . 'locale');
	textdomain('squirrelmail');

	return;
}

function twc_weather_optpage_register_block ()
{
	global $optpage_blocks;
	
	include_once(SM_PATH . 'functions/i18n.php');
	bindtextdomain('twc_weather', SM_PATH . 'plugins/twc_weather/locale');
	textdomain('twc_weather');
	
	$optpage_blocks[] = array (
		'name' => _("TWC Weather"),
		'url'  => SM_PATH . 'plugins/twc_weather/options.php',
		'desc' => _("Setup the weather displaying options. You can add all the cities you want to monitor as well as various options to display."),
		'js'   => false);

	bindtextdomain('squirrelmail', SM_PATH . 'locale');
	textdomain('squirrelmail');
	return;
}

?>
