<?php

function twc_weather_check_SM_version ($a = '0', $b = '0', $c = '0') {

       global $version;
       list($aa, $bb, $cc) = preg_split('/\./', $version, 3);
       $tmp_cc = '';
	
       if(!is_numeric($cc)) 
       {
       		if (count (explode (" ", $cc, 2)) < 2)
       		{
       			for ($i=0; $i < strlen ($cc); $i++ )
       			{
       				if (is_numeric (substr($cc, $i, 1)))
       				{
       					$tmp_cc .= substr($cc, $i, 1);
       				}
       				else
       				{
       					$info = substr ($cc, $i);
       					break;
       				}
       			}
       			$cc = $tmp_cc;    				
       		}
       		else
       		{
           		list($tmp_cc, $info) = explode(" ", $cc, 2);
        	}
       }
       return ($aa > $a)
           || (($aa == $a) && ($bb > $b))
           || (($aa == $a) && ($bb == $b) && ($cc >= $c));
}


/* The SI_x functions are simple English to SI units conversion functions for the
   various meteorological measurements used by twc_weather */

function SI_Temperature ($temp_F) {

	$temp_C = (5/9)*($temp_F-32);

	return (round($temp_C,0));

}

function SI_Pressure ($Pressure_InchesHg, $pressure_units) {

	$Pressure_MB = $Pressure_InchesHg * 33.8639;
	$pressure = $Pressure_MB;
	if ($pressure_units == 'kPa')
	{
   		$Pressure_kPa = $Pressure_MB * 0.1 ;
   		$pressure = $Pressure_kPa;
   	}

        return (round($pressure,1));


}

function SI_Distance ($Distance_Miles) {

	$Distance_Kilometers = $Distance_Miles * 1.609;

	return (round($Distance_Kilometers,1));

}

function SI_Length ($Distance_Inches) {

        $Distance_Centimeters = $Distance_Inches * 2.54;

        return (round($Distance_Centimeters,1));

}

function SI_Speed ($Speed_Mph, $wind_units) {

	$Speed_Kph = $Speed_Mph * 1.609;
	$Speed = $Speed_Kph;
	if ($wind_units == "m/s")
	{
		$Speed = $Speed_Kph * 1000/3600;
	}
	return (round ($Speed,0));

}

/* 
   fixX functions are the callback functions that operate on the narrative text.
   I make heavy useage of PCRE strings so break out your decoder ring!

*/


function fixTemps($temperature_phrase)  
{
	$temperature_phrase[0] = SI_Temperature($temperature_phrase[0]);
	return ($temperature_phrase[0]."&deg;C");

	/* Append a degree symbol and the C to the converted temperature */

}

/*
   Process the english words that are used to modify the word values and convert
   to numerical equivalents.
*/

function fixBallParkTemps($temperature_phrase)
{
	$temperature_text = explode (" ", $temperature_phrase[0]);
	foreach ($temperature_text as $key => $value)
	{
		// $search = "/(highs|high|lows|low|upper|middle|mid)?/";
		// $temperature_text[$key] = preg_replace($search, "", $value);
		switch ($value)
		{
			case 'low' :
				$value = "";
				$temperature_text[$key] = $value;
				break;
                        case 'lower' :
                                $value = "";
                                $temperature_text[$key] = $value;
                                break;
			case 'mid' :
                                $value = "";
                                $temperature_text[$key] = $value;
                                break;
                        case 'middle' :
                                $value = "";
                                $temperature_text[$key] = $value;
                                break;
			case 'upper':
				$value = "";
				$temperature_text[$key] = $value;
                        case 'high':
                                $value = "";
                                $temperature_text[$key] = $value;
			
		}
	}
	$temperature_phrase[0] = implode (" ", $temperature_text);
	$temperature_phrase[0] = preg_replace("/\ {2}/", " ", $temperature_phrase[0]);
	
	/* this is where some work on the adjectives would be nice */
	/* this could get ugly! */
        	preg_replace("/(single\ digits)/", 
		             round(SI_Temperature("5"), -1)."s", 
		 	     $temperature_phrase[0]);
		preg_replace("/(teens)/", round(SI_Temperature("15"), -1)."s", 
		             $temperature_phrase[0]);
		preg_match("/\-*[0-9]+/", $temperature_phrase[0], $value);
		$temperature_phrase[0] =  preg_replace("/\-*[0-9]+/", 
	 	                          round(SI_Temperature($value[0]), 
					  -1), $temperature_phrase[0]);
	

	if (preg_match("/(\ \-*0s){1}/", $temperature_phrase[0]))
	{
		return ("near 0");
	}
	else
        { 
		return ( $temperature_phrase[0]);
	}	
}


function fixWind($wind_speed_phrase, $wind_units)
{
	$wind_text = explode (" ",$wind_speed_phrase);
	foreach ($wind_text as $key => $value)
	{
		if (ereg("[0-9]+", $value))
		{
			$wind_text[$key]  = SI_Speed($value, $wind_units);
		}
		elseif ( ereg("(mph)+", $value))
		{
			$wind_text[$key] = $wind_units;
		}
		if ( ereg("(\.)+", $value))
		{
			$wind_text[$key] .= ".";
		}
	}
	$wind_speed_phrase = implode (" ", $wind_text);
	return ($wind_speed_phrase);
}

/*
   The TWC narratives don't include the degree symbol they are just valueF 
   (like 45F).  Parse and fix up to include the html tag for degrees (&deg;)
*/

function fixFahrenheit ($temperature_phrase)
{
        $temperature_phrase[0] = preg_replace ("/F+/", "&deg;F", $temperature_phrase[0]);
        return ($temperature_phrase[0]);
}


/*

  The temperatures are the only thing that I currently hate with TWC narratives.
  Looks like they are pasting the info from some other source that doesn't know
  about the degree symbol.  So I parse for xxF and fix it up.

*/

function fixEnglishNarrative ($narrative)
{
        $start_pos = 0;
        $chop_pos = 0;
        $new_narrative ="";
        while ($chop_pos !== false)
        {
/*
   This little trick keeps from getting a null phrase after the last valid
   phrase.
*/
                if (!(1 && $chop_pos = strpos($narrative, ".", $start_pos)))
                        {break;}

                $phrase = substr($narrative, $start_pos, 
			$chop_pos + 1 - $start_pos);

/* 
   Annoyingly the fahrenheit temps in the narratives don't have the little 
   degree symbol.  So trap them here for fixFahrenheit to fix up.
*/
                $phrase = preg_replace_callback ("/\-?[0-9]+[F]{1}/", 
				'fixFahrenheit', $phrase);

                $start_pos = $chop_pos + 1;
                $new_narrative .= $phrase;
        }

        return ($new_narrative);

}


/*

  Seems TWC has a propensity for speaking of percipitation in terms of word
  values for numbers rather than an actual numeric value. 

*/
function fixInches ($inches_phrase)
{
        $inches_text = explode (" ",$inches_phrase[0]);
	foreach ($inches_text as $key => $value)
        {

/* 
   This gets really ugly because they all use a's, an's, of an's to make the english words
   read correctly.
*/
		
		if ( ereg("(^a|^an|^of)+", $value))
		{
			$inches_text[$key] ="";
		}
	
		$inches_text[$key] = preg_replace ( "/[0-9]+(\.+[0-9]+)*/", 
					SI_Length($value), $inches_text[$key]);

        	$inches_text[$key] = preg_replace("/(inches|inch)+/", "cm", 
					$inches_text[$key]);
	}
	$inches_phrase[0] = implode (" ", $inches_text);
	$inches_phrase[0] = preg_replace ("/\ {2}/", " ", $inches_phrase[0]);
	return ($inches_phrase[0]);
}

function fixTemperatureRange ($temperature_phrase)
{
        $temperature_text = explode (" ",$temperature_phrase[0]);
        foreach ($temperature_text as $key => $value)
        {
                if (ereg("[0-9]+F?", $value))
                {
                        $temperature_text[$key]  = SI_Temperature($value);
                }
                if ( ereg("(F)+", $value))
                {
                        $temperature_text[$key] .= "&deg;C";
                }
                if ( ereg("(\.)+", $value))
                {
                        $temperature_text[$key] .= ".";
                }
        }
        $temperature_phrase[0] = implode (" ", $temperature_text);

        return ($temperature_phrase[0]);

}

/* Sometimes the phrase will be XX-YY mph; replace the "-" with "to" */

function fixHyphen ($phrase)
{
	$phrase[0] = preg_replace("/\-/", " to ", $phrase[0]);
	return ($phrase[0]);
}

function fixWordstoNumbers ($phrase)
{
	$phrase[0] = preg_replace ("/(three(\-|\ )+quarters)+(\ of\ an\ inch)+/"
			, "0.75 inches", $phrase[0]);
	$phrase[0] = preg_replace ("/((quarter\ inch)|(quarter\ of\ an\ inch))+/"
                        , "0.25 inches", $phrase[0]);
	$phrase[0] = preg_replace ("/(one)+/", "1.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(two)+/", "2.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(three)+/", "3.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(four)+/", "4.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(five)+/", "5.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(six)+/", "6.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(seven)+/", "7.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(eight)+/", "8.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(nine)+/", "9.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(ten)+/", "10.0", $phrase[0]);
        $phrase[0] = preg_replace ("/(teens)+/", "15s", $phrase[0]);
	$phrase[0] = preg_replace ("/(single\ digits)+/", "5s", $phrase[0]);
	$phrase[0] = preg_replace ("/((a\ )*half\ an\ inch)+/", "0.5 inches", $phrase[0]);
	$phrase[0] = preg_replace ("/(an\ inch)+/", "1.0 inches", $phrase[0]);

	return ($phrase[0]);
}



function fixInchesRange ($inches_phrase)
{
	$inches_text = explode (" ",$inches_phrase[0]);
        foreach ($inches_text as $key => $value)
        {
                $inches_text[$key] = preg_replace ( "/[0-9]+(\.+[0-9]+)*/", 
					SI_Length($value), $inches_text[$key]);
                $inches_text[$key] = preg_replace("/(inches|inch)+/", "cm", 
					$inches_text[$key]);
        }
        $inches_phrase[0] = implode (" ", $inches_text);
	$inches_phrase[0] = preg_replace ("/\ {2}/", " ", $inches_phrase[0]);

	return ($inches_phrase[0]);
}

/*

  This is the workhorse parser for the SI conversions.  TWC expresses the
  narratives in all sort of different ways.  Some as words in stead of numbers,
  as ranges of words and/or numbers, or even fractions--not to mention 
  modifiers like uppper, lower, mid, middle, etc. 

*/
function SI_Narrative($narrative, $wind_units)
{
	$start_pos = 0;
	$chop_pos = 0;
	$new_narrative ="";

/* 
   Chop up the complete narrative into phrases that are delimited with "."s
   Then iterate over the phrases and convert based on the contextual
   searches below.
*/
	while ($chop_pos !== false)
	{

/* 
   This little trick keeps from getting a null phrase after the last valid 
   phrase.  
*/
		if (!(1 && $chop_pos = strpos($narrative, ".", $start_pos)))
		{
			break;
		}

		$phrase = substr($narrative, $start_pos, 
			  $chop_pos + 1 - $start_pos);



/* First let's do our best to convert words to numbers */

                $search = "/((three(\-|\ )+quarters)(\ of\ an inch)*".
                          "|one|two|three|four|five|six|seven|eight|nine|ten".
                          "|(quarter((\ of\ an\ inch)|(\ inch)))|half\ an\ inch|eighth|teens|single\ digits|an\ inch(\.*))/";
                $phrase = preg_replace_callback ($search, 'fixWordstoNumbers', 
                          $phrase);
		
/* Find wind speed range:  XX to YY mph or just XX mph  */

/* Sometimes the phrase will be XX-YY mph; replace the "-" with "to" */
		$search = "/[0-9]+\-[0-9]+/";
		$phrase = preg_replace_callback ($search, 'fixHyphen', $phrase);
 
		$search = "/([0-9]+((\-)|(\ to\ {1}))[0-9]+\ {1}mph{1}\.*)".
			  "|(to\ {1}[0-9]+\ {1}mph{1}\.*)|([0-9]+\ mph\.*)/e";
			 
		$phrase = preg_replace ($search, "fixWind('\\1', '$wind_units')", $phrase);
                
/* Find Temperature (Fahrenheit Variants  */

/* Handle a range of temps from XX to YYF */

		$search = "/[0-9]+\ to\ {1}\-?[0-9]+F{1}\.*/";
		$phrase = preg_replace_callback ($search, 'fixTemperatureRange', 
			  $phrase);
	
/* Handle a single temp:  XXF  */

		$phrase = preg_replace_callback ("/\-?[0-9]+[F]{1}/", 'fixTemps', 
 			  $phrase);

/* TWC likes to use words for numerical values when expressing temperature 
   forecasts usually the forecast is: XXs or WORD-VALUEs  */


		$search = "/((in\ the\ )*(|high|low|upper". 
			  "|lower|middle|mid)*\ )\-*[0-9]+[s]{1}/";
		$phrase = preg_replace_callback ($search, 'fixBallParkTemps', 
			  $phrase);
	
/* Convert Precipitaion (Inches variants) */

/* First let's do our best to convert words to numbers 

		$search = "/((three(\-|\ )+quarters)(\ of\ an)*".
			  "|one|two|three|four|five|six|seven|eight|nine|ten".
			  "|quarter|half|eighth|an\ inch(\.*))/";
		$phrase = preg_replace_callback ($search, 'fixWordstoNumbers', 
			  $phrase);
*/
/* Handle ranges of precipitation: to XX inch(es) or XX to YY inch(es) */

		$search = "/(to\ ([0-9](\.[0-9])+)*\ (inches|inch)\.*)".
			  "|([0-9]+(\.[0-9]+)*\ to\ {1}[0-9]+(\.+[0-9]+)*".
			   "\ (inches|inch)+\.*)/";
		$phrase = preg_replace_callback ($search, 'fixInchesRange',$phrase);

/* Handle single instance of precip:  an XX inch(es) */

		$search = "/(!(than)&an\ |a\ )*([0-9]+(\.[0-9]+)*\ )*(inches|inch){1}\.*/";

		$phrase = preg_replace_callback ($search, 'fixInches', $phrase);
/* 
   Almost done, remove any extra spaces that were introduced during conversion
*/
		$phrase = preg_replace ("/\ {2}/", " ", $phrase);

		$start_pos = $chop_pos + 1;

		$new_narrative .= $phrase;
	}

	return ($new_narrative);

}
function twc_display_wicon($tmp_URL) 
{	

	/* take in a URL pointing to a GIF and spit it out to a client as PNG.
	   Guess I'd call that a twc_weather image proxy (sans cache)?  The
	   idea here is to allow the SM server to go out and gather the weather
	   icons and feed them to the SM clients rather than redirecting the
	   clients to get them themselves.  This should eliminate the annoying
	   pop-up warning users get when they are accessing SM via a secure 
	   (HTTPS) connection and the icon's URL is somewhere's else (like at 
	   twc's site) and can only be gotten via a clear channel HTTP
	   connection.
	 */
include ('config.php');
global $weather_proxy_icons_method;
if ($weather_proxy_icons_method == "TRANSPARENT")
{
	$img_in = @fopen($tmp_URL, "rb");
	if (!$img_in)
	{
		die ("Internal Error opening WICON GIF. " .
			"URL likely not found!\r\n");
	}
	$contents = "";
	while (!@feof($img_in))
	{
		$contents .= @fread($img_in, 8192);
		header("Content-type: image/gif");
		header("Content-length: " & strlen($contents));
		header("Cache-Control: public");
        	header("X-Image-ID: $tmp_URL");
		print ($contents);
	}



}
else	/* Transcoding Proxy functionality (PNG by hardcoded by default) */
{
	

	header("X-Image-ID: $tmp_URL");

        /*
           Unhack the name that we hacked so the client browser would
           name the icon correctly in the HTML source.
        */
	if (preg_match ("/png/", $tmp_URL))
	{
		$tmp_URL = preg_replace("/png/", 'gif', $tmp_URL);
	}
	/* Assume original URL to wicon is a GIF */
	$img_in = imagecreatefromgif($tmp_URL);

        $in_x = imagesx($img_in);
        $in_y = imagesy($img_in);

	/* Spit out a PNG header type */
	header("Content-type: image/png");

        /* not sure if determining length this way is a valid assumption */
	header("Content-length: " . ($in_x * $in_y));
	
	/* In case anybody (proxy) cares to save some bandwidth */
	header("Cache-Control: public");

	/* All done, spit out PNG instead of GIF to the client */	
        imagepng($img_in);
}
        return (TRUE);

}
?>
