<?php

/**
  * SquirrelMail TNEF Decoder Plugin
  *
  * Copyright (c) 2010- Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2003  Bernd Wiegmann <bernd@wib-software.de>
  * Copyright (c) 2002  Graham Norburys <gnorbury@bondcar.com>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage tnef_decoder
  *
  */



/**
  * Register this plugin with SquirrelMail
  *
  */
function squirrelmail_plugin_init_tnef_decoder()
{

   global $squirrelmail_plugin_hooks;


   // Add "view" link for TNEF attachments
   //
   $squirrelmail_plugin_hooks['attachment application/ms-tnef']['tnef_decoder']
      = 'tnef_decoder_link_stub';


   // Optionally look for "winmail.dat" attachments with wrong MIME type
   //
   $squirrelmail_plugin_hooks['attachment application/octet-stream']['tnef_decoder']
      = 'tnef_decoder_link_application_octet_stub';
   $squirrelmail_plugin_hooks['attachment */*']['tnef_decoder']
      = 'tnef_decoder_link_all_types_stub';

}



/**
  * Returns info about this plugin
  *
  */
function tnef_decoder_info()
{

   return array(
                 'english_name' => 'TNEF Decoder',
                 'authors' => array(
                    'Paul Lesniewski' => array(
                       'email' => 'paul@squirrelmail.org',
                       'sm_site_username' => 'pdontthink',
                    ),
                    'Bernd Wiegmann' => array(
                       'email' => 'bernd@wib-software.de',
                       'sm_site_username' => '',
                    ),
                    'Graham Norburys' => array(
                       'email' => 'gnorbury@bondcar.com',
                       'sm_site_username' => '',
                    ),
                 ),
                 'version' => '1.0',
                 'required_sm_version' => '1.4.0',
                 'requires_configuration' => 0,
                 'summary' => 'Provides the ability to view the contents of TNEF attachments (usually "winmail.dat")',
                 'details' => 'This plugin provides links to view and download the contents of Transport Neutral Encapsulation Format (TNEF) attachments (usually named "winmail.dat" and generated by Microsoft Outlook) on the message view screen.',
                 'requires_source_patch' => 0,
                 'per_version_requirements' => array(
                    // FIXME: add support for 1.5.2
                    '1.5.0' => SQ_INCOMPATIBLE,
                    '1.4.10' => array(
                       'required_plugins' => array()
                    ),
                    '1.4.0' => array(
                       'required_plugins' => array(
                          'compatibility' => array(
                             'version' => '2.0.7',
                             'activate' => FALSE,
                          ),
                       )
                    ),
                 ),
               );

}



/**
  * Returns version info about this plugin
  *
  */             
function tnef_decoder_version()
{                   
   $info = tnef_decoder_info();
   return $info['version'];
}                   



/**                          
  * Add "view" link for TNEF attachments
  *                       
  */                   
function tnef_decoder_link_stub(&$args)
{                   
   include_once(SM_PATH . 'plugins/tnef_decoder/functions.php');
   tnef_decoder_link($args);
}                



/**                          
  * Optionally Add "view" link for TNEF attachments with wrong MIME type
  *                       
  */                   
function tnef_decoder_link_all_types_stub(&$args)
{                   
   include_once(SM_PATH . 'plugins/tnef_decoder/functions.php');
   tnef_decoder_link_all_types($args);
}                



/**                          
  * Optionally Add "view" link for TNEF attachments with wrong MIME type
  *                       
  */                   
function tnef_decoder_link_application_octet_stub(&$args)
{                   
   include_once(SM_PATH . 'plugins/tnef_decoder/functions.php');
   tnef_decoder_link_application_octet($args);
}                



