<?php

/**
  * SquirrelMail TNEF Decoder Plugin
  *
  * Copyright (c) 2010- Paul Lesniewski <paul@squirrelmail.org>
  * Copyright (c) 2003  Bernd Wiegmann <bernd@wib-software.de>
  * Copyright (c) 2002  Graham Norburys <gnorbury@bondcar.com>
  *
  * Licensed under the GNU GPL. For full terms see the file COPYING.
  *
  * @package plugins
  * @subpackage tnef_decoder
  *
  */



/**
  * Returns a list of file extension-to-MIME-type mappings
  *
  * The returned list is a combination of things culled
  * from a typical /etc/mime.types file as well as various
  * Internet sources
  *
  * @return array Keys are extension names, values are MIME types
  *
  */
function get_file_extension_to_mime_type_map()
{

   return array(
      '3dm' => 'x-world/x-3dmf',
      '3dmf' => 'x-world/x-3dmf',
      'Z' => 'application/x-compress',
      'a' => 'application/octet-stream',
      'aab' => 'application/x-authorware-bin',
      'aam' => 'application/x-authorware-map',
      'aas' => 'application/x-authorware-seg',
      'abc' => 'text/vnd.abc',
      'acgi' => 'text/html',
      'acx' => 'application/internet-property-stream',
      'afl' => 'video/animaflex',
      'ai' => 'application/postscript',
      'aif' => 'audio/x-aiff',
      'aifc' => 'audio/x-aiff',
      'aiff' => 'audio/x-aiff',
      'aim' => 'application/x-aim',
      'aip' => 'text/x-audiosoft-intra',
      'ani' => 'application/x-navi-animation',
      'aos' => 'application/x-nokia-9000-communicator-add-on-software',
      'aps' => 'application/mime',
      'arc' => 'application/octet-stream',
      'arj' => 'application/octet-stream',
      'art' => 'image/x-jg',
      'asc' => 'text/plain',
      'asf' => 'video/x-ms-asf',
      'asm' => 'text/x-asm',
      'asp' => 'text/asp',
      'asr' => 'video/x-ms-asf',
      'asx' => 'video/x-ms-asf',
      'au' => 'audio/x-au',
      'avi' => 'video/x-msvideo',
      'avs' => 'video/avs-video',
      'axs' => 'application/olescript',
      'bas' => 'text/plain',
      'bcpio' => 'application/x-bcpio',
      'bin' => 'application/x-macbinary',
      'bm' => 'image/bmp',
      'bmp' => 'image/bmp',
      'boo' => 'application/book',
      'book' => 'application/book',
      'boz' => 'application/x-bzip2',
      'bsh' => 'application/x-bsh',
      'bz' => 'application/x-bzip',
      'bz2' => 'application/x-bzip2',
      'c' => 'text/plain',
      'c++' => 'text/plain',
      'cat' => 'application/vnd.ms-pki.seccat',
      'cc' => 'text/plain',
      'ccad' => 'application/clariscad',
      'cco' => 'application/x-cocoa',
      'cdf' => 'application/x-netcdf',
      'cer' => 'application/x-x509-ca-cert',
      'cgi' => 'application/x-httpd-cgi',
      'cha' => 'application/x-chat',
      'chat' => 'application/x-chat',
      'chrt' => 'application/x-kchart',
      'class' => 'application/x-java-class',
      'clp' => 'application/x-msclip',
      'cmx' => 'image/x-cmx',
      'cod' => 'image/cis-cod',
      'com' => 'application/octet-stream',
      'conf' => 'text/plain',
      'cpio' => 'application/x-cpio',
      'cpp' => 'text/x-c',
      'cpt' => 'application/mac-compactpro',
      'crd' => 'application/x-mscardfile',
      'crl' => 'application/pkix-crl',
      'crt' => 'application/x-x509-ca-cert',
      'csh' => 'text/x-script.csh',
      'css' => 'text/css',
      'cxx' => 'text/plain',
      'dcr' => 'application/x-director',
      'deepv' => 'application/x-deepv',
      'def' => 'text/plain',
      'der' => 'application/x-x509-ca-cert',
      'dif' => 'video/x-dv',
      'dir' => 'application/x-director',
      'djv' => 'image/vnd.djvu',
      'djvu' => 'image/vnd.djvu',
      'dl' => 'video/x-dl',
      'dll' => 'application/octet-stream',
      'dms' => 'application/octet-stream',
      'doc' => 'application/msword',
      'dot' => 'application/msword',
      'dp' => 'application/commonground',
      'drw' => 'application/drafting',
      'dump' => 'application/octet-stream',
      'dv' => 'video/x-dv',
      'dvi' => 'application/x-dvi',
      'dwf' => 'model/vnd.dwf',
      'dwg' => 'image/x-dwg',
      'dxf' => 'image/x-dwg',
      'dxr' => 'application/x-director',
      'el' => 'text/x-script.elisp',
      'elc' => 'application/x-elc',
      'env' => 'application/x-envoy',
      'eps' => 'application/postscript',
      'es' => 'application/x-esrehber',
      'etx' => 'text/x-setext',
      'evy' => 'application/envoy',
      'exe' => 'application/octet-stream',
      'ez' => 'application/andrew-inset',
      'f' => 'text/x-fortran',
      'f77' => 'text/x-fortran',
      'f90' => 'text/x-fortran',
      'fdf' => 'application/vnd.fdf',
      'fif' => 'application/fractals',
      'fli' => 'video/x-fli',
      'flo' => 'image/florian',
      'flr' => 'x-world/x-vrml',
      'flx' => 'text/vnd.fmi.flexstor',
      'fmf' => 'video/x-atomic3d-feature',
      'for' => 'text/x-fortran',
      'fpx' => 'image/vnd.net-fpx',
      'frl' => 'application/freeloader',
      'funk' => 'audio/make',
      'g' => 'text/plain',
      'g3' => 'image/g3fax',
      'gif' => 'image/gif',
      'gl' => 'video/x-gl',
      'gsd' => 'audio/x-gsm',
      'gsm' => 'audio/x-gsm',
      'gsp' => 'application/x-gsp',
      'gss' => 'application/x-gss',
      'gtar' => 'application/x-gtar',
      'gz' => 'application/x-gzip',
      'gzip' => 'application/x-gzip',
      'h' => 'text/plain',
      'hdf' => 'application/x-hdf',
      'help' => 'application/x-helpfile',
      'hgl' => 'application/vnd.hp-hpgl',
      'hh' => 'text/x-h',
      'hlb' => 'text/x-script',
      'hlp' => 'application/x-winhelp',
      'hpg' => 'application/vnd.hp-hpgl',
      'hpgl' => 'application/vnd.hp-hpgl',
      'hqx' => 'application/x-mac-binhex40',
      'hta' => 'application/hta',
      'htc' => 'text/x-component',
      'htm' => 'text/html',
      'html' => 'text/html',
      'htmls' => 'text/html',
      'htt' => 'text/webviewhtml',
      'htx' => 'text/html',
      'ice' => 'x-conference/x-cooltalk',
      'ico' => 'image/x-icon',
      'idc' => 'text/plain',
      'ief' => 'image/ief',
      'iefs' => 'image/ief',
      'iges' => 'model/iges',
      'igs' => 'model/iges',
      'iii' => 'application/x-iphone',
      'ima' => 'application/x-ima',
      'imap' => 'application/x-httpd-imap',
      'img' => 'application/octet-stream',
      'inf' => 'application/inf',
      'ins' => 'application/x-internet-signup',
      'ip' => 'application/x-ip2',
      'iso' => 'application/octet-stream',
      'isp' => 'application/x-internet-signup',
      'isu' => 'video/x-isvideo',
      'it' => 'audio/it',
      'iv' => 'application/x-inventor',
      'ivr' => 'i-world/i-vrml',
      'ivy' => 'application/x-livescreen',
      'jam' => 'audio/x-jam',
      'jav' => 'text/x-java-source',
      'java' => 'text/x-java-source',
      'jcm' => 'application/x-java-commerce',
      'jfif' => 'image/pipeg',
      'jfif-tbnl' => 'image/jpeg',
      'jpe' => 'image/pjpeg',
      'jpeg' => 'image/pjpeg',
      'jpg' => 'image/pjpeg',
      'jps' => 'image/x-jps',
      'js' => 'application/x-javascript',
      'jut' => 'image/jutvision',
      'kar' => 'audio/midi',
      'kil' => 'application/x-killustrator',
      'kpr' => 'application/x-kpresenter',
      'kpt' => 'application/x-kpresenter',
      'ksh' => 'text/x-script.ksh',
      'ksp' => 'application/x-kspread',
      'kwd' => 'application/x-kword',
      'kwt' => 'application/x-kword',
      'la' => 'audio/x-nspaudio',
      'lam' => 'audio/x-liveaudio',
      'latex' => 'application/x-latex',
      'lha' => 'application/x-lha',
      'lhx' => 'application/octet-stream',
      'list' => 'text/plain',
      'lma' => 'audio/x-nspaudio',
      'log' => 'text/plain',
      'lsf' => 'video/x-la-asf',
      'lsp' => 'text/x-script.lisp',
      'lst' => 'text/plain',
      'lsx' => 'video/x-la-asf',
      'ltx' => 'application/x-latex',
      'lzh' => 'application/x-lzh',
      'lzx' => 'application/x-lzx',
      'm' => 'text/x-m',
      'm13' => 'application/x-msmediaview',
      'm14' => 'application/x-msmediaview',
      'm1v' => 'video/mpeg',
      'm2a' => 'audio/mpeg',
      'm2v' => 'video/mpeg',
      'm3u' => 'audio/x-mpegurl',
      'man' => 'application/x-troff-man',
      'map' => 'application/x-navimap',
      'mar' => 'text/plain',
      'mbd' => 'application/mbedlet',
      'mc$' => 'application/x-magic-cap-package-1.0',
      'mcd' => 'application/x-mathcad',
      'mcf' => 'text/mcf',
      'mcp' => 'application/netmc',
      'mdb' => 'application/x-msaccess',
      'me' => 'application/x-troff-me',
      'mesh' => 'model/mesh',
      'mht' => 'message/rfc822',
      'mhtml' => 'message/rfc822',
      'mid' => 'audio/midi',
      'midi' => 'audio/midi',
      'mif' => 'application/vnd.mif',
      'mime' => 'www/mime',
      'mjf' => 'audio/x-vnd.audioexplosion.mjuicemediafile',
      'mjpg' => 'video/x-motion-jpeg',
      'mm' => 'application/x-meme',
      'mme' => 'application/base64',
      'mny' => 'application/x-msmoney',
      'mod' => 'audio/x-mod',
      'moov' => 'video/quicktime',
      'mov' => 'video/quicktime',
      'movie' => 'video/x-sgi-movie',
      'mp2' => 'audio/mpeg',
      'mp3' => 'audio/mpeg',
      'mpa' => 'video/mpeg',
      'mpc' => 'application/x-project',
      'mpe' => 'video/mpeg',
      'mpeg' => 'video/mpeg',
      'mpg' => 'video/mpeg',
      'mpga' => 'audio/mpeg',
      'mpp' => 'application/vnd.ms-project',
      'mpt' => 'application/x-project',
      'mpv' => 'application/x-project',
      'mpv2' => 'video/mpeg',
      'mpx' => 'application/x-project',
      'mrc' => 'application/marc',
      'ms' => 'application/x-troff-ms',
      'msh' => 'model/mesh',
      'msxls' => 'application/msexcel',
      'mv' => 'video/x-sgi-movie',
      'mvb' => 'application/x-msmediaview',
      'mxu' => 'video/vnd.mpegurl',
      'my' => 'audio/make',
      'mzz' => 'application/x-vnd.audioexplosion.mzz',
      'nap' => 'image/naplps',
      'naplps' => 'image/naplps',
      'nc' => 'application/x-netcdf',
      'ncm' => 'application/vnd.nokia.configuration-message',
      'nif' => 'image/x-niff',
      'niff' => 'image/x-niff',
      'nix' => 'application/x-mix-transfer',
      'nsc' => 'application/x-conference',
      'nvd' => 'application/x-navidoc',
      'nws' => 'message/rfc822',
      'o' => 'application/octet-stream',
      'oda' => 'application/oda',
      'odb' => 'application/vnd.oasis.opendocument.database',
      'odc' => 'application/vnd.oasis.opendocument.chart',
      'odf' => 'application/vnd.oasis.opendocument.formula',
      'odg' => 'application/vnd.oasis.opendocument.graphics',
      'odi' => 'application/vnd.oasis.opendocument.image',
      'odm' => 'application/vnd.oasis.opendocument.text-master',
      'odp' => 'application/vnd.oasis.opendocument.presentation',
      'ods' => 'application/vnd.oasis.opendocument.spreadsheet',
      'odt' => 'application/vnd.oasis.opendocument.text',
      'ogg' => 'application/ogg',
      'omc' => 'application/x-omc',
      'omcd' => 'application/x-omcdatamaker',
      'omcr' => 'application/x-omcregerator',
      'otg' => 'application/vnd.oasis.opendocument.graphics-template',
      'oth' => 'application/vnd.oasis.opendocument.text-web',
      'otp' => 'application/vnd.oasis.opendocument.presentation-template',
      'ots' => 'application/vnd.oasis.opendocument.spreadsheet-template',
      'ott' => 'application/vnd.oasis.opendocument.text-template',
      'p' => 'text/x-pascal',
      'p10' => 'application/pkcs10',
      'p12' => 'application/x-pkcs12',
      'p7a' => 'application/x-pkcs7-signature',
      'p7b' => 'application/x-pkcs7-certificates',
      'p7c' => 'application/x-pkcs7-mime',
      'p7m' => 'application/x-pkcs7-mime',
      'p7r' => 'application/x-pkcs7-certreqresp',
      'p7s' => 'application/x-pkcs7-signature',
      'part' => 'application/pro_eng',
      'pas' => 'text/pascal',
      'pbm' => 'image/x-portable-bitmap',
      'pcl' => 'application/x-pcl',
      'pct' => 'image/x-pict',
      'pcx' => 'image/x-pcx',
      'pdb' => 'chemical/x-pdb',
      'pdf' => 'application/pdf',
      'pfunk' => 'audio/make.my.funk',
      'pfx' => 'application/x-pkcs12',
      'pgm' => 'image/x-portable-greymap',
      'pgn' => 'application/x-chess-pgn',
      'pic' => 'image/pict',
      'pict' => 'image/pict',
      'pkg' => 'application/x-newton-compatible-pkg',
      'pko' => 'application/vnd.ms-pki.pko',
      'pl' => 'text/x-script.perl',
      'plx' => 'application/x-pixclscript',
      'pm' => 'text/x-script.perl-module',
      'pm4' => 'application/x-pagemaker',
      'pm5' => 'application/x-pagemaker',
      'pma' => 'application/x-perfmon',
      'pmc' => 'application/x-perfmon',
      'pml' => 'application/x-perfmon',
      'pmr' => 'application/x-perfmon',
      'pmw' => 'application/x-perfmon',
      'png' => 'image/png',
      'pnm' => 'image/x-portable-anymap',
      'pot' => 'application/vnd.ms-powerpoint',
      'pot,' => 'application/vnd.ms-powerpoint',
      'pov' => 'model/x-pov',
      'ppa' => 'application/vnd.ms-powerpoint',
      'ppm' => 'image/x-portable-pixmap',
      'pps' => 'application/vnd.ms-powerpoint',
      'ppt' => 'application/vnd.ms-powerpoint',
      'ppz' => 'application/mspowerpoint',
      'pre' => 'application/x-freelance',
      'prf' => 'application/pics-rules',
      'prt' => 'application/pro_eng',
      'ps' => 'application/postscript',
      'psd' => 'application/octet-stream',
      'pub' => 'application/x-mspublisher',
      'pvu' => 'paleovu/x-pv',
      'pwz' => 'application/vnd.ms-powerpoint',
      'py' => 'text/x-script.phyton',
      'pyc' => 'applicaiton/x-bytecode.python',
      'qcp' => 'audio/vnd.qcelp',
      'qd3' => 'x-world/x-3dmf',
      'qd3d' => 'x-world/x-3dmf',
      'qif' => 'image/x-quicktime',
      'qt' => 'video/quicktime',
      'qtc' => 'video/x-qtc',
      'qti' => 'image/x-quicktime',
      'qtif' => 'image/x-quicktime',
      'ra' => 'audio/x-realaudio',
      'ram' => 'audio/x-pn-realaudio',
      'ras' => 'image/x-cmu-raster',
      'rast' => 'image/cmu-raster',
      'rexx' => 'text/x-script.rexx',
      'rf' => 'image/vnd.rn-realflash',
      'rgb' => 'image/x-rgb',
      'rm' => 'audio/x-pn-realaudio',
      'rmi' => 'audio/mid',
      'rmm' => 'audio/x-pn-realaudio',
      'rmp' => 'audio/x-pn-realaudio-plugin',
      'rng' => 'application/vnd.nokia.ringing-tone',
      'rnx' => 'application/vnd.rn-realplayer',
      'roff' => 'application/x-troff',
      'rp' => 'image/vnd.rn-realpix',
      'rpm' => 'audio/x-pn-realaudio-plugin',
      'rt' => 'text/vnd.rn-realtext',
      'rtf' => 'application/rtf',
      'rtx' => 'text/richtext',
      'rv' => 'video/vnd.rn-realvideo',
      's' => 'text/x-asm',
      's3m' => 'audio/s3m',
      'saveme' => 'application/octet-stream',
      'sbk' => 'application/x-tbook',
      'scd' => 'application/x-msschedule',
      'scm' => 'video/x-scm',
      'sct' => 'text/scriptlet',
      'sdml' => 'text/plain',
      'sdp' => 'application/x-sdp',
      'sdr' => 'application/sounder',
      'sea' => 'application/x-sea',
      'set' => 'application/set',
      'setpay' => 'application/set-payment-initiation',
      'setreg' => 'application/set-registration-initiation',
      'sgm' => 'text/x-sgml',
      'sgml' => 'text/x-sgml',
      'sh' => 'text/x-script.sh',
      'shar' => 'application/x-shar',
      'shtml' => 'text/x-server-parsed-html',
      'sid' => 'audio/x-psid',
      'silo' => 'model/mesh',
      'sit' => 'application/x-stuffit',
      'skd' => 'application/x-koan',
      'skm' => 'application/x-koan',
      'skp' => 'application/x-koan',
      'skt' => 'application/x-koan',
      'sl' => 'application/x-seelogo',
      'smi' => 'application/smil',
      'smil' => 'application/smil',
      'snd' => 'audio/x-adpcm',
      'so' => 'application/octet-stream',
      'sol' => 'application/solids',
      'spc' => 'application/x-pkcs7-certificates',
      'spl' => 'application/x-futuresplash',
      'spr' => 'application/x-sprite',
      'sprite' => 'application/x-sprite',
      'src' => 'application/x-wais-source',
      'ssi' => 'text/x-server-parsed-html',
      'ssm' => 'application/streamingmedia',
      'sst' => 'application/vnd.ms-pkicertstore',
      'stc' => 'application/vnd.sun.xml.calc.template',
      'std' => 'application/vnd.sun.xml.draw.template',
      'step' => 'application/step',
      'sti' => 'application/vnd.sun.xml.impress.template',
      'stl' => 'application/vnd.ms-pkistl',
      'stm' => 'text/html',
      'stp' => 'application/step',
      'stw' => 'application/vnd.sun.xml.writer.template',
      'sv4cpio' => 'application/x-sv4cpio',
      'sv4crc' => 'application/x-sv4crc',
      'svf' => 'image/x-dwg',
      'svg' => 'image/svg+xml',
      'svr' => 'x-world/x-svr',
      'swf' => 'application/x-shockwave-flash',
      'sxc' => 'application/vnd.sun.xml.calc',
      'sxd' => 'application/vnd.sun.xml.draw',
      'sxg' => 'application/vnd.sun.xml.writer.global',
      'sxi' => 'application/vnd.sun.xml.impress',
      'sxm' => 'application/vnd.sun.xml.math',
      'sxw' => 'application/vnd.sun.xml.writer',
      't' => 'application/x-troff',
      'talk' => 'text/x-speech',
      'tar' => 'application/x-tar',
      'tbk' => 'application/x-tbook',
      'tcl' => 'text/x-script.tcl',
      'tcsh' => 'text/x-script.tcsh',
      'tex' => 'application/x-tex',
      'texi' => 'application/x-texinfo',
      'texinfo' => 'application/x-texinfo',
      'text' => 'text/plain',
      'tgz' => 'application/x-compressed',
      'tif' => 'image/x-tiff',
      'tiff' => 'image/x-tiff',
      'torrent' => 'application/x-bittorrent',
      'tr' => 'application/x-troff',
      'trm' => 'application/x-msterminal',
      'tsi' => 'audio/tsp-audio',
      'tsp' => 'audio/tsplayer',
      'tsv' => 'text/tab-separated-values',
      'turbot' => 'image/florian',
      'txt' => 'text/plain',
      'uil' => 'text/x-uil',
      'uls' => 'text/iuls',
      'uni' => 'text/uri-list',
      'unis' => 'text/uri-list',
      'unv' => 'application/i-deas',
      'uri' => 'text/uri-list',
      'uris' => 'text/uri-list',
      'ustar' => 'multipart/x-ustar',
      'uu' => 'text/x-uuencode',
      'uue' => 'text/x-uuencode',
      'vcd' => 'application/x-cdlink',
      'vcf' => 'text/x-vcard',
      'vcs' => 'text/x-vcalendar',
      'vda' => 'application/vda',
      'vdo' => 'video/vdo',
      'vew' => 'application/groupwise',
      'viv' => 'video/vnd.vivo',
      'vivo' => 'video/vnd.vivo',
      'vmd' => 'application/vocaltec-media-desc',
      'vmf' => 'application/vocaltec-media-file',
      'voc' => 'audio/x-voc',
      'vos' => 'video/vosaic',
      'vox' => 'audio/voxware',
      'vqe' => 'audio/x-twinvq-plugin',
      'vqf' => 'audio/x-twinvq',
      'vql' => 'audio/x-twinvq-plugin',
      'vrml' => 'x-world/x-vrml',
      'vrt' => 'x-world/x-vrt',
      'vsd' => 'application/x-visio',
      'vst' => 'application/x-visio',
      'vsw' => 'application/x-visio',
      'w60' => 'application/wordperfect6.0',
      'w61' => 'application/wordperfect6.1',
      'w6w' => 'application/msword',
      'wav' => 'audio/x-wav',
      'wb1' => 'application/x-qpro',
      'wbmp' => 'image/vnd.wap.wbmp',
      'wbxml' => 'application/vnd.wap.wbxml',
      'wcm' => 'application/vnd.ms-works',
      'wdb' => 'application/vnd.ms-works',
      'web' => 'application/vnd.xara',
      'wiz' => 'application/msword',
      'wk1' => 'application/x-123',
      'wks' => 'application/vnd.ms-works',
      'wmf' => 'application/x-msmetafile',
      'wml' => 'text/vnd.wap.wml',
      'wmlc' => 'application/vnd.wap.wmlc',
      'wmls' => 'text/vnd.wap.wmlscript',
      'wmlsc' => 'application/vnd.wap.wmlscriptc',
      'word' => 'application/msword',
      'wp' => 'application/wordperfect',
      'wp5' => 'application/wordperfect6.0',
      'wp6' => 'application/wordperfect',
      'wpd' => 'application/x-wpwin',
      'wps' => 'application/vnd.ms-works',
      'wq1' => 'application/x-lotus',
      'wri' => 'application/x-mswrite',
      'wrl' => 'x-world/x-vrml',
      'wrz' => 'x-world/x-vrml',
      'wsc' => 'text/scriplet',
      'wsrc' => 'application/x-wais-source',
      'wtk' => 'application/x-wintalk',
      'x-png' => 'image/png',
      'xaf' => 'x-world/x-vrml',
      'xbm' => 'image/xbm',
      'xdr' => 'video/x-amt-demorun',
      'xgz' => 'xgl/drawing',
      'xht' => 'application/xhtml+xml',
      'xhtml' => 'application/xhtml+xml',
      'xif' => 'image/vnd.xiff',
      'xl' => 'application/excel',
      'xla' => 'application/vnd.ms-excel',
      'xlb' => 'application/x-excel',
      'xlc' => 'application/vnd.ms-excel',
      'xld' => 'application/x-excel',
      'xlk' => 'application/x-excel',
      'xll' => 'application/x-excel',
      'xlm' => 'application/vnd.ms-excel',
      'xls' => 'application/vnd.ms-excel',
      'xlt' => 'application/vnd.ms-excel',
      'xlv' => 'application/x-excel',
      'xlw' => 'application/vnd.ms-excel',
      'xm' => 'audio/xm',
      'xml' => 'text/xml',
      'xmz' => 'xgl/movie',
      'xof' => 'x-world/x-vrml',
      'xpix' => 'application/x-vnd.ls-xpix',
      'xpm' => 'image/xpm',
      'xsl' => 'text/xml',
      'xsr' => 'video/x-amt-showrun',
      'xwd' => 'image/x-xwindowdump',
      'xyz' => 'chemical/x-pdb',
      'z' => 'application/x-compress',
      'zip' => 'multipart/x-zip',
      'zoo' => 'application/octet-stream',
      'zsh' => 'text/x-script.zsh',
      '323' => 'text/h323',
   );

}



