<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file is a component of TMDA Tools, a plugin for SquirrelMail.
 * http://www.morison.net/squirrelmail-plugins/tmdatools.html
 *
 */

function tmdatools_version()
{
  return '1.0.2';
}

function squirrelmail_plugin_init_tmdatools()
{  
  /* SquirrelMail Globals */
  global $squirrelmail_plugin_hooks;

  global $username;
  
  global $sendmail_path;

  /* TMDA Tools Globals */
  global $plugin_tmdatools_homedir;

  global $plugin_tmdatools_tmdaevidence;

  global $plugin_tmdatools_sendmail_path;

  if (!isset($username))
  {
    $username = $_SESSION['username'];
  }
  
  include_once(SM_PATH . 'plugins/tmdatools/tmdatools_config.php');
  
  include_once(SM_PATH . 'plugins/tmdatools/tmdatools_findhome.php');
  
  putenv("USER=$username");
  
  putenv("NAME=$username");

  putenv("HOME=".tmdatools_findhome($username));

  putenv("RECIPIENT=NONE");
  
  if (isset($plugin_tmdatools_tmdaevidence))
  {  
    if (substr($plugin_tmdatools_tmdaevidence,0,1)=="~")
    {
      $plugin_tmdatools_evidencefile = getenv("HOME").substr($plugin_tmdatools_tmdaevidence,2);
    }
    else
    {
      $plugin_tmdatools_evidencefile = $plugin_tmdatools_tmdaevidence;
    }        
    
    if (!file_exists($plugin_tmdatools_evidencefile))
    {
      return; 
    }
  }
  
  $squirrelmail_plugin_hooks['menuline']['tmdatools'] = 'plugin_tmdatools_menuline';    
  
  $squirrelmail_plugin_hooks['compose_button_row']['tmdatools'] = 'plugin_tmdatools_compose_button_row';
  
  $squirrelmail_plugin_hooks['compose_send']['tmdatools'] = 'plugin_tmdatools_compose_send';      
  
  if (isset($plugin_tmdatools_sendmail_path))
  {
    $sendmail_path = $plugin_tmdatools_sendmail_path;
  }
}

function plugin_tmdatools_menuline()
{
   include_once(SM_PATH . 'plugins/tmdatools/tmdatools.php');
   
   plugin_tmdatools_menuline_do();
}

function plugin_tmdatools_compose_button_row()
{
   include_once(SM_PATH . 'plugins/tmdatools/tmdatools.php');
   
   plugin_tmdatools_compose_button_row_do();
}

function plugin_tmdatools_compose_send(&$data)
{            
   include_once(SM_PATH . 'plugins/tmdatools/tmdatools.php');
         
   plugin_tmdatools_compose_send_do($data);   
}
?>