<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file is a component of TMDA Tools, a plugin for SquirrelMail.
 * http://www.morison.net/squirrelmail-plugins/tmdatools.html
 *
 */

/*
 * The default tmdatools_findhome() where the SquirrelMail variable
 * $username is equivalent to the system username, and the simple
 * $plugin_tmdatools_homedir variable can be used on your system.
 */

function tmdatools_findhome($username)
{
  global $plugin_tmdatools_homedir;
  
  return $plugin_tmdatools_homedir.$username."/";
}

/*
 * An alternative tmdatools_findhome() for use when the SquirrelMail
 * $username variable is user@host and the host component must be
 * stripped before appending to the $plugin_tmdatools_homedir.
 */

function _tmdatools_findhome($username)
{
  global $plugin_tmdatools_homedir;
  
  $username = preg_replace("/$@.*/", '', $username);
  
  return $plugin_tmdatools_homedir.$username."/";
}

?>