<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * A generic version of the paginator found in the core SquirrelMail
 * code in /functions/mailbox_display.php
 *
 */

define('PG_SEL_MAX', 10);

function paginator_getlink( $start, $text)
{  
  return '<a href="?startMessage='.$start.'">'.$text.'</a>'; 
}

function paginator_getshowalllink()
{
  return '?startMessage=1&PG_SHOWALL=1'; 
}

function paginator_getpaginatelink()
{
  return '?startMessage=1';
}

function paginator_getselectalllink($start_msg)
{
  global $javascript_on,$username;
  
  if ($javascript_on)
  {    
    $func_name = "CheckAll";
    $form_name = "FormMsgs";
    $result = '<script language="JavaScript" type="text/javascript">'
            . "\n<!-- \n"
            . "function " . $func_name . "() {\n"
            . "  for (var i = 0; i < document." . $form_name . ".elements.length; i++) {\n"
            . "    if(document." . $form_name . ".elements[i].type == 'checkbox'){\n"
            . "      document." . $form_name . ".elements[i].checked = "
            . "        !(document." . $form_name . ".elements[i].checked);\n"
            . "    }\n"
            . "  }\n"
            . "}\n"
            . "//-->\n"
            . '</script><a href="javascript:void(0)" onClick="' . $func_name . '();">' . _("Toggle All")
            . "</a>\n";
            
    return $result; 
  }
  else
  {
    return ''; 
  }
}

/*
 * This function computes the paginator string.
 */
function paginator_getstr($start_msg, $end_msg, $num_msgs, $show_num) 
{
    global $username, $data_dir, $color;        

    /* Initialize paginator string chunks. */
    $prv_str = '';
    $nxt_str = '';
    $pg_str  = '';
    $all_str = '';
    $tgl_str = '';    

    /* Create simple strings that will be creating the paginator. */
    $spc = '&nbsp;';     /* This will be used as a space. */
    $sep = '|';          /* This will be used as a seperator. */

    /* Get some paginator preference values. */
    $pg_sel = getPref($data_dir, $username, 'page_selector', SMPREF_ON);
    $pg_max = getPref($data_dir, $username, 'page_selector_max', PG_SEL_MAX);

    // echo("[$pg_sel][$pg_max]");

    /* Make sure that our start message number is not too big. */
    $start_msg = min($start_msg, $num_msgs);

    /* Compute the starting message of the previous and next page group. */
    $next_grp = $start_msg + $show_num;
    $prev_grp = $start_msg - $show_num;

    /* Compute the basic previous and next strings. */
    if (($next_grp <= $num_msgs) && ($prev_grp >= 0)) {
        $prv_str = paginator_getlink( $prev_grp,  _("Previous"));
        $nxt_str = paginator_getlink( $next_grp,  _("Next"));
    } else if (($next_grp > $num_msgs) && ($prev_grp >= 0)) {
        $prv_str = paginator_getlink( $prev_grp,  _("Previous"));
        $nxt_str = "<FONT COLOR=\"$color[9]\">"._("Next")."</FONT>\n";
    } else if (($next_grp <= $num_msgs) && ($prev_grp < 0)) {
        $prv_str = "<FONT COLOR=\"$color[9]\">"._("Previous") . '</FONT>';
        $nxt_str = paginator_getlink( $next_grp,  _("Next"));
    }

    /* Page selector block. Following code computes page links. */
    if ($pg_sel && ($num_msgs > $show_num)) {
        /* Most importantly, what is the current page!!! */
        $cur_pg = intval($start_msg / $show_num) + 1;

        /* Compute total # of pages and # of paginator page links. */
        $tot_pgs = ceil($num_msgs / $show_num);  /* Total number of Pages */
        $vis_pgs = min($pg_max, $tot_pgs - 1);   /* Visible Pages    */

        /* Compute the size of the four quarters of the page links. */

        /* If we can, just show all the pages. */
        if (($tot_pgs - 1) <= $pg_max) {
            $q1_pgs = $cur_pg - 1;
            $q2_pgs = $q3_pgs = 0;
            $q4_pgs = $tot_pgs - $cur_pg;

        /* Otherwise, compute some magic to choose the four quarters. */
        } else {
            /*
             * Compute the magic base values. Added together,
             * these values will always equal to the $pag_pgs.
             * NOTE: These are DEFAULT values and do not take
             * the current page into account. That is below.
             */
            $q1_pgs = floor($vis_pgs/4);
            $q2_pgs = round($vis_pgs/4, 0);
            $q3_pgs = ceil($vis_pgs/4);
            $q4_pgs = round(($vis_pgs - $q2_pgs)/3, 0);

            /* Adjust if the first quarter contains the current page. */
            if (($cur_pg - $q1_pgs) < 1) {
                $extra_pgs = ($q1_pgs - ($cur_pg - 1)) + $q2_pgs;
                $q1_pgs = $cur_pg - 1;
                $q2_pgs = 0;
                $q3_pgs += ceil($extra_pgs / 2);
                $q4_pgs += floor($extra_pgs / 2);

            /* Adjust if the first and second quarters intersect. */
            } else if (($cur_pg - $q2_pgs - ceil($q2_pgs/3)) <= $q1_pgs) {
                $extra_pgs = $q2_pgs;
                $extra_pgs -= ceil(($cur_pg - $q1_pgs - 1) * 3/4);
                $q2_pgs = ceil(($cur_pg - $q1_pgs - 1) * 3/4);
                $q3_pgs += ceil($extra_pgs / 2);
                $q4_pgs += floor($extra_pgs / 2);

            /* Adjust if the fourth quarter contains the current page. */
            } else if (($cur_pg + $q4_pgs) >= $tot_pgs) {
                $extra_pgs = ($q4_pgs - ($tot_pgs - $cur_pg)) + $q3_pgs;
                $q3_pgs = 0;
                $q4_pgs = $tot_pgs - $cur_pg;
                $q1_pgs += floor($extra_pgs / 2);
                $q2_pgs += ceil($extra_pgs / 2);

            /* Adjust if the third and fourth quarter intersect. */
            } else if (($cur_pg + $q3_pgs) >= ($tot_pgs - $q4_pgs)) {
                $extra_pgs = $q3_pgs;
                $extra_pgs -= ceil(($tot_pgs - $cur_pg - $q4_pgs) * 3/4);
                $q3_pgs = ceil(($tot_pgs - $cur_pg - $q4_pgs) * 3/4);
                $q1_pgs += floor($extra_pgs / 2);
                $q2_pgs += ceil($extra_pgs / 2);
            }
        }

        /*
         * I am leaving this debug code here, commented out, because
         * it is a really nice way to see what the above code is doing.
	 */
          // echo "qts =  $q1_pgs/$q2_pgs/$q3_pgs/$q4_pgs = "
          //    . ($q1_pgs + $q2_pgs + $q3_pgs + $q4_pgs) . '<br>';
         

        /* Print out the page links from the compute page quarters. */

        /* Start with the first quarter. */
        if (($q1_pgs == 0) && ($cur_pg > 1)) {
            $pg_str .= "...$spc";
        } else {
            for ($pg = 1; $pg <= $q1_pgs; ++$pg) {
                $start = (($pg-1) * $show_num) + 1;
                $pg_str .= paginator_getlink( $start,  $pg) . $spc;
            }
            if ($cur_pg - $q2_pgs - $q1_pgs > 1) {
                $pg_str .= "...$spc";
            }
        }

        /* Continue with the second quarter. */
        for ($pg = $cur_pg - $q2_pgs; $pg < $cur_pg; ++$pg) {
            $start = (($pg-1) * $show_num) + 1;            
            $pg_str .= paginator_getlink( $start,  $pg) . $spc;
        }

        /* Now print the current page. */
        $pg_str .= $cur_pg . $spc;

        /* Next comes the third quarter. */
        for ($pg = $cur_pg + 1; $pg <= $cur_pg + $q3_pgs; ++$pg) {
            $start = (($pg-1) * $show_num) + 1;
            $pg_str .= paginator_getlink( $start,  $pg) . $spc;
        }

        /* And last, print the forth quarter page links. */
        if (($q4_pgs == 0) && ($cur_pg < $tot_pgs)) {
            $pg_str .= "...$spc";
        } else {
            if (($tot_pgs - $q4_pgs) > ($cur_pg + $q3_pgs)) {
                $pg_str .= "...$spc";
            }
            for ($pg = $tot_pgs - $q4_pgs + 1; $pg <= $tot_pgs; ++$pg) {
                $start = (($pg-1) * $show_num) + 1;                
                $pg_str .= paginator_getlink( $start,  $pg) . $spc;
            }
        }
    } else if ($show_num == 999999) {
        $pg_str = '<a href="'.paginator_getpaginatelink().'">' ._("Paginate") . '</a>' . $spc;
    }

    /* If necessary, compute the 'show all' string. */
    if (($prv_str != '') || ($nxt_str != '')) {
        $all_str = '<a href="'.paginator_getshowalllink().'">' . _("Show All") . '</a>';
    }

    /* Last but not least, get the value for the toggle all link. */
    $tgl_str = paginator_getselectalllink($start_msg);

    /* Put all the pieces of the paginator string together. */
    /**
     * Hairy code... But let's leave it like it is since I am not certain
     * a different approach would be any easier to read. ;)
     */
    $result = '';
    $result .= ($prv_str != '' ? $prv_str . $spc . $sep . $spc : '');
    $result .= ($nxt_str != '' ? $nxt_str . $spc . $sep . $spc : '');
    $result .= ($pg_str  != '' ? $pg_str : '');
    $result .= ($all_str != '' ? $sep . $spc . $all_str . $spc : '');
    $result .= ($result  != '' ? $sep . $spc . $tgl_str: $tgl_str);

    /* If the resulting string is blank, return a non-breaking space. */
    if ($result == '') {
        $result = '&nbsp;';
    }

    /* Return our final magical paginator string. */
    return ($result);
}
?>