<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file is a component of TMDA Tools, a plugin for SquirrelMail.
 * http://www.morison.net/squirrelmail-plugins/tmdatools.html
 *
 */

define('SM_PATH','../../');

require_once(SM_PATH . 'include/validate.php');

require_once(SM_PATH . 'functions/page_header.php');

$tmdatools_address_options[""]        = _("Default");

$tmdatools_address_options["dated"]   = _("Dated, Default");

$tmdatools_address_options["keyword"] = _("Keyword")." --->";

$tmdatools_address_options["sender"]  = _("Sender")." --->";

$tmdatools_address_options["dated"]   = _("Dated")." --->";

sqgetGlobalVar('tmdatools_submit',$tmdatools_submit);

sqgetGlobalVar('tmdatools_address',$tmdatools_address);
  
sqgetGlobalVar('tmdatools_address_text',$tmdatools_address_text);

displayPageHeader($color, 'None');

echo '<table align="center" width="95%" border="0" cellpadding="1" cellspacing="0">';

echo '<tr>';

echo '<td align="center" bgcolor="'.$color[0].'">';

echo '<b>' . _("TMDA Address Generator") . '</b>';

echo '<table width="100%" border="0" cellpadding="8" cellspacing="0">'; 

echo '<tr>';

echo '<td align="center" bgcolor="'.$color[4].'">';

echo '<br>';

if ($tmdatools_submit)
{
  $command = $plugin_tmdatools_tmdadir . "bin/tmda-address";
  
  if (file_exists($command))
  {
    $command .= ' --'.$tmdatools_address.' '.escapeshellcmd($tmdatools_address_text);
    
    $address = exec($command);
    
    echo $address;
  }
  else
  {
    echo _("File not found").': <b>'.$command.'</b>';
  }
}
echo '<form method="POST">';

echo _("TMDA Send Mode").': <select name="tmdatools_address">';

if (isset($tmdatools_address))
{
  echo '<option value="'.$tmdatools_address.'">'.$tmdatools_address_options[$tmdatools_address].'</option>';
}
foreach($tmdatools_address_options as $value => $text)
{
  echo '<option value="'.$value.'">'.$text.'</option>';
}
echo '</select> ';

echo '<input name="tmdatools_address_text" value="'.$tmdatools_address_text.'" type="text" size="15"> ';

echo '<br><br>';

echo '<input type="submit" name="tmdatools_submit" value="'._("Generate Address").'">';

echo '</form>';

echo '</center></td></tr></table>';
?>