<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file is a component of TMDA Tools, a plugin for SquirrelMail.
 * http://www.morison.net/squirrelmail-plugins/tmdatools.html
 *
 */

define('SM_PATH','../../');

require_once(SM_PATH . 'include/validate.php');

require_once(SM_PATH . 'functions/page_header.php');

function print_optionpages_row($leftopt, $rightopt = false) {
    global $color;

    if ($rightopt) {
        $rightopt_name = html_tag( 'td', '<a href="' . $rightopt['url'] . '">' . $rightopt['name'] . '</a>', 'left', $color[9], 'valign="top" width="49%"' );
        $rightopt_desc = html_tag( 'td', $rightopt['desc'], 'left', $color[0], 'valign="top" width="49%"' );
    } else {
        $rightopt_name = html_tag( 'td', '&nbsp;', 'left', $color[4], 'valign="top" width="49%"' );
        $rightopt_desc = html_tag( 'td', '&nbsp;', 'left', $color[4], 'valign="top" width="49%"' );
    }

    echo
    html_tag( 'table', "\n" .
        html_tag( 'tr', "\n" .
            html_tag( 'td', "\n" .
                html_tag( 'table', "\n" .
                    html_tag( 'tr', "\n" .
                        html_tag( 'td',
                            '<a href="' . $leftopt['url'] . '">' . $leftopt['name'] . '</a>' ,
                        'left', $color[9], 'valign="top" width="49%"' ) .
                        html_tag( 'td',
                            '&nbsp;' ,
                        'left', $color[4], 'valign="top" width="2%"' ) . "\n" .
                        $rightopt_name
                    ) . "\n" .
                    html_tag( 'tr', "\n" .
                        html_tag( 'td',
                            $leftopt['desc'] ,
                        'left', $color[0], 'valign="top" width="49%"' ) .
                        html_tag( 'td',
                            '&nbsp;' ,
                        'left', $color[4], 'valign="top" width="2%"' ) . "\n" .
                        $rightopt_desc
                    ) ,
                '', '', 'width="100%" cellpadding="2" cellspacing="0" border="0"' ) ,
            'left', '', 'valign="top"' )
        ) ,
    '', $color[4], 'width="100%" cellpadding="0" cellspacing="5" border="0"' );
}


if (is_array($plugin_tmdatools_editfiles))
{
  $tmdatools_edithtml = "";
  
  $tmdatools_edithtml .= '<center><form method="GET" action="editfile.php">';
  
  $tmdatools_edithtml .= '<select name="plugin_tmdatools_fileid">';
  
  foreach($plugin_tmdatools_editfiles as $id => $editfile)
  {
    $tmdatools_edithtml .= '<option value="'.$id.'">'. _($editfile["title"]) . '</option>';
  }
  
  $tmdatools_edithtml .= '</select> ';
  
  $tmdatools_edithtml .= '<input type="submit" value="Edit">';
  
  $tmdatools_edithtml .= '</form></center>';

  if ($plugin_tmdatools_editfiles[0]["title"]=="Test")
  {
  $tmdatools_debughtml = "";  
    
  $tmdatools_debughtml .= 'Squirrelmail is running as the user: <b>'.get_current_user().'</b>';

  $tmdatools_debughtml .= '<br>';

  $tmdatools_debughtml .= 'Your home directory is: <b>'.getenv("HOME").'</b>';        
  }
}

$optpage_blocks = array();

$optpage_blocks[] = array(
    'name' => _("Address Generator"),
    'url'  => 'address.php',
    'desc' => _("Create TMDA coded addresses for use elsewhere, such as on a sign-up or customer details form on a website."),
    'js'   => false
);
if ($tmdatools_edithtml)
{
$optpage_blocks[] = array(
    'name' => _("File Editor"),
    'url'  => 'editfile.php?plugin_tmdatools_fileid=0',
    'desc' => $tmdatools_edithtml,
    'js'   => false
);
}
$optpage_blocks[] = array(
    'name' => _("Pending Messages"),
    'url'  => 'pending.php',
    'desc' => _("Manage incoming messages awaiting sender confirmation.  You can view, release or delete pending messages."),
    'js'   => false
);
if ($tmdatools_debughtml)
{
$optpage_blocks[] = array(
    'name' => _("Debug"),
    'url'  => 'tools.php',
    'desc' => $tmdatools_debughtml,
    'js'   => false
);
}

displayPageHeader($color, 'None');

echo '<table align="center" width="95%" border="0" cellpadding="1" cellspacing="0">';

echo '<tr>';

echo '<td align="center" bgcolor="'.$color[0].'">';

echo '<b>' . _("TMDA Tools") . '</b>';

echo '<table width="100%" border="0" cellpadding="8" cellspacing="0">'; 

echo '<tr>';

echo '<td align="center" bgcolor="'.$color[4].'">';

$first_optpage = false;
echo html_tag( 'table', '', '', $color[4], 'width="100%" cellpadding="0" cellspacing="5" border="0"' ) . "\n" .
            html_tag( 'tr' ) . "\n" .
                html_tag( 'td', '', 'left', '', 'valign="top"' ) .
                    html_tag( 'table', '', '', $color[4], 'width="100%" cellpadding="3" cellspacing="0" border="0"' ) . "\n" .
                        html_tag( 'tr' ) . "\n" .
                            html_tag( 'td', '', 'left' );
foreach ($optpage_blocks as $next_optpage) {
    if ($first_optpage == false) {
        $first_optpage = $next_optpage;
    } else {
        print_optionpages_row($first_optpage, $next_optpage);
        $first_optpage = false;
    }
}
if ($first_optpage != false) {
    print_optionpages_row($first_optpage);
}
echo "</td></tr></table></td></tr></table>\n";

echo '</center></td></tr></table>';
?>