<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file is a component of TMDA Tools, a plugin for SquirrelMail.
 * http://www.morison.net/squirrelmail-plugins/tmdatools.html
 *
 */

define('SM_PATH','../../');

require_once(SM_PATH . 'include/validate.php');

require_once(SM_PATH . 'functions/page_header.php');

require_once(SM_PATH . 'functions/date.php');

require_once('paginator.php');

sqgetGlobalVar('tmdatools_submit',$tmdatools_submit,SQ_FORM);

if ($tmdatools_submit)
{
  sqgetGlobalVar('tmdatools_pmsg',$tmdatools_pmsg,SQ_FORM);

  sqgetGlobalVar('tmdatools_whitelist',$tmdatools_whitelist,SQ_FORM);

  sqgetGlobalVar('tmdatools_blacklist',$tmdatools_blacklist,SQ_FORM);

  if (is_array($tmdatools_pmsg))
  {
    foreach($tmdatools_pmsg as $tmdatools_key => $tmdatools_value)
    {
      if ($tmdatools_value == "on")
      {
        $tmdatools_msglist .= $tmdatools_key . " ";
      }
    }
    if ($tmdatools_msglist)
    {
      switch($tmdatools_submit)
      {
        case "Release + Whitelist":
          $tmdatools_pending = $plugin_tmdatools_tmdadir . "bin/tmda-pending";
  
          $tmdatools_pending .= " -b -W ";
  
          $tmdatools_pending .= escapeshellcmd($tmdatools_msglist);
  
          $tmdatools_pending = shell_exec($tmdatools_pending);
  
          //Can't have a break yet, more work to do
  
        case "Release":
          $tmdatools_pending = $plugin_tmdatools_tmdadir . "bin/tmda-pending";
  
          $tmdatools_pending .= " -b -r ";
  
          $tmdatools_pending .= escapeshellcmd($tmdatools_msglist);
  
          $tmdatools_pending = shell_exec($tmdatools_pending);
  
          //Now we can have a break.
  
          break;
  
        case "Delete + Blacklist":
          $tmdatools_pending = $plugin_tmdatools_tmdadir . "bin/tmda-pending";
  
          $tmdatools_pending .= " -b -B ";
  
          $tmdatools_pending .= escapeshellcmd($tmdatools_msglist);
  
          $tmdatools_pending = shell_exec($tmdatools_pending);
  
          //Can't have a break yet, more work to do
  
        case "Delete":
          $tmdatools_pending = $plugin_tmdatools_tmdadir . "bin/tmda-pending";
  
          $tmdatools_pending .= " -b -d ";
  
          $tmdatools_pending .= escapeshellcmd($tmdatools_msglist);
  
          $tmdatools_pending = shell_exec($tmdatools_pending);
  
          //Now we can have a break.
  
          break;
      }   
    }
  }
  header("Location: pending.php");

  exit();
}

displayPageHeader($color, 'None');

sqgetGlobalVar('PG_SHOWALL', $tmdatools_showall, SQ_GET);

sqgetGlobalVar('show_num', $show_num, SQ_SESSION);

if ( sqgetGlobalVar('startMessage', $temp) ) {
  $startMessage = (int) $temp;
}
else
{
  $startMessage = 1;
}

$tmdatools_command = $plugin_tmdatools_tmdadir . "bin/tmda-pending";

if (file_exists($tmdatools_command))
{
  $tmdatools_command .= ' -b -T -D';

  $tmdatools_pending = shell_exec($tmdatools_command);

  $tmdatools_lines = explode("\n",$tmdatools_pending);
     
  $tmdatools_numpending = (count($tmdatools_lines)-1);

  if ($startMessage > $tmdatools_numpending)
  {
    $startMessage = 1; 
  }

  if ($tmdatools_showall=="1")
  {
    $endMsg = $tmdatools_numpending;
  }
  else
  {    
    $endMsg = $startMessage + ($show_num-1);  
  }
  
  if ($endMsg > $tmdatools_numpending)
  {
    $endMsg = $tmdatools_numpending;
  }

  if ($tmdatools_numpending)
  {
    $tmdatools_paginatorkey = _("Viewing Pending Messages:").' <b>'.$startMessage.'</b> '._("to").' <b>'.$endMsg.'</b> ('.$tmdatools_numpending.' '._("total").')';
  }

  if ($tmdatools_showall=="1")
  {
    $show_num = 999999; 
  }

  $tmdatools_paginator = paginator_getstr($startMessage, $endMsg, $tmdatools_numpending, $show_num);
    
  echo '<table border="0" width="100%" cellpadding="0" cellspacing="0">';

  echo '<form name="FormMsgs" method="post" action="pending.php">';

  echo '<tr><td>';
    
  echo '    <table width="100%" cellpadding="1" cellspacing="0" align="center"'.' border="0" bgcolor="'.$color[9].'">';

  echo '     <tr><td>';

  echo '      <table width="100%" cellpadding="1" cellspacing="0" align="center" border="0" bgcolor="'.$color[4].'">';

  echo '       <tr>';

  echo '        <td aligh="left">';

  echo ($tmdatools_paginator);  

  echo '       </td>';

  echo '        <td align="right">';

  echo ($tmdatools_paginatorkey);  

  echo '       </td>';

  echo '      </tr>';

  echo '      </table>';

  echo '     </td></tr>';

  echo '    </table>';
  
  echo '</td></tr>';

  echo '<tr><td HEIGHT="5" BGCOLOR="'.$color[4].'"></td></tr>';

  echo '<tr><td>';
    
  echo '    <table width="100%" cellpadding="1" cellspacing="0" align="center"'.' border="0" bgcolor="'.$color[9].'">';

  echo '     <tr><td>';

  echo '      <table width="100%" cellpadding="1" cellspacing="0" align="center" border="0" bgcolor="'.$color[0].'">';

  echo '       <tr><td>';

  echo '       <small>'._("Transform Selected Messages").':</small><br>';

  echo '       <input type="submit" name="tmdatools_submit" value="'._("Release").'">';

  if ($plugin_tmdatools_tmdasettings["PENDING_WHITELIST_APPEND"])
  {  
    echo '<input type="submit" name="tmdatools_submit" value="'._("Release + Whitelist").'">';
  }
  echo '       <input type="submit" name="tmdatools_submit" value="'._("Delete").'">';

  if ($plugin_tmdatools_tmdasettings["PENDING_BLACKLIST_APPEND"])
  {    
    echo '<input type="submit" name="tmdatools_submit" value="'._("Delete + Blacklist").'">';
  }
  echo '       </td></tr>';
  
  echo '      </table>';
  
  echo '     </td></tr>';
  
  echo '    </table>';

  echo '</td></tr>';

  echo '<tr><td HEIGHT="5" BGCOLOR="'.$color[4].'"></td></tr>';

  echo '<tr><td>';

  echo '    <table width="100%" cellpadding="1" cellspacing="0" align="center"'.' border="0" bgcolor="'.$color[9].'">';

  echo '     <tr><td>';

  echo '      <table width="100%" cellpadding="1" cellspacing="0" align="center" border="0">';

  echo '       <tr bgcolor="'.$color[5].'">';

  echo '       <td></td>';

  echo '       <td width="25%"><b>'._("From").'</b></td>';

  echo '       <td width="60%"><b>'._("Subject").'</b></td>';
  
  echo '       <td width="15%"><b>'._("Date").'</b></td>';

  echo '       </tr>';
  
  $tmdatools_row = 0;

  for($i = $startMessage;$i <= $endMsg; $i++)
  {  
      $tmdatools_line = $tmdatools_lines[($i-1)];
      
      $tmdatools_fields = explode("\t",$tmdatools_line);

      if ($tmdatools_fields[1]=="")
      {
        $tmdatools_fields[1] = '('._("no Sender").')';
      }
      if ($tmdatools_fields[2]=="")
      {
        $tmdatools_fields[2] = '('._("no subject").')';
      }

      if ($tmdatools_row++ % 2)
      {
        echo '<tr bgcolor="'.$color[12].'">';
      }
      else
      {
        echo '<tr bgcolor="'.$color[4].'">';
      }
      echo '<td><input name="tmdatools_pmsg['.$tmdatools_fields[0].']" type="checkbox"></td>';

      echo '<td width="25%">'.$tmdatools_fields[1].'</td>';

      echo '<td width="60%"><a href="viewer.php?msg='.$tmdatools_fields[0].'">'.$tmdatools_fields[2].'</a></td>';

      $tmdatools_stamp = strtotime($tmdatools_fields[3]);

      echo '<td width="15%">'.getDateString($tmdatools_stamp).'</td>';
      
      echo '</tr>';
  }    
  if (!$tmdatools_row)
  {
    echo '<tr bgcolor="'.$color[4].'">';
    
    echo '<td colspan="4" align="center">';
    
    echo '<br><b>'._("THIS FOLDER IS EMPTY").'</b><br><br>';
    
    echo '</td>';
    
    echo '</tr>';
  }
  echo '      </table>';
  
  echo '     </td></tr>';
  
  echo '    </table>';

  echo '</td></tr>';

  if ($tmdatools_numpending)
  {
    echo '</td></tr>';
  
    echo '<tr><td HEIGHT="5" BGCOLOR="'.$color[4].'"></td></tr>';
  
    echo '<tr><td>';
      
    echo '<tr><td>';
        
    echo '    <table width="100%" cellpadding="1" cellspacing="0" align="center"'.' border="0" bgcolor="'.$color[9].'">';
    
    echo '     <tr><td>';
    
    echo '      <table width="100%" cellpadding="1" cellspacing="0" align="center" border="0" bgcolor="'.$color[4].'">';
    
    echo '       <tr>';
    
    echo '        <td aligh="left">';
    
    echo ($tmdatools_paginator);  
    
    echo '       </td>';
    
    echo '        <td align="right">';
    
    echo ($tmdatools_paginatorkey);  
    
    echo '       </td>';
    
    echo '      </tr>';
    
    echo '      </table>';
    
    echo '     </td></tr>';
    
    echo '    </table>';
      
    echo '</td></tr>';  
  }
  echo '</form>';

  echo '</table>';
}
else
{
  echo _("File not found").': <b>'.$command.'</b>';
}
?>