<?php

/*
 * Copyright (c) 2004 David Morison (david@morison.net) 
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file is a component of TMDA Tools, a plugin for SquirrelMail.
 * http://www.morison.net/squirrelmail-plugins/tmdatools.html
 *
 */
global $tmdatools_tmdahdr_options;

$tmdatools_tmdahdr_options[""]            = _("Default");

$tmdatools_tmdahdr_options["bare"]        = _("Bare");

$tmdatools_tmdahdr_options["bare=append"] = _("Bare, Append");

$tmdatools_tmdahdr_options["dated"]       = _("Dated, Default");

$tmdatools_tmdahdr_options["sender"]      = _("Sender");

$tmdatools_tmdahdr_options["domain"]      = _("Domain");

$tmdatools_tmdahdr_options["keyword="]    = _("Keyword")." --->";

$tmdatools_tmdahdr_options["sender="]     = _("Sender")." --->";

$tmdatools_tmdahdr_options["dated="]      = _("Dated")." --->";

$tmdatools_tmdahdr_options["ext="]        = _("Ext")." --->";

function plugin_tmdatools_menuline_do()
{
  displayInternalLink ('plugins/tmdatools/tools.php', _("TMDA Tools"));

  echo "&nbsp;&nbsp;\n";
}

function plugin_tmdatools_compose_button_row_do()
{
  global $subject,$tmdatools_tmdahdr,$tmdatools_tmdahdr_text,$tmdatools_tmdahdr_options;
  
  sqgetGlobalVar('tmdatools_tmdahdr',$tmdatools_tmdahdr);
  
  sqgetGlobalVar('tmdatools_tmdahdr_text',$tmdatools_tmdahdr_text);
      
  echo '<br>';

  echo _("TMDA Send Mode").': <select name="tmdatools_tmdahdr">';

  if (isset($tmdatools_tmdahdr))
  {
    echo '<option value="'.$tmdatools_tmdahdr.'">'.$tmdatools_tmdahdr_options[$tmdatools_tmdahdr].'</option>';
  }
  foreach($tmdatools_tmdahdr_options as $value => $text)
  {
    echo '<option value="'.$value.'">'.$text.'</option>';
  }
  echo '</select> ';

  echo '<input name="tmdatools_tmdahdr_text" value="'.$tmdatools_tmdahdr_text.'" type="text">';      
}

function plugin_tmdatools_compose_send_do(&$data)
{
  global $tmdatools_tmdahdr,$tmdatools_tmdahdr_text;

  $composeMessage = &$data[1];
  
  sqgetGlobalVar('tmdatools_tmdahdr',$tmdatools_tmdahdr);
  
  sqgetGlobalVar('tmdatools_tmdahdr_text',$tmdatools_tmdahdr_text);

  if ($tmdatools_tmdahdr)
  {
    $composeMessage->rfc822_header->more_headers[ "X-TMDA" ] = $tmdatools_tmdahdr.$tmdatools_tmdahdr_text;
  }
}
?>