<?php
/**
 **  @(#) tmda plugin for squirrelmail system
 **  @(#) $Id: setup.php,v 1.1 2002/02/24 05:18:52 bduncan Exp $
 **
 **  Created:  Bill Duncan, <bduncan@beachnetcommunications.com>
 **  (c) 2002 (GNU GPL - see ../../COPYING)
 **
 **  Description:
 **   - provides some TMDA options for setting headers for use with TMDA
 **   - future options to include managing TMDA files and filters better.
 **
 **/

global $tmdaSendHeaders;
global $tmdatype;

// This is a constant array for values used with the X-TMDA header
$tmdaSendHeaders = Array (
  0  =>  "",
  1  =>  "bare",
  2  =>  "bare=append",
  3  =>  "dated",
  4  =>  "sender"
);


/*******************************************************
 **   No need to change anything else below this point.
 *******************************************************/



function squirrelmail_plugin_init_tmda()
{
  global $squirrelmail_plugin_hooks;

  $squirrelmail_plugin_hooks['smtp_send']['tmda']          = 'tmda_addition';
  $squirrelmail_plugin_hooks['compose_button_row']['tmda'] = 'tmda_compose';
}


function tmda_addition()
{

  global $tmdatype, $more_headers, $tmdaSendHeaders;

  if (isset($tmdatype) && ($tmdatype != 0)) {
    $more_headers[ "X-TMDA" ] = $tmdaSendHeaders[$tmdatype];
  }
}

function tmda_compose()
{
  global $tmdatype;

  if (!isset($tmdatype)) {
    $tmdatype = "0";
  }
  echo "    <TR><TD>\n   </TD><TD>\n";
  echo "\n\t". _("TMDA Send Type") .':<select name="tmdatype">'.
    "\n\t\t<option value=0".($tmdatype=='0'?' selected':'').'>'. _("Default, by config").'</option>'.
    "\n\t\t<option value=1".($tmdatype=='1'?' selected':'').'>'. _("Bare, Normal Address").'</option>'.
    "\n\t\t<option value=2".($tmdatype=='2'?' selected':'').'>'. _("Bare, Add to OK List").'</option>'.
    "\n\t\t<option value=3".($tmdatype=='3'?' selected':'').'>'. _("Dated, force expiry").'</option>'.
    "\n\t\t<option value=4".($tmdatype=='4'?' selected':'').'>'. _("Sender, key by recip").'</option>'.
    "\n\t</select>";
  echo "    </TD></TR>";
}

?>
