<?php
  /**
   **  Timeout User (timeout_user) v0.2
   **
   **  By Ray Black III <allah@accessnode.net>
   **  (c) 2001 (GNU GPL - see ../../COPYING)
   **
   **  This plugin monitors page changes in the right-hand frame.
   **  If the right-hand frame doesn't update within a set number
   **  of minutes, then the plugin logs the user out automatically.
   **  
   **  To change the timeout, see below. Default is 15 minutes.
   **/


global $timeout_in_minutes;
$timeout_in_minutes = 15; // this is the number of minutes before folks are logged out.



function squirrelmail_plugin_init_timeout_user()
{
    global $squirrelmail_plugin_hooks;

    $squirrelmail_plugin_hooks['menuline']['timeout_user']
            = 'timeout_user_metatag';
    $squirrelmail_plugin_hooks['logout_above_text']['timeout_user']
            = 'timeout_user_explanation';

} // end squirrelmail_plugin_init_timeout_user()


function timeout_user_metatag()
{

    global $timeout_in_minutes;

    $timeout = $timeout_in_minutes * 60; // we need this in seconds
    $js_timeout = ($timeout - 5) * 1000; // js needs milliseconds, and this should take precedence over meta

?>

<META HTTP-EQUIV="REFRESH" CONTENT="<?php echo $timeout; ?>;URL=../src/signout.php?timeout">
<script language="javascript">
<!-- hide from stupid browsers
    var dir_path = window.location.pathname.substr(0,window.location.pathname.lastIndexOf('/'));
    setTimeout('parent.window.location = "" + dir_path + "/../src/signout.php?timeout";' , <?php echo $js_timeout; ?>);
//-->
</script>

<?php

} // end timeout_user_metatag()



// this function only applies in 1.1.2 and beyond
function timeout_user_explanation()
{  
     
    global $timeout_in_minutes, $HTTP_SERVER_VARS;
 
    if ( isset($HTTP_SERVER_VARS[QUERY_STRING]) && stristr($HTTP_SERVER_VARS[QUERY_STRING], 'timeout') )
        echo "<br><b>$timeout_in_minutes</b> " . _("minutes idle. Logging out automatically.") . "<br><br>\n";
        
} // end timeout_user_explanation()


?>
